/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.timer.cronTask.generic;

import io.olvid.keycloak.classes.models.realms.CronJobModel;
import io.olvid.keycloak.jpa.OlvidData;
import io.olvid.keycloak.jpa.OlvidGroup;
import io.olvid.keycloak.jpa.OlvidLogsBackend;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.Base64;
import java.util.HashSet;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.utils.KeycloakSessionUtil;

public class CleanUpOlvidDataJob
implements Runnable {
    private final KeycloakSessionFactory factory;
    private final Logger logger;

    public CleanUpOlvidDataJob(KeycloakSessionFactory factory, Logger logger) {
        this.factory = factory;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block34: {
            this.logger.info((Object)"Starting Clean up OlvidData task");
            long currentTimestamp = System.currentTimeMillis();
            try (KeycloakSession session = this.factory.create();){
                boolean transactionCompletedSuccessfully;
                EntityManager em;
                KeycloakTransactionManager transactionManager;
                block37: {
                    block33: {
                        KeycloakSessionUtil.setKeycloakSession((KeycloakSession)session);
                        transactionManager = session.getTransactionManager();
                        em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                        transactionCompletedSuccessfully = false;
                        transactionManager.begin();
                        HashSet<OlvidData.OlvidDataId> olvidDataIds = new HashSet<OlvidData.OlvidDataId>();
                        TypedQuery q2333333332 = em.createNamedQuery("OlvidData.getAll", OlvidData.class);
                        for (OlvidData olvidData : q2333333332.getResultList()) {
                            olvidDataIds.add(new OlvidData.OlvidDataId(olvidData.getRealmId(), olvidData.getDataUid()));
                        }
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException q2333333332) {
                            // empty catch block
                        }
                        q2333333332 = em.createNamedQuery("OlvidGroup.getAllWithPhoto", OlvidGroup.class);
                        for (OlvidGroup group : q2333333332.getResultList()) {
                            if (group.getGroupPhotoUid() == null) continue;
                            String dataUid = Base64.getEncoder().encodeToString(group.getGroupPhotoUid());
                            olvidDataIds.remove(new OlvidData.OlvidDataId(group.getRealmId(), dataUid));
                        }
                        if (!olvidDataIds.isEmpty()) {
                            this.logger.infof("Found %d unused OlvidData to clean up", (Object)olvidDataIds.size());
                            for (OlvidData.OlvidDataId olvidDataId : olvidDataIds) {
                                TypedQuery q2 = em.createNamedQuery("OlvidData.getByUid", OlvidData.class);
                                q2.setParameter("realmId", (Object)olvidDataId.getRealmId());
                                q2.setParameter("dataUid", (Object)olvidDataId.getDataUid());
                                try {
                                    OlvidData olvidData = (OlvidData)q2.getSingleResult();
                                    em.remove((Object)olvidData);
                                }
                                catch (NoResultException noResultException) {}
                            }
                        }
                        if (!(transactionCompletedSuccessfully = true)) break block33;
                        transactionManager.commit();
                        break block37;
                    }
                    transactionManager.rollback();
                }
                this.logger.info((Object)"Ending Clean up OlvidData task.");
                try {
                    transactionManager.begin();
                    OlvidLogsBackend item = new OlvidLogsBackend();
                    item.setLogType(new CronJobModel().cleanUpOlvidDataJob);
                    item.setTimestampStart(currentTimestamp);
                    item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                    item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                    em.persist((Object)item);
                }
                catch (Exception item) {
                    transactionManager.commit();
                    break block34;
                    catch (Throwable throwable) {
                        transactionManager.commit();
                        throw throwable;
                    }
                }
                transactionManager.commit();
                break block34;
                catch (Exception e) {
                    block38: {
                        block35: {
                            try {
                                this.logger.warn((Object)"Exception in Clean up OlvidData task", (Throwable)e);
                                if (!transactionCompletedSuccessfully) break block35;
                            }
                            catch (Throwable throwable) {
                                if (transactionCompletedSuccessfully) {
                                    transactionManager.commit();
                                } else {
                                    transactionManager.rollback();
                                }
                                this.logger.info((Object)"Ending Clean up OlvidData task.");
                                try {
                                    transactionManager.begin();
                                    OlvidLogsBackend item = new OlvidLogsBackend();
                                    item.setLogType(new CronJobModel().cleanUpOlvidDataJob);
                                    item.setTimestampStart(currentTimestamp);
                                    item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                                    item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                                    em.persist((Object)item);
                                }
                                catch (Exception exception) {
                                }
                                finally {
                                    transactionManager.commit();
                                }
                                throw throwable;
                            }
                            transactionManager.commit();
                            break block38;
                        }
                        transactionManager.rollback();
                    }
                    this.logger.info((Object)"Ending Clean up OlvidData task.");
                    try {
                        transactionManager.begin();
                        OlvidLogsBackend item = new OlvidLogsBackend();
                        item.setLogType(new CronJobModel().cleanUpOlvidDataJob);
                        item.setTimestampStart(currentTimestamp);
                        item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                        item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                        em.persist((Object)item);
                    }
                    catch (Exception exception) {
                        transactionManager.commit();
                        break block34;
                        catch (Throwable throwable) {
                            transactionManager.commit();
                            throw throwable;
                        }
                    }
                    transactionManager.commit();
                }
            }
        }
    }
}

