/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.timer.cronTask.circlesVisibility;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.classes.models.realms.CronJobModel;
import io.olvid.keycloak.jpa.OlvidCircleVisibilityUser;
import io.olvid.keycloak.jpa.OlvidLogsBackend;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.utils.KeycloakSessionUtil;

public class CleanUpOlvidVisibilityCircleUsers
implements Runnable {
    private final KeycloakSessionFactory factory;
    private final Logger logger;

    public CleanUpOlvidVisibilityCircleUsers(KeycloakSessionFactory factory, Logger logger) {
        this.factory = factory;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block29: {
            this.logger.info((Object)"Starting Clean up OlvidVisibilityCircleUsers task");
            long currentTimestamp = System.currentTimeMillis();
            try (KeycloakSession session = this.factory.create();){
                boolean transactionCompletedSuccessfully;
                EntityManager em;
                KeycloakTransactionManager transactionManager;
                block32: {
                    block28: {
                        KeycloakSessionUtil.setKeycloakSession((KeycloakSession)session);
                        transactionManager = session.getTransactionManager();
                        ObjectMapper jsonObjectMapper = new ObjectMapper();
                        jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                        em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                        transactionCompletedSuccessfully = false;
                        transactionManager.begin();
                        TypedQuery q = em.createNamedQuery("OlvidCircleVisibilityUser.getUserWithDeletedCircle", OlvidCircleVisibilityUser.class);
                        List olvidCircleVisibilityUserList = q.getResultList();
                        for (OlvidCircleVisibilityUser olvidCircleVisibilityUser : olvidCircleVisibilityUserList) {
                            TypedQuery qSingle = em.createNamedQuery("OlvidCircleVisibilityUser.getUserCircleVisibilityById", OlvidCircleVisibilityUser.class);
                            qSingle.setParameter("id", (Object)olvidCircleVisibilityUser.getId());
                            try {
                                OlvidCircleVisibilityUser found = (OlvidCircleVisibilityUser)qSingle.getSingleResult();
                                em.remove((Object)found);
                            }
                            catch (NoResultException noResultException) {}
                        }
                        transactionCompletedSuccessfully = true;
                        if (!transactionCompletedSuccessfully) break block28;
                        transactionManager.commit();
                        break block32;
                    }
                    transactionManager.rollback();
                }
                this.logger.info((Object)"Ending Clean up OlvidVisibilityCircleUsers task");
                try {
                    OlvidLogsBackend item = new OlvidLogsBackend();
                    item.setLogType(new CronJobModel().cleanUpOlvidCircleVisibilityUser);
                    item.setTimestampStart(currentTimestamp);
                    item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                    item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                    em.persist((Object)item);
                }
                catch (Exception item) {
                    transactionManager.commit();
                    break block29;
                    catch (Throwable throwable) {
                        transactionManager.commit();
                        throw throwable;
                    }
                }
                transactionManager.commit();
                break block29;
                catch (Exception e) {
                    block33: {
                        block30: {
                            try {
                                this.logger.warn((Object)"Exception in Clean up OlvidVisibilityCircleUsers task", (Throwable)e);
                                if (!transactionCompletedSuccessfully) break block30;
                            }
                            catch (Throwable throwable) {
                                if (transactionCompletedSuccessfully) {
                                    transactionManager.commit();
                                } else {
                                    transactionManager.rollback();
                                }
                                this.logger.info((Object)"Ending Clean up OlvidVisibilityCircleUsers task");
                                try {
                                    OlvidLogsBackend item = new OlvidLogsBackend();
                                    item.setLogType(new CronJobModel().cleanUpOlvidCircleVisibilityUser);
                                    item.setTimestampStart(currentTimestamp);
                                    item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                                    item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                                    em.persist((Object)item);
                                }
                                catch (Exception exception) {
                                }
                                finally {
                                    transactionManager.commit();
                                }
                                throw throwable;
                            }
                            transactionManager.commit();
                            break block33;
                        }
                        transactionManager.rollback();
                    }
                    this.logger.info((Object)"Ending Clean up OlvidVisibilityCircleUsers task");
                    try {
                        OlvidLogsBackend item = new OlvidLogsBackend();
                        item.setLogType(new CronJobModel().cleanUpOlvidCircleVisibilityUser);
                        item.setTimestampStart(currentTimestamp);
                        item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                        item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                        em.persist((Object)item);
                    }
                    catch (Exception exception) {
                        transactionManager.commit();
                        break block29;
                        catch (Throwable throwable) {
                            transactionManager.commit();
                            throw throwable;
                        }
                    }
                    transactionManager.commit();
                }
            }
        }
    }
}

