/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.timer;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.datatypes.UserOrTopicToNotify;
import io.olvid.keycloak.rest.OlvidServerApiHelper;
import io.olvid.keycloak.timer.cronTask.circlesVisibility.CleanUpOlvidVisibilityCircleRules;
import io.olvid.keycloak.timer.cronTask.circlesVisibility.CleanUpOlvidVisibilityCircleUsers;
import io.olvid.keycloak.timer.cronTask.generic.CleanUpOlvidDataJob;
import io.olvid.keycloak.timer.cronTask.generic.CleanUpRealms;
import io.olvid.keycloak.timer.cronTask.groups.DetectGroupModificationsJob;
import io.olvid.keycloak.timer.cronTask.groups.ExpungeGroupDeletionsAndKicksJob;
import io.olvid.keycloak.timer.cronTask.notifications.GetKeycloakPluginVersionJob;
import io.olvid.keycloak.timer.cronTask.users.DetectUserModificationsJob;
import io.olvid.keycloak.timer.cronTask.users.SynchronizeApiKeysJob;
import io.olvid.keycloak.timer.oneTimeJob.PluginVersionUpgradeOneTimeJob;
import jakarta.persistence.EntityManager;
import java.time.OffsetDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.ExecutionResult;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.timer.TimerProvider;

public class CronScheduler {
    private static CronScheduler INSTANCE = null;
    private final KeycloakSessionFactory factory;
    private final Logger logger;
    private final HashMap<String, CronJob> registeredJobs;
    private final Queue<Runnable> oneTimeJobsQueue;
    private final ExecutorService executorService;
    private final ArrayList<UserOrTopicToNotify> notificationQueue;
    public static final int HOURLY = 3600000;
    public static final int DAILY = 86400000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CronScheduler(KeycloakSessionFactory factory) {
        this.factory = factory;
        this.logger = Logger.getLogger(CronScheduler.class);
        this.logger.info((Object)"Initializing Olvid Cron Scheduler");
        this.registeredJobs = new HashMap();
        this.oneTimeJobsQueue = new ArrayDeque<Runnable>();
        this.executorService = Executors.newCachedThreadPool();
        this.notificationQueue = new ArrayList();
        this.registeredJobs.put("Synchronize API keys and push topics", new CronJob(86400000, new Random().nextInt(7200) * 1000, new SynchronizeApiKeysJob(factory, this.logger)));
        this.registeredJobs.put("Detect user modifications", new CronJob(3600000, new Random().nextInt(3600) * 1000, new DetectUserModificationsJob(factory, this.logger)));
        this.registeredJobs.put("Detect group modifications", new CronJob(3600000, new Random().nextInt(3600) * 1000, new DetectGroupModificationsJob(factory, this.logger)));
        this.registeredJobs.put("Expunge group deletions and member kicks", new CronJob(86400000, 0x6DDD00 + new Random().nextInt(7200) * 1000, new ExpungeGroupDeletionsAndKicksJob(factory, this.logger)));
        this.registeredJobs.put("Clean up olvid data table", new CronJob(86400000, 0x6DDD00 + new Random().nextInt(7200) * 1000, new CleanUpOlvidDataJob(factory, this.logger)));
        this.registeredJobs.put("Clean up visibility circle rules", new CronJob(86400000, 3600000 + new Random().nextInt(7200) * 1000, new CleanUpOlvidVisibilityCircleRules(factory, this.logger)));
        this.registeredJobs.put("Clean up visibility circle users", new CronJob(86400000, 3600000 + new Random().nextInt(7200) * 1000, new CleanUpOlvidVisibilityCircleUsers(factory, this.logger)));
        this.registeredJobs.put("Get Keycloak Plugin version", new CronJob(86400000, 0x6DDD00 + new Random().nextInt(7200) * 1000, new GetKeycloakPluginVersionJob(factory, this.logger)));
        this.registeredJobs.put("Clean up realms", new CronJob(86400000, 0x6DDD00 + new Random().nextInt(7200) * 1000, new CleanUpRealms(factory, this.logger)));
        Queue<Runnable> queue = this.oneTimeJobsQueue;
        synchronized (queue) {
            this.oneTimeJobsQueue.offer(new GetKeycloakPluginVersionJob(factory, this.logger));
            this.oneTimeJobsQueue.offer(new PluginVersionUpgradeOneTimeJob(factory, this.logger));
            this.oneTimeJobsQueue.offer(new CleanUpRealms(factory, this.logger));
        }
        try (KeycloakSession session = factory.create();){
            TimerProvider timer = (TimerProvider)session.getProvider(TimerProvider.class);
            timer.schedule(this::runTasks, 30000L, "Olvid_cron_task");
            timer.schedule(this::sendNotifications, 5000L, "Scheduled_notification_sending");
        }
    }

    public static void initTimer(KeycloakSessionFactory factory) {
        if (INSTANCE == null) {
            INSTANCE = new CronScheduler(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleSendNotifications(Collection<UserOrTopicToNotify> usersAndTopicsToNotify) {
        if (INSTANCE != null) {
            ArrayList<UserOrTopicToNotify> arrayList = CronScheduler.INSTANCE.notificationQueue;
            synchronized (arrayList) {
                CronScheduler.INSTANCE.notificationQueue.addAll(usersAndTopicsToNotify);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleOneTimeJob(Runnable oneTimeJob) {
        if (INSTANCE != null) {
            Queue<Runnable> queue = CronScheduler.INSTANCE.oneTimeJobsQueue;
            synchronized (queue) {
                CronScheduler.INSTANCE.oneTimeJobsQueue.offer(oneTimeJob);
            }
        }
    }

    public static void scheduleOneTimeJobFromManagementConsole(String job) {
        if (job == null) {
            return;
        }
        switch (job) {
            case "synchronizeApiKeys": {
                CronScheduler.scheduleOneTimeJob(new SynchronizeApiKeysJob(CronScheduler.INSTANCE.factory, CronScheduler.INSTANCE.logger));
                break;
            }
            case "detectUserModificationsJob": {
                CronScheduler.scheduleOneTimeJob(new DetectUserModificationsJob(CronScheduler.INSTANCE.factory, CronScheduler.INSTANCE.logger));
                break;
            }
            case "detectGroupModificationsJob": {
                CronScheduler.scheduleOneTimeJob(new DetectGroupModificationsJob(CronScheduler.INSTANCE.factory, CronScheduler.INSTANCE.logger));
                break;
            }
            case "getKeycloakPluginVersionJob": {
                CronScheduler.scheduleOneTimeJob(new GetKeycloakPluginVersionJob(CronScheduler.INSTANCE.factory, CronScheduler.INSTANCE.logger));
                break;
            }
            default: {
                CronScheduler.INSTANCE.logger.warn((Object)("In scheduleOneTimeJobFromManagementConsole, unknown CronJob name " + job));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTasks() {
        Queue<Runnable> queue = this.oneTimeJobsQueue;
        synchronized (queue) {
            Runnable oneTimeJob;
            while ((oneTimeJob = this.oneTimeJobsQueue.poll()) != null) {
                this.executorService.submit(oneTimeJob);
            }
        }
        long timeZoneOffset = (long)OffsetDateTime.now().getOffset().getTotalSeconds() * 1000L;
        long currentTimestamp = System.currentTimeMillis() + timeZoneOffset;
        for (Map.Entry<String, CronJob> task : this.registeredJobs.entrySet()) {
            long timestampInPeriod = currentTimestamp % (long)task.getValue().periodicityMs;
            long periodStart = currentTimestamp - timestampInPeriod;
            long latestSupposedRunTimestamp = periodStart + (long)task.getValue().offsetMs - (long)(timestampInPeriod < (long)task.getValue().offsetMs ? task.getValue().periodicityMs : 0);
            if (task.getValue().lastRunTimestamp >= latestSupposedRunTimestamp || latestSupposedRunTimestamp > currentTimestamp) continue;
            this.logger.info((Object)("Checking if we should run cron job: " + task.getKey()));
            task.getValue().lastRunTimestamp = currentTimestamp;
            this.executorService.submit(() -> {
                try (KeycloakSession session = this.factory.create();){
                    ClusterProvider clusterProvider = (ClusterProvider)session.getProvider(ClusterProvider.class);
                    ExecutionResult result = clusterProvider.executeIfNotExecuted("olvid.cron." + (String)task.getKey(), ((CronJob)task.getValue()).periodicityMs, () -> {
                        this.executorService.submit(((CronJob)task.getValue()).runnable);
                        try {
                            Thread.sleep((long)((CronJob)task.getValue()).periodicityMs * 95L / 100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        return null;
                    });
                    if (!result.isExecuted()) {
                        this.logger.info((Object)("No need to run cron job: " + (String)task.getKey()));
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotifications() {
        ArrayList<UserOrTopicToNotify> batch;
        ArrayList<UserOrTopicToNotify> arrayList = this.notificationQueue;
        synchronized (arrayList) {
            batch = new ArrayList<UserOrTopicToNotify>(this.notificationQueue);
            this.notificationQueue.clear();
        }
        this.executorService.submit(() -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try (KeycloakSession session = this.factory.create();){
                ObjectMapper jsonObjectMapper = new ObjectMapper();
                jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                OlvidServerApiHelper.sendNotifications(session, em, jsonObjectMapper, batch);
            }
        });
    }

    public static class CronJob {
        public final int periodicityMs;
        public final int offsetMs;
        public final Runnable runnable;
        public long lastRunTimestamp;

        public CronJob(int periodicityMs, int offsetMs, Runnable runnable) {
            this.periodicityMs = periodicityMs;
            this.offsetMs = offsetMs;
            this.runnable = runnable;
            this.lastRunTimestamp = System.currentTimeMillis() + (long)OffsetDateTime.now().getOffset().getTotalSeconds() * 1000L;
        }
    }
}

