/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.wellknown;

import io.olvid.keycloak.jpa.OlvidConfigurationDao;
import io.olvid.keycloak.rest.wellknown.OlvidWellKnownJson;
import io.olvid.keycloak.rest.wellknown.OlvidWellKnownMinVersionsJson;
import jakarta.persistence.EntityManager;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.wellknown.WellKnownProvider;

public class OlvidWellKnownProvider
implements WellKnownProvider {
    private final KeycloakSession keycloakSession;

    public OlvidWellKnownProvider(KeycloakSession keycloakSession) {
        this.keycloakSession = keycloakSession;
    }

    public Object getConfig() {
        EntityManager em = ((JpaConnectionProvider)this.keycloakSession.getProvider(JpaConnectionProvider.class)).getEntityManager();
        OlvidWellKnownJson wellKnown = new OlvidWellKnownJson();
        wellKnown.supportIdentityAuthentication = OlvidConfigurationDao.getBooleanConfiguration(em, this.keycloakSession.getContext().getRealm().getId(), "enableAuthenticationWithOlvidId", false);
        OlvidWellKnownMinVersionsJson minBuildVersions = new OlvidWellKnownMinVersionsJson();
        minBuildVersions.android = 200;
        minBuildVersions.ios = 650;
        minBuildVersions.desktop = 20000;
        minBuildVersions.daemon = 200000;
        wellKnown.minBuildVersions = minBuildVersions;
        wellKnown.apiVersion = 1;
        return wellKnown;
    }

    public void close() {
    }
}

