/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.engine.requestChallenge;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.datatypes.crypto.PRNGHolder;
import io.olvid.keycloak.datatypes.encoder.Encoded;
import io.olvid.keycloak.rest.api.AbstractEngineEntryPoint;
import jakarta.persistence.EntityManager;
import jakarta.ws.rs.core.Response;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;

public class RequestChallenge
extends AbstractEngineEntryPoint {
    protected static final Logger logger = Logger.getLogger(RequestChallenge.class);

    public RequestChallenge(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(byte[] postData) {
        byte[] nonce;
        String userId;
        try {
            Encoded[] list = new Encoded(postData).decodeList();
            userId = list[0].decodeString();
            nonce = list[1].decodeBytes();
            if (nonce.length != 32) {
                throw new IllegalArgumentException("Invalid nonce length");
            }
        }
        catch (Exception e) {
            return this.parsingError();
        }
        byte[] challenge = PRNGHolder.get().bytes(32);
        Response response = this.getResponse(Encoded.of(new Encoded[]{Encoded.of(STATUS_OK), Encoded.of(challenge), Encoded.of(nonce)}));
        UserModel userModel = this.session.users().getUserById(this.session.getContext().getRealm(), userId);
        if (userModel == null) {
            logger.warn((Object)"requestChallenge: user not found");
            return response;
        }
        String identityString = userModel.getAttributeStream("olvid-identity").findFirst().orElse(null);
        if (identityString == null) {
            logger.warn((Object)"requestChallenge: user identity not found");
            return response;
        }
        InfinispanConnectionProvider provider = (InfinispanConnectionProvider)this.session.getProvider(InfinispanConnectionProvider.class);
        Cache actionTokenCache = provider.getCache("actionTokens");
        actionTokenCache.put((Object)EncodedChallenge.getCacheKey(nonce), (Object)new EncodedChallenge(userId, challenge).encode(), 60L, TimeUnit.SECONDS);
        return response;
    }

    public static class EncodedChallenge {
        public final String userId;
        public final byte[] challenge;

        public EncodedChallenge(String userId, byte[] challenge) {
            this.userId = userId;
            this.challenge = challenge;
        }

        public static String getCacheKey(byte[] nonce) {
            return "challenge-" + Base64.getEncoder().encodeToString(nonce);
        }

        public String encode() {
            Encoded encoded = Encoded.of(new Encoded[]{Encoded.of(this.userId), Encoded.of(this.challenge)});
            return Base64.getEncoder().encodeToString(encoded.getBytes());
        }

        public static EncodedChallenge decode(String encodedChallenge) throws Exception {
            byte[] bytesEncodedChallenge = Base64.getDecoder().decode(encodedChallenge);
            Encoded[] list = new Encoded(bytesEncodedChallenge).decodeList();
            return new EncodedChallenge(list[0].decodeString(), list[1].decodeBytes());
        }
    }
}

