/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.engine.getSession;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.classes.constants.Constants;
import io.olvid.keycloak.datatypes.crypto.Identity;
import io.olvid.keycloak.datatypes.crypto.Signature;
import io.olvid.keycloak.datatypes.crypto.Suite;
import io.olvid.keycloak.datatypes.crypto.keys.ServerAuthenticationECSdsaPublicKey;
import io.olvid.keycloak.datatypes.crypto.keys.SignatureECSdsaPublicKey;
import io.olvid.keycloak.datatypes.encoder.DecodingException;
import io.olvid.keycloak.datatypes.encoder.Encoded;
import io.olvid.keycloak.jpa.OlvidConfigurationDao;
import io.olvid.keycloak.rest.Utils;
import io.olvid.keycloak.rest.api.AbstractEngineEntryPoint;
import io.olvid.keycloak.rest.engine.requestChallenge.RequestChallenge;
import jakarta.persistence.EntityManager;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Base64;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;

public class GetSession
extends AbstractEngineEntryPoint {
    protected static final Logger logger = Logger.getLogger(GetSession.class);

    public GetSession(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(byte[] postData) {
        boolean identityAuthenticationEnabled;
        Identity identity;
        RequestChallenge.EncodedChallenge encodedChallenge;
        byte[] nonce;
        byte[] challengeResponse;
        try {
            Encoded[] list = new Encoded(postData).decodeList();
            challengeResponse = list[0].decodeBytes();
            if (challengeResponse.length != 80 && challengeResponse.length != 112) {
                throw new Exception("Bad response length");
            }
            nonce = list[1].decodeBytes();
            if (nonce.length != 32) {
                throw new Exception("Bad nonce length");
            }
        }
        catch (Exception e) {
            return this.parsingError();
        }
        try {
            InfinispanConnectionProvider provider = (InfinispanConnectionProvider)this.session.getProvider(InfinispanConnectionProvider.class);
            Cache actionTokenCache = provider.getCache("actionTokens");
            String cacheKey = RequestChallenge.EncodedChallenge.getCacheKey(nonce);
            if (!actionTokenCache.containsKey((Object)cacheKey)) {
                throw new Exception("Challenge not foud in cache");
            }
            encodedChallenge = RequestChallenge.EncodedChallenge.decode((String)actionTokenCache.remove((Object)cacheKey));
        }
        catch (Exception e) {
            logger.error((Object)"getSession: challenge not found", (Throwable)e);
            return this.generalError();
        }
        UserModel userModel = this.session.users().getUserById(this.session.getContext().getRealm(), encodedChallenge.userId);
        if (userModel == null) {
            logger.warn((Object)"getSession: user not found");
            return this.generalError();
        }
        String identityString = userModel.getAttributeStream("olvid-identity").findFirst().orElse(null);
        if (identityString == null) {
            logger.warn((Object)"getSession: user identity not found");
            return this.permissionDenied();
        }
        try {
            identity = Identity.of(Base64.getDecoder().decode(identityString));
        }
        catch (DecodingException e) {
            logger.error((Object)"getSession: cannot decode user identity");
            return this.permissionDenied();
        }
        byte[] formattedChallenge = new byte[Constants.TOKEN_SIGNATURE_PREFIX.length + encodedChallenge.challenge.length + 16];
        System.arraycopy(Constants.TOKEN_SIGNATURE_PREFIX, 0, formattedChallenge, 0, Constants.TOKEN_SIGNATURE_PREFIX.length);
        System.arraycopy(encodedChallenge.challenge, 0, formattedChallenge, Constants.TOKEN_SIGNATURE_PREFIX.length, encodedChallenge.challenge.length);
        System.arraycopy(challengeResponse, 0, formattedChallenge, Constants.TOKEN_SIGNATURE_PREFIX.length + encodedChallenge.challenge.length, 16);
        byte[] signature = Arrays.copyOfRange(challengeResponse, 16, challengeResponse.length);
        SignatureECSdsaPublicKey signaturePublicKey = ((ServerAuthenticationECSdsaPublicKey)identity.getServerAuthenticationPublicKey()).getSignaturePublicKey();
        Signature signer = Suite.getSignature(signaturePublicKey);
        try {
            if (!signer.verify(signaturePublicKey, formattedChallenge, signature)) {
                logger.error((Object)"getSession: signature verification failed");
                throw new Exception("Invalid response");
            }
        }
        catch (Exception e) {
            logger.error((Object)"getSession: signature verification failed", (Throwable)e);
            return this.permissionDenied();
        }
        if (!Utils.isBotUser(userModel) && !(identityAuthenticationEnabled = OlvidConfigurationDao.getBooleanConfiguration(this.em, this.session.getContext().getRealm().getId(), "enableAuthenticationWithOlvidId", false))) {
            logger.error((Object)"getSession: identity authentication disabled for realm");
            return this.permissionDenied();
        }
        String olvidClientId = OlvidConfigurationDao.getStringConfiguration(this.em, this.session.getContext().getRealm().getId(), "authClient");
        if (olvidClientId == null) {
            logger.error((Object)"getSession: client id not found");
            return this.generalError();
        }
        ClientModel clientModel = this.session.getContext().getRealm().getClientByClientId(olvidClientId);
        if (clientModel == null) {
            logger.error((Object)"getSession: client not found");
            return this.generalError();
        }
        try {
            byte[] sessionAndTokenBytes = this.objectMapper.writeValueAsBytes((Object)Utils.createSessionAndToken(this.session, this.session.getContext().getRealm(), clientModel, userModel, true));
            return this.getResponse(Encoded.of(new Encoded[]{Encoded.of(STATUS_OK), Encoded.of(sessionAndTokenBytes)}));
        }
        catch (Exception e) {
            logger.error((Object)"getSession: cannot create session", (Throwable)e);
            return this.generalError();
        }
    }
}

