/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.revocationTest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.rest.Utils;
import io.olvid.keycloak.rest.api.AbstractEntryPoint;
import io.olvid.keycloak.rest.api.configuration.Configuration;
import io.olvid.keycloak.rest.api.revocationTest.JsonRevocationTestRequest;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.entities.UserAttributeEntity;
import org.keycloak.models.jpa.entities.UserEntity;

public class RevocationTest
extends AbstractEntryPoint {
    protected static final Logger logger = Logger.getLogger(RevocationTest.class);

    public RevocationTest(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(byte[] postData) {
        byte[] response;
        block8: {
            JsonRevocationTestRequest request;
            try {
                request = (JsonRevocationTestRequest)this.objectMapper.readValue(postData, JsonRevocationTestRequest.class);
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to parse revocationTest post data. ", (Throwable)e);
                return this.invalidRequestDevice();
            }
            response = new byte[]{0};
            TypedQuery query = this.em.createQuery("SELECT attr FROM UserAttributeEntity attr WHERE attr.name = :name AND attr.value = :nonce", UserAttributeEntity.class).setParameter("name", (Object)"olvid-nonce").setParameter("nonce", (Object)request.getNonce());
            try {
                UserAttributeEntity userAttribute = (UserAttributeEntity)query.getSingleResult();
                UserEntity userEntity = userAttribute.getUser();
                RealmModel realmModel = this.session.getContext().getRealm();
                if (userEntity.isEnabled() || realmModel == null) break block8;
                try {
                    UserModel userModel = this.session.users().getUserById(realmModel, userEntity.getId());
                    if (userModel != null) {
                        String identity = Utils.getUserAttribute(userModel, "olvid-identity");
                        if (identity != null && !Utils.isUnboundUser(userModel)) {
                            ObjectMapper jsonObjectMapper = new ObjectMapper();
                            jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                            Configuration.subProcessRevokeUsers(this.em, this.session, "revocationTest", realmModel.getName(), Collections.singletonList(userModel.getId()), 2, realmModel, jsonObjectMapper);
                        }
                        response[0] = 1;
                    }
                }
                catch (Exception e) {
                    return this.internalErrorDevice();
                }
            }
            catch (NoResultException e) {
                response[0] = 1;
            }
        }
        return Response.ok((Object)response, (String)"application/octet-stream").build();
    }
}

