/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.getMagicSession;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.credentials.MagicTokenCredentialProvider;
import io.olvid.keycloak.jpa.OlvidConfigurationDao;
import io.olvid.keycloak.rest.Utils;
import io.olvid.keycloak.rest.api.AbstractEntryPoint;
import io.olvid.keycloak.rest.api.getMagicSession.JsonGetMagicSessionRequest;
import jakarta.persistence.EntityManager;
import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;

public class GetMagicSession
extends AbstractEntryPoint {
    protected static final Logger logger = Logger.getLogger(GetMagicSession.class);

    public GetMagicSession(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(byte[] postData) {
        JsonGetMagicSessionRequest request;
        try {
            request = (JsonGetMagicSessionRequest)this.objectMapper.readValue(postData, JsonGetMagicSessionRequest.class);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to parse magic post data. ", (Throwable)e);
            return this.invalidRequestDevice();
        }
        UserModel userModel = this.session.users().getUserByUsername(this.session.getContext().getRealm(), request.username);
        if (userModel == null) {
            return this.invalidRequestDevice();
        }
        if (!MagicTokenCredentialProvider.isUserMagicTokenValid(userModel, request.token)) {
            return this.invalidRequestDevice();
        }
        String olvidClientId = OlvidConfigurationDao.getStringConfiguration(this.em, this.session.getContext().getRealm().getId(), "authClient");
        if (olvidClientId == null) {
            logger.error((Object)"GetMagicSession: client id not found");
            return this.internalError();
        }
        ClientModel clientModel = this.session.getContext().getRealm().getClientByClientId(olvidClientId);
        if (clientModel == null) {
            logger.error((Object)"GetMagicSession: client not found");
            return this.internalError();
        }
        return Response.ok((Object)Utils.createSessionAndToken(this.session, this.session.getContext().getRealm(), clientModel, userModel, true), (String)"application/json").build();
    }
}

