/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.getDirectAuthToken;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.credentials.DirectAuthTokenCredentialProvider;
import io.olvid.keycloak.rest.api.AbstractEntryPoint;
import io.olvid.keycloak.rest.api.getDirectAuthToken.JsonGetDirectAuthTokenRequest;
import io.olvid.keycloak.rest.api.getDirectAuthToken.JsonGetDirectAuthTokenResponse;
import jakarta.persistence.EntityManager;
import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;

public class GetDirectAuthToken
extends AbstractEntryPoint {
    protected static final Logger logger = Logger.getLogger(GetDirectAuthToken.class);

    public GetDirectAuthToken(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(byte[] postData) {
        JsonGetDirectAuthTokenRequest request;
        try {
            request = (JsonGetDirectAuthTokenRequest)this.objectMapper.readValue(postData, JsonGetDirectAuthTokenRequest.class);
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to parse magic post data. ", (Throwable)e);
            return this.invalidRequestDevice();
        }
        String token = DirectAuthTokenCredentialProvider.getUserTokenFromNonce(this.session, request.username, request.nonce);
        if (token == null) {
            logger.error((Object)"Invalid nonce");
            return this.permissionDeniedDevice();
        }
        try {
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)new JsonGetDirectAuthTokenResponse(token)), (String)"application/json").build();
        }
        catch (Exception e) {
            return this.internalErrorDevice();
        }
    }
}

