/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.configuration;

public class ConfigurationDbQuery {
    public static final String SELECT_QUERY_FILTER_OR = " OR (( attr.name = 'olvid-position' AND attr.value LIKE :?) OR ( attr.name = 'olvid-company' AND attr.value LIKE :?) OR u.firstName LIKE :? OR u.lastName LIKE :? OR u.username LIKE :? ) ";
    public static final String SELECT_QUERY_ALL = "SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId";
    public static final String SELECT_QUERY_ALL_DEVICES = " SELECT oud, u FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId ";
    public static final String SELECT_QUERY_ALL_USER_FROM_ATTRIBUTE = " SELECT DISTINCT u FROM UserEntity u  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'LDAP_ENTRY_DN' AND (attr.value IN :filters))";
    public static final String SELECT_QUERY_ALL_USER_DEVICES = " SELECT oud, u FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId AND oud.userId = :userId";
    public static final String SELECT_QUERY_GROUP_ALL = " SELECT DISTINCT u FROM UserEntity u  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId ";
    public static final String SELECT_QUERY_USERS_BY_USERNAME = " SELECT DISTINCT u, ocv as olvidCircleVisibility FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId and u.username in :usersList";
    public static final String SELECT_QUERY_USERS_BY_IDS = " SELECT DISTINCT u, ocv as olvidCircleVisibility FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId and u.id in :list";
    public static final String SELECT_QUERY_COUNT = "SELECT COUNT(DISTINCT u) FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId";
    public static final String SELECT_QUERY_COUNT_DEVICES = " SELECT COUNT(oud) FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId ";
    public static final String SELECT_QUERY_COUNT_USER_DEVICES = " SELECT COUNT(oud) FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId AND oud.userId = :userId";
    public static final String SELECT_QUERY_COUNT_DEVICES_UNKNOWN = " SELECT COUNT(oud) FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId AND oud.isKnown = false";
    public static final String SELECT_QUERY_COUNT_OLD_DEVICES = " SELECT COUNT(oud) FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId LEFT JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId AND oud.lastSync < :oldDeviceTimeLimit AND oud.isKnown = true";
    public static final String SELECT_QUERY_COUNT_USER_OLD_DEVICES = "SELECT count(distinct u.username) FROM UserEntity u  LEFT JOIN u.attributes attr  INNER JOIN OlvidUserDevice oud ON u.id = oud.userId LEFT JOIN u.credentials cred on cred.type = 'password' left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId AND oud.lastSync < :oldDeviceTimeLimit";
    public static final String SELECT_QUERY_COUNT_OLD_USERs = "SELECT  count(distinct u.username)  FROM UserEntity u  INNER JOIN OlvidUser ou ON u.id = ou.userId AND u.realmId = ou.realmId  WHERE u.realmId = :realmId AND ou.lastSync < :oldDeviceTimeLimit";
    public static final String SELECT_QUERY_COUNT_WITH_CREDENTIAL = " SELECT COUNT(DISTINCT u) FROM UserEntity u  LEFT JOIN u.attributes attr  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.credentials cred on cred.type = 'password' WHERE u.realmId = :realmId AND (cred.id is null)";
    public static final String SELECT_QUERY_COUNT_OLVID_IDENTITY_USERS = " SELECT COUNT(DISTINCT u) FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE attr.name = 'olvid-identity'  AND u.realmId = :realmId ";
    public static final String SELECT_QUERY_COUNT_BOT = "SELECT COUNT(DISTINCT u) FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-is-bot')";
    public static final String SELECT_QUERY_COUNT_USER_DEVICES_UNKNOWN = "SELECT COUNT(DISTINCT(u)) FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  INNER JOIN OlvidUserDevice oud ON u.id = oud.userId WHERE u.realmId = :realmId AND oud.isKnown = false";
    public static final String SELECT_QUERY_COUNT_USERS_BY_USERNAME = " SELECT COUNT(DISTINCT u) FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId and u.username in :usersList";
    public static final String SELECT_QUERY_WITHOUT_USERS_FEDERATION = "SELECT DISTINCT u FROM UserEntity u  LEFT JOIN u.attributes attr WHERE u.realmId = :realmId AND attr.name in ('LDAP_ID', 'KERBEROS_PRINCIPAL')";
    public static final String SELECT_QUERY_WITHOUT_USERS_ID_PROVIDER = "SELECT DISTINCT u FROM UserEntity u  LEFT JOIN u.attributes attr WHERE u.realmId = :realmId AND size(u.federatedIdentities)>0";
    public static final String SELECT_QUERY_FILTER_CREDENTIAL = " SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN u.credentials cred on cred.type = 'password' left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId AND ((cred.id is null) AND u not in (SELECT DISTINCT u FROM UserEntity u  LEFT JOIN u.attributes attr WHERE u.realmId = :realmId AND attr.name in ('LDAP_ID', 'KERBEROS_PRINCIPAL'))) AND ((cred.id is null) AND u not in (SELECT DISTINCT u FROM UserEntity u  LEFT JOIN u.attributes attr WHERE u.realmId = :realmId AND size(u.federatedIdentities)>0))";
    public static final String SELECT_QUERY_FILTER_ACTIVATED = "SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  LEFT JOIN u.attributes attr_unbound on attr_unbound.name = 'olvid-unbound'  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  LEFT JOIN u.credentials cred on cred.type = 'password' WHERE u.realmId = :realmId  AND (attr.name = 'olvid-identity') AND attr_unbound.value is null ";
    public static final String SELECT_QUERY_FILTER_ENABLED = " SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId  AND u.enabled = true";
    public static final String SELECT_QUERY_COUNT_FILTER_ENABLED = " SELECT  count(distinct u)  FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId  AND u.enabled = true";
    public static final String SELECT_QUERY_FILTER_DISABLED = " SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId  AND u.enabled is false";
    public static final String SELECT_QUERY_COUNT_FILTER_DISABLED = " SELECT  count(distinct u)  FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId  AND u.enabled is false";
    public static final String SELECT_ID_QUERY_FILTER_ACTIVATED = " SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN u.attributes attr_unbound on attr_unbound.name = 'olvid-unbound'  AND u.enabled = true  WHERE u.realmId = :realmId  AND attr_unbound.value is null  AND (attr.name = 'olvid-identity')";
    public static final String SELECT_QUERY_FILTER_NOT_ACTIVATED = " SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN u.credentials cred on cred.type = 'password' left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId AND u.id not in ( SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN u.attributes attr_unbound on attr_unbound.name = 'olvid-unbound'  AND u.enabled = true  WHERE u.realmId = :realmId  AND attr_unbound.value is null  AND (attr.name = 'olvid-identity'))";
    public static final String SELECT_QUERY_FILTER_BOT = "SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-is-bot')";
    public static final String SELECT_QUERY_FILTER_USER_DEVICES_UNKNOWN = "SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  LEFT JOIN u.attributes attr  INNER JOIN OlvidUserDevice oud ON u.id = oud.userId LEFT JOIN u.credentials cred on cred.type = 'password' left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilit9y9.yId = ocv.id  WHERE u.realmId = :realmId AND oud.isKnown = false";
    public static final String SELECT_QUERY_FILTER_USER_OLD_DEVICES = "SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  LEFT JOIN u.attributes attr  INNER JOIN OlvidUserDevice oud ON u.id = oud.userId LEFT JOIN u.credentials cred on cred.type = 'password' left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId AND oud.lastSync < :oldDeviceTimeLimit AND oud.isKnown = true";
    public static final String SELECT_QUERY_FILTER_DEVICES_UNKNOWN = " SELECT oud, u FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId AND oud.isKnown = false";
    public static final String SELECT_QUERY_FILTER_OLD_DEVICES = "SELECT oud, u FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId AND oud.lastSync < :oldDeviceTimeLimit AND oud.isKnown = true";
    public static final String SELECT_QUERY_COUNT_WITHOUT_OLVID_IDENTITY_USERS = " SELECT COUNT(DISTINCT u) FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId AND u.id not in ( SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN u.attributes attr_unbound on attr_unbound.name = 'olvid-unbound'  AND u.enabled = true  WHERE u.realmId = :realmId  AND attr_unbound.value is null  AND (attr.name = 'olvid-identity'))";
    public static final String SELECT_QUERY_FILTER_AND = " AND (( attr.name = 'olvid-position' AND LOWER(attr.value) LIKE :?) OR ( attr.name = 'olvid-company' AND LOWER(attr.value) LIKE :?) OR LOWER(u.firstName) LIKE :? OR LOWER(u.lastName) LIKE :? OR LOWER(u.username) LIKE :? OR LOWER(u.email) LIKE :? OR LOWER(ocv.name) LIKE :?) ";
    public static final String SELECT_QUERY_FILTER_USERNAME_IN_LIST = " AND (u.username IN :usernameList)";
    public static final String SELECT_QUERY_FILTER_ID_IN_LIST = " AND (u.id IN :list)";
    public static final String SELECT_DEVICES_QUERY_FILTER_AND = " AND (LOWER(oud.displayName) LIKE :? OR LOWER(u.firstName) LIKE :? OR LOWER(u.lastName) LIKE :? OR LOWER(u.username) LIKE :?) ";
    public static final String SELECT_QUERY_CIRCLE_VISIBILITY = " SELECT olgv FROM OlvidCircleVisibility olgv  WHERE olgv.realmId = :realmId";
    public static final String SELECT_QUERY_COUNT_CIRCLE_VISIBILITY = " SELECT COUNT(olgv) FROM OlvidCircleVisibility olgv  WHERE olgv.realmId = :realmId ";
    public static final String SELECT_QUERY_COUNT_CIRCLE_VISIBILITY_MEMBERS = " SELECT COUNT(olgvu) FROM OlvidCircleVisibilityUser olgvu  WHERE olgvu.realmId = :realmId AND olgvu.userId in :usersList ";
    public static final String SELECT_QUERY_COUNT_CIRCLE_VISIBILITY_MEMBERS_FILTERED = " SELECT count(DISTINCT u)FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId and u.id in :list";
    public static final String SELECT_QUERY_COUNT_CIRCLE_VISIBILITY_MEMBERS_BY_CIRCLE_ID = " SELECT COUNT(olgvu) FROM OlvidCircleVisibilityUser olgvu  WHERE olgvu.realmId = :realmId AND olgvu.circleVisibilityId in :id ";
    public static final String SELECT_QUERY_COUNT_MEMBERS_WITHOUT_CIRCLE_VISIBILITY = " SELECT count(DISTINCT u) FROM UserEntity u  LEFT JOIN OlvidCircleVisibilityUser olgvu on olgvu.userId = u.id  WHERE u.realmId = :realmId and olgvu.userId is null";
    public static final String SELECT_QUERY_USERS_WITHOUT_CIRCLE_VISIBILITY = " SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  LEFT JOIN u.attributes attr  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId and ocvu.userId is null";
    public static final String SELECT_QUERY_USERS_IDS_WITHOUT_CIRCLE_VISIBILITY_RESTRICTED = " SELECT distinct u.id FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId and ocvu.userId is null";
    public static final String SELECT_QUERY_COUNT_USERS_WITHOUT_CIRCLE_VISIBILITY = " SELECT count(DISTINCT u) FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN OlvidCircleVisibilityUser ocvu on ocvu.userId = u.id  LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId and ocvu.userId is null";
    public static final String SELECT_CIRCLE_MEMBERS_WITH_INFORMATIONS = " SELECT u as userEntity, ocvu as olvidCircleVisibilityUser, ocv as olvidCircleVisibility, ocvr as olvidCircleVisibilityRules FROM UserEntity u  LEFT JOIN u.attributes attr  RIGHT JOIN OlvidCircleVisibilityUser ocvu on ocvu.userId = u.id  LEFT JOIN OlvidCircleVisibility ocv on ocv.id = ocvu.circleVisibilityId  LEFT JOIN OlvidCircleVisibilityRules ocvr on (ocvr.circleVisibilityId1From = ocv.id or ocvr.circleVisibilityId2To = ocv.id) WHERE u.realmId = :realmId";
    public static final String SELECT_QUERY_GET_DASHBOARD = " SELECT  r.id as realmId, u.username, oc.value, a.value as activated  FROM RealmEntity r LEFT JOIN OlvidConfiguration oc ON oc.realmId = r.id AND oc.name = 'serverKeycloakApiKey'  LEFT JOIN UserEntity u ON u.realmId = r.id LEFT JOIN u.attributes AS a ON a.name = 'olvid-identity'  WHERE r.id in ( SELECT oc2.realmId FROM OlvidConfiguration oc2 WHERE oc2.name = 'olvid' and oc2.value = 'true')";
}

