/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.configuration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.classes.constants.Constants;
import io.olvid.keycloak.classes.constants.ConstantsCircleVisibility;
import io.olvid.keycloak.classes.constants.EmailConstants;
import io.olvid.keycloak.classes.constants.ResponseConstants;
import io.olvid.keycloak.classes.models.circleVisibility.CircleVisibilityChangeVisibilityRuleModel;
import io.olvid.keycloak.classes.models.circleVisibility.CircleVisibilityEditVisibilityRuleModel;
import io.olvid.keycloak.classes.models.circleVisibility.CircleVisibilityModel;
import io.olvid.keycloak.classes.models.circleVisibility.CircleVisibilityRuleModel;
import io.olvid.keycloak.classes.models.circleVisibility.CirclesVisibilityRulesModel;
import io.olvid.keycloak.classes.models.circleVisibility.CreateCircleVisibilityModel;
import io.olvid.keycloak.classes.models.circleVisibility.OlvidCircleVisibilityRulesListModel;
import io.olvid.keycloak.classes.models.dashboard.DashboardJPAModel;
import io.olvid.keycloak.classes.models.dashboard.DashboardLicensesModel;
import io.olvid.keycloak.classes.models.dashboard.DashboardModel;
import io.olvid.keycloak.classes.models.dashboard.DashboardOldDataModel;
import io.olvid.keycloak.classes.models.dashboard.DashboardUsersModel;
import io.olvid.keycloak.classes.models.externalLinks.ExternalLinkModel;
import io.olvid.keycloak.classes.models.groups.CreateOlvidGroupModel;
import io.olvid.keycloak.classes.models.groups.GroupDuplicateSettingsModel;
import io.olvid.keycloak.classes.models.groups.GroupUserModel;
import io.olvid.keycloak.classes.models.groups.KeycloakProviderGroupMapperModel;
import io.olvid.keycloak.classes.models.groups.UpdateOlvidGroupModel;
import io.olvid.keycloak.classes.models.logs.LogModel;
import io.olvid.keycloak.classes.models.managers.CustomBasicWithPasswordModel;
import io.olvid.keycloak.classes.models.managers.CustomManagerBasicModel;
import io.olvid.keycloak.classes.models.managers.CustomManagerModel;
import io.olvid.keycloak.classes.models.realms.ClientInfoModel;
import io.olvid.keycloak.classes.models.realms.CronJobModel;
import io.olvid.keycloak.classes.models.realms.KeyPropertiesModel;
import io.olvid.keycloak.classes.models.realms.RealmBasicInfoModel;
import io.olvid.keycloak.classes.models.realms.RealmConfigModel;
import io.olvid.keycloak.classes.models.realms.RealmMainConfigModel;
import io.olvid.keycloak.classes.models.realms.RealmSettingsModel;
import io.olvid.keycloak.classes.models.realms.RealmsGlobalSettingsModel;
import io.olvid.keycloak.classes.models.revocations.RevocationModel;
import io.olvid.keycloak.classes.models.users.CustomUserBasicWithPasswordModel;
import io.olvid.keycloak.classes.models.users.CustomUserModel;
import io.olvid.keycloak.classes.models.users.UserModelAttributes;
import io.olvid.keycloak.classes.modelsDevices.OlvidUserDeviceModel;
import io.olvid.keycloak.credentials.MagicTokenModel;
import io.olvid.keycloak.datatypes.JsonSharedSettings;
import io.olvid.keycloak.datatypes.OlvidUserDetails;
import io.olvid.keycloak.datatypes.OlvidUserDetailsSignatureSignerContext;
import io.olvid.keycloak.datatypes.UserOrTopicToNotify;
import io.olvid.keycloak.datatypes.crypto.PRNGHolder;
import io.olvid.keycloak.datatypes.crypto.keys.AuthEncAES256ThenSHA256Key;
import io.olvid.keycloak.datatypes.encoder.Encoded;
import io.olvid.keycloak.jpa.OlvidCircleVisibility;
import io.olvid.keycloak.jpa.OlvidCircleVisibilityRules;
import io.olvid.keycloak.jpa.OlvidCircleVisibilityUser;
import io.olvid.keycloak.jpa.OlvidConfigurationDao;
import io.olvid.keycloak.jpa.OlvidConsoleLogs;
import io.olvid.keycloak.jpa.OlvidConsoleLogsDao;
import io.olvid.keycloak.jpa.OlvidData;
import io.olvid.keycloak.jpa.OlvidDataDao;
import io.olvid.keycloak.jpa.OlvidExternalLink;
import io.olvid.keycloak.jpa.OlvidExternalLinkDao;
import io.olvid.keycloak.jpa.OlvidGroup;
import io.olvid.keycloak.jpa.OlvidGroupDao;
import io.olvid.keycloak.jpa.OlvidLogsBackend;
import io.olvid.keycloak.jpa.OlvidNotifications;
import io.olvid.keycloak.jpa.OlvidNotificationsDao;
import io.olvid.keycloak.jpa.OlvidRevocation;
import io.olvid.keycloak.jpa.OlvidRevocationDao;
import io.olvid.keycloak.jpa.OlvidUser;
import io.olvid.keycloak.jpa.OlvidUserDevice;
import io.olvid.keycloak.rest.ConfigurationLinkHelper;
import io.olvid.keycloak.rest.OlvidServerApiHelper;
import io.olvid.keycloak.rest.Utils;
import io.olvid.keycloak.rest.api.AbstractAdminApiEntryPoint;
import io.olvid.keycloak.rest.api.apiModels.configurations.payload.users.CreateUserMagicLinkPayloadModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.payload.users.RevokeUserMagicLinksPayloadModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.payload.users.bots.CreateBotPayloadModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.circlesVisibilities.AddCircleVisibilityResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.circlesVisibilities.EditCircleVisibilityResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.circlesVisibilities.GetCircleVisibilityMembersFilteredResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.circlesVisibilities.GetCircleVisibilityResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.circlesVisibilities.GetCircleVisibilityRulesByCirclesResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.circlesVisibilities.GetCirclesVisibilitiesFilteredResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.dashboard.GetDashboardResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.devices.GetDevicesResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.devices.SetKnownDeviceResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.emails.SendAutomaticPasswordResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.externalLinks.CreateExternalLinksResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.externalLinks.GetExternalLinksResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.externalLinks.RevokeExternalLinksResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.externalLinks.UpdateExternalLinksResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.generic.GenericReponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.groups.AddGroupUserResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.groups.CreateOlvidGroupResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.groups.DuplicateGroupResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.groups.GetGroupAvatarResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.groups.GetGroupEphemeralSettingsResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.groups.GetGroupsByIdResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.groups.GetGroupsByNameResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.groups.GetGroupsResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.groups.RemoveGroupAvatarResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.groups.UpdateOlvidGroupByIdResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.logs.GetLogsResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.logs.GetLogsTypesResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.managers.AddManagerResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.managers.GetManagerUsersResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.notifications.GetNotificationsResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.notifications.PluginVersionInformationsResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.realms.GetRealmGlobalSettingsResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.realms.GetRealmSettingsResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.realms.GetRealmsBasicInfoResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.realms.GetRealmsConfigurationResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.realms.GetRealmsMainAttributesResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.revocations.GetRevocationsResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.AddUserResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.AddUsersByListResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.CreateUserMagicLinkResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.GetUserByUsernameResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.GetUserGroupsResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.GetUsersByUsernameResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.GetUsersFilteredResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.RemoveOlvidGroupUsersResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.SignOutUsersResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.UpdateUserResetPasswordResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.bots.GetBotsFilteredResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.utils.DownloadXslxCsvUsersResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.utils.GetEmailContentResponseModel;
import io.olvid.keycloak.rest.api.configuration.ConfigurationQueryJson;
import io.olvid.keycloak.rest.api.configuration.GroupMembersQueryType;
import io.olvid.keycloak.timer.CronScheduler;
import io.olvid.keycloak.timer.oneTimeJob.PluginVersionUpgradeOneTimeJob;
import io.olvid.keycloak.utils.mail.Email;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.ExecutionResult;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.crypto.KeyStatus;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.email.EmailSenderProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.credential.PasswordCredentialModel;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPStorageProviderFactory;
import org.keycloak.storage.ldap.idm.query.Condition;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQueryConditionsBuilder;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPIdentityStore;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;

public class Configuration
extends AbstractAdminApiEntryPoint {
    protected static final Logger logger = Logger.getLogger(Configuration.class);

    public Configuration(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(byte[] postData) {
        block87: {
            try {
                ConfigurationQueryJson.QueryJson query = (ConfigurationQueryJson.QueryJson)this.objectMapper.readValue(postData, ConfigurationQueryJson.QueryJson.class);
                String role = this.authenticatedUser.getFirstAttribute("olvid-role");
                boolean isQueryAllowed = this.checkQueryIsAllowed(query.q, role);
                if (isQueryAllowed) {
                    logger.infof("Called \"configuration\", query " + query.q, new Object[0]);
                    switch (query.q) {
                        case 0: {
                            return this.processGetErrorContainersVersionQuery();
                        }
                        case 3: {
                            return this.processGetRealmsQuery();
                        }
                        case 42: {
                            return this.processGetRealmsGlobalSettings();
                        }
                        case 43: {
                            return this.processGetRealmSettings(role, query.realmName);
                        }
                        case 44: {
                            return this.processSetRealmsSettings(role, query.realmName, query.realmSettings);
                        }
                        case 4: {
                            return this.processGetRealmsMainAttributesQuery(role);
                        }
                        case 6: {
                            return this.processSetRealmsConfig(query.realmListSettings);
                        }
                        case 41: {
                            return this.processSetRealmsGlobalSettings(query.realmGlobalSettings);
                        }
                        case 7: {
                            return this.processSetRole(role, query.realmName, query.roleList);
                        }
                        case 8: {
                            return this.processGetManagersUsers(role, query.realmName, query.tabChose, query.filters, query.limit, query.offset);
                        }
                        case 9: {
                            return this.processGetOlvidUsersFiltered(role, query.realmName, query.tabChose, query.filters, query.limit, query.offset, query.isWithRestrictedInformations);
                        }
                        case 12: {
                            return this.processGetRevocation(role, query.realmName, query.filters, query.limit, query.offset);
                        }
                        case 13: {
                            return this.processSignOutUser(query.realmName, query.id);
                        }
                        case 14: {
                            return this.processDeleteUserRevokedData(role, query.realmName, query.revocationId);
                        }
                        case 15: {
                            return this.processGetLogs(role, query.realmName, query.tabChose, query.filters, query.limit, query.offset);
                        }
                        case 47: {
                            return this.processGetLogsType();
                        }
                        case 16: {
                            return this.processAddManagerUser(query.managerUser);
                        }
                        case 17: {
                            return this.processRemoveManagers(role, query.managersList);
                        }
                        case 18: {
                            return this.processSendAutomaticPasswordEmail(query.password, query.username, query.isocode, query.realmName);
                        }
                        case 21: {
                            return this.processSendAutomaticPasswordEmailReseted(query.password, query.username, query.isocode, query.realmName);
                        }
                        case 20: {
                            return this.processResetManagerPassword(query.managersList);
                        }
                        case 22: {
                            return this.processGetEmailContent(query.isocode, query.emailType);
                        }
                        case 19: {
                            return this.processCreateBot(postData);
                        }
                        case 46: {
                            return this.processResetBotLink(query.realmName, query.id);
                        }
                        case 23: {
                            return this.processResetUserPassword(query.usersUsernameList, query.password, query.realmName);
                        }
                        case 24: {
                            return this.processAddUser(query.user, query.realmName, query.isNoPassword);
                        }
                        case 25: {
                            return this.processGetUsersByUsername(role, query.realmName, query.usersUsernameList, query.filters, query.limit, query.offset);
                        }
                        case 26: {
                            return this.processUpdateUser(query.user, query.realmName);
                        }
                        case 30: {
                            return this.processUpdateGroup(query.realmName, query.dataObj);
                        }
                        case 31: {
                            return this.processSetUnsetGroupOlvidDiscussion(query.realmName, query.dataObj);
                        }
                        case 27: {
                            return this.processAddUsersByList(query.usersList, query.realmName, query.isNoPassword);
                        }
                        case 28: {
                            return this.processGetAllGroups(role, query.realmName, query.userId, query.isWithRestrictedInformations);
                        }
                        case 29: {
                            return this.processGetGroupsByName(role, query.realmName, query.filters, query.limit, query.offset);
                        }
                        case 32: {
                            return this.processCreateOlvidGroup(query.realmName, query.dataObj);
                        }
                        case 33: {
                            return this.processAddOlvidGroupUsers(query.realmName, query.id, query.dataArray);
                        }
                        case 34: {
                            return this.processSetUpGroupAvatar(query.realmName, query.dataBytes, query.id, query.name);
                        }
                        case 35: {
                            return this.processRemoveOlvidGroupUsers(query.realmName, query.id, query.dataArray);
                        }
                        case 36: {
                            return this.processRemoveGroupAvatar(query.realmName, query.data);
                        }
                        case 37: {
                            return this.processGetGroupById(role, query.realmName, query.id);
                        }
                        case 38: {
                            return this.processGetGroupAvatar(query.realmName, query.dataBytes, query.id);
                        }
                        case 39: {
                            return this.processRevokeUsers(role, query.realmName, query.usersUsernameList, query.revocationType);
                        }
                        case 40: {
                            return this.processDeleteGroup(query.realmName, query.data);
                        }
                        case 45: {
                            return this.processGetBotsFiltered(role, query.realmName, query.filters, query.limit, query.offset);
                        }
                        case 48: {
                            return this.processGetRealmsBasicInfo();
                        }
                        case 49: {
                            return this.processMoveOlvidGroup(query.realmName, query.id, query.newId);
                        }
                        case 50: {
                            return this.processDuplicateOlvidGroup(query.realmName, query.id, query.dataObj);
                        }
                        case 51: {
                            return this.processGetOlvidDevicesFiltered(query.realmName, query.tabChose, query.filters, query.limit, query.offset);
                        }
                        case 52: {
                            return this.processSetDeviceKnown(role, query.realmName, query.id, query.userId, query.value);
                        }
                        case 53: {
                            return this.processSendUserOldDeviceAlert(query.id, query.username, query.isocode, query.realmName);
                        }
                        case 54: {
                            return this.processSendUserUnknownDeviceAlert(query.id, query.username, query.isocode, query.realmName);
                        }
                        case 55: {
                            return this.processDownloadXslxCsv(query.realmName, query.format, query.tabChose, query.filters, query.offset);
                        }
                        case 56: {
                            return this.processGetUserByUsername(role, query.realmName, query.username, query.filters, query.limit, query.offset);
                        }
                        case 57: {
                            return this.processGetGroupMembersById(role, query.realmName, query.id, query.tabChose, query.filters, query.limit, query.offset, query.groupList);
                        }
                        case 58: {
                            return this.processCreateExternalLinks(query.realmName, query.dataArray);
                        }
                        case 59: {
                            return this.processGetExternalLinks(role, query.realmName, query.tabChose, query.filters, query.limit, query.offset);
                        }
                        case 60: {
                            return this.processRevokeExternalLinks(query.realmName, query.dataArray);
                        }
                        case 61: {
                            return this.processEditExternalLinks(query.realmName, query.dataObj);
                        }
                        case 62: {
                            return this.processCreateCronOneTimeJob(query.dataObj);
                        }
                        case 63: {
                            return this.processGetUserGroups(role, query.realmName, query.tabChose, query.filters, query.limit, query.offset, query.userId);
                        }
                        case 64: {
                            return this.processGetCirclesVisibilitesFiltered(role, query.realmName, query.tabChose, query.filters, query.limit, query.offset);
                        }
                        case 65: {
                            return this.processGetCircleVisibility(role, query.realmName, query.id);
                        }
                        case 66: {
                            return this.processGetCircleVisibilityRulesByCircles(role, query.realmName, query.id, query.isWithMembers);
                        }
                        case 67: {
                            return this.processGetCircleVisibilityRulesByUsers(role, query.realmName, query.id);
                        }
                        case 68: {
                            return this.processGetCircleVisibilityMembers(role, query.realmName, query.id, query.tabChose, query.filters, query.limit, query.offset, query.isWithRestrictedInformations);
                        }
                        case 69: {
                            return this.processAddCircleVisibility(query.realmName, query.dataObj);
                        }
                        case 70: {
                            return this.processDeleteCircleVisibility(query.realmName, query.id, query.name);
                        }
                        case 71: {
                            return this.processEditCircleVisibility(query.realmName, query.dataObj);
                        }
                        case 72: {
                            return this.processEditCircleVisibilityRules(query.realmName, query.dataObj);
                        }
                        case 73: {
                            return this.processEditUserCircleVisibilityRules(query.realmName, query.id, query.userId);
                        }
                        case 74: {
                            return this.processRemoveUsersCircleVisibility(query.realmName, query.id, query.list);
                        }
                        case 75: {
                            return this.processAddUsersCircleVisibility(query.realmName, query.id, query.list);
                        }
                        case 76: {
                            return this.processGetNotifications(role, query.realmName, query.tabChose, query.filters, query.limit, query.offset);
                        }
                        case 77: {
                            return this.processSetNotificationRead(role, query.dataArray);
                        }
                        case 78: {
                            return this.processGetDashboard(role);
                        }
                        case 79: {
                            return this.processSetGroupSharedSettings(this.authenticatedUser, role, query.realmName, query.id, query.data);
                        }
                        case 80: {
                            return this.processGetGroupEphemeralSettings(query.realmName, query.id);
                        }
                        case 81: {
                            return this.processSetBotRole(role, query.realmName, query.username, query.data);
                        }
                        case 82: {
                            return this.processToggleEnableUser(role, query.realmName, query.id);
                        }
                        case 1000: {
                            return this.processCreateUserMagicLink(postData);
                        }
                        case 1001: {
                            return this.processRevokeUserMagicLinks(postData);
                        }
                    }
                    break block87;
                }
                try {
                    GenericReponseModel response = new GenericReponseModel();
                    response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 7, "isQueryAllowed", false);
                    return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
                }
                catch (JsonProcessingException e) {
                    logger.warn((Object)"Switch configuration", (Throwable)e);
                    GenericReponseModel response = new GenericReponseModel();
                    response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
            }
        }
        return this.internalError();
    }

    private Boolean checkQueryIsAllowed(int query, String role) {
        if ("master".equals(this.authenticatedUserRealm.getName())) {
            return true;
        }
        boolean isAdminRealm = OlvidConfigurationDao.getBooleanConfiguration(this.em, this.authenticatedUserRealm.getId(), "admin", false);
        if (!isAdminRealm && !this.useDirectAuthToken) {
            return false;
        }
        if (role == null) {
            return false;
        }
        switch (role) {
            case "admin": {
                return true;
            }
            case "editor": {
                switch (query) {
                    case 4: 
                    case 8: 
                    case 9: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 18: 
                    case 19: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 78: 
                    case 80: 
                    case 82: 
                    case 1000: 
                    case 1001: {
                        return true;
                    }
                }
                return false;
            }
            case "viewer": {
                switch (query) {
                    case 4: 
                    case 9: 
                    case 12: 
                    case 25: 
                    case 28: 
                    case 29: 
                    case 37: 
                    case 38: 
                    case 42: 
                    case 43: 
                    case 45: 
                    case 51: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 59: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 76: 
                    case 78: 
                    case 80: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    protected Response processGetErrorContainersVersionQuery() {
        this.session.realms().getRealmsStream().forEach(realmModel -> realmModel.getClientsStream().forEach(element -> logger.info((Object)element.getClientId())));
        try {
            return Response.status((Response.Status)Response.Status.OK).type("application/json").build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    protected Response processGetRealmsQuery() throws JsonProcessingException {
        ArrayList<RealmConfigModel> realmList = new ArrayList<RealmConfigModel>();
        this.session.realms().getRealmsStream().forEach(realmModel -> {
            if ("master".equals(realmModel.getName())) {
                return;
            }
            realmList.add(this.processGetOneConfig(this.em, this.session, (RealmModel)realmModel));
        });
        GetRealmsConfigurationResponseModel responseModel = new GetRealmsConfigurationResponseModel();
        responseModel.setRealmList(realmList);
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (JsonProcessingException e) {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    public RealmConfigModel processGetOneConfig(EntityManager em, KeycloakSession session, RealmModel realmModel) {
        String keycloakServerUrl;
        String keycloakApiKey;
        String olvidServerUrl;
        RealmConfigModel config = new RealmConfigModel();
        config.setRevocationAllowed(OlvidConfigurationDao.getBooleanConfiguration(em, realmModel.getId(), "revocationAllowed", false));
        config.setTransferRestricted(OlvidConfigurationDao.getBooleanConfiguration(em, realmModel.getId(), "transferRestricted", false));
        config.setAdmin(OlvidConfigurationDao.getBooleanConfiguration(em, realmModel.getId(), "admin", false));
        config.setOlvid(OlvidConfigurationDao.getBooleanConfiguration(em, realmModel.getId(), "olvid", false));
        config.setName(realmModel.getName());
        String olvidClient = OlvidConfigurationDao.getStringConfiguration(em, realmModel.getId(), "authClient");
        ArrayList clients = new ArrayList();
        realmModel.getClientsStream().forEach(clientModel -> clients.add(clientModel.getClientId()));
        if (olvidClient != null && clients.contains(olvidClient)) {
            config.setOlvidClient(olvidClient);
        }
        if ((olvidServerUrl = OlvidConfigurationDao.getStringConfiguration(em, realmModel.getId(), "serverUrl")) != null) {
            config.setOlvidServerUrl(olvidServerUrl);
        }
        if ((keycloakApiKey = OlvidConfigurationDao.getStringConfiguration(em, realmModel.getId(), "serverKeycloakApiKey")) != null) {
            config.setKeycloakApiKey(keycloakApiKey);
        }
        if ((keycloakServerUrl = OlvidConfigurationDao.getStringConfiguration(em, realmModel.getId(), "keycloakUrl")) != null) {
            config.setKeycloakServerUrl(keycloakServerUrl);
        }
        String keyChosen = OlvidConfigurationDao.getStringConfiguration(em, realmModel.getId(), "keyChoosen");
        config.setKeyId(new ArrayList<KeyPropertiesModel>());
        for (KeyWrapper key : session.keys().getKeysStream(realmModel).collect(Collectors.toList())) {
            if (key.getStatus() != KeyStatus.ACTIVE || !Objects.equals(key.getType(), "RSA") && !Objects.equals(key.getType(), "EC") || key.getUse() != KeyUse.SIG) continue;
            KeyPropertiesModel keyProperties = new KeyPropertiesModel();
            keyProperties.keyAlgorithm = key.getAlgorithm();
            keyProperties.keyType = key.getType();
            keyProperties.name = key.getKid();
            config.getKeyId().add(keyProperties);
            if (!key.getKid().equals(keyChosen)) continue;
            config.setKeyChoosen(keyChosen);
        }
        config.setClientsInfo(new ArrayList<ClientInfoModel>());
        realmModel.getClientsStream().forEach(clientModel -> {
            if (!clientModel.isEnabled()) {
                return;
            }
            try {
                ClientInfoModel clientInfoModel = new ClientInfoModel();
                clientInfoModel.setName(clientModel.getClientId());
                clientInfoModel.setConfigLink(ConfigurationLinkHelper.getKeycloakRealmConfigurationLink(em, session, realmModel, clientModel));
                config.getClientsInfo().add(clientInfoModel);
            }
            catch (Exception e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
            }
        });
        return config;
    }

    private Response processGetRealmsBasicInfo() throws JsonProcessingException {
        ArrayList<RealmBasicInfoModel> realmList = new ArrayList<RealmBasicInfoModel>();
        this.session.realms().getRealmsStream().forEach(realmModel -> {
            RealmBasicInfoModel realmBasicInfo = new RealmBasicInfoModel();
            realmBasicInfo.setId(realmModel.getId());
            realmBasicInfo.setName(realmModel.getName());
            realmList.add(realmBasicInfo);
        });
        GetRealmsBasicInfoResponseModel responseModel = new GetRealmsBasicInfoResponseModel();
        responseModel.setRealmList(realmList);
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (JsonProcessingException e) {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processGetRealmsGlobalSettings() throws JsonProcessingException {
        GetRealmGlobalSettingsResponseModel responseModel = new GetRealmGlobalSettingsResponseModel();
        PluginVersionInformationsResponseModel versionsInformations = new PluginVersionInformationsResponseModel();
        try {
            versionsInformations.setCurrent("4.5.1");
            versionsInformations.setMax("4.5.1");
            List<OlvidNotifications> onList = OlvidNotificationsDao.getOlvidNotificationsVersion(this.em);
            if (onList.isEmpty()) {
                versionsInformations.setNotificationIsRead("1");
            } else {
                versionsInformations.setNotificationIsRead("0");
                onList.forEach(on -> {
                    if (PluginVersionUpgradeOneTimeJob.getPluginVersionFromString(versionsInformations.getMax()) < PluginVersionUpgradeOneTimeJob.getPluginVersionFromString(on.getValue())) {
                        versionsInformations.setMax(on.getValue());
                    }
                });
            }
            responseModel.setVersionsInformations(versionsInformations);
        }
        catch (NoResultException e) {
            versionsInformations.setNotificationIsRead("0");
            versionsInformations.setMax("0.0.0");
            versionsInformations.setCurrent("0.0.0");
            responseModel.setVersionsInformations(versionsInformations);
        }
        ArrayList<CronJobModel> cronList = new ArrayList<CronJobModel>();
        try {
            TypedQuery q = this.em.createNamedQuery("OlvidLogsBackend.getLastTimestampStartByType", OlvidLogsBackend.class);
            for (CronJobModel.Label item : CronJobModel.Label.values()) {
                q.setParameter("logType", (Object)item.toString());
                CronJobModel cronJobModel = new CronJobModel();
                cronJobModel.setLabel(item);
                try {
                    OlvidLogsBackend logBackend = (OlvidLogsBackend)q.getSingleResult();
                    cronJobModel.setStatus(logBackend.getMessage());
                    cronJobModel.setLastRunTimestamp(logBackend.getTimestampStart());
                    if (logBackend.getTimestampEnd() != null) {
                        cronJobModel.setDuration(logBackend.getTimestampEnd() - logBackend.getTimestampStart());
                    }
                }
                catch (NoResultException e) {
                    cronJobModel.setStatus("");
                    cronJobModel.setLastRunTimestamp(0L);
                }
                cronList.add(cronJobModel);
            }
            responseModel.setCronJob(cronList);
        }
        catch (Exception e) {
            responseModel.setCronJob(cronList);
            logger.error((Object)e.getMessage());
        }
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (JsonProcessingException e) {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processGetRealmSettings(String role, String realmName) {
        boolean writeAllowed = this.checkQueryIsAllowed(44, role);
        RealmModel realmModel = this.session.realms().getRealmByName(realmName);
        RealmSettingsModel realmSettings = RealmSettingsModel.initRealmSettings(this.em, this.session, realmModel, writeAllowed);
        RealmConfigModel realmConfig = this.processGetOneConfig(this.em, this.session, realmModel);
        ClientInfoModel clientInfoModel = realmConfig.getClientsInfo().stream().filter(ci -> ci.getName().equals(realmConfig.getOlvidClient())).findFirst().orElse(null);
        if (clientInfoModel == null) {
            logger.error((Object)"processGetRealmSettings: client info not found");
            return this.internalError();
        }
        realmSettings.configLink = clientInfoModel.getConfigLink();
        GetRealmSettingsResponseModel responseModel = new GetRealmSettingsResponseModel().initGetRealmSettingsResponseModel(realmSettings);
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (JsonProcessingException e) {
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), true);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).type("application/json").build();
        }
    }

    private Response processGetRealmsMainAttributesQuery(String role) throws JsonProcessingException {
        boolean adminRealmAccess;
        ArrayList<RealmMainConfigModel> realms = new ArrayList<RealmMainConfigModel>();
        boolean globalSettingsAccess = false;
        if (this.authenticatedUser != null) {
            globalSettingsAccess = this.checkQueryIsAllowed(3, role);
            adminRealmAccess = this.checkQueryIsAllowed(8, role);
        } else {
            adminRealmAccess = false;
        }
        this.session.realms().getRealmsStream().forEach(realmModel -> {
            if ("master".equals(realmModel.getName())) {
                return;
            }
            if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "admin", false) && !adminRealmAccess) {
                return;
            }
            RealmMainConfigModel realmMainConfig = new RealmMainConfigModel();
            realmMainConfig.setName(realmModel.getName());
            realmMainConfig.setAdmin(OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "admin", false));
            realmMainConfig.setOlvid(OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false));
            realmMainConfig.setIdProvider(realmModel.getIdentityProvidersStream().findAny().isPresent());
            List realmComponentList = realmModel.getComponentsStream().map(ComponentModel::getProviderId).collect(Collectors.toList());
            realmMainConfig.setUserFederation(false);
            if (!realmComponentList.isEmpty()) {
                realmMainConfig.setUserFederation(realmComponentList.contains("ldap") || realmComponentList.contains("kerberos"));
            }
            realmMainConfig.setRealmSettings(RealmSettingsModel.initRealmSettings(this.em, this.session, realmModel, false));
            realms.add(realmMainConfig);
        });
        GetRealmsMainAttributesResponseModel responseModel = new GetRealmsMainAttributesResponseModel();
        responseModel.setGlobalSettingsAccess(globalSettingsAccess);
        responseModel.setRealmMainAttributes(realms);
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (JsonProcessingException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private boolean processSetOneRealmConfig(String realmId, boolean revocationAllowed, boolean transferRestricted, boolean admin, boolean olvid, String olvidClient, String olvidServerUrl, String keycloakApiKey, String keycloakServerUrl, String keyChosen) {
        try {
            OlvidConfigurationDao.setBooleanConfiguration(this.em, realmId, "revocationAllowed", revocationAllowed);
            OlvidConfigurationDao.setBooleanConfiguration(this.em, realmId, "transferRestricted", transferRestricted);
            OlvidConfigurationDao.setBooleanConfiguration(this.em, realmId, "admin", admin);
            OlvidConfigurationDao.setBooleanConfiguration(this.em, realmId, "olvid", olvid);
            OlvidConfigurationDao.setConfiguration(this.em, realmId, "authClient", Utils.nullOrTrim(olvidClient));
            OlvidConfigurationDao.setConfiguration(this.em, realmId, "serverUrl", Utils.nullOrTrim(olvidServerUrl));
            OlvidConfigurationDao.setConfiguration(this.em, realmId, "serverKeycloakApiKey", Utils.nullOrTrim(keycloakApiKey));
            OlvidConfigurationDao.setConfiguration(this.em, realmId, "keycloakUrl", Utils.nullOrTrim(keycloakServerUrl));
            OlvidConfigurationDao.setConfiguration(this.em, realmId, "keyChoosen", Utils.nullOrTrim(keyChosen));
            return true;
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return false;
        }
    }

    private Response processSetRealmsConfig(HashMap<String, List<RealmConfigModel>> realmListSettings) throws JsonProcessingException {
        try {
            Optional<RealmConfigModel> authenticatedUserRealmConfig;
            GenericReponseModel response = new GenericReponseModel();
            realmListSettings.get("realmList").forEach(realmConfig -> {
                List realmAdmin;
                if (realmConfig.isAdmin() && !(realmAdmin = this.session.realms().getRealmsStream().filter(realmModel -> OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "admin", false)).collect(Collectors.toList())).isEmpty()) {
                    boolean isRealmListContainsAdmin = ((List)realmListSettings.get("realmList")).stream().map(RealmConfigModel::getName).collect(Collectors.toList()).contains(((RealmModel)realmAdmin.get(0)).getName());
                    if (!realmConfig.getName().equals(((RealmModel)realmAdmin.get(0)).getName()) && realmConfig.isAdmin() && !isRealmListContainsAdmin) {
                        response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "Cannot save two different admin realms", false);
                    }
                }
                if (realmConfig.isOlvid()) {
                    if (realmConfig.getKeyChoosen() == null) {
                        response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "Cannot save without Key chosen", false);
                    }
                    if (realmConfig.getOlvidClient() == null) {
                        response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "Cannot save without Client chosen", false);
                    }
                }
            });
            if (response.getError() != 0) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
            }
            if (!"master".equals(this.authenticatedUserRealm.getName()) && (authenticatedUserRealmConfig = realmListSettings.get("realmList").stream().filter(realmModel -> realmModel.getName().equals(this.authenticatedUserRealm.getName())).findFirst()).isPresent() && !authenticatedUserRealmConfig.get().isAdmin()) {
                HashMap<String, String> error = new HashMap<String, String>();
                error.put("errorMessage", "Cannot set the realm you are logged in to non admin");
                return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes(error)).type("application/json").build();
            }
        }
        catch (JsonProcessingException e) {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        StringBuilder realmsSb = new StringBuilder();
        try {
            realmListSettings.get("realmList").forEach(realmConfig -> {
                String realmName = realmConfig.getName();
                RealmModel realmModel = this.session.realms().getRealmByName(realmName);
                StringBuilder modificationsSb = new StringBuilder();
                boolean realmHasModifications = false;
                boolean configHasModifications = false;
                if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "revocationAllowed", false) != realmConfig.isRevocationAllowed()) {
                    modificationsSb.append("    revocationAllowed: " + realmConfig.isRevocationAllowed());
                    realmHasModifications = true;
                }
                if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "transferRestricted", false) != realmConfig.isTransferRestricted()) {
                    modificationsSb.append("    transferRestricted: " + realmConfig.isTransferRestricted());
                    realmHasModifications = true;
                }
                if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "admin", false) != realmConfig.isAdmin()) {
                    if (realmHasModifications) {
                        modificationsSb.append(",\n");
                    }
                    modificationsSb.append("    admin: " + realmConfig.isAdmin());
                    realmHasModifications = true;
                }
                if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false) != realmConfig.isOlvid()) {
                    if (realmHasModifications) {
                        modificationsSb.append(",\n");
                    }
                    modificationsSb.append("    olvid: " + realmConfig.isOlvid());
                    realmHasModifications = true;
                }
                if (!Objects.equals(OlvidConfigurationDao.getStringConfiguration(this.em, realmModel.getId(), "authClient"), realmConfig.getOlvidClient())) {
                    if (realmHasModifications) {
                        modificationsSb.append(",\n");
                    }
                    modificationsSb.append("    authClient: " + realmConfig.getOlvidClient());
                    realmHasModifications = true;
                }
                if (!Objects.equals(OlvidConfigurationDao.getStringConfiguration(this.em, realmModel.getId(), "keyChoosen"), realmConfig.getKeyChoosen())) {
                    if (realmHasModifications) {
                        modificationsSb.append(",\n");
                    }
                    modificationsSb.append("    keyChoosen: " + realmConfig.getKeyChoosen());
                    realmHasModifications = true;
                }
                if (!Objects.equals(OlvidConfigurationDao.getStringConfiguration(this.em, realmModel.getId(), "serverUrl"), realmConfig.getOlvidServerUrl())) {
                    if (realmHasModifications) {
                        modificationsSb.append(",\n");
                    }
                    modificationsSb.append("    serverUrl: " + realmConfig.getOlvidServerUrl());
                    realmHasModifications = true;
                }
                if (!Objects.equals(OlvidConfigurationDao.getStringConfiguration(this.em, realmModel.getId(), "serverKeycloakApiKey"), realmConfig.getKeycloakApiKey())) {
                    if (realmHasModifications) {
                        modificationsSb.append(",\n");
                    }
                    modificationsSb.append("    serverKeycloakApiKey: " + realmConfig.getKeycloakApiKey());
                    realmHasModifications = true;
                }
                if (!Objects.equals(OlvidConfigurationDao.getStringConfiguration(this.em, realmModel.getId(), "keycloakUrl"), realmConfig.getKeycloakServerUrl())) {
                    if (realmHasModifications) {
                        modificationsSb.append(",\n");
                    }
                    modificationsSb.append("    keycloakUrl: " + realmConfig.getKeycloakServerUrl());
                    realmHasModifications = true;
                }
                if (realmHasModifications) {
                    realmsSb.append("\n");
                    realmsSb.append("- '" + realmName + "' modified [\n" + String.valueOf(modificationsSb) + "\n  ]");
                    configHasModifications = true;
                }
                if (!this.processSetOneRealmConfig(realmModel.getId(), realmConfig.isRevocationAllowed(), realmConfig.isTransferRestricted(), realmConfig.isAdmin(), realmConfig.isOlvid(), realmConfig.getOlvidClient(), realmConfig.getOlvidServerUrl(), realmConfig.getKeycloakApiKey(), realmConfig.getKeycloakServerUrl(), realmConfig.getKeyChoosen())) {
                    logger.warn((Object)("An error occurred saving " + realmConfig.getName() + ", Configuration.java"));
                }
                if (configHasModifications) {
                    HashMap<String, Object> ret = new HashMap<String, Object>();
                    OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmName, "setConfig", "Realms modified:\n" + String.valueOf(realmsSb), ret);
                }
            });
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
        }
        return this.processGetRealmsQuery();
    }

    private Response processSetRealmsGlobalSettings(RealmsGlobalSettingsModel realmListGlobalSettings) throws JsonProcessingException {
        StringBuilder realmsSb = new StringBuilder();
        boolean configHasModifications = false;
        if (configHasModifications) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, this.session.realms().getRealmByName("master"), this.authenticatedUser.getUsername(), "master", "setGlobalSettings", realmsSb.toString(), ret);
        }
        return this.processGetRealmsGlobalSettings();
    }

    private Response processSetRealmsSettings(String role, String realmName, RealmSettingsModel realmSettings) {
        boolean configHasModifications;
        StringBuilder realmsSb;
        block31: {
            realmsSb = new StringBuilder();
            realmsSb.append(realmName).append(" ");
            configHasModifications = false;
            try {
                RealmModel realmModel = this.session.realms().getRealmByName(realmName);
                boolean isBotUserExist = this.session.users().searchForUserByUserAttributeStream(realmModel, "olvid-is-bot", "true").findAny().isPresent();
                if (!isBotUserExist) {
                    if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "enableBotsManagement", false) != realmSettings.getEnableBotsManagement()) {
                        realmsSb.append("- Bots management " + (realmSettings.getEnableBotsManagement() ? "enabled" : "disabled"));
                        configHasModifications = true;
                    }
                    OlvidConfigurationDao.setBooleanConfiguration(this.em, realmModel.getId(), "enableBotsManagement", realmSettings.getEnableBotsManagement());
                } else {
                    OlvidConfigurationDao.setBooleanConfiguration(this.em, realmModel.getId(), "enableBotsManagement", true);
                }
                if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "enableAuthenticationWithOlvidId", false) != realmSettings.getEnableAuthenticationWithOlvidId()) {
                    realmsSb.append("- Authentication With Olvid Id " + (realmSettings.getEnableAuthenticationWithOlvidId() ? "enabled" : "disabled"));
                    configHasModifications = true;
                }
                OlvidConfigurationDao.setBooleanConfiguration(this.em, realmModel.getId(), "enableAuthenticationWithOlvidId", realmSettings.getEnableAuthenticationWithOlvidId());
                if (OlvidConfigurationDao.getIntConfiguration(this.em, realmModel.getId(), "searchResultCount", 50) != realmSettings.searchResultCount) {
                    if (configHasModifications) {
                        realmsSb.append("\n");
                    }
                    realmsSb.append("- Search result count management : " + realmSettings.searchResultCount);
                    configHasModifications = true;
                }
                if (realmSettings.searchResultCount < 1) {
                    realmSettings.searchResultCount = 50;
                }
                OlvidConfigurationDao.setConfiguration(this.em, realmModel.getId(), "searchResultCount", String.valueOf(realmSettings.searchResultCount));
                if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "isSearchIncludeNotActivatedUsers", false) != realmSettings.getIsSearchIncludeNotActivatedUsers()) {
                    if (configHasModifications) {
                        realmsSb.append("\n");
                    }
                    realmsSb.append("- Search IncludeNotActivatedUsers management " + (realmSettings.getIsSearchIncludeNotActivatedUsers() ? "enabled" : "disabled"));
                    configHasModifications = true;
                }
                OlvidConfigurationDao.setBooleanConfiguration(this.em, realmModel.getId(), "isSearchIncludeNotActivatedUsers", realmSettings.getIsSearchIncludeNotActivatedUsers());
                if (realmSettings.oldDeviceTimeLimit < 1) {
                    realmSettings.oldDeviceTimeLimit = 30;
                }
                OlvidConfigurationDao.setConfiguration(this.em, realmModel.getId(), "oldDeviceTimeLimit", String.valueOf(realmSettings.oldDeviceTimeLimit));
                if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "enableVisibilityCircles", false) != realmSettings.getEnableVisibilityCircle()) {
                    realmsSb.append("- Visibility Circle management " + (realmSettings.getEnableVisibilityCircle() ? "enabled" : "disabled"));
                    configHasModifications = true;
                }
                OlvidConfigurationDao.setBooleanConfiguration(this.em, realmModel.getId(), "enableVisibilityCircles", realmSettings.getEnableVisibilityCircle());
                if (!realmSettings.getEnableVisibilityCircle()) break block31;
                try {
                    HashMap<String, Object> ret;
                    String logs2;
                    TypedQuery qFrom = this.em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultRealmCircleRuleFrom", OlvidCircleVisibilityRules.class);
                    qFrom.setParameter("realmId", (Object)realmModel.getId());
                    qFrom.getSingleResult();
                    try {
                        int count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateDefaultRealmCircleRuleFrom").setParameter("realmId", (Object)realmModel.getId()).setParameter("visibility", (Object)"NO").executeUpdate();
                        if (count == 0) {
                            OlvidCircleVisibilityRules circleDefaultRuleFrom = new OlvidCircleVisibilityRules();
                            circleDefaultRuleFrom.setId("default-from");
                            circleDefaultRuleFrom.setRealmId(realmModel.getId());
                            circleDefaultRuleFrom.setVisibility("NO");
                            this.em.persist((Object)circleDefaultRuleFrom);
                        }
                        try {
                            logs2 = " [\n  realm Name: " + realmModel.getName() + ",\n  edit default rule for realm : default-from,\n  edit rule visibility : NO,\n  count edited : " + count + ",\n]";
                            logger.debug((Object)logs2);
                            ret = new HashMap<String, Object>();
                            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "circleVisibilityEdit", "Circle visibility edited:" + logs2, ret);
                        }
                        catch (Exception logs2) {}
                    }
                    catch (NoResultException count) {
                        // empty catch block
                    }
                    try {
                        int count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateDefaultRealmCircleRuleTo").setParameter("realmId", (Object)realmModel.getId()).setParameter("visibility", (Object)"NO").executeUpdate();
                        if (count == 0) {
                            OlvidCircleVisibilityRules circleDefaultRuleTo = new OlvidCircleVisibilityRules();
                            circleDefaultRuleTo.setId("default-to");
                            circleDefaultRuleTo.setRealmId(realmModel.getId());
                            circleDefaultRuleTo.setVisibility("NO");
                            this.em.persist((Object)circleDefaultRuleTo);
                        }
                        try {
                            logs2 = " [\n  realm Name: " + realmModel.getName() + ",\n  edit default rule for realm : default-to,\n  edit rule visibility : NO,\n  count edited : " + count + ",\n]";
                            logger.debug((Object)logs2);
                            ret = new HashMap();
                            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "circleVisibilityEdit", "Circle visibility edited:" + logs2, ret);
                        }
                        catch (Exception logs3) {}
                    }
                    catch (NoResultException count) {
                        // empty catch block
                    }
                    try {
                        int count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateDefaultCircleRuleBetweenMembers").setParameter("realmId", (Object)realmModel.getId()).setParameter("visibility", (Object)ConstantsCircleVisibility.sanitizeVisibility(realmSettings.getVisibilityCircleDefaultRuleBetweenMembers())).executeUpdate();
                        if (count == 0) {
                            OlvidCircleVisibilityRules circleDefaultCircleRules = new OlvidCircleVisibilityRules();
                            circleDefaultCircleRules.setId("defaultCircleBetweenMembers");
                            circleDefaultCircleRules.setVisibility(realmSettings.getVisibilityCircleDefaultRuleBetweenMembers());
                            circleDefaultCircleRules.setRealmId(realmModel.getId());
                            this.em.persist((Object)circleDefaultCircleRules);
                        }
                        try {
                            logs2 = " [\n  realm Name: " + realmModel.getName() + ",\n  edit default rule for realm : DefaultCircleRuleBetweenMembers,\n  edit rule visibility : " + realmSettings.getVisibilityCircleDefaultRuleBetweenMembers() + ",\n  count edited : " + count + ",\n]";
                            logger.debug((Object)logs2);
                            ret = new HashMap();
                            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "circleVisibilityEdit", "Circle visibility edited:" + logs2, ret);
                        }
                        catch (Exception logs4) {}
                    }
                    catch (NoResultException count) {
                    }
                }
                catch (Exception e) {
                    OlvidCircleVisibilityRules circleDefaultRuleFrom = new OlvidCircleVisibilityRules();
                    circleDefaultRuleFrom.setId("default-from");
                    circleDefaultRuleFrom.setRealmId(realmModel.getId());
                    circleDefaultRuleFrom.setVisibility(realmSettings.getVisibilityCircleRealmDefaultRuleFrom() != null ? realmSettings.getVisibilityCircleRealmDefaultRuleFrom() : "NO");
                    this.em.persist((Object)circleDefaultRuleFrom);
                    OlvidCircleVisibilityRules circleDefaultRuleTo = new OlvidCircleVisibilityRules();
                    circleDefaultRuleTo.setId("default-to");
                    circleDefaultRuleTo.setRealmId(realmModel.getId());
                    circleDefaultRuleTo.setVisibility(realmSettings.getVisibilityCircleRealmDefaultRuleTo() != null ? realmSettings.getVisibilityCircleRealmDefaultRuleTo() : "NO");
                    this.em.persist((Object)circleDefaultRuleTo);
                    OlvidCircleVisibilityRules circleDefaultCircleRules = new OlvidCircleVisibilityRules();
                    circleDefaultCircleRules.setId("defaultCircleBetweenMembers");
                    circleDefaultCircleRules.setVisibility(realmSettings.getVisibilityCircleDefaultRuleBetweenMembers());
                    circleDefaultCircleRules.setRealmId(realmModel.getId());
                    this.em.persist((Object)circleDefaultCircleRules);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
            }
        }
        if (configHasModifications) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, this.session.realms().getRealmByName(realmName), this.authenticatedUser.getUsername(), realmName, "setGlobalSettings", "Realms modified:\n" + String.valueOf(realmsSb), ret);
        }
        return this.processGetRealmSettings(role, realmName);
    }

    private Response processSetRole(String role, String realmName, List<CustomManagerModel> roleList) {
        StringBuilder sb = new StringBuilder();
        boolean[] modified = new boolean[]{false};
        try {
            RealmModel realmModel = this.session.realms().getRealmByName(realmName);
            roleList.forEach(roleManager -> {
                UserModel userModel = this.session.users().getUserByUsername(realmModel, roleManager.getUsername());
                String previousRole = userModel.getFirstAttribute("olvid-role");
                if (!Objects.equals(previousRole, roleManager.getRole())) {
                    userModel.setSingleAttribute("olvid-role", roleManager.getRole());
                    if (modified[0]) {
                        sb.append(";\n");
                    }
                    sb.append(roleManager.getUsername() + " given role " + roleManager.getRole());
                    modified[0] = true;
                }
            });
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
        }
        if (modified[0]) {
            sb.append(";");
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        OlvidConsoleLogsDao.logUserEvent(this.em, this.session, this.session.realms().getRealmByName(realmName), this.authenticatedUser.getUsername(), realmName, "setRole", "Changes roles of users:\n" + String.valueOf(sb), ret);
        ArrayList<String> filters = new ArrayList<String>();
        String tabChose = "";
        return this.processGetManagersUsers(role, realmName, tabChose, filters, 5, 0);
    }

    private Response processSetDeviceKnown(String role, String realmName, String deviceUid, String userId, Boolean value) throws JsonProcessingException {
        GenericReponseModel response;
        boolean writeAllowed = this.checkQueryIsAllowed(52, role);
        RealmModel realmModel = this.session.realms().getRealmByName(realmName);
        try {
            TypedQuery q = this.em.createNamedQuery("OlvidUserDevice.getByDeviceUid", OlvidUserDevice.class);
            q.setParameter("realmId", (Object)realmModel.getId());
            q.setParameter("deviceUid", (Object)deviceUid);
            q.setParameter("userId", (Object)userId);
            OlvidUserDevice olvidUserDevice = (OlvidUserDevice)q.getSingleResult();
            olvidUserDevice.setIsKnown(value);
            this.em.persist((Object)olvidUserDevice);
        }
        catch (NoResultException q) {
            // empty catch block
        }
        try {
            SetKnownDeviceResponseModel responseModel = new SetKnownDeviceResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processRevokeUsers(String role, String realmName, List<String> userIdsList, Integer revocationType) throws JsonProcessingException {
        if (realmName == null || userIdsList.isEmpty() || userIdsList.get(0) == null || revocationType == null || revocationType != 0 && revocationType != 1 && revocationType != 2) {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "internal error", false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        RealmModel realmModel = this.session.realms().getRealmByName(realmName);
        if (realmModel == null) {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "internal error", false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        Configuration.subProcessRevokeUsers(this.em, this.session, this.authenticatedUser.getUsername(), realmName, userIdsList, revocationType, realmModel, this.objectMapper);
        return this.processGetRevocation(role, realmName, new ArrayList<String>(), 10, 0);
    }

    public static void subProcessRevokeUsers(EntityManager em, KeycloakSession session, String username, String realmName, List<String> userIdsList, int revocationType, RealmModel realmModel, ObjectMapper objectMapper) {
        HashSet groupIdsSet = new HashSet();
        userIdsList.forEach(userId -> {
            UserModel user = session.users().getUserById(realmModel, userId);
            groupIdsSet.addAll(user.getGroupsStream().map(GroupModel::getId).collect(Collectors.toList()));
            try {
                List offlineSessions = session.sessions().getOfflineUserSessionsStream(realmModel, user).collect(Collectors.toList());
                for (UserSessionModel userSessionModel : offlineSessions) {
                    session.sessions().removeOfflineUserSession(realmModel, userSessionModel);
                }
                session.sessions().removeUserSessions(realmModel, user);
            }
            catch (Exception offlineSessions) {
                // empty catch block
            }
            try {
                TypedQuery q = em.createNamedQuery("OlvidUser.getById", OlvidUser.class);
                q.setParameter("realmId", (Object)realmModel.getId());
                q.setParameter("userId", (Object)user.getId());
                OlvidUser olvidUser = (OlvidUser)q.getSingleResult();
                em.remove((Object)olvidUser);
            }
            catch (Exception q) {
                // empty catch block
            }
            try {
                TypedQuery qd = em.createNamedQuery("OlvidUserDevice.getById", OlvidUserDevice.class);
                qd.setParameter("realmId", (Object)realmModel.getId());
                qd.setParameter("userId", userId);
                List olvidUserDevices = qd.getResultList();
                olvidUserDevices.forEach(arg_0 -> ((EntityManager)em).remove(arg_0));
            }
            catch (Exception qd) {
                // empty catch block
            }
            try {
                HashMap<String, Object> ret;
                OlvidRevocationDao.createRevocation(em, realmModel, user, System.currentTimeMillis(), revocationType, session, objectMapper);
                if (revocationType == 0) {
                    ret = new HashMap<String, Object>();
                    OlvidConsoleLogsDao.logUserEvent(em, session, realmModel, username, realmName, "idRevocation", "User's id revoked: " + user.getUsername(), ret);
                } else if (revocationType == 1) {
                    ret = new HashMap();
                    OlvidConsoleLogsDao.logUserEvent(em, session, realmModel, username, realmName, "removeUser", "User removed: " + user.getUsername(), ret);
                } else {
                    ret = new HashMap();
                    OlvidConsoleLogsDao.logUserEvent(em, session, realmModel, username, realmName, "unboundUser", "User unbound: " + user.getUsername(), ret);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
            }
        });
        SecureRandom random = new SecureRandom();
        groupIdsSet.forEach(groupId -> {
            GroupModel groupModel = session.groups().getGroupById(realmModel, groupId);
            if (Utils.isOlvidGroup(groupModel)) {
                try {
                    OlvidGroupDao.enableThenUpdateOlvidGroupIfNeededAndGetMembersToNotify(session, em, realmModel, groupModel, objectMapper, random);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to update OlvidGroup with id " + groupModel.getId()));
                    logger.warn((Object)"Exception : ", (Throwable)e);
                }
            }
        });
        HashSet<UserOrTopicToNotify> usersAndTopicsToNotify = new HashSet<UserOrTopicToNotify>();
        String pushTopic = OlvidConfigurationDao.getStringConfiguration(em, realmModel.getId(), "keycloakPushTopic");
        if (pushTopic != null) {
            usersAndTopicsToNotify.add(new UserOrTopicToNotify(UserOrTopicToNotify.NotificationType.TOPIC, realmModel.getId(), pushTopic));
        }
        CronScheduler.scheduleSendNotifications(usersAndTopicsToNotify);
    }

    private void processEnabledUsers(String role, String realmName, List<String> userIdsList, boolean isEnabled) {
        if (realmName == null || userIdsList.isEmpty() || userIdsList.get(0) == null) {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "internal error", false);
            return;
        }
        RealmModel realmModel = this.session.realms().getRealmByName(realmName);
        if (realmModel == null) {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "internal error", false);
            return;
        }
        String username = this.authenticatedUser.getUsername();
        Configuration.subProcessEnableUsers(this.em, this.session, realmName, userIdsList, username, isEnabled, realmModel);
    }

    public static void subProcessEnableUsers(EntityManager em, KeycloakSession session, String realmName, List<String> userIdsList, String username, boolean isEnabled, RealmModel realmModel) {
        userIdsList.forEach(userId -> {
            UserModel user = session.users().getUserById(realmModel, userId);
            user.setEnabled(!isEnabled);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            if (isEnabled) {
                OlvidConsoleLogsDao.logUserEvent(em, session, realmModel, username, realmName, "disabledUser", "User disabled: " + user.getUsername(), ret);
            } else {
                OlvidConsoleLogsDao.logUserEvent(em, session, realmModel, username, realmName, "enabledUser", "User enabled: " + user.getUsername(), ret);
            }
        });
    }

    private Response processGetRevocation(String role, String realmName, List<String> filters, int limit, int offset) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(realmName);
        boolean writeAllowed = this.checkQueryIsAllowed(14, role);
        if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false)) {
            List<OlvidRevocation> revocations = OlvidRevocationDao.getOlvidRevocations(this.em, realmModel.getId(), filters, limit, offset);
            List<RevocationModel> customRevocationsModel = revocations.stream().map(revocation -> new RevocationModel().initRevocationModel((OlvidRevocation)revocation)).collect(Collectors.toList());
            long count = OlvidRevocationDao.getOlvidCountRevocations(this.em, realmModel.getId(), filters);
            GetRevocationsResponseModel responseModel = new GetRevocationsResponseModel();
            responseModel.setRevocations(customRevocationsModel);
            responseModel.setCount(count);
            responseModel.setWriteAllowed(writeAllowed);
            try {
                GenericReponseModel response = new GenericReponseModel();
                response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
                return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
            }
            catch (Exception e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
                GenericReponseModel response = new GenericReponseModel();
                response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
            }
        }
        logger.warn((Object)"Cannot access revocation list of a non olvid realm");
        return this.badRealmType();
    }

    private Response processGetManagersUsers(String role, String realmName, String tabChose, List<String> filters, int limit, int offset) {
        boolean writeAllowed = this.checkQueryIsAllowed(7, role);
        RealmModel realmModel = this.session.realms().getRealmByName(realmName);
        return this.getResponseProcessGetManagerUsers(tabChose, filters, limit, offset, realmModel, writeAllowed);
    }

    protected Response getResponseProcessGetManagerUsers(String tabChose, List<String> filters, int limit, int offset, RealmModel realmModel, boolean writeAllowed) {
        HashMap<String, String> searchParams;
        ArrayList<CustomManagerModel> managerUsersList = new ArrayList<CustomManagerModel>();
        if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "admin", false)) {
            searchParams = new HashMap<String, String>();
            if (!filters.isEmpty()) {
                for (String filter : filters) {
                    if (tabChose.contentEquals("username")) {
                        searchParams.put("username", filter);
                        continue;
                    }
                    if (tabChose.contentEquals("firstname")) {
                        searchParams.put("firstName", filter);
                        continue;
                    }
                    if (tabChose.contentEquals("lastname")) {
                        searchParams.put("lastName", filter);
                        continue;
                    }
                    if (!tabChose.contentEquals("email")) continue;
                    searchParams.put("email", filter);
                }
            }
        } else {
            logger.warn((Object)"Cannot access admin users of a non admin realm");
            return this.badRealmType();
        }
        List<UserModel> usersList = this.session.users().searchForUserStream(realmModel, searchParams, Integer.valueOf(offset), Integer.valueOf(limit)).collect(Collectors.toList());
        usersList.forEach(userModel -> {
            OlvidUserDetails olvidUserDetails = new OlvidUserDetails((UserModel)userModel);
            CustomManagerModel managerUsers = new CustomManagerModel();
            managerUsers.setFirstname(olvidUserDetails.getFirstname());
            managerUsers.setLastname(olvidUserDetails.getLastname());
            managerUsers.setUsername(userModel.getUsername());
            managerUsers.setEmail(userModel.getEmail());
            managerUsers.setRole(userModel.getFirstAttribute("olvid-role"));
            managerUsers.setIsEnabled(userModel.isEnabled());
            managerUsers.setFederatedUsers(Utils.getUserAttribute(userModel, "LDAP_ID") != null || Utils.getUserAttribute(userModel, "KERBEROS_PRINCIPAL") != null);
            managerUsers.setFederatedIdentities(this.session.users().getFederatedIdentitiesStream(realmModel, userModel).findAny().isPresent());
            managerUsersList.add(managerUsers);
        });
        filters = new ArrayList<String>();
        Query countQuery = this.buildQueryCountWithFilter(realmModel.getId(), "", filters, new ArrayList<String>());
        Object countResult = countQuery.getSingleResult();
        GetManagerUsersResponseModel responseModel = new GetManagerUsersResponseModel();
        responseModel.setCount((Long)countResult);
        responseModel.setWriteAllowed(writeAllowed);
        responseModel.setManagerUsersList(managerUsersList);
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (JsonProcessingException e) {
            return Response.serverError().type("text/html").build();
        }
    }

    private Response processGetOlvidUsersFiltered(String role, String realmName, String tabChose, List<String> filters, int limit, int offset, Boolean isWithRestrictedInformations) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (realmModel == null) {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "realm not exists", false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        boolean writeAllowed = this.checkQueryIsAllowed(39, role);
        if (isWithRestrictedInformations == null) {
            isWithRestrictedInformations = false;
        }
        return this.getResponseProcessGetOlvidUsersFiltered(tabChose, filters, limit, offset, realmModel, writeAllowed, isWithRestrictedInformations);
    }

    protected Response getResponseProcessGetOlvidUsersFiltered(String tabChose, List<String> filters, int limit, int offset, RealmModel realmModel, boolean writeAllowed, boolean isWithRestrictedInformations) throws JsonProcessingException {
        try {
            TypedQuery<Object[]> query = this.buildUsersQueryLimited(realmModel.getId(), filters, limit, offset, Utils.emptyStringOrTrim(tabChose), new ArrayList<String>());
            List<CustomUserModel> olvidUsersList = isWithRestrictedInformations ? query.getResultStream().map(result -> Configuration.createOlvidUserRestrictedFromUserEntity(this.em, this.session, realmModel, (UserEntity)result[0], (OlvidCircleVisibility)result[1])).collect(Collectors.toList()) : query.getResultStream().map(result -> Configuration.createOlvidUserFromUserEntity(this.em, this.session, realmModel, (UserEntity)result[0], (OlvidCircleVisibility)result[1])).collect(Collectors.toList());
            Query countQuery = this.buildQueryCountWithFilter(realmModel.getId(), Utils.emptyStringOrTrim(tabChose), filters, new ArrayList<String>());
            Long countResult = (Long)countQuery.getSingleResult();
            GetUsersFilteredResponseModel responseModel = new GetUsersFilteredResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setCount(countResult);
            responseModel.setUsersList(olvidUsersList);
            responseModel.setRealmComponent(realmModel.getComponentsStream().map(ComponentModel::getName).collect(Collectors.toList()));
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processGetOlvidDevicesFiltered(String realmName, String tabChose, List<String> filters, int limit, int offset) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            TypedQuery<Object[]> query = this.buildDevicesQueryLimited(realmModel.getId(), filters, limit, offset, Utils.emptyStringOrTrim(tabChose));
            List<OlvidUserDeviceModel> olvidUserDeviceList = query.getResultStream().map(device -> new OlvidUserDeviceModel().newOlvidUserDevice(this.em, this.session, realmModel, (Object[])device, new OlvidCircleVisibility())).collect(Collectors.toList());
            Query countQuery = this.buildDevicesQueryCountWithFilter(realmModel.getId(), Utils.emptyStringOrTrim(tabChose), filters, new ArrayList<String>());
            Object countResult = countQuery.getSingleResult();
            Object countResultUnknown = 0;
            Object countResultOldSync = 0;
            if (!tabChose.contentEquals("From User Page")) {
                Query countQueryUnknown = this.buildDevicesQueryCountWithFilter(realmModel.getId(), "Devices UnKnown", filters, new ArrayList<String>());
                countResultUnknown = countQueryUnknown.getSingleResult();
                Query countQueryOldSync = this.buildDevicesQueryCountWithFilter(realmModel.getId(), "inactivefortoolong", filters, new ArrayList<String>());
                countResultOldSync = countQueryOldSync.getSingleResult();
            }
            GetDevicesResponseModel responseModel = new GetDevicesResponseModel();
            responseModel.setCount((Long)countResult);
            responseModel.setCountUnknown((Long)countResultUnknown);
            responseModel.setCountOldSync((Long)countResultOldSync);
            responseModel.setDevicesList(olvidUserDeviceList);
            responseModel.setRealmComponent(realmModel.getComponentsStream().map(ComponentModel::getName).collect(Collectors.toList()));
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processGetBotsFiltered(String role, String realmName, List<String> filters, int limit, int offset) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        boolean writeAllowed = this.checkQueryIsAllowed(46, role);
        boolean botsManagementEnable = OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "enableBotsManagement", false);
        try {
            TypedQuery<Object[]> query = this.buildBotQueryLimited(realmModel.getId(), filters, limit, offset);
            List<CustomUserModel> olvidUsersList = query.getResultStream().map(result -> Configuration.createOlvidUserFromUserEntity(this.em, this.session, realmModel, (UserEntity)result[0], (OlvidCircleVisibility)result[1])).collect(Collectors.toList());
            Query countQuery = this.buildBotCountQueryLimited(realmModel.getId(), filters, new ArrayList<String>());
            Object countResult = countQuery.getSingleResult();
            GetBotsFilteredResponseModel responseModel = new GetBotsFilteredResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setEnableBotsManagement(botsManagementEnable);
            responseModel.setCount((Long)countResult);
            responseModel.setBotsList(olvidUsersList);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    public static CustomUserModel createOlvidUserFromUserEntity(EntityManager em, KeycloakSession session, RealmModel realmModel, UserEntity userEntity, OlvidCircleVisibility userOlvidCircleVisibility) {
        try {
            UserModel userModel = session.users().getUserById(realmModel, userEntity.getId());
            if (userModel != null) {
                String tabChose = "";
                return Configuration.createOlvidUserFromUserModel(em, session, realmModel, userModel, tabChose, userOlvidCircleVisibility);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
        }
        return null;
    }

    public static CustomUserModel createOlvidUserRestrictedFromUserEntity(EntityManager em, KeycloakSession session, RealmModel realmModel, UserEntity userEntity, OlvidCircleVisibility userOlvidCircleVisibility) {
        CustomUserModel olvidUser = new CustomUserModel();
        userEntity.getAttributes().forEach(attribute -> {
            if (attribute.getName().contentEquals("olvid-is-bot")) {
                olvidUser.setOlvidIsBot(true);
            } else if (attribute.getName().contentEquals("olvid-company")) {
                olvidUser.setCompany(attribute.getValue());
            } else if (attribute.getName().contentEquals("olvid-position")) {
                olvidUser.setPosition(attribute.getValue());
            } else if (attribute.getName().contentEquals("olvid-unbound")) {
                olvidUser.setIsUnbound(true);
            }
        });
        olvidUser.setId(userEntity.getId());
        olvidUser.setUsername(userEntity.getUsername());
        olvidUser.setFirstname(userEntity.getFirstName());
        olvidUser.setLastname(userEntity.getLastName());
        olvidUser.setFullname(userEntity.getFirstName(), userEntity.getLastName());
        olvidUser.setEmail(userEntity.getEmail());
        olvidUser.setIsEnabled(userEntity.isEnabled());
        return olvidUser;
    }

    public static CustomUserModel createOlvidUserFromUserModel(EntityManager em, KeycloakSession session, RealmModel realmModel, UserModel user, String tabChose, OlvidCircleVisibility userOlvidCircleVisibility) {
        CustomUserModel olvidUser = new CustomUserModel();
        olvidUser = olvidUser.initCustomUserModel(em, session, realmModel, olvidUser, user, userOlvidCircleVisibility);
        olvidUser.setLastSync(OlvidUserDetails.getLastSync(em, realmModel, user));
        olvidUser.setUserDevices(OlvidUserDetails.getOlvidUserDevice(em, realmModel, user));
        olvidUser.setCountUserOlvidGroups(user.getGroupsCount());
        olvidUser.setUserGroups(Collections.emptyList());
        if (olvidUser.getOlvidIdentity() != null) {
            try {
                byte[] identityBytes = Base64.getDecoder().decode(olvidUser.getOlvidIdentity());
                StringBuilder sb = new StringBuilder();
                if (olvidUser.getFirstname() != null) {
                    sb.append(olvidUser.getFirstname());
                }
                if (olvidUser.getLastname() != null) {
                    if (olvidUser.getFirstname() != null) {
                        sb.append(" ");
                    }
                    sb.append(olvidUser.getLastname());
                }
                if (olvidUser.getPosition() != null || olvidUser.getCompany() != null) {
                    sb.append(" (");
                    if (olvidUser.getPosition() != null) {
                        sb.append(olvidUser.getPosition());
                        if (olvidUser.getCompany() != null) {
                            sb.append("@");
                            sb.append(olvidUser.getCompany());
                        }
                    } else {
                        sb.append(olvidUser.getCompany());
                    }
                    sb.append(")");
                }
                olvidUser.setInvitationLink("https://invitation.olvid.io/#" + Base64.getUrlEncoder().encodeToString(Encoded.of(new Encoded[]{Encoded.of(identityBytes), Encoded.of(sb.toString())}).getBytes()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (tabChose != null && !tabChose.isEmpty()) {
            if (tabChose.contentEquals("withoutolvidpassword")) {
                if (!olvidUser.getCredential().booleanValue()) {
                    return olvidUser;
                }
                olvidUser.setId("");
                return olvidUser;
            }
            if (tabChose.contentEquals("activated")) {
                if (olvidUser.getIsActivated().booleanValue()) {
                    return olvidUser;
                }
                olvidUser.setId("");
                return olvidUser;
            }
            if (tabChose.contentEquals("notactivated")) {
                if (!olvidUser.getIsActivated().booleanValue()) {
                    return olvidUser;
                }
                olvidUser.setId("");
                return olvidUser;
            }
            if (tabChose.contentEquals("bot")) {
                if (olvidUser.getOlvidIsBot().booleanValue()) {
                    return olvidUser;
                }
                olvidUser.setId("");
                return olvidUser;
            }
            if (tabChose.contentEquals("enabled")) {
                if (olvidUser.getIsEnabled().booleanValue()) {
                    return olvidUser;
                }
                olvidUser.setId("");
                return olvidUser;
            }
            if (tabChose.contentEquals("disabled")) {
                if (!olvidUser.getIsEnabled().booleanValue()) {
                    return olvidUser;
                }
                olvidUser.setId("");
                return olvidUser;
            }
            olvidUser.setId("");
            return olvidUser;
        }
        return olvidUser;
    }

    private Response processGetAllGroups(String role, String realmName, String userId, Boolean isWithRestrictedInformations) throws JsonProcessingException {
        boolean writeAllowed = this.checkQueryIsAllowed(30, role);
        GroupMembersQueryType groupMembersQueryType = isWithRestrictedInformations == null || isWithRestrictedInformations != false ? GroupMembersQueryType.GROUP_LIST_NO_DETAILS : GroupMembersQueryType.GROUP_LIST_WITH_DETAILS;
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid groups of a non olvid realm");
            return this.badRealmType();
        }
        try {
            HashMap<String, UserModelAttributes> userModelsCache = new HashMap<String, UserModelAttributes>();
            List<GroupModel> flatGroupList = realmModel.getGroupsStream().collect(Collectors.toList());
            ArrayList<GroupModel> groupFlatListFiltered = new ArrayList<GroupModel>();
            List<GroupModel> flatGroupListTopPath = flatGroupList.stream().filter(group -> Utils.computeGroupPath(group).isEmpty()).collect(Collectors.toList());
            int limit = flatGroupListTopPath.size();
            List<GroupUserModel> groupTreeList = this.buildGroupsTreeHierarchy(this.em, this.session, realmModel, flatGroupList, flatGroupListTopPath, groupFlatListFiltered, 0, limit, userId, userModelsCache, groupMembersQueryType);
            GetGroupsResponseModel responseModel = new GetGroupsResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            List flatGroupListFilteredFormated = groupFlatListFiltered.stream().map(group -> {
                try {
                    return this.createGroupUsersFromGroupModel(this.em, this.session, realmModel, (GroupModel)group, groupMembersQueryType, (Map<String, UserModelAttributes>)userModelsCache, "", (List<String>)new ArrayList<String>(), "");
                }
                catch (NamingException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            responseModel.setCount(flatGroupList.size());
            responseModel.setFlatList(flatGroupListFilteredFormated);
            responseModel.setGroupTreeList(groupTreeList);
            responseModel.setCountTopGroup(flatGroupListTopPath.size());
            responseModel.setCountPages((flatGroupListTopPath.size() - 1) / 10 + 1);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    protected List<GroupUserModel> buildGroupsTreeHierarchy(EntityManager em, KeycloakSession session, RealmModel realmModel, List<GroupModel> flatGroupList, List<GroupModel> flatGroupListTopPath, List<GroupModel> flatGroupListFiltered, int offset, int limit, String userId, Map<String, UserModelAttributes> userModelsCache, GroupMembersQueryType groupMembersQueryType) {
        if (!flatGroupListTopPath.isEmpty()) {
            for (int i = offset; i < flatGroupListTopPath.size(); ++i) {
                try {
                    GroupModel group2 = flatGroupListTopPath.get(i);
                    flatGroupListFiltered.add(group2);
                    List listParentsIdToFind = flatGroupListFiltered.stream().map(GroupModel::getId).collect(Collectors.toList());
                    while (!listParentsIdToFind.isEmpty()) {
                        String parentId = (String)listParentsIdToFind.get(listParentsIdToFind.size() - 1);
                        List<GroupModel> groupsChildFound = flatGroupList.stream().filter(child -> child.getParentId() != null && child.getParentId().contentEquals(parentId)).collect(Collectors.toList());
                        if (!groupsChildFound.isEmpty()) {
                            groupsChildFound.forEach(groupChildFound -> {
                                listParentsIdToFind.add(groupChildFound.getId());
                                if (!flatGroupListFiltered.contains(groupChildFound)) {
                                    flatGroupListFiltered.add((GroupModel)groupChildFound);
                                }
                            });
                        }
                        listParentsIdToFind.remove(parentId);
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.info((Object)("buildGroupsTreeHierarchy 'for boucle' Exception " + e.getMessage()));
                }
            }
        }
        List<GroupUserModel> flatGroupListFilteredFormated = flatGroupListFiltered.stream().map(group -> {
            try {
                return this.createGroupUsersFromGroupModel(em, session, realmModel, (GroupModel)group, groupMembersQueryType, userModelsCache, "", (List<String>)new ArrayList<String>(), "");
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        return Configuration.arrayToTree(flatGroupListFilteredFormated, null, 0);
    }

    protected static List<GroupUserModel> arrayToTree(List<GroupUserModel> groupFlatList, String parentId, int currentDepth) {
        return groupFlatList.stream().filter(item -> Objects.equals(item.parentId, parentId)).peek(parent -> {
            if (currentDepth < 50) {
                parent.children = Configuration.arrayToTree(groupFlatList, parent.id, currentDepth + 1);
                if (!parent.children.isEmpty()) {
                    parent.hasChild = true;
                }
            }
        }).collect(Collectors.toList());
    }

    private GroupUserModel createGroupUsersFromGroupModel(EntityManager em, KeycloakSession session, RealmModel realmModel, GroupModel groupModel, GroupMembersQueryType groupMembersQueryType, Map<String, UserModelAttributes> userModelsCache, String tabChoseGroupMembers, List<String> filtersGroupMembers, String groupId) throws NamingException {
        GroupUserModel groupUsers = GroupUserModel.initGroupUsers(groupModel);
        groupUsers.setParentId(groupModel.getParentId());
        if (groupUsers.getParentId() != null) {
            groupUsers.setParentName(session.groups().getGroupById(realmModel, groupUsers.parentId).getName());
        }
        groupUsers.setDuplicateGroup(session.groups().getGroupsStream(realmModel).anyMatch(groupFound -> Objects.equals(groupFound.getName(), groupUsers.name) && !Objects.equals(groupFound.getId(), groupUsers.id)));
        groupUsers.setOlvidManaged(Utils.getGroupBooleanAttribute(groupModel, "olvid-managed"));
        ArrayList<CustomUserModel> groupMembers = new ArrayList<CustomUserModel>();
        groupUsers.setGroupMembers(groupMembers);
        if (groupMembersQueryType == GroupMembersQueryType.GROUP_LIST_WITH_DETAILS || groupMembersQueryType == GroupMembersQueryType.SINGLE_GROUP_WITH_DETAILS) {
            if (!groupUsers.olvidManaged.booleanValue()) {
                if (tabChoseGroupMembers != null && !tabChoseGroupMembers.isEmpty() || !filtersGroupMembers.isEmpty() || !groupId.isEmpty()) {
                    Configuration.getGroupMembersKeycloakProcessWithTabChoseAndFilters(em, session, realmModel, groupModel, groupMembersQueryType, new HashMap<String, UserModelAttributes>(), tabChoseGroupMembers, filtersGroupMembers, groupUsers, groupMembers);
                } else {
                    List<ComponentModel> userProviderList = realmModel.getComponentsStream().filter(elem -> Objects.equals("ldap", elem.getProviderId())).collect(Collectors.toList());
                    if (!userProviderList.isEmpty()) {
                        Configuration.getProviderGroupsAndUsers(em, session, realmModel, groupModel, groupMembersQueryType, userProviderList, groupUsers, groupMembers, userModelsCache, tabChoseGroupMembers, filtersGroupMembers);
                    } else {
                        Configuration.getGroupMembersKeycloakProcessWithTabChoseAndFilters(em, session, realmModel, groupModel, groupMembersQueryType, userModelsCache, tabChoseGroupMembers, filtersGroupMembers, groupUsers, groupMembers);
                    }
                }
            } else {
                Configuration.getGroupMembersKeycloakProcessWithTabChoseAndFilters(em, session, realmModel, groupModel, groupMembersQueryType, userModelsCache, tabChoseGroupMembers, filtersGroupMembers, groupUsers, groupMembers);
            }
        }
        try {
            byte[] groupPhotoUid;
            OlvidGroup olvidGroup = OlvidGroupDao.getOlvidGroupById(em, realmModel.getId(), groupUsers.id);
            if (olvidGroup != null && (groupPhotoUid = olvidGroup.getGroupPhotoUid()) != null) {
                groupUsers.avatarUuid = groupPhotoUid;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"createGroupUsersFromGroupModel: Exception while preparing group avatar", (Throwable)e);
        }
        return groupUsers;
    }

    private static void getGroupMembersKeycloakProcessWithTabChoseAndFilters(EntityManager em, KeycloakSession session, RealmModel realmModel, GroupModel groupModel, GroupMembersQueryType groupMembersQueryType, Map<String, UserModelAttributes> userModelsCache, String tabChoseGroupMembers, List<String> filtersGroupMembers, GroupUserModel groupUsers, List<CustomUserModel> groupMembers) {
        Stream userStream = filtersGroupMembers.isEmpty() ? session.users().getGroupMembersStream(realmModel, groupModel) : session.users().getGroupMembersStream(realmModel, groupModel, String.join((CharSequence)",", filtersGroupMembers), Boolean.valueOf(false), Integer.valueOf(0), Integer.valueOf(10000));
        if (tabChoseGroupMembers != null && !tabChoseGroupMembers.isEmpty()) {
            userStream.forEach(userModel -> {
                CustomUserModel olvidUser = Configuration.createOlvidUserFromUserModel(em, session, realmModel, userModel, tabChoseGroupMembers, new OlvidCircleVisibility());
                if (!olvidUser.getId().isEmpty()) {
                    Configuration.setGroupUsersInformationFromUserModelAndGetGroupMemberIfIsWithGroupMembers(em, session, realmModel, groupMembersQueryType, userModelsCache, userModel, groupUsers, groupMembers);
                }
            });
        } else {
            userStream.forEach(userModel -> Configuration.setGroupUsersInformationFromUserModelAndGetGroupMemberIfIsWithGroupMembers(em, session, realmModel, groupMembersQueryType, userModelsCache, userModel, groupUsers, groupMembers));
        }
    }

    private static void setGroupUsersInformationFromUserModelAndGetGroupMemberIfIsWithGroupMembers(EntityManager em, KeycloakSession session, RealmModel realmModel, GroupMembersQueryType groupMembersQueryType, Map<String, UserModelAttributes> userModelsCache, UserModel userModel, GroupUserModel finalGroupUsers, List<CustomUserModel> groupMembers) {
        switch (groupMembersQueryType) {
            case GROUP_LIST_NO_DETAILS: 
            case SINGLE_GROUP_NO_DETAILS: {
                break;
            }
            case GROUP_LIST_WITH_DETAILS: {
                UserModelAttributes user = userModelsCache.get(userModel.getId());
                if (user == null) {
                    user = new UserModelAttributes().initUserModelAttributes(session, realmModel, new UserModelAttributes(), userModel, userModel.getUsername());
                    userModelsCache.put(userModel.getId(), user);
                }
                Configuration.setGroupUsersInformationFromUserModel(finalGroupUsers, user);
                break;
            }
            case SINGLE_GROUP_WITH_DETAILS: {
                groupMembers.add(Configuration.createOlvidUserFromUserModel(em, session, realmModel, userModel, "", new OlvidCircleVisibility()));
            }
        }
    }

    private static void getProviderGroupsAndUsers(EntityManager em, KeycloakSession session, RealmModel realmModel, GroupModel groupModel, GroupMembersQueryType groupMembersQueryType, List<ComponentModel> userProviderList, GroupUserModel finalGroupUsers, List<CustomUserModel> groupMembers, Map<String, UserModelAttributes> usersModelAttributesCache, String tabChoseGroupMembers, List<String> filtersGroupMembers) {
        userProviderList.forEach(provider -> {
            block17: {
                if (provider.getProviderId().equals("ldap")) {
                    try {
                        MultivaluedHashMap config = provider.getConfig();
                        LDAPConfig ldapConfig = new LDAPConfig(config);
                        LDAPStorageProviderFactory lDAPStorageProviderFactory = new LDAPStorageProviderFactory();
                        LDAPIdentityStore lDAPIdentityStore = new LDAPIdentityStore(session, ldapConfig);
                        LDAPStorageProvider lDAPStorageProvider = new LDAPStorageProvider(lDAPStorageProviderFactory, session, provider, lDAPIdentityStore);
                        List configProperties = lDAPStorageProviderFactory.getConfigProperties();
                        AtomicReference<Boolean> isEnabled = new AtomicReference<Boolean>(false);
                        configProperties.forEach(configProperty -> {
                            if (configProperty.getName().equals("importEnabled")) {
                                isEnabled.set(true);
                            }
                        });
                        List<ComponentModel> mapperModels = realmModel.getComponentsStream(lDAPStorageProvider.getModel().getId(), LDAPStorageMapper.class.getName()).collect(Collectors.toList());
                        AtomicReference<KeycloakProviderGroupMapperModel> keycloakProviderGroupMapperModel = new AtomicReference<KeycloakProviderGroupMapperModel>(new KeycloakProviderGroupMapperModel());
                        mapperModels.forEach(mapper -> {
                            if (mapper.getProviderId().equals("group-ldap-mapper")) {
                                MultivaluedHashMap configMapper = mapper.getConfig();
                                keycloakProviderGroupMapperModel.set(new KeycloakProviderGroupMapperModel().initKeycloakProviderGroupMapperModel((MultivaluedHashMap<String, String>)configMapper));
                            }
                        });
                        if (!isEnabled.get().booleanValue()) break block17;
                        try (LDAPQuery ldapQuery = new LDAPQuery(lDAPStorageProvider);){
                            LDAPConfig configIdentityStore = lDAPStorageProvider.getLdapIdentityStore().getConfig();
                            ldapQuery.setSearchScope(configIdentityStore.getSearchScope());
                            ldapQuery.setSearchDn(configIdentityStore.getUsersDn());
                            configIdentityStore.getCustomUserSearchFilter();
                            ldapQuery.addReturningLdapAttribute(keycloakProviderGroupMapperModel.get().getMembershipLdapAttribute());
                            ldapQuery.addMappers(mapperModels);
                            String customFilterCustom = configIdentityStore.getCustomUserSearchFilter();
                            if (customFilterCustom != null) {
                                Condition customFilterCondition = new LDAPQueryConditionsBuilder().addCustomLDAPFilter(customFilterCustom);
                                ldapQuery.addWhereCondition(new Condition[]{customFilterCondition});
                            }
                            String customFilter = "(" + keycloakProviderGroupMapperModel.get().getGroupNameLdapAttribute() + "=" + finalGroupUsers.getName() + ")";
                            Condition customFilterCondition = new LDAPQueryConditionsBuilder().addCustomLDAPFilter(customFilter);
                            ldapQuery.addWhereCondition(new Condition[]{customFilterCondition});
                            ldapQuery.getFirstResult();
                            List queryResults = ldapQuery.getResultList();
                            List groupMembersLDAP = new ArrayList();
                            List resultTMP = queryResults.stream().map(result -> new ArrayList((Collection)result.getAttributes().get(((KeycloakProviderGroupMapperModel)keycloakProviderGroupMapperModel.get()).getMembershipLdapAttribute()))).collect(Collectors.toList());
                            if (!resultTMP.isEmpty()) {
                                groupMembersLDAP = (List)resultTMP.get(0);
                            }
                            int limit = 0;
                            int offset = 0;
                            HashMap usersModelCache = new HashMap();
                            while (limit < groupMembersLDAP.size() - 1) {
                                try {
                                    List<String> groupMembersLDAP_TMP;
                                    int limitForGetGroups = 20;
                                    if ((limit += limitForGetGroups) > groupMembersLDAP.size()) {
                                        limit = groupMembersLDAP.size();
                                        groupMembersLDAP_TMP = groupMembersLDAP.subList(offset, groupMembersLDAP.size());
                                    } else {
                                        groupMembersLDAP_TMP = groupMembersLDAP.subList(offset, limit);
                                    }
                                    TypedQuery<UserEntity> query = Configuration.buildGetUserByAttributes(em, realmModel.getId(), groupMembersLDAP_TMP, 10000, 0);
                                    List usersEntities = query.getResultList();
                                    usersEntities.forEach(userEntity -> {
                                        boolean userMatchesFilters;
                                        boolean bl = userMatchesFilters = filtersGroupMembers.isEmpty() || filtersGroupMembers.stream().anyMatch(filter -> userEntity.getUsername().contains((CharSequence)filter) || userEntity.getEmail().contains((CharSequence)filter) || userEntity.getFirstName().contains((CharSequence)filter) || userEntity.getLastName().contains((CharSequence)filter));
                                        if (userMatchesFilters) {
                                            UserModelAttributes cachedUserModelAttributes = (UserModelAttributes)usersModelAttributesCache.get(userEntity.getId());
                                            if (cachedUserModelAttributes != null) {
                                                CustomUserModel cachedUserModel;
                                                Configuration.setGroupUsersInformationFromUserModel(finalGroupUsers, cachedUserModelAttributes);
                                                if (groupMembersQueryType == GroupMembersQueryType.SINGLE_GROUP_WITH_DETAILS && (cachedUserModel = (CustomUserModel)usersModelCache.get(cachedUserModelAttributes.getId())) != null) {
                                                    groupMembers.add(cachedUserModel);
                                                    finalGroupUsers.groupMembers.add(cachedUserModel);
                                                }
                                            } else {
                                                Configuration.setGroupUsersInformationAndIfIsWithMembers(em, session, realmModel, groupMembersQueryType, finalGroupUsers, groupMembers, usersModelAttributesCache, userEntity, usersModelCache, tabChoseGroupMembers);
                                            }
                                        }
                                    });
                                    offset = limit;
                                }
                                catch (Exception e) {
                                    logger.warn((Object)"Exception in createGroupUsersFromGroupModel e ", (Throwable)e);
                                }
                            }
                        }
                    }
                    catch (Exception ectx) {
                        logger.warn((Object)"LDAP query failed", (Throwable)ectx);
                        Configuration.getGroupMembersKeycloakProcessWithTabChoseAndFilters(em, session, realmModel, groupModel, groupMembersQueryType, usersModelAttributesCache, tabChoseGroupMembers, filtersGroupMembers, finalGroupUsers, groupMembers);
                    }
                } else if (provider.getProviderId().equals("kerberos")) {
                    logger.warn((Object)"Kerberos is not actually implemented, ask Olvid Team for the feature");
                    Configuration.getGroupMembersKeycloakProcessWithTabChoseAndFilters(em, session, realmModel, groupModel, groupMembersQueryType, usersModelAttributesCache, tabChoseGroupMembers, filtersGroupMembers, finalGroupUsers, groupMembers);
                }
            }
        });
    }

    private static void setGroupUsersInformationAndIfIsWithMembers(EntityManager em, KeycloakSession session, RealmModel realmModel, GroupMembersQueryType groupMembersQueryType, GroupUserModel finalGroupUsers, List<CustomUserModel> groupMembers, Map<String, UserModelAttributes> usersModelAttributesCache, UserEntity userEntity, Map<String, CustomUserModel> usersModelCache, String tabChose) {
        UserModelAttributes userModelAttributes = new UserModelAttributes().initUserModelAttributes(session, realmModel, new UserModelAttributes(), session.users().getUserById(realmModel, userEntity.getId()), userEntity.getUsername());
        Configuration.setGroupUsersInformationFromUserModel(finalGroupUsers, userModelAttributes);
        usersModelAttributesCache.put(userEntity.getId(), userModelAttributes);
        if (groupMembersQueryType == GroupMembersQueryType.SINGLE_GROUP_WITH_DETAILS) {
            try {
                UserModel userModel = session.users().getUserById(realmModel, userEntity.getId());
                CustomUserModel customUserModel = Configuration.createOlvidUserFromUserModel(em, session, realmModel, userModel, tabChose, new OlvidCircleVisibility());
                groupMembers.add(customUserModel);
                usersModelCache.put(userEntity.getId(), customUserModel);
                finalGroupUsers.groupMembers.add(customUserModel);
            }
            catch (Exception e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
            }
        }
    }

    private static void setGroupUsersInformationFromUserModel(GroupUserModel finalGroupUsers, UserModelAttributes user) {
        ++finalGroupUsers.countGroupMembers;
        if (user.getFederatedUsers().booleanValue()) {
            ++finalGroupUsers.countMembersFederated;
        } else if (user.getFederatedIdentities().booleanValue()) {
            ++finalGroupUsers.countMembersIdentityProvider;
        } else if (!user.getCredential().booleanValue()) {
            ++finalGroupUsers.countMembersWithoutPassword;
        }
        if (user.getOlvidIdentity() == null && !user.getOlvidIsBot().booleanValue() || user.getIsUnbound().booleanValue()) {
            ++finalGroupUsers.countMembersAwaitingActivation;
        }
        if (user.getOlvidIsBot().booleanValue()) {
            ++finalGroupUsers.countMembersBots;
        }
    }

    private Response processGetUsersByUsername(String role, String realmName, List<String> usersList, List<String> filters, int limit, int offset) throws JsonProcessingException {
        boolean writeAllowed = this.checkQueryIsAllowed(39, role);
        int userGroupsLimit = 10;
        int userGroupsOffset = 0;
        return this.getResponseProcessGetUsersByUsername(realmName, usersList, filters, limit, offset, writeAllowed, userGroupsLimit, userGroupsOffset);
    }

    private Response processGetUserByUsername(String role, String realmName, String username, List<String> filters, int limit, int offset) throws JsonProcessingException {
        boolean writeAllowed = this.checkQueryIsAllowed(39, role);
        return this.getResponseProcessGetUserByUsername(realmName, username, filters, limit, offset, writeAllowed);
    }

    protected Response getResponseProcessGetUserByUsername(String realmName, String username, List<String> filters, int userGroupsLimit, int userGroupsOffset, boolean writeAllowed) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            UserModel user = this.session.users().getUserByUsername(realmModel, username);
            String tabChose = "";
            CustomUserModel userFormated = Configuration.createOlvidUserFromUserModel(this.em, this.session, realmModel, user, tabChose, new OlvidCircleVisibility());
            GetUserByUsernameResponseModel responseModel = new GetUserByUsernameResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setUser(userFormated);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    protected Response getResponseProcessGetUsersByUsername(String realmName, List<String> usersList, List<String> filters, int limit, int offset, boolean writeAllowed, int userGroupsLimit, int userGroupsOffset) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            TypedQuery<Object[]> query = this.buildQueryFindUsersLimited(realmModel.getId(), usersList, filters, limit, offset);
            List<CustomUserModel> olvidUsersList = query.getResultStream().map(result -> Configuration.createOlvidUserFromUserEntity(this.em, this.session, realmModel, (UserEntity)result[0], (OlvidCircleVisibility)result[1])).collect(Collectors.toList());
            Query countQuery = this.buildQueryCountWithFilter(realmModel.getId(), "selected", filters, usersList);
            Object countResult = countQuery.getSingleResult();
            Query countQueryTotal = this.buildQueryCount(realmModel.getId());
            Object countResultTotal = countQueryTotal.getSingleResult();
            List<OlvidCircleVisibility> circles = Configuration.getOlvidCirclesVisibilities(this.em, realmModel);
            GetUsersByUsernameResponseModel responseModel = new GetUsersByUsernameResponseModel();
            responseModel.setCount((Long)countResult);
            responseModel.setUsersList(olvidUsersList);
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setCircles(circles);
            responseModel.setCountRealmTotalUserst((Long)countResultTotal);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processGetGroupsByName(String role, String realmName, List<String> filters, int limit, int offset) throws JsonProcessingException {
        boolean writeAllowed = this.checkQueryIsAllowed(30, role);
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            List unaccentFilters = filters.stream().filter(filter -> !filter.trim().isEmpty()).map(Utils::unAccent).collect(Collectors.toList());
            List matchingGroupModels = realmModel.getGroupsStream().filter(groupModel -> {
                for (String filter : unaccentFilters) {
                    if (Utils.unAccent(groupModel.getName()).contains(filter)) continue;
                    return false;
                }
                return true;
            }).collect(Collectors.toList());
            ArrayList<GroupModel> flatGroupListTopPath = new ArrayList<GroupModel>();
            ArrayList<GroupModel> flatGroupListFiltered = new ArrayList<GroupModel>();
            for (GroupModel matchingGroupModel : matchingGroupModels) {
                boolean isChild;
                boolean bl = isChild = matchingGroupModel.getParentId() != null;
                if (!isChild) {
                    if (!flatGroupListTopPath.contains(matchingGroupModel)) {
                        flatGroupListTopPath.add(matchingGroupModel);
                    }
                } else {
                    ArrayList<String> listParentsIdToFind = new ArrayList<String>();
                    listParentsIdToFind.add(matchingGroupModel.getParentId());
                    while (!listParentsIdToFind.isEmpty()) {
                        boolean isChildTMP;
                        String parentId = (String)listParentsIdToFind.get(listParentsIdToFind.size() - 1);
                        GroupModel groupsParentFound = this.session.groups().getGroupById(realmModel, parentId);
                        boolean bl2 = isChildTMP = groupsParentFound.getParentId() != null;
                        if (!isChildTMP && !flatGroupListTopPath.contains(groupsParentFound)) {
                            flatGroupListTopPath.add(groupsParentFound);
                        }
                        if (groupsParentFound.getParentId() != null) {
                            listParentsIdToFind.add(groupsParentFound.getParentId());
                            if (!flatGroupListFiltered.contains(groupsParentFound)) {
                                flatGroupListFiltered.add(groupsParentFound);
                            }
                        }
                        listParentsIdToFind.remove(parentId);
                    }
                }
                if (flatGroupListFiltered.contains(matchingGroupModel)) continue;
                flatGroupListFiltered.add(matchingGroupModel);
            }
            ArrayList<GroupModel> groupFlatListFiltered = new ArrayList<GroupModel>();
            limit = flatGroupListTopPath.size();
            HashMap<String, UserModelAttributes> userModelsCache = new HashMap<String, UserModelAttributes>();
            List<GroupUserModel> groupTreeList = this.buildGroupsTreeHierarchy(this.em, this.session, realmModel, flatGroupListFiltered, flatGroupListTopPath, groupFlatListFiltered, offset, limit, null, userModelsCache, GroupMembersQueryType.GROUP_LIST_WITH_DETAILS);
            List<GroupUserModel> flatGroupListFilteredFormated = groupFlatListFiltered.stream().map(group -> {
                try {
                    return this.createGroupUsersFromGroupModel(this.em, this.session, realmModel, (GroupModel)group, GroupMembersQueryType.GROUP_LIST_WITH_DETAILS, (Map<String, UserModelAttributes>)userModelsCache, "", (List<String>)new ArrayList<String>(), "");
                }
                catch (NamingException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            GetGroupsByNameResponseModel responseModel = new GetGroupsByNameResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setGroupTreeList(groupTreeList);
            responseModel.setFlatList(flatGroupListFilteredFormated);
            responseModel.setCountTopGroup(flatGroupListTopPath.size());
            responseModel.setCountPages((flatGroupListTopPath.size() - 1) / 10 + 1);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processGetGroupMembersById(String role, String realmName, String groupId, String tabChose, List<String> filters, int limit, int offset, List<String> groupList) throws JsonProcessingException {
        boolean writeAllowed = this.checkQueryIsAllowed(30, role);
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            GroupUserModel groupUsers = this.getGroupUsers(groupId, realmModel, tabChose, filters, limit, offset, true, groupList);
            GetGroupsByIdResponseModel responseModel = new GetGroupsByIdResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setGroup(groupUsers);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processGetGroupById(String role, String realmName, String groupId) throws JsonProcessingException {
        boolean writeAllowed = this.checkQueryIsAllowed(30, role);
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            GroupModel groupModel = this.session.groups().getGroupById(realmModel, groupId);
            GroupUserModel groupUsers = GroupUserModel.initGroupUsers(groupModel);
            groupUsers.setCountGroupMembers(this.session.users().getGroupMembersStream(realmModel, groupModel).count());
            GetGroupsByIdResponseModel responseModel = new GetGroupsByIdResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setGroup(groupUsers);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    protected GroupUserModel getGroupUsers(String groupId, RealmModel realmModel, String tabChose, List<String> filters, int limit, int offset, boolean isWithGroupMembers, List<String> groupList) throws NamingException {
        GroupModel matchingGroupModel = realmModel.getGroupById(groupId);
        GroupMembersQueryType groupMembersQueryType = isWithGroupMembers ? GroupMembersQueryType.SINGLE_GROUP_WITH_DETAILS : GroupMembersQueryType.SINGLE_GROUP_NO_DETAILS;
        return this.createGroupUsersFromGroupModel(this.em, this.session, realmModel, matchingGroupModel, groupMembersQueryType, new HashMap<String, UserModelAttributes>(), tabChose, filters, groupId);
    }

    protected Response processGetGroupAvatar(String realmName, byte[] dataUid, String id) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        Object avatarUrl = "";
        try {
            try {
                OlvidData olvidData;
                OlvidGroup olvidGroup;
                byte[] dataUidToFind = dataUid;
                if (dataUidToFind == null && (olvidGroup = OlvidGroupDao.getOlvidGroupById(this.em, realmModel.getId(), id)) != null) {
                    dataUidToFind = olvidGroup.getGroupPhotoUid();
                }
                if (dataUidToFind != null && (olvidData = OlvidDataDao.getOlvidDataByUid(this.em, realmModel.getId(), dataUidToFind)) != null) {
                    avatarUrl = "data:image/jpeg;base64," + Base64.getEncoder().encodeToString(olvidData.getData());
                }
            }
            catch (Exception e) {
                logger.warn((Object)"getGroupAvatar: Exception while preparing group avatar", (Throwable)e);
            }
            GetGroupAvatarResponseModel responseModel = new GetGroupAvatarResponseModel();
            responseModel.setAvatarUrl((String)avatarUrl);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    protected Response processGetGroupEphemeralSettings(String realmName, String id) throws IOException {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (realmModel == null) {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "internal error", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        OlvidGroup olvidGroup = OlvidGroupDao.getOlvidGroupById(this.em, realmModel.getId(), id);
        JsonSharedSettings sharedSettings = new JsonSharedSettings();
        if (olvidGroup != null && olvidGroup.getSerializedSharedSettings() != null) {
            sharedSettings = (JsonSharedSettings)this.objectMapper.readValue(olvidGroup.getSerializedSharedSettings(), JsonSharedSettings.class);
        }
        GetGroupEphemeralSettingsResponseModel responseModel = new GetGroupEphemeralSettingsResponseModel();
        responseModel.setSharedSettings(sharedSettings);
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
    }

    private static TypedQuery<UserEntity> buildGetUserByAttributes(EntityManager em, String realmId, List<String> filters, int limit, int offset) {
        StringBuilder sb = new StringBuilder(" SELECT DISTINCT u FROM UserEntity u  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'LDAP_ENTRY_DN' AND (attr.value IN :filters))");
        sb.append(" order by u.lastName, u.firstName, u.username");
        TypedQuery query = em.createQuery(sb.toString(), UserEntity.class);
        query.setParameter("realmId", (Object)realmId);
        query.setParameter("filters", filters);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query;
    }

    private TypedQuery<Object[]> buildUsersQueryLimited(String realmId, List<String> filters, int limit, int offset, String tabChose, List<String> usernameList) {
        StringBuilder sb = tabChose.contentEquals("withoutolvidpassword") ? new StringBuilder(" SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN u.credentials cred on cred.type = 'password' left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId AND ((cred.id is null) AND u not in (SELECT DISTINCT u FROM UserEntity u  LEFT JOIN u.attributes attr WHERE u.realmId = :realmId AND attr.name in ('LDAP_ID', 'KERBEROS_PRINCIPAL'))) AND ((cred.id is null) AND u not in (SELECT DISTINCT u FROM UserEntity u  LEFT JOIN u.attributes attr WHERE u.realmId = :realmId AND size(u.federatedIdentities)>0))") : (tabChose.contentEquals("activated") ? new StringBuilder("SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  LEFT JOIN u.attributes attr_unbound on attr_unbound.name = 'olvid-unbound'  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  LEFT JOIN u.credentials cred on cred.type = 'password' WHERE u.realmId = :realmId  AND (attr.name = 'olvid-identity') AND attr_unbound.value is null ") : (tabChose.contentEquals("notactivated") ? new StringBuilder(" SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN u.credentials cred on cred.type = 'password' left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId AND u.id not in ( SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN u.attributes attr_unbound on attr_unbound.name = 'olvid-unbound'  AND u.enabled = true  WHERE u.realmId = :realmId  AND attr_unbound.value is null  AND (attr.name = 'olvid-identity'))") : (tabChose.contentEquals("enabled") ? new StringBuilder(" SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId  AND u.enabled = true") : (tabChose.contentEquals("disabled") ? new StringBuilder(" SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId  AND u.enabled is false") : (tabChose.contentEquals("bot") ? new StringBuilder("SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-is-bot')") : (tabChose.contentEquals("withuntrusteddevice") ? new StringBuilder("SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  LEFT JOIN u.attributes attr  INNER JOIN OlvidUserDevice oud ON u.id = oud.userId LEFT JOIN u.credentials cred on cred.type = 'password' left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilit9y9.yId = ocv.id  WHERE u.realmId = :realmId AND oud.isKnown = false") : (tabChose.contentEquals("inactivefortoolong") ? new StringBuilder("SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  LEFT JOIN u.attributes attr  INNER JOIN OlvidUserDevice oud ON u.id = oud.userId LEFT JOIN u.credentials cred on cred.type = 'password' left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId AND oud.lastSync < :oldDeviceTimeLimit AND oud.isKnown = true") : new StringBuilder("SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId"))))))));
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND LOWER(attr.value) LIKE :?) OR ( attr.name = 'olvid-company' AND LOWER(attr.value) LIKE :?) OR LOWER(u.firstName) LIKE :? OR LOWER(u.lastName) LIKE :? OR LOWER(u.username) LIKE :? OR LOWER(u.email) LIKE :? OR LOWER(ocv.name) LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        if (!usernameList.isEmpty()) {
            sb.append(" AND (u.username IN :usernameList)");
        }
        sb.append(" order by u.lastName, u.firstName, u.username");
        TypedQuery query = this.em.createQuery(sb.toString(), Object[].class);
        query.setParameter("realmId", (Object)realmId);
        if (!usernameList.isEmpty()) {
            query.setParameter("usernameList", usernameList);
        }
        if (tabChose.contentEquals("inactivefortoolong")) {
            int oldDeviceTimeLimit = OlvidConfigurationDao.getIntConfiguration(this.em, realmId, "oldDeviceTimeLimit", 30);
            long currentTimestamp = System.currentTimeMillis();
            long oldDeviceTimeLimitFromcurrentTimestamp = currentTimestamp - (long)oldDeviceTimeLimit * 86400000L;
            query.setParameter("oldDeviceTimeLimit", (Object)oldDeviceTimeLimitFromcurrentTimestamp);
        }
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter.toLowerCase() + "%"));
            ++count;
        }
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query;
    }

    private TypedQuery<Object[]> buildCircleMembersQueryLimited(String realmId, int limit, int offset) {
        StringBuilder sb = new StringBuilder(" SELECT u as userEntity, ocvu as olvidCircleVisibilityUser, ocv as olvidCircleVisibility, ocvr as olvidCircleVisibilityRules FROM UserEntity u  LEFT JOIN u.attributes attr  RIGHT JOIN OlvidCircleVisibilityUser ocvu on ocvu.userId = u.id  LEFT JOIN OlvidCircleVisibility ocv on ocv.id = ocvu.circleVisibilityId  LEFT JOIN OlvidCircleVisibilityRules ocvr on (ocvr.circleVisibilityId1From = ocv.id or ocvr.circleVisibilityId2To = ocv.id) WHERE u.realmId = :realmId");
        sb.append(" order by u.lastName, u.firstName, u.username");
        TypedQuery query = this.em.createQuery(sb.toString(), Object[].class);
        query.setParameter("realmId", (Object)realmId);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query;
    }

    private TypedQuery<Object[]> buildDevicesQueryLimited(String realmId, List<String> filters, int limit, int offset, String tabChose) {
        StringBuilder sb = new StringBuilder(" SELECT oud, u FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId ");
        if (tabChose.contentEquals("withuntrusteddevice")) {
            sb = new StringBuilder(" SELECT oud, u FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId AND oud.isKnown = false");
        } else if (tabChose.contentEquals("inactivefortoolong")) {
            sb = new StringBuilder("SELECT oud, u FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId AND oud.lastSync < :oldDeviceTimeLimit AND oud.isKnown = true");
        } else if (tabChose.contentEquals("From Page Users")) {
            sb = new StringBuilder(" SELECT oud, u FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId AND oud.userId = :userId");
        }
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (LOWER(oud.displayName) LIKE :? OR LOWER(u.firstName) LIKE :? OR LOWER(u.lastName) LIKE :? OR LOWER(u.username) LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        sb.append(" order by u.lastName, u.firstName, u.username");
        TypedQuery query = this.em.createQuery(sb.toString(), Object[].class);
        query.setParameter("realmId", (Object)realmId);
        if (tabChose.contentEquals("inactivefortoolong")) {
            int oldDeviceTimeLimit = OlvidConfigurationDao.getIntConfiguration(this.em, realmId, "oldDeviceTimeLimit", 30);
            long currentTimestamp = System.currentTimeMillis();
            long oldDeviceTimeLimitFromcurrentTimestamp = currentTimestamp - (long)oldDeviceTimeLimit * 24L * 60L * 60L * 1000L;
            query.setParameter("oldDeviceTimeLimit", (Object)oldDeviceTimeLimitFromcurrentTimestamp);
        }
        if (tabChose.contentEquals("From Page Users")) {
            RealmModel realmModel = this.session.realms().getRealm(realmId);
            String userId = this.session.users().getUserByUsername(realmModel, filters.get(0)).getId();
            query.setParameter("userId", (Object)userId);
        }
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter.toLowerCase() + "%"));
            ++count;
        }
        if (!tabChose.contentEquals("From Page Users")) {
            query.setFirstResult(offset);
            query.setMaxResults(limit);
        }
        return query;
    }

    private TypedQuery<Object[]> buildBotQueryLimited(String realmId, List<String> filters, int limit, int offset) {
        StringBuilder sb = new StringBuilder("SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-is-bot')");
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND LOWER(attr.value) LIKE :?) OR ( attr.name = 'olvid-company' AND LOWER(attr.value) LIKE :?) OR LOWER(u.firstName) LIKE :? OR LOWER(u.lastName) LIKE :? OR LOWER(u.username) LIKE :? OR LOWER(u.email) LIKE :? OR LOWER(ocv.name) LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        sb.append(" order by u.lastName, u.firstName, u.username");
        TypedQuery query = this.em.createQuery(sb.toString(), Object[].class);
        query.setParameter("realmId", (Object)realmId);
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter.toLowerCase() + "%"));
            ++count;
        }
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query;
    }

    public TypedQuery<Object[]> buildQueryFindUsersLimited(String realmId, List<String> usersList, List<String> filters, int limit, int offset) {
        StringBuilder sb = new StringBuilder(" SELECT DISTINCT u, ocv as olvidCircleVisibility FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId and u.username in :usersList");
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND LOWER(attr.value) LIKE :?) OR ( attr.name = 'olvid-company' AND LOWER(attr.value) LIKE :?) OR LOWER(u.firstName) LIKE :? OR LOWER(u.lastName) LIKE :? OR LOWER(u.username) LIKE :? OR LOWER(u.email) LIKE :? OR LOWER(ocv.name) LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        sb.append(" order by u.lastName, u.firstName, u.username");
        TypedQuery query = this.em.createQuery(sb.toString(), Object[].class);
        query.setParameter("realmId", (Object)realmId);
        query.setParameter("usersList", usersList);
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter.toLowerCase() + "%"));
            ++count;
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        return query;
    }

    public TypedQuery<Object[]> buildQueryFindUsersByIdsLimited(String realmId, List<String> usersList, List<String> filters, int limit, int offset) {
        StringBuilder sb = new StringBuilder(" SELECT DISTINCT u, ocv as olvidCircleVisibility FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId and u.id in :list");
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND LOWER(attr.value) LIKE :?) OR ( attr.name = 'olvid-company' AND LOWER(attr.value) LIKE :?) OR LOWER(u.firstName) LIKE :? OR LOWER(u.lastName) LIKE :? OR LOWER(u.username) LIKE :? OR LOWER(u.email) LIKE :? OR LOWER(ocv.name) LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        sb.append(" order by u.lastName, u.firstName, u.username");
        TypedQuery query = this.em.createQuery(sb.toString(), Object[].class);
        query.setParameter("realmId", (Object)realmId);
        query.setParameter("list", usersList);
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter.toLowerCase() + "%"));
            ++count;
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        return query;
    }

    public TypedQuery<Object[]> buildQueryFindUsersWithoutCircleVisibility(String realmId, List<String> filters, int limit, int offset) {
        StringBuilder sb = new StringBuilder(" SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  LEFT JOIN u.attributes attr  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId and ocvu.userId is null");
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND LOWER(attr.value) LIKE :?) OR ( attr.name = 'olvid-company' AND LOWER(attr.value) LIKE :?) OR LOWER(u.firstName) LIKE :? OR LOWER(u.lastName) LIKE :? OR LOWER(u.username) LIKE :? OR LOWER(u.email) LIKE :? OR LOWER(ocv.name) LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        sb.append(" order by u.lastName, u.firstName, u.username");
        TypedQuery query = this.em.createQuery(sb.toString(), Object[].class);
        query.setParameter("realmId", (Object)realmId);
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter.toLowerCase() + "%"));
            ++count;
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        return query;
    }

    public TypedQuery<String> buildQueryFindAllUsersIdsWithoutCircleVisibility(String realmId) {
        StringBuilder sb = new StringBuilder(" SELECT distinct u.id FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId and ocvu.userId is null");
        TypedQuery query = this.em.createQuery(sb.toString(), String.class);
        query.setParameter("realmId", (Object)realmId);
        return query;
    }

    protected Query buildQueryCountWithFilter(String realmId, String tabChose, List<String> filters, List<String> usersList) {
        StringBuilder sb = tabChose.contentEquals("withoutolvidpassword") ? new StringBuilder(" SELECT COUNT(DISTINCT u) FROM UserEntity u  LEFT JOIN u.attributes attr  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.credentials cred on cred.type = 'password' WHERE u.realmId = :realmId AND (cred.id is null)") : (tabChose.contentEquals("activated") ? new StringBuilder(" SELECT COUNT(DISTINCT u) FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE attr.name = 'olvid-identity'  AND u.realmId = :realmId ") : (tabChose.contentEquals("notactivated") ? new StringBuilder(" SELECT COUNT(DISTINCT u) FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId AND u.id not in ( SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN u.attributes attr_unbound on attr_unbound.name = 'olvid-unbound'  AND u.enabled = true  WHERE u.realmId = :realmId  AND attr_unbound.value is null  AND (attr.name = 'olvid-identity'))") : (tabChose.contentEquals("enabled") ? new StringBuilder(" SELECT  count(distinct u)  FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId  AND u.enabled = true") : (tabChose.contentEquals("disabled") ? new StringBuilder(" SELECT  count(distinct u)  FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId  AND u.enabled is false") : (tabChose.contentEquals("selected") ? new StringBuilder(" SELECT COUNT(DISTINCT u) FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId and u.username in :usersList") : (tabChose.contentEquals("bot") ? new StringBuilder("SELECT COUNT(DISTINCT u) FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-is-bot')") : (tabChose.contentEquals("withuntrusteddevice") ? new StringBuilder("SELECT COUNT(DISTINCT(u)) FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  INNER JOIN OlvidUserDevice oud ON u.id = oud.userId WHERE u.realmId = :realmId AND oud.isKnown = false") : (tabChose.contentEquals("inactivefortoolong") ? new StringBuilder(" SELECT COUNT(oud) FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId LEFT JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId AND oud.lastSync < :oldDeviceTimeLimit AND oud.isKnown = true") : (tabChose.contentEquals("useroldlastsync") ? new StringBuilder("SELECT  count(distinct u.username)  FROM UserEntity u  INNER JOIN OlvidUser ou ON u.id = ou.userId AND u.realmId = ou.realmId  WHERE u.realmId = :realmId AND ou.lastSync < :oldDeviceTimeLimit") : new StringBuilder("SELECT COUNT(DISTINCT u) FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId"))))))))));
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND LOWER(attr.value) LIKE :?) OR ( attr.name = 'olvid-company' AND LOWER(attr.value) LIKE :?) OR LOWER(u.firstName) LIKE :? OR LOWER(u.lastName) LIKE :? OR LOWER(u.username) LIKE :? OR LOWER(u.email) LIKE :? OR LOWER(ocv.name) LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        Query query = this.em.createQuery(sb.toString());
        query.setParameter("realmId", (Object)realmId);
        if (tabChose.contentEquals("selected")) {
            query.setParameter("usersList", usersList);
        }
        if (tabChose.contentEquals("inactivefortoolong") || tabChose.contentEquals("useroldlastsync")) {
            int oldDeviceTimeLimit = OlvidConfigurationDao.getIntConfiguration(this.em, realmId, "oldDeviceTimeLimit", 30);
            long currentTimestamp = System.currentTimeMillis();
            long oldDeviceTimeLimitFromcurrentTimestamp = currentTimestamp - (long)oldDeviceTimeLimit * 86400000L;
            query.setParameter("oldDeviceTimeLimit", (Object)oldDeviceTimeLimitFromcurrentTimestamp);
        }
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter.toLowerCase() + "%"));
            ++count;
        }
        return query;
    }

    protected TypedQuery<Object[]> buildQueryFindCircleVisibilityLimitedWithFilter(String realmId, List<String> filters, int limit, int offset) {
        StringBuilder sb = new StringBuilder(" SELECT olgv FROM OlvidCircleVisibility olgv  WHERE olgv.realmId = :realmId");
        logger.info((Object)sb.toString());
        logger.info((Object)realmId);
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND LOWER(attr.value) LIKE :?) OR ( attr.name = 'olvid-company' AND LOWER(attr.value) LIKE :?) OR LOWER(u.firstName) LIKE :? OR LOWER(u.lastName) LIKE :? OR LOWER(u.username) LIKE :? OR LOWER(u.email) LIKE :? OR LOWER(ocv.name) LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        sb.append(" order by u.name");
        TypedQuery query = this.em.createQuery(sb.toString(), Object[].class);
        query.setParameter("realmId", (Object)realmId);
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter.toLowerCase() + "%"));
            ++count;
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        return query;
    }

    protected Query buildQueryCountFindCircleVisibilityWithFilter(String realmId, String tabChose, List<String> filters) {
        StringBuilder sb = new StringBuilder(" SELECT COUNT(olgv) FROM OlvidCircleVisibility olgv  WHERE olgv.realmId = :realmId ");
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND LOWER(attr.value) LIKE :?) OR ( attr.name = 'olvid-company' AND LOWER(attr.value) LIKE :?) OR LOWER(u.firstName) LIKE :? OR LOWER(u.lastName) LIKE :? OR LOWER(u.username) LIKE :? OR LOWER(u.email) LIKE :? OR LOWER(ocv.name) LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        Query query = this.em.createQuery(sb.toString());
        query.setParameter("realmId", (Object)realmId);
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter.toLowerCase() + "%"));
            ++count;
        }
        return query;
    }

    protected Query buildQueryCountCircleVisibilityMembersWithFilter(String realmId, List<String> usersList, List<String> filters) {
        StringBuilder sb = new StringBuilder(" SELECT count(DISTINCT u)FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId and u.id in :list");
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND LOWER(attr.value) LIKE :?) OR ( attr.name = 'olvid-company' AND LOWER(attr.value) LIKE :?) OR LOWER(u.firstName) LIKE :? OR LOWER(u.lastName) LIKE :? OR LOWER(u.username) LIKE :? OR LOWER(u.email) LIKE :? OR LOWER(ocv.name) LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        Query query = this.em.createQuery(sb.toString());
        query.setParameter("realmId", (Object)realmId);
        query.setParameter("list", usersList);
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter.toLowerCase() + "%"));
            ++count;
        }
        return query;
    }

    protected Query buildQueryCountCircleVisibilityByCircleIdMembersWithFilter(String realmId, String id, List<String> filters) {
        StringBuilder sb = new StringBuilder(" SELECT COUNT(olgvu) FROM OlvidCircleVisibilityUser olgvu  WHERE olgvu.realmId = :realmId AND olgvu.circleVisibilityId in :id ");
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND LOWER(attr.value) LIKE :?) OR ( attr.name = 'olvid-company' AND LOWER(attr.value) LIKE :?) OR LOWER(u.firstName) LIKE :? OR LOWER(u.lastName) LIKE :? OR LOWER(u.username) LIKE :? OR LOWER(u.email) LIKE :? OR LOWER(ocv.name) LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        Query query = this.em.createQuery(sb.toString());
        query.setParameter("realmId", (Object)realmId);
        query.setParameter("id", (Object)id);
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter.toLowerCase() + "%"));
            ++count;
        }
        return query;
    }

    protected Query buildQueryCountCircleVisibilityMemberWithoutCircleIdWithFilter(String realmId) {
        StringBuilder sb = new StringBuilder(" SELECT count(DISTINCT u) FROM UserEntity u  LEFT JOIN OlvidCircleVisibilityUser olgvu on olgvu.userId = u.id  WHERE u.realmId = :realmId and olgvu.userId is null");
        Query query = this.em.createQuery(sb.toString());
        query.setParameter("realmId", (Object)realmId);
        return query;
    }

    protected Query buildQueryCountDefaultCircleVisibilityMembers(String realmId, List<String> filters) {
        StringBuilder sb = new StringBuilder(" SELECT count(DISTINCT u) FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN OlvidCircleVisibilityUser ocvu on ocvu.userId = u.id  LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId and ocvu.userId is null");
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND LOWER(attr.value) LIKE :?) OR ( attr.name = 'olvid-company' AND LOWER(attr.value) LIKE :?) OR LOWER(u.firstName) LIKE :? OR LOWER(u.lastName) LIKE :? OR LOWER(u.username) LIKE :? OR LOWER(u.email) LIKE :? OR LOWER(ocv.name) LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        Query query = this.em.createQuery(sb.toString());
        query.setParameter("realmId", (Object)realmId);
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter.toLowerCase() + "%"));
            ++count;
        }
        return query;
    }

    private Query buildDevicesQueryCountWithFilter(String realmId, String tabChose, List<String> filters, List<String> usersList) {
        StringBuilder sb = new StringBuilder(" SELECT COUNT(oud) FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId ");
        if (tabChose.contentEquals("Devices UnKnown")) {
            sb = new StringBuilder(" SELECT COUNT(oud) FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId AND oud.isKnown = false");
        } else if (tabChose.contentEquals("inactivefortoolong")) {
            sb = new StringBuilder(" SELECT COUNT(oud) FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId LEFT JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId AND oud.lastSync < :oldDeviceTimeLimit AND oud.isKnown = true");
        } else if (tabChose.contentEquals("From Page Users")) {
            sb = new StringBuilder(" SELECT COUNT(oud) FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId AND oud.userId = :userId");
        }
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (LOWER(oud.displayName) LIKE :? OR LOWER(u.firstName) LIKE :? OR LOWER(u.lastName) LIKE :? OR LOWER(u.username) LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        Query query = this.em.createQuery(sb.toString());
        query.setParameter("realmId", (Object)realmId);
        if (tabChose.contentEquals("selected")) {
            query.setParameter("usersList", usersList);
        }
        if (tabChose.contentEquals("inactivefortoolong")) {
            int oldDeviceTimeLimit = OlvidConfigurationDao.getIntConfiguration(this.em, realmId, "oldDeviceTimeLimit", 30);
            long currentTimestamp = System.currentTimeMillis();
            long oldDeviceTimeLimitFromcurrentTimestamp = currentTimestamp - (long)oldDeviceTimeLimit * 86400000L;
            query.setParameter("oldDeviceTimeLimit", (Object)oldDeviceTimeLimitFromcurrentTimestamp);
        }
        if (tabChose.contentEquals("From Page Users")) {
            RealmModel realmModel = this.session.realms().getRealm(realmId);
            String userId = this.session.users().getUserByUsername(realmModel, filters.get(0)).getId();
            query.setParameter("userId", (Object)userId);
        }
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter.toLowerCase() + "%"));
            ++count;
        }
        return query;
    }

    private Query buildBotCountQueryLimited(String realmId, List<String> filters, List<String> usersList) {
        StringBuilder sb = new StringBuilder("SELECT COUNT(DISTINCT u) FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-is-bot')");
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND LOWER(attr.value) LIKE :?) OR ( attr.name = 'olvid-company' AND LOWER(attr.value) LIKE :?) OR LOWER(u.firstName) LIKE :? OR LOWER(u.lastName) LIKE :? OR LOWER(u.username) LIKE :? OR LOWER(u.email) LIKE :? OR LOWER(ocv.name) LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        Query query = this.em.createQuery(sb.toString());
        query.setParameter("realmId", (Object)realmId);
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter.toLowerCase() + "%"));
            ++count;
        }
        return query;
    }

    protected Query buildQueryCount(String realmId) {
        Query query = this.em.createQuery("SELECT COUNT(DISTINCT u) FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId");
        query.setParameter("realmId", (Object)realmId);
        return query;
    }

    protected Response processSignOutUser(String realmName, String id) {
        boolean userWasSignedOut = this.signOutUser(realmName, id);
        SignOutUsersResponseModel responseModel = new SignOutUsersResponseModel();
        responseModel.setStatus(userWasSignedOut);
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (JsonProcessingException e) {
            return Response.serverError().type("text/html").build();
        }
    }

    protected boolean signOutUser(String realmName, String id) {
        UserModel userModel;
        RealmModel realmModel;
        boolean userWasSignedOut = false;
        if (id != null && realmName != null && (realmModel = this.session.realms().getRealmByName(realmName)) != null && (userModel = this.session.users().getUserById(realmModel, id)) != null) {
            List offlineSessions = this.session.sessions().getOfflineUserSessionsStream(realmModel, userModel).collect(Collectors.toList());
            for (UserSessionModel userSessionModel : offlineSessions) {
                this.session.sessions().removeOfflineUserSession(realmModel, userSessionModel);
            }
            this.session.sessions().removeUserSessions(realmModel, userModel);
            userWasSignedOut = true;
        }
        return userWasSignedOut;
    }

    private Response processDeleteUserRevokedData(String role, String realmName, Long revocationId) throws JsonProcessingException {
        block4: {
            try {
                if (revocationId == null) break block4;
                RealmModel realmModel = this.session.realms().getRealmByName(realmName);
                try {
                    String logs = " [\n  userId : " + revocationId + ",\n  realm Name: " + realmName + ",\n]";
                    logger.debug((Object)logs);
                    HashMap<String, Object> ret = new HashMap<String, Object>();
                    OlvidConsoleLogsDao.logUserEvent(this.em, this.session, this.session.realms().getRealmByName(realmName), this.authenticatedUser.getUsername(), realmModel.getName(), "userRevokedData", "Admin created:" + logs, ret);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                OlvidRevocationDao.clearOlvidRevocationUserData(this.em, revocationId, realmModel.getId());
            }
            catch (Exception e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
            }
        }
        return this.processGetRevocation(role, realmName, new ArrayList<String>(), 10, 0);
    }

    private Response processGetLogs(String role, String realmName, String tabChose, List<String> filters, int limit, int offset) throws JsonProcessingException {
        boolean writeAllowed = this.checkQueryIsAllowed(15, role);
        return this.getResponseProcessGetLogs(realmName, tabChose, filters, limit, offset, writeAllowed);
    }

    protected Response getResponseProcessGetLogs(String realmName, String tabChose, List<String> filters, int limit, int offset, boolean writeAllowed) throws JsonProcessingException {
        String realmId = "";
        if (realmName != null && !realmName.isEmpty()) {
            realmId = this.session.realms().getRealmByName(realmName).getId();
        }
        List<OlvidConsoleLogs> consoleLogs = OlvidConsoleLogsDao.getLogs(this.em, realmId, tabChose, filters, limit, offset);
        Long consoleLogsCount = OlvidConsoleLogsDao.getLogsCount(this.em, realmId, tabChose, filters);
        if (consoleLogsCount == null || consoleLogs == null) {
            logger.warn((Object)"Null consoleLogsCount or consoleLogs");
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "Null consoleLogsCount or consoleLogs", false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        GetLogsResponseModel responseModel = new GetLogsResponseModel();
        responseModel.setCount(consoleLogsCount);
        responseModel.setWriteAllowed(writeAllowed);
        responseModel.setConsoleLogs(new LogModel().initLogsListModel(consoleLogs));
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    protected Response processGetLogsType() throws JsonProcessingException {
        List<String> logsType = OlvidConsoleLogsDao.getLogsType(this.em);
        GetLogsTypesResponseModel responseModel = new GetLogsTypesResponseModel();
        responseModel.setLogsType(logsType);
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processAddManagerUser(CustomManagerBasicModel managerUser) throws JsonProcessingException {
        Optional<RealmModel> adminRealm = this.session.realms().getRealmsStream().filter(realmModel -> OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "admin", false)).findFirst();
        if (adminRealm.isEmpty()) {
            logger.warn((Object)"Admin user creation error: could not find any admin realm");
            return this.invalidRequest();
        }
        RealmModel realmModel2 = adminRealm.get();
        if (Utils.nullOrTrim(managerUser.getUsername()) == null || Utils.nullOrTrim(managerUser.getEmail()) == null || Utils.nullOrTrim(managerUser.getRole()) == null || this.session.users().getUserByUsername(realmModel2, managerUser.getUsername().trim()) != null || this.session.users().getUserByEmail(realmModel2, managerUser.getEmail().trim()) != null) {
            logger.warn((Object)"Admin user creation error: username already exists or invalid request");
            return this.invalidRequest();
        }
        UserModel newUser = this.session.users().addUser(realmModel2, Utils.nullOrTrim(managerUser.getUsername()));
        newUser.setFirstName(Utils.nullOrTrim(managerUser.getFirstname()));
        newUser.setLastName(Utils.nullOrTrim(managerUser.getLastname()));
        newUser.setEmail(Utils.nullOrTrim(managerUser.getEmail()));
        newUser.setSingleAttribute("olvid-role", managerUser.getRole());
        newUser.setEnabled(true);
        PasswordPolicy passwordPolicy = realmModel2.getPasswordPolicy();
        String password = this.generateRandomPassword(passwordPolicy);
        try {
            this.setUserPassword(newUser, password, passwordPolicy);
        }
        catch (Exception e) {
            logger.warn((Object)"Admin user creation error: unable to create password for account (no hash provider found)");
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        try {
            String logs = " [\n  username: " + newUser.getUsername() + ",\n  realm Name: " + realmModel2.getName() + ",\n" + (String)(Utils.nullOrTrim(newUser.getFirstName()) != null ? "  firstname: " + newUser.getFirstName() + ",\n" : "") + (String)(Utils.nullOrTrim(newUser.getLastName()) != null ? "  lastname: " + newUser.getLastName() + ",\n" : "") + "  email: " + newUser.getEmail() + ",\n  role: " + managerUser.getRole() + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel2, this.authenticatedUser.getUsername(), realmModel2.getName(), "adminCreation", "Admin created:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        AddManagerResponseModel responseModel = new AddManagerResponseModel();
        Map masterSmtpConfig = this.session.realms().getRealmByName("master").getSmtpConfig();
        responseModel.addManagerResponseModel(password, masterSmtpConfig.isEmpty() || masterSmtpConfig.get("host") == null || ((String)masterSmtpConfig.get("host")).isEmpty() || masterSmtpConfig.get("from") == null || ((String)masterSmtpConfig.get("from")).isEmpty());
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processAddUser(CustomUserBasicWithPasswordModel user, String realmName, Boolean isNoPassword) throws JsonProcessingException {
        AddUserResponseModel responseModel;
        block10: {
            RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
            responseModel = new AddUserResponseModel();
            if (Utils.nullOrTrim(user.getUsername()) == null || Utils.nullOrTrim(user.getFirstname()) == null || this.session.users().getUserByUsername(realmModel, user.getUsername().trim()) != null) {
                return this.invalidRequest();
            }
            UserModel newUser = this.session.users().addUser(realmModel, user.getUsername().trim());
            newUser.setFirstName(Utils.nullOrTrim(user.getFirstname()));
            newUser.setLastName(Utils.nullOrTrim(user.getLastname()));
            newUser.setEmail(Utils.nullOrTrim(user.getEmail()));
            Utils.setUserAttribute(newUser, "olvid-company", user.getCompany());
            Utils.setUserAttribute(newUser, "olvid-position", user.getPosition());
            String fullSearchString = Utils.getUserAttributeFullSearch(newUser);
            Utils.setUserAttribute(newUser, "olvid-search", fullSearchString);
            newUser.setEnabled(true);
            try {
                if (isNoPassword.booleanValue()) {
                    responseModel.setPassword("");
                    break block10;
                }
                PasswordPolicy passwordPolicy = realmModel.getPasswordPolicy();
                String password = user.getPassword() == null || user.getPassword().trim().isEmpty() ? this.generateRandomPassword(passwordPolicy) : user.getPassword().trim();
                try {
                    this.setUserPassword(newUser, password, passwordPolicy);
                }
                catch (Exception e) {
                    logger.warn((Object)"User creation error: unable to create password for account (no hash provider found)");
                    GenericReponseModel response = new GenericReponseModel();
                    response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
                }
                try {
                    String logs = " [\n  username: " + user.getUsername() + ",\n  realmName: " + realmModel.getName() + ",\n" + (String)(Utils.nullOrTrim(user.getFirstname()) != null ? "  firstname: " + user.getFirstname() + ",\n" : "") + (String)(Utils.nullOrTrim(user.getLastname()) != null ? "  lastname: " + user.getLastname() + ",\n" : "") + "  email: " + user.getEmail() + ",\n]";
                    HashMap<String, Object> ret = new HashMap<String, Object>();
                    OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "userCreation", "User created:" + logs, ret);
                }
                catch (Exception logs) {
                    // empty catch block
                }
                responseModel.setPassword(password);
            }
            catch (Exception e) {
                logger.warn((Object)"User create : create password Exception : ", (Throwable)e);
                responseModel.setPassword("");
            }
        }
        Map masterSmtpConfig = this.session.realms().getRealmByName("master").getSmtpConfig();
        responseModel.setSmtpError(masterSmtpConfig.isEmpty() || masterSmtpConfig.get("host") == null || ((String)masterSmtpConfig.get("host")).isEmpty() || masterSmtpConfig.get("from") == null || ((String)masterSmtpConfig.get("from")).isEmpty());
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processAddUsersByList(List<CustomUserBasicWithPasswordModel> usersList, String realmName, Boolean isNoPassword) throws JsonProcessingException {
        ArrayList errors = new ArrayList();
        ArrayList<CustomUserBasicWithPasswordModel> usersCreated = new ArrayList<CustomUserBasicWithPasswordModel>();
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (realmModel == null) {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "realmModel is null", false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        usersList.forEach(user -> {
            block10: {
                if (Utils.nullOrTrim(user.getUsername()) == null || Utils.nullOrTrim(user.getFirstname()) == null && Utils.nullOrTrim(user.getLastname()) == null || this.session.users().getUserByUsername(realmModel, user.getUsername()) != null) {
                    logger.warn((Object)"User creation error: username already exists or invalid request");
                    errors.add(user);
                    return;
                }
                UserModel newUser = this.session.users().addUser(realmModel, user.getUsername().trim());
                newUser.setFirstName(Utils.nullOrTrim(user.getFirstname()));
                newUser.setLastName(Utils.nullOrTrim(user.getLastname()));
                newUser.setEmail(Utils.nullOrTrim(user.getEmail()));
                Utils.setUserAttribute(newUser, "olvid-position", user.getPosition());
                Utils.setUserAttribute(newUser, "olvid-company", user.getCompany());
                String fullSearchString = Utils.getUserAttributeFullSearch(newUser);
                Utils.setUserAttribute(newUser, "olvid-search", fullSearchString);
                newUser.setEnabled(true);
                try {
                    PasswordPolicy passwordPolicy = realmModel.getPasswordPolicy();
                    String password = "";
                    if (user.getPassword() == null || user.getPassword().trim().isEmpty()) {
                        if (!isNoPassword.booleanValue()) {
                            password = this.generateRandomPassword(passwordPolicy);
                        }
                    } else {
                        password = user.getPassword().trim();
                    }
                    if (password.contentEquals("")) break block10;
                    try {
                        this.setUserPassword(newUser, password, passwordPolicy);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"User creation error: unable to create password for account (no hash provider found)");
                        errors.add(user);
                        return;
                    }
                    user.setPassword(password);
                    try {
                        String logs = " [\n  username: " + user.getUsername() + ",\n  realmName: " + realmModel.getName() + ",\n" + (String)(Utils.nullOrTrim(user.getFirstname()) != null ? "  firstname: " + user.getFirstname() + ",\n" : "") + (String)(Utils.nullOrTrim(user.getLastname()) != null ? "  lastname: " + user.getLastname() + ",\n" : "") + "  email: " + user.getEmail() + ",\n]";
                        HashMap<String, Object> ret = new HashMap<String, Object>();
                        OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "userCreation", "User created:" + logs, ret);
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            usersCreated.add((CustomUserBasicWithPasswordModel)user);
        });
        AddUsersByListResponseModel responseModel = new AddUsersByListResponseModel();
        responseModel.setUsersCreated(usersCreated);
        responseModel.setUsersErrors(errors);
        Map masterSmtpConfig = this.session.realms().getRealmByName("master").getSmtpConfig();
        responseModel.setSmtpError(masterSmtpConfig.isEmpty() || masterSmtpConfig.get("host") == null || ((String)masterSmtpConfig.get("host")).isEmpty() || masterSmtpConfig.get("from") == null || ((String)masterSmtpConfig.get("from")).isEmpty());
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private String generateRandomPassword(PasswordPolicy passwordPolicy) {
        int length = 10;
        Object maxLength = passwordPolicy.getPolicyConfig("maxLength");
        if (maxLength instanceof Integer && length > (Integer)maxLength) {
            length = (Integer)maxLength;
        }
        Object minLength = passwordPolicy.getPolicyConfig("length");
        if (maxLength instanceof Integer && length < (Integer)minLength) {
            length = (Integer)minLength;
        }
        SecureRandom random = new SecureRandom();
        char[] password = new char[length];
        for (int i = 0; i < length; ++i) {
            password[i] = Constants.ALLOWED_ADMIN_PASSWORD_CHARS[random.nextInt(Constants.ALLOWED_ADMIN_PASSWORD_CHARS.length)];
        }
        return new String(password);
    }

    private void setUserPassword(UserModel user, String password, PasswordPolicy passwordPolicy) throws Exception {
        PasswordHashProvider hashProvider = this.getHashProvider(passwordPolicy);
        if (hashProvider == null) {
            throw new Exception();
        }
        PasswordCredentialModel credentialModel = hashProvider.encodedCredential(password, passwordPolicy.getHashIterations());
        credentialModel.setCreatedDate(Long.valueOf(System.currentTimeMillis()));
        user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        user.credentialManager().getStoredCredentialsByTypeStream("password").forEach(elem -> user.credentialManager().removeStoredCredentialById(elem.getId()));
        user.credentialManager().createStoredCredential((CredentialModel)credentialModel);
    }

    private Response processUpdateUser(CustomUserBasicWithPasswordModel user, String realmName) throws JsonProcessingException {
        HashMap<String, Object> ret;
        String logs2;
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        UserModel userToUpdate = this.session.users().getUserByUsername(realmModel, user.getUsername());
        if (userToUpdate == null || Utils.nullOrTrim(user.getFirstname()) == null) {
            logger.warn((Object)"User update error: username already exists or invalid request");
            return this.invalidRequest();
        }
        userToUpdate.setEnabled(true);
        userToUpdate.setFirstName(Utils.nullOrTrim(user.getFirstname()));
        userToUpdate.setLastName(Utils.nullOrTrim(user.getLastname()));
        userToUpdate.setEmail(Utils.nullOrTrim(user.getEmail()));
        Utils.setUserAttribute(userToUpdate, "olvid-position", Utils.nullOrTrim(user.getPosition()));
        Utils.setUserAttribute(userToUpdate, "olvid-company", Utils.nullOrTrim(user.getCompany()));
        OlvidUserDetails olvidUserDetails = new OlvidUserDetails(userToUpdate);
        Utils.setUserAttribute(userToUpdate, "olvid-search", olvidUserDetails.getFullSearchString());
        boolean isBotUser = Utils.isBotUser(userToUpdate);
        if (!isBotUser) {
            try {
                logs2 = " [\n  username: " + user.getUsername() + ",\n  realm Name: " + realmModel.getName() + ",\n" + (String)(!Utils.emptyStringOrTrim(user.getFirstname()).isEmpty() ? "  firstname: " + user.getFirstname() + ",\n" : "") + (String)(!Utils.emptyStringOrTrim(user.getLastname()).isEmpty() ? "  lastname: " + user.getLastname() + ",\n" : "") + "  email: " + user.getEmail() + ",\n]";
                logger.debug((Object)logs2);
                ret = new HashMap<String, Object>();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "userUpdate", "User updated:" + logs2, ret);
            }
            catch (Exception logs2) {}
        } else {
            try {
                logs2 = " [\n  username: " + user.getUsername() + ",\n  realm Name: " + realmModel.getName() + ",\n" + (String)(!Utils.emptyStringOrTrim(user.getFirstname()).isEmpty() ? "  firstname: " + user.getFirstname() + ",\n" : "") + (String)(!Utils.emptyStringOrTrim(user.getLastname()).isEmpty() ? "  lastname: " + user.getLastname() + ",\n" : "") + "  email: " + user.getEmail() + ",\n]";
                logger.debug((Object)logs2);
                ret = new HashMap();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "botUpdate", "Bot updated:" + logs2, ret);
            }
            catch (Exception logs3) {
                // empty catch block
            }
        }
        try {
            String identityString;
            if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false) && (identityString = Utils.getUserAttribute(userToUpdate, "olvid-identity")) != null) {
                try {
                    OlvidUserDetailsSignatureSignerContext signatureSignerContext = OlvidUserDetailsSignatureSignerContext.createForRealm(this.session, this.em, realmModel);
                    if (signatureSignerContext == null) {
                        logger.warn((Object)"Unable to update signed user details: failed to get signature context");
                    } else {
                        Utils.updateSignedUserDetails(this.em, realmModel, userToUpdate, olvidUserDetails.getSignedDetails((SignatureSignerContext)signatureSignerContext, this.objectMapper), false);
                        CronScheduler.scheduleSendNotifications(Collections.singletonList(new UserOrTopicToNotify(UserOrTopicToNotify.NotificationType.SINGLE_USER, realmModel.getId(), identityString)));
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Exception : ", (Throwable)e);
                }
            }
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(new HashMap(), new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processSetBotRole(String role, String realmName, String username, String data) {
        boolean writeAllowed = this.checkQueryIsAllowed(44, role);
        if (writeAllowed) {
            RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
            UserModel userToUpdate = this.session.users().getUserByUsername(realmModel, username);
            Utils.setUserAttribute(userToUpdate, "olvid-role", Utils.nullOrTrim(data));
            try {
                String logs = " [\n  username: " + username + ",\n  realm Name: " + realmModel.getName() + ",\n" + (String)(!Utils.emptyStringOrTrim(data).isEmpty() ? "  data: " + data + ",\n" : "") + "]";
                logger.debug((Object)logs);
                HashMap<String, Object> ret = new HashMap<String, Object>();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "botUpdate", "Bot updated:" + logs, ret);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(new HashMap(), new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
    }

    private Response processToggleEnableUser(String role, String realmName, String userId) {
        boolean writeAllowed = this.checkQueryIsAllowed(44, role);
        boolean isEnabled = false;
        if (writeAllowed) {
            RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
            UserModel userToUpdate = this.session.users().getUserById(realmModel, userId);
            boolean isUnbound = Utils.isUnboundUser(userToUpdate);
            isEnabled = userToUpdate.isEnabled();
            List<String> usersIdsList = Collections.singletonList(userToUpdate.getId());
            if (isEnabled && !isUnbound) {
                Configuration.subProcessRevokeUsers(this.em, this.session, this.authenticatedUser.getUsername(), realmName, usersIdsList, 2, realmModel, this.objectMapper);
            } else {
                this.processEnabledUsers(role, realmName, usersIdsList, isEnabled);
            }
            try {
                String logs = " [\n  username: " + userToUpdate.getUsername() + ",\n  realm Name: " + realmModel.getName() + ",\n  set isEnabled \n  from : " + isEnabled + ",\n  to : " + !isEnabled + ",\n]";
                logger.debug((Object)logs);
                HashMap<String, Object> ret = new HashMap<String, Object>();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "userUpdate", "User updated:" + logs, ret);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(new HashMap(), new ResponseConstants().STATUS_SUCCESS, 0, String.valueOf(!isEnabled), true);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
    }

    private Response processUpdateGroup(String realmName, Object data) throws Exception {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        UpdateOlvidGroupModel group = (UpdateOlvidGroupModel)this.objectMapper.convertValue(data, UpdateOlvidGroupModel.class);
        String groupId = group.getId();
        String groupName = group.getName();
        String groupDescription = group.getDescription();
        String groupOlvidName = group.getOlvidName();
        if (groupName.contentEquals("")) {
            logger.info((Object)"processUpdateGroup: group name empty");
            return this.invalidRequest();
        }
        if (this.session.groups().getGroupsStream(realmModel).anyMatch(groupFound -> Objects.equals(groupFound.getName(), groupName) && !Objects.equals(groupFound.getId(), groupId))) {
            logger.info((Object)"processUpdateGroup: duplicate group name");
            return this.invalidRequest();
        }
        GroupModel groupToUpdate = this.session.groups().getGroupById(realmModel, groupId);
        if (groupToUpdate == null) {
            logger.info((Object)"processUpdateGroup: group id not found");
            return this.invalidRequest();
        }
        groupToUpdate.setName(groupName);
        Utils.setGroupAttribute(groupToUpdate, "olvid-description", groupDescription);
        Utils.setGroupAttribute(groupToUpdate, "olvid-name", groupOlvidName);
        this.updateOlvidGroupAndNotify(realmModel, groupToUpdate);
        try {
            String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  groupName: " + groupName + ",\n  groupDescription: " + groupDescription + ",\n  groupCustomName: " + groupOlvidName + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "groupEdit", "Group edited:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        UpdateOlvidGroupByIdResponseModel responseModel = new UpdateOlvidGroupByIdResponseModel();
        responseModel.setStatus(true);
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processSetUnsetGroupOlvidDiscussion(String realmName, Object dataObj) throws Exception {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        GroupUserModel group = (GroupUserModel)this.objectMapper.convertValue(dataObj, GroupUserModel.class);
        String groupId = group.getId();
        Boolean groupOlvid = group.getOlvidGroup();
        if (groupOlvid == null || groupId == null) {
            return this.invalidRequest();
        }
        GroupModel groupModel = this.session.groups().getGroupById(realmModel, groupId);
        if (groupModel == null) {
            return this.invalidRequest();
        }
        if (groupOlvid.booleanValue()) {
            Utils.setGroupAttribute(groupModel, "olvid-group", "true");
            this.updateOlvidGroupAndNotify(realmModel, groupModel);
        } else {
            Utils.setGroupAttribute(groupModel, "olvid-group", null);
            OlvidGroup olvidGroup = OlvidGroupDao.getOlvidGroupById(this.em, realmModel.getId(), groupId);
            if (olvidGroup != null) {
                this.disableOlvidGroupAndNotify(realmModel, olvidGroup);
            }
        }
        String groupName = groupModel.getName();
        try {
            String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  groupName: " + groupName + ",\n  change groupOlvid: " + groupOlvid + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "groupEdit", "Group edited:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(new HashMap(), new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private void disableOlvidGroupAndNotify(RealmModel realmModel, OlvidGroup olvidGroup) {
        CronScheduler.scheduleSendNotifications(OlvidGroupDao.disableGroupAndGetMembersToNotify(this.session, this.objectMapper, this.em, realmModel, olvidGroup));
    }

    private void updateOlvidGroupAndNotify(RealmModel realmModel, GroupModel groupModel) throws Exception {
        if (Utils.isOlvidGroup(groupModel)) {
            CronScheduler.scheduleSendNotifications(OlvidGroupDao.enableThenUpdateOlvidGroupIfNeededAndGetMembersToNotify(this.session, this.em, realmModel, groupModel, this.objectMapper, new SecureRandom()));
        }
    }

    private Response processCreateCronOneTimeJob(Object dataObj) throws JsonProcessingException {
        CronJobModel job = (CronJobModel)this.objectMapper.convertValue(dataObj, CronJobModel.class);
        CronScheduler.scheduleOneTimeJobFromManagementConsole(job.label.toString());
        try {
            String logs = " [\n  create cron one time job : " + dataObj.toString() + "]";
            logger.debug((Object)logs);
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, null, this.authenticatedUser.getUsername(), "master", "cronOneTimeJob", "Cron One Time Job:" + logs, new HashMap<String, Object>());
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
        }
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(new HashMap(), new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processEditExternalLinks(String realmName, Object dataObj) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        Map data = (Map)this.objectMapper.convertValue(dataObj, (TypeReference)new TypeReference<Map<String, String>>(){});
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<OlvidExternalLink> success = new ArrayList<OlvidExternalLink>();
        try {
            TypedQuery q = this.em.createNamedQuery("OlvidExternalLinks.getById", OlvidExternalLink.class);
            q.setParameter("realmId", (Object)realmModel.getId());
            q.setParameter("id", data.get("id"));
            OlvidExternalLink found = (OlvidExternalLink)q.getSingleResult();
            found.setTag((String)data.get("newTag"));
            try {
                this.em.createNamedQuery("OlvidExternalLinks.updateById").setParameter("realmId", (Object)realmModel.getId()).setParameter("newTag", data.get("newTag")).setParameter("id", data.get("id")).executeUpdate();
                success.add(found);
            }
            catch (NoResultException noResultException) {}
        }
        catch (Exception e) {
            errors.add((String)data.get("newTag"));
        }
        try {
            String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  external Links tags : " + dataObj.toString() + "]";
            logger.debug((Object)logs);
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "externalLinks", "External Links edited:" + logs, new HashMap<String, Object>());
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
        }
        UpdateExternalLinksResponseModel responseModel = new UpdateExternalLinksResponseModel();
        responseModel.setErrors(errors);
        responseModel.setSuccess(success);
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processRevokeExternalLinks(String realmName, List<String> dataArray) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> success = new ArrayList<String>();
        dataArray.forEach(data -> {
            block7: {
                try {
                    OlvidExternalLink externalLink = (OlvidExternalLink)this.em.createNamedQuery("OlvidExternalLinks.getById", OlvidExternalLink.class).setParameter("realmId", (Object)realmModel.getId()).setParameter("id", data).getSingleResult();
                    String apiKey = externalLink.getKey();
                    if (OlvidServerApiHelper.revokeApiKey(this.session, this.em, realmModel.getId(), this.objectMapper, apiKey)) {
                        try {
                            this.em.createNamedQuery("OlvidExternalLinks.revokeById").setParameter("realmId", (Object)realmModel.getId()).setParameter("id", data).setParameter("revokedDate", (Object)System.currentTimeMillis()).executeUpdate();
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                        }
                        HashMap<String, Object> ret = new HashMap<String, Object>();
                        try {
                            String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  external Links tags : " + String.join((CharSequence)",", data) + "]";
                            logger.debug((Object)logs);
                            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "externalLinks", "External Links revoked:" + logs, ret);
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Exception : ", (Throwable)e);
                        }
                        success.add((String)data);
                        break block7;
                    }
                    errors.add((String)data);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
        });
        RevokeExternalLinksResponseModel responseModel = new RevokeExternalLinksResponseModel();
        responseModel.setErrors(errors);
        responseModel.setSuccess(success);
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processCreateExternalLinks(String realmName, List<String> dataArray) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<ExternalLinkModel> success = new ArrayList<ExternalLinkModel>();
        dataArray.forEach(data -> {
            String newApiKey;
            long currentTimestamp = System.currentTimeMillis();
            try {
                newApiKey = OlvidServerApiHelper.requestNewApiKey(this.session, this.em, realmModel.getId(), this.objectMapper);
            }
            catch (Exception e) {
                logger.error((Object)"ERROR in getResponseProcessCreateExternalLinks: ", (Throwable)e);
                errors.add("Error generating link for " + data);
                return;
            }
            String id = KeycloakModelUtils.generateId();
            try {
                OlvidExternalLink olvidExternalLink = new OlvidExternalLink();
                olvidExternalLink.setId(id);
                olvidExternalLink.setRealmId(realmModel.getId());
                olvidExternalLink.setUserCreatorId(this.authenticatedUser.getId());
                olvidExternalLink.setKey(newApiKey);
                olvidExternalLink.setTag((String)data);
                olvidExternalLink.setCreateDate(currentTimestamp);
                olvidExternalLink.setRevoked(false);
                this.em.persist((Object)olvidExternalLink);
            }
            catch (Exception e) {
                logger.error((Object)("getResponseProcessCreateExternalLinks e " + e.getMessage()));
            }
            HashMap<String, Object> ret = new HashMap<String, Object>();
            try {
                String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  external Links tags : " + String.join((CharSequence)",", data) + "]";
                logger.debug((Object)logs);
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "externalLinks", "External Links created:" + logs, ret);
            }
            catch (Exception e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
            }
            if (ret.get("status").equals("ERROR") && ret.get("message").equals("Duplicate entry")) {
                errors.add((String)data);
            }
            if (ret.get("status").equals("SUCCESS")) {
                String link;
                ExternalLinkModel detail = new ExternalLinkModel();
                detail.setTag((String)data);
                try {
                    link = ConfigurationLinkHelper.generateConfigurationLink(this.em, realmModel, newApiKey);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
                detail.setId(id);
                detail.setLink(link);
                detail.setLink(link);
                detail.setKey_value(newApiKey);
                detail.setCreateDate(currentTimestamp);
                success.add(detail);
            }
        });
        CreateExternalLinksResponseModel responseModel = new CreateExternalLinksResponseModel();
        responseModel.setErrors(errors);
        responseModel.setCreated(success);
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processGetExternalLinks(String role, String realmName, String tabChose, List<String> filters, int limit, int offset) throws JsonProcessingException {
        boolean writeAllowed = this.checkQueryIsAllowed(30, role);
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            List<OlvidExternalLink> list = OlvidExternalLinkDao.getAllOlvidExternalLinkForRealmId(this.em, realmModel.getId(), filters);
            int count = list.size();
            list = list.subList(Math.min(count, offset), Math.min(count, offset + limit));
            List<ExternalLinkModel> listFormated = list.stream().map(item -> new ExternalLinkModel().initExternalLinkModel(this.em, realmModel, this.objectMapper, (OlvidExternalLink)item)).collect(Collectors.toList());
            GetExternalLinksResponseModel responseModel = new GetExternalLinksResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setData(listFormated);
            responseModel.setCount(count);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processGetUserGroups(String role, String realmName, String tabChose, List<String> filters, int limit, int offset, String userId) throws JsonProcessingException {
        boolean writeAllowed = this.checkQueryIsAllowed(30, role);
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            List<GroupUserModel> userGroups;
            UserModel userModel = this.session.users().getUserById(realmModel, userId);
            if (userModel != null) {
                Stream groupStream = filters.isEmpty() ? userModel.getGroupsStream() : userModel.getGroupsStream(String.join((CharSequence)",", filters), Integer.valueOf(0), Integer.valueOf(10000));
                HashMap userModelsCache = new HashMap();
                userGroups = groupStream.map(groupModel -> {
                    try {
                        return this.createGroupUsersFromGroupModel(this.em, this.session, realmModel, (GroupModel)groupModel, GroupMembersQueryType.GROUP_LIST_WITH_DETAILS, userModelsCache, tabChose, filters, "");
                    }
                    catch (NamingException e) {
                        throw new RuntimeException(e);
                    }
                }).collect(Collectors.toList());
            } else {
                userGroups = Collections.emptyList();
            }
            GetUserGroupsResponseModel responseModel = new GetUserGroupsResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setData(userGroups);
            responseModel.setCount(userGroups.size());
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processGetCirclesVisibilitesFiltered(String role, String realmName, String tabChose, List<String> filters, int limit, int offset) throws JsonProcessingException {
        boolean writeAllowed = this.checkQueryIsAllowed(30, role);
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            List<OlvidCircleVisibility> data = Configuration.getOlvidCirclesVisibilities(this.em, realmModel);
            if (!filters.isEmpty()) {
                ArrayList<OlvidCircleVisibility> dataFiltered = new ArrayList<OlvidCircleVisibility>();
                List<OlvidCircleVisibility> finalData = data;
                filters.forEach(filter -> dataFiltered.addAll(finalData.stream().filter(item -> item.getName() != null && item.getName().toLowerCase().contains(filter.toLowerCase()) || item.getDescription() != null && item.getDescription().toLowerCase().contains(filter.toLowerCase())).collect(Collectors.toList())));
                data = dataFiltered;
            }
            GetCirclesVisibilitiesFilteredResponseModel responseModel = new GetCirclesVisibilitiesFilteredResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setData(data);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    public static List<OlvidCircleVisibility> getOlvidCirclesVisibilities(EntityManager em, RealmModel realmModel) {
        try {
            TypedQuery q = em.createNamedQuery("OlvidCircleVisibility.getAllByRealm", OlvidCircleVisibility.class);
            q.setParameter("realmId", (Object)realmModel.getId());
            List ret = q.getResultList();
            OlvidCircleVisibility olvidCircleVisibility = new OlvidCircleVisibility();
            olvidCircleVisibility.setId("default");
            olvidCircleVisibility.setName("Default Circle");
            olvidCircleVisibility.setDescription("All users not assigned to any other Circle");
            olvidCircleVisibility.setRealmId(realmModel.getId());
            ret.add(olvidCircleVisibility);
            return ret;
        }
        catch (NoResultException e) {
            return new ArrayList<OlvidCircleVisibility>();
        }
    }

    public static OlvidCircleVisibility getOlvidCircleVisibility(EntityManager em, RealmModel realmModel, String id) {
        try {
            TypedQuery q = em.createNamedQuery("OlvidCircleVisibility.getById", OlvidCircleVisibility.class);
            q.setParameter("realmId", (Object)realmModel.getId());
            q.setParameter("id", (Object)id);
            OlvidCircleVisibility ret = (OlvidCircleVisibility)q.getSingleResult();
            return ret;
        }
        catch (NoResultException e) {
            return new OlvidCircleVisibility();
        }
    }

    public static List<OlvidCircleVisibilityRules> getOlvidCircleVisibilityByCircles(EntityManager em, RealmModel realmModel, String id) {
        new CirclesVisibilityRulesModel().checkRulesDuplicate(em);
        try {
            TypedQuery q;
            if (!id.contentEquals("default")) {
                q = em.createNamedQuery("OlvidCircleVisibilityRules.getByIdFromTo", OlvidCircleVisibilityRules.class);
                q.setParameter("realmId", (Object)realmModel.getId());
                q.setParameter("fromId", (Object)id);
                q.setParameter("toId", (Object)id);
            } else {
                q = em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultRules", OlvidCircleVisibilityRules.class);
                q.setParameter("realmId", (Object)realmModel.getId());
            }
            List<OlvidCircleVisibilityRules> result = q.getResultList();
            if (id.contentEquals("default")) {
                OlvidCircleVisibilityRules defaultCircle = (OlvidCircleVisibilityRules)result.stream().filter(rule -> rule.getId().contains("default")).collect(Collectors.toList()).get(0);
                List<OlvidCircleVisibilityRules> defaultsRules = result.stream().filter(rule -> !rule.getId().contains("default")).collect(Collectors.toList());
                defaultCircle.setId("default");
                List<OlvidCircleVisibilityRules> listClean = defaultsRules;
                listClean.add(defaultCircle);
                result = listClean;
            }
            result.forEach(rule -> {
                if (rule.getVisibility() != null && rule.getVisibility().isEmpty()) {
                    rule.setVisibility(null);
                }
            });
            TypedQuery queryCircles = em.createNamedQuery("OlvidCircleVisibility.getAllByRealm", OlvidCircleVisibility.class);
            queryCircles.setParameter("realmId", (Object)realmModel.getId());
            List circles = queryCircles.getResultList();
            ArrayList<OlvidCircleVisibility> missingCircles = new ArrayList<OlvidCircleVisibility>();
            List<OlvidCircleVisibilityRules> finalResult = result;
            circles.forEach(circle -> {
                List found = finalResult.stream().filter(rule -> rule.getCircleVisibilityId1From() != null && rule.getCircleVisibilityId1From().contentEquals(circle.getId()) || rule.getCircleVisibilityId2To() != null && rule.getCircleVisibilityId2To().contentEquals(circle.getId())).collect(Collectors.toList());
                if (found.isEmpty()) {
                    missingCircles.add((OlvidCircleVisibility)circle);
                }
            });
            boolean isDefaultRule = finalResult.stream().anyMatch(rule -> rule.getCircleVisibilityId1From() == null);
            boolean isCircleRule = finalResult.stream().filter(elem -> elem.getCircleVisibilityId1From() != null && elem.getCircleVisibilityId2To() != null).anyMatch(rule -> rule.getCircleVisibilityId1From().contentEquals(rule.getCircleVisibilityId2To()) && rule.getCircleVisibilityId2To().contentEquals(rule.getCircleVisibilityId1From()));
            if (!isDefaultRule) {
                OlvidCircleVisibility defaultRule = new OlvidCircleVisibility();
                defaultRule.setId("default");
                missingCircles.add(defaultRule);
            }
            if (!isCircleRule) {
                OlvidCircleVisibility circleRule = new OlvidCircleVisibility();
                circleRule.setId(id);
                missingCircles.add(circleRule);
            }
            if (!missingCircles.isEmpty()) {
                TypedQuery queryDefaultCircleRuleFrom = em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultRealmCircleRuleFrom", OlvidCircleVisibilityRules.class);
                queryDefaultCircleRuleFrom.setParameter("realmId", (Object)realmModel.getId());
                try {
                    OlvidCircleVisibilityRules defaultCircleRuleFrom = (OlvidCircleVisibilityRules)queryDefaultCircleRuleFrom.getResultList().get(0);
                    missingCircles.forEach(circle -> {
                        if (!circle.getId().contains("default")) {
                            OlvidCircleVisibilityRules olvidCircleVisibilityRulesFrom = new OlvidCircleVisibilityRules();
                            olvidCircleVisibilityRulesFrom.setId(KeycloakModelUtils.generateId());
                            olvidCircleVisibilityRulesFrom.setCircleVisibilityId1From(circle.getId());
                            olvidCircleVisibilityRulesFrom.setCircleVisibilityId2To(id);
                            olvidCircleVisibilityRulesFrom.setVisibility(defaultCircleRuleFrom.getVisibility());
                            olvidCircleVisibilityRulesFrom.setRealmId(defaultCircleRuleFrom.getRealmId());
                            finalResult.add(olvidCircleVisibilityRulesFrom);
                            if (!circle.getId().contentEquals(id)) {
                                OlvidCircleVisibilityRules olvidCircleVisibilityRulesTo = new OlvidCircleVisibilityRules();
                                olvidCircleVisibilityRulesTo.setId(KeycloakModelUtils.generateId());
                                olvidCircleVisibilityRulesTo.setCircleVisibilityId1From(id);
                                olvidCircleVisibilityRulesTo.setCircleVisibilityId2To(circle.getId());
                                olvidCircleVisibilityRulesTo.setVisibility(defaultCircleRuleFrom.getVisibility());
                                olvidCircleVisibilityRulesTo.setRealmId(defaultCircleRuleFrom.getRealmId());
                                finalResult.add(olvidCircleVisibilityRulesTo);
                            }
                        } else if (!id.contains("default")) {
                            TypedQuery queryDefaultCircleRuleTo = em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultRealmCircleRuleFrom", OlvidCircleVisibilityRules.class);
                            queryDefaultCircleRuleTo.setParameter("realmId", (Object)realmModel.getId());
                            OlvidCircleVisibilityRules defaultCircleRuleTo = (OlvidCircleVisibilityRules)queryDefaultCircleRuleFrom.getResultList().get(0);
                            OlvidCircleVisibilityRules olvidCircleVisibilityRulesFrom = new OlvidCircleVisibilityRules();
                            olvidCircleVisibilityRulesFrom.setId(KeycloakModelUtils.generateId());
                            olvidCircleVisibilityRulesFrom.setCircleVisibilityId1From(circle.getId());
                            olvidCircleVisibilityRulesFrom.setCircleVisibilityId2To(id);
                            olvidCircleVisibilityRulesFrom.setVisibility(defaultCircleRuleTo.getVisibility());
                            olvidCircleVisibilityRulesFrom.setRealmId(defaultCircleRuleTo.getRealmId());
                            finalResult.add(olvidCircleVisibilityRulesFrom);
                            OlvidCircleVisibilityRules olvidCircleVisibilityRulesTo = new OlvidCircleVisibilityRules();
                            olvidCircleVisibilityRulesTo.setId(KeycloakModelUtils.generateId());
                            olvidCircleVisibilityRulesTo.setCircleVisibilityId1From(id);
                            olvidCircleVisibilityRulesTo.setCircleVisibilityId2To(circle.getId());
                            olvidCircleVisibilityRulesTo.setVisibility(defaultCircleRuleTo.getVisibility());
                            olvidCircleVisibilityRulesTo.setRealmId(defaultCircleRuleTo.getRealmId());
                            finalResult.add(olvidCircleVisibilityRulesTo);
                        }
                    });
                }
                catch (NoResultException noResultException) {
                    // empty catch block
                }
                return finalResult;
            }
            return finalResult;
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
            return new ArrayList<OlvidCircleVisibilityRules>();
        }
    }

    public static OlvidCircleVisibility getOlvidCircleVisibilityByUsers(EntityManager em, RealmModel realmModel, String id) {
        try {
            TypedQuery q = em.createNamedQuery("OlvidCircleVisibility.getById", OlvidCircleVisibility.class);
            q.setParameter("realmId", (Object)realmModel.getId());
            q.setParameter("id", (Object)id);
            OlvidCircleVisibility ret = (OlvidCircleVisibility)q.getSingleResult();
            return ret;
        }
        catch (NoResultException e) {
            return new OlvidCircleVisibility();
        }
    }

    private Response processGetCircleVisibility(String role, String realmName, String id) throws JsonProcessingException {
        boolean writeAllowed = this.checkQueryIsAllowed(30, role);
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            OlvidCircleVisibility data = new OlvidCircleVisibility();
            if (!id.contentEquals("") && !id.contentEquals("default")) {
                data = Configuration.getOlvidCircleVisibility(this.em, realmModel, id);
            }
            List<OlvidCircleVisibility> circles = Configuration.getOlvidCirclesVisibilities(this.em, realmModel);
            String circleDefaultRule = "";
            if (!id.contentEquals("default") && !id.contentEquals("")) {
                TypedQuery q = this.em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultCircleRule", OlvidCircleVisibilityRules.class);
                q.setParameter("realmId", (Object)realmModel.getId());
                q.setParameter("id", (Object)id);
                circleDefaultRule = ((OlvidCircleVisibilityRules)q.getSingleResult()).getVisibility();
            } else {
                TypedQuery q = this.em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultCircleRuleBetweenMembers", OlvidCircleVisibilityRules.class);
                q.setParameter("realmId", (Object)realmModel.getId());
                try {
                    circleDefaultRule = ((OlvidCircleVisibilityRules)q.getSingleResult()).getVisibility();
                }
                catch (NoResultException noResultException) {
                    // empty catch block
                }
            }
            Query countQuery = this.buildQueryCountCircleVisibilityByCircleIdMembersWithFilter(realmModel.getId(), id, new ArrayList<String>());
            if (id.contentEquals("default")) {
                countQuery = this.buildQueryCountCircleVisibilityMemberWithoutCircleIdWithFilter(realmModel.getId());
            }
            Object countResult = countQuery.getSingleResult();
            try {
                GetCircleVisibilityResponseModel responseModel = new GetCircleVisibilityResponseModel();
                responseModel.setWriteAllowed(writeAllowed);
                responseModel.setCircles(circles);
                responseModel.setCount((Long)countResult);
                responseModel.setData(data);
                responseModel.setCircleDefaultRule(circleDefaultRule);
                GenericReponseModel response = new GenericReponseModel();
                response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
                return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
            }
            catch (Exception e) {
                logger.info((Object)e.getMessage());
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "internal error", false);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
    }

    private Response processGetCircleVisibilityMembers(String role, String realmName, String id, String tabChose, List<String> filters, int limit, int offset, boolean isWithRestrictedInformations) throws JsonProcessingException {
        boolean writeAllowed = this.checkQueryIsAllowed(30, role);
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            List<Object> data;
            List<OlvidCircleVisibilityUser> olvidCircleVisibilityMembersFiltered = Configuration.getOlvidCircleVisibilityMembersFiltered(this.em, realmModel, id, tabChose, filters, limit, offset);
            List usersListIds = olvidCircleVisibilityMembersFiltered.stream().map(OlvidCircleVisibilityUser::getUserId).collect(Collectors.toList());
            TypedQuery<Object[]> query = this.buildQueryFindUsersByIdsLimited(realmModel.getId(), usersListIds, filters, limit, offset);
            if (id.contains("default")) {
                query = this.buildQueryFindUsersWithoutCircleVisibility(realmModel.getId(), filters, limit, offset);
            }
            try {
                data = isWithRestrictedInformations ? query.getResultStream().map(result -> Configuration.createOlvidUserRestrictedFromUserEntity(this.em, this.session, realmModel, (UserEntity)result[0], (OlvidCircleVisibility)result[1])).collect(Collectors.toList()) : query.getResultStream().map(result -> Configuration.createOlvidUserFromUserEntity(this.em, this.session, realmModel, (UserEntity)result[0], (OlvidCircleVisibility)result[1])).collect(Collectors.toList());
            }
            catch (NoResultException e) {
                data = new ArrayList();
            }
            if (id.contains("default")) {
                TypedQuery<String> queryIds = this.buildQueryFindAllUsersIdsWithoutCircleVisibility(realmModel.getId());
                usersListIds = queryIds.getResultList();
            }
            Query countQuery = this.buildQueryCountCircleVisibilityMembersWithFilter(realmModel.getId(), usersListIds, filters);
            if (id.contentEquals("default")) {
                countQuery = this.buildQueryCountDefaultCircleVisibilityMembers(realmModel.getId(), filters);
            }
            Object countResult = countQuery.getSingleResult();
            GetCircleVisibilityMembersFilteredResponseModel responseModel = new GetCircleVisibilityMembersFilteredResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setCount((Long)countResult);
            responseModel.setData(data);
            responseModel.setTotalMembersIds(usersListIds);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    public static List<OlvidCircleVisibilityUser> getOlvidCircleVisibilityMembersFiltered(EntityManager em, RealmModel realmModel, String id, String tabChose, List<String> filters, int limit, int offset) {
        try {
            TypedQuery q = em.createNamedQuery("OlvidCircleVisibilityUser.getAllByCircleVisibilityId", OlvidCircleVisibilityUser.class);
            q.setParameter("realmId", (Object)realmModel.getId());
            q.setParameter("id", (Object)id);
            List ret = q.getResultList();
            return ret;
        }
        catch (NoResultException e) {
            return new ArrayList<OlvidCircleVisibilityUser>();
        }
    }

    public static OlvidCircleVisibilityUser getUserOlvidCircleVisibility(EntityManager em, RealmModel realmModel, String id) {
        try {
            TypedQuery q = em.createNamedQuery("OlvidCircleVisibilityUser.getUserCircleVisibilityId", OlvidCircleVisibilityUser.class);
            q.setParameter("realmId", (Object)realmModel.getId());
            q.setParameter("id", (Object)id);
            OlvidCircleVisibilityUser ret = (OlvidCircleVisibilityUser)q.getSingleResult();
            return ret;
        }
        catch (NoResultException e) {
            return new OlvidCircleVisibilityUser();
        }
    }

    private Response processGetCircleVisibilityRulesByCircles(String role, String realmName, String id, Boolean isWithMembers) throws JsonProcessingException {
        boolean writeAllowed = this.checkQueryIsAllowed(30, role);
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        if (id == null) {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(new HashMap(), new ResponseConstants().STATUS_ERROR, 1, "internal error", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        try {
            if (id.isEmpty()) {
                id = "default";
            }
            List<OlvidCircleVisibilityRules> data = Configuration.getOlvidCircleVisibilityByCircles(this.em, realmModel, id);
            OlvidCircleVisibilityRulesListModel dataFormated = new OlvidCircleVisibilityRulesListModel().newOlvidCircleVisibilityRulesListModel(this.em, this.session, realmModel, data, id, isWithMembers);
            Query countQuery = this.buildQueryCountCircleVisibilityByCircleIdMembersWithFilter(realmModel.getId(), id, new ArrayList<String>());
            if (id.contentEquals("default")) {
                countQuery = this.buildQueryCountCircleVisibilityMemberWithoutCircleIdWithFilter(realmModel.getId());
            }
            Object countResult = countQuery.getSingleResult();
            GetCircleVisibilityRulesByCirclesResponseModel responseModel = new GetCircleVisibilityRulesByCirclesResponseModel();
            responseModel.setCount((Long)countResult);
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setData(dataFormated);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processGetCircleVisibilityRulesByUsers(String role, String realmName, String id) throws JsonProcessingException {
        boolean writeAllowed = this.checkQueryIsAllowed(30, role);
        Boolean isWithMembers = true;
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            if (id.isEmpty()) {
                id = "default";
            }
            List<OlvidCircleVisibilityRules> data = Configuration.getOlvidCircleVisibilityByCircles(this.em, realmModel, id);
            OlvidCircleVisibilityRulesListModel dataFormated = new OlvidCircleVisibilityRulesListModel().newOlvidCircleVisibilityRulesListModel(this.em, this.session, realmModel, data, id, isWithMembers);
            Query countQuery = this.buildQueryCountCircleVisibilityByCircleIdMembersWithFilter(realmModel.getId(), id, new ArrayList<String>());
            if (id.contentEquals("default")) {
                countQuery = this.buildQueryCountCircleVisibilityMemberWithoutCircleIdWithFilter(realmModel.getId());
            }
            Object countResult = countQuery.getSingleResult();
            GetCircleVisibilityRulesByCirclesResponseModel responseModel = new GetCircleVisibilityRulesByCirclesResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setCount((Long)countResult);
            responseModel.setData(dataFormated);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processAddCircleVisibility(String realmName, Object dataObj) throws JsonProcessingException {
        AddCircleVisibilityResponseModel responseModel = new AddCircleVisibilityResponseModel();
        try {
            this.em.getTransaction().begin();
            RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
            CreateCircleVisibilityModel createCircleVisibilityModel = (CreateCircleVisibilityModel)this.objectMapper.convertValue(dataObj, CreateCircleVisibilityModel.class);
            OlvidCircleVisibility olvidCircleVisibility = new OlvidCircleVisibility();
            String circleId = KeycloakModelUtils.generateId();
            olvidCircleVisibility.setId(circleId);
            olvidCircleVisibility.setRealmId(realmModel.getId());
            olvidCircleVisibility.setName(createCircleVisibilityModel.getName());
            olvidCircleVisibility.setDescription(createCircleVisibilityModel.getDescription());
            this.em.persist((Object)olvidCircleVisibility);
            OlvidCircleVisibilityRules olvidCircleVisibilityRules = new OlvidCircleVisibilityRules();
            String ruleId = KeycloakModelUtils.generateId();
            olvidCircleVisibilityRules.setRealmId(realmModel.getId());
            olvidCircleVisibilityRules.setId(ruleId);
            olvidCircleVisibilityRules.setCircleVisibilityId1From(circleId);
            olvidCircleVisibilityRules.setCircleVisibilityId2To(circleId);
            olvidCircleVisibilityRules.setVisibility(createCircleVisibilityModel.getDefaultCircleMembersRule().toUpperCase());
            this.em.persist((Object)olvidCircleVisibilityRules);
            CircleVisibilityRuleModel fromRules = createCircleVisibilityModel.getFrom();
            fromRules.noContact.forEach(rule -> this.createOlvidCircleVisibilityRulesFrom(realmModel, (CirclesVisibilityRulesModel)rule, circleId));
            fromRules.seeContact.forEach(rule -> this.createOlvidCircleVisibilityRulesFrom(realmModel, (CirclesVisibilityRulesModel)rule, circleId));
            CircleVisibilityRuleModel toRules = createCircleVisibilityModel.getTo();
            toRules.noContact.forEach(rule -> this.createOlvidCircleVisibilityRulesTo(realmModel, (CirclesVisibilityRulesModel)rule, circleId));
            toRules.seeContact.forEach(rule -> this.createOlvidCircleVisibilityRulesTo(realmModel, (CirclesVisibilityRulesModel)rule, circleId));
            try {
                String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  create circleName: " + createCircleVisibilityModel.getName() + ",\n  with description: " + createCircleVisibilityModel.getDescription() + ",\n  with rules From : " + String.valueOf(createCircleVisibilityModel.getFrom()) + ",\n  with rules To : " + String.valueOf(createCircleVisibilityModel.getTo()) + ",\n]";
                logger.debug((Object)logs);
                HashMap<String, Object> ret = new HashMap<String, Object>();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "circleVisibilityCreate", "Circle visibility created:" + logs, ret);
            }
            catch (Exception exception) {
                // empty catch block
            }
            responseModel.setId(circleId);
            responseModel.setStatus(true);
            this.em.flush();
            this.em.getTransaction().commit();
        }
        catch (Exception e) {
            this.em.getTransaction().rollback();
        }
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processDeleteCircleVisibility(String realmName, String id, String name) throws JsonProcessingException {
        HashMap<String, Object> ret;
        String logs2;
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        TypedQuery query = this.em.createNamedQuery("OlvidCircleVisibility.getById", OlvidCircleVisibility.class);
        query.setParameter("realmId", (Object)realmModel.getId());
        query.setParameter("id", (Object)id);
        OlvidCircleVisibility olvidCircleVisibility = (OlvidCircleVisibility)query.getSingleResult();
        try {
            int countLinks = this.em.createNamedQuery("OlvidCircleVisibilityRules.deleteAllCircleRules").setParameter("realmId", (Object)realmModel.getId()).setParameter("id", (Object)id).executeUpdate();
            try {
                logs2 = " [\n  realm Name: " + realmModel.getName() + ",\n  step 1 delete circle's members: " + olvidCircleVisibility.getName() + ",\n  countLinks: " + countLinks + ",\n]";
                logger.debug((Object)logs2);
                ret = new HashMap<String, Object>();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "circleVisibilityDelete", "Circle visibility deletion:" + logs2, ret);
            }
            catch (Exception logs2) {}
        }
        catch (NoResultException countLinks) {
            // empty catch block
        }
        try {
            int countRules = this.em.createNamedQuery("OlvidCircleVisibilityRules.deleteAllCircleRules").setParameter("realmId", (Object)realmModel.getId()).setParameter("id", (Object)id).executeUpdate();
            try {
                logs2 = " [\n  realm Name: " + realmModel.getName() + ",\n  step 2 delete circle's rules: " + olvidCircleVisibility.getName() + ",\n  countRules: " + countRules + ",\n]";
                logger.debug((Object)logs2);
                ret = new HashMap();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "circleVisibilityDelete", "Circle visibility deletion:" + logs2, ret);
            }
            catch (Exception logs3) {}
        }
        catch (NoResultException countRules) {
            // empty catch block
        }
        try {
            int countCircle = this.em.createNamedQuery("OlvidCircleVisibility.deleteCircle").setParameter("realmId", (Object)realmModel.getId()).setParameter("id", (Object)id).executeUpdate();
            try {
                logs2 = " [\n  realm Name: " + realmModel.getName() + ",\n  step 3 delete circle : " + olvidCircleVisibility.getName() + ",\n  countCircle: " + countCircle + ",\n]";
                logger.debug((Object)logs2);
                ret = new HashMap();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "circleVisibilityDelete", "Circle visibility deletion:" + logs2, ret);
            }
            catch (Exception logs4) {}
        }
        catch (NoResultException countCircle) {
            // empty catch block
        }
        AddCircleVisibilityResponseModel responseModel = new AddCircleVisibilityResponseModel();
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processEditCircleVisibility(String realmName, Object dataObj) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        CircleVisibilityModel circleEdited = (CircleVisibilityModel)this.objectMapper.convertValue(dataObj, CircleVisibilityModel.class);
        circleEdited.setRealmId(realmModel.getId());
        try {
            int count = this.em.createNamedQuery("OlvidCircleVisibility.editCircle").setParameter("name", (Object)circleEdited.getName()).setParameter("description", (Object)circleEdited.getDescription()).setParameter("id", (Object)circleEdited.getId()).executeUpdate();
            try {
                String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  edit circle id : " + circleEdited.getId() + ",\n  edit circle name : " + circleEdited.getName() + ",\n  edit circle description : " + circleEdited.getDescription() + ",\n  count edited : " + count + ",\n]";
                logger.debug((Object)logs);
                HashMap<String, Object> ret = new HashMap<String, Object>();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "circleVisibilityEdit", "Circle visibility edited:" + logs, ret);
            }
            catch (Exception logs) {}
        }
        catch (NoResultException count) {
            // empty catch block
        }
        Query countQuery = this.buildQueryCountCircleVisibilityByCircleIdMembersWithFilter(realmModel.getId(), circleEdited.getId(), new ArrayList<String>());
        if (circleEdited.getId().contentEquals("default")) {
            countQuery = this.buildQueryCountCircleVisibilityMemberWithoutCircleIdWithFilter(realmModel.getId());
        }
        Object countResult = countQuery.getSingleResult();
        EditCircleVisibilityResponseModel responseModel = new EditCircleVisibilityResponseModel();
        responseModel.setCount((Long)countResult);
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processEditCircleVisibilityRules(String realmName, Object dataObj) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        CircleVisibilityChangeVisibilityRuleModel rulesEdited = (CircleVisibilityChangeVisibilityRuleModel)this.objectMapper.convertValue(dataObj, CircleVisibilityChangeVisibilityRuleModel.class);
        ClusterProvider clusterProvider = (ClusterProvider)this.session.getProvider(ClusterProvider.class);
        this.em.getTransaction().begin();
        ExecutionResult result = clusterProvider.executeIfNotExecuted("olvid.editCircle." + realmModel.getId() + "." + rulesEdited.circleId, 10000, () -> {
            List<CircleVisibilityEditVisibilityRuleModel> changesFrom = rulesEdited.getChangeFrom();
            changesFrom.forEach(rule -> {
                String visibility = ConstantsCircleVisibility.sanitizeVisibility(rule.getAfter());
                try {
                    int count;
                    if (!(rule.getId().contentEquals("default") || rule.getId().contentEquals("default-to") || rule.getId().contentEquals("default-from"))) {
                        OlvidCircleVisibilityRules olvidCircleVisibilityRulesTo;
                        String circleId;
                        String string = circleId = rulesEdited.getCircleId().contentEquals("default") ? null : rulesEdited.getCircleId();
                        if (circleId != null) {
                            count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateCircleRules").setParameter("realmId", (Object)realmModel.getId()).setParameter("visibility", (Object)visibility).setParameter("fromId", (Object)circleId).setParameter("toId", (Object)rule.getId()).executeUpdate();
                            if (count == 0) {
                                olvidCircleVisibilityRulesTo = new OlvidCircleVisibilityRules();
                                olvidCircleVisibilityRulesTo.setId(KeycloakModelUtils.generateId());
                                olvidCircleVisibilityRulesTo.setRealmId(realmModel.getId());
                                olvidCircleVisibilityRulesTo.setVisibility(visibility);
                                olvidCircleVisibilityRulesTo.setCircleVisibilityId1From(circleId);
                                olvidCircleVisibilityRulesTo.setCircleVisibilityId2To(rule.getId());
                                this.em.persist((Object)olvidCircleVisibilityRulesTo);
                                TypedQuery q = this.em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultRealmCircleRuleTo", OlvidCircleVisibilityRules.class);
                                q.setParameter("realmId", (Object)realmModel.getId());
                                OlvidCircleVisibilityRules olvidCircleVisibilityRulesFrom = new OlvidCircleVisibilityRules();
                                olvidCircleVisibilityRulesFrom.setId(KeycloakModelUtils.generateId());
                                olvidCircleVisibilityRulesFrom.setRealmId(realmModel.getId());
                                olvidCircleVisibilityRulesFrom.setVisibility(((OlvidCircleVisibilityRules)q.getSingleResult()).getVisibility());
                                olvidCircleVisibilityRulesFrom.setCircleVisibilityId2To(circleId);
                                olvidCircleVisibilityRulesFrom.setCircleVisibilityId1From(rule.getId());
                                this.em.persist((Object)olvidCircleVisibilityRulesFrom);
                            }
                        } else {
                            count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateCircleRulesDefaultCircleFrom").setParameter("realmId", (Object)realmModel.getId()).setParameter("visibility", (Object)visibility).setParameter("toId", (Object)rule.getId()).executeUpdate();
                            if (count == 0) {
                                olvidCircleVisibilityRulesTo = new OlvidCircleVisibilityRules();
                                olvidCircleVisibilityRulesTo.setId(KeycloakModelUtils.generateId());
                                olvidCircleVisibilityRulesTo.setRealmId(realmModel.getId());
                                olvidCircleVisibilityRulesTo.setVisibility(visibility);
                                olvidCircleVisibilityRulesTo.setCircleVisibilityId1From(circleId);
                                olvidCircleVisibilityRulesTo.setCircleVisibilityId2To(rule.getId());
                                this.em.persist((Object)olvidCircleVisibilityRulesTo);
                                TypedQuery q = this.em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultRealmCircleRuleTo", OlvidCircleVisibilityRules.class);
                                q.setParameter("realmId", (Object)realmModel.getId());
                                OlvidCircleVisibilityRules olvidCircleVisibilityRulesFrom = new OlvidCircleVisibilityRules();
                                olvidCircleVisibilityRulesFrom.setId(KeycloakModelUtils.generateId());
                                olvidCircleVisibilityRulesFrom.setRealmId(realmModel.getId());
                                olvidCircleVisibilityRulesFrom.setVisibility(((OlvidCircleVisibilityRules)q.getSingleResult()).getVisibility());
                                olvidCircleVisibilityRulesFrom.setCircleVisibilityId2To(circleId);
                                olvidCircleVisibilityRulesFrom.setCircleVisibilityId1From(rule.getId());
                                this.em.persist((Object)olvidCircleVisibilityRulesFrom);
                            }
                        }
                    } else if (rule.getId().contentEquals("default")) {
                        count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateDefaultCircleRuleBetweenMembers").setParameter("realmId", (Object)realmModel.getId()).setParameter("visibility", (Object)visibility).executeUpdate();
                    } else {
                        count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateCircleRulesDefaultCircleTo").setParameter("realmId", (Object)realmModel.getId()).setParameter("fromId", (Object)rulesEdited.getCircleId()).setParameter("visibility", (Object)visibility).executeUpdate();
                        if (count == 0) {
                            OlvidCircleVisibilityRules olvidCircleVisibilityRulesTo = new OlvidCircleVisibilityRules();
                            olvidCircleVisibilityRulesTo.setId(KeycloakModelUtils.generateId());
                            olvidCircleVisibilityRulesTo.setRealmId(realmModel.getId());
                            olvidCircleVisibilityRulesTo.setVisibility(visibility);
                            olvidCircleVisibilityRulesTo.setCircleVisibilityId1From(rulesEdited.getCircleId());
                            this.em.persist((Object)olvidCircleVisibilityRulesTo);
                            TypedQuery q = this.em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultRealmCircleRuleTo", OlvidCircleVisibilityRules.class);
                            q.setParameter("realmId", (Object)realmModel.getId());
                            OlvidCircleVisibilityRules olvidCircleVisibilityRulesFrom = new OlvidCircleVisibilityRules();
                            olvidCircleVisibilityRulesFrom.setId(KeycloakModelUtils.generateId());
                            olvidCircleVisibilityRulesFrom.setRealmId(realmModel.getId());
                            olvidCircleVisibilityRulesFrom.setVisibility(((OlvidCircleVisibilityRules)q.getSingleResult()).getVisibility());
                            olvidCircleVisibilityRulesFrom.setCircleVisibilityId2To(rulesEdited.getCircleId());
                            this.em.persist((Object)olvidCircleVisibilityRulesFrom);
                        }
                    }
                    try {
                        String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  edit rule from circle id : " + rulesEdited.getCircleId() + ",\n  edit rule to circle : " + rule.item + ",\n  edit rule before : " + rule.before + ",\n  edit rule after : " + rule.after + ",\n  count edited : " + count + ",\n]";
                        logger.debug((Object)logs);
                        HashMap<String, Object> ret = new HashMap<String, Object>();
                        OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "circleVisibilityEdit", "Circle visibility edited:" + logs, ret);
                    }
                    catch (Exception exception) {}
                }
                catch (NoResultException noResultException) {
                    // empty catch block
                }
            });
            List<CircleVisibilityEditVisibilityRuleModel> changesTo = rulesEdited.getChangeTo();
            changesTo.forEach(rule -> {
                String visibility = ConstantsCircleVisibility.sanitizeVisibility(rule.getAfter());
                try {
                    int count;
                    if (!(rule.getId().contentEquals("defaultCircleBetweenMembers") || rule.getId().contentEquals("default-to") || rule.getId().contentEquals("default-from"))) {
                        String circleId;
                        String string = circleId = rulesEdited.getCircleId().contentEquals("default") ? null : rulesEdited.getCircleId();
                        if (circleId != null) {
                            count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateCircleRules").setParameter("realmId", (Object)realmModel.getId()).setParameter("visibility", (Object)visibility).setParameter("fromId", (Object)rule.getId()).setParameter("toId", (Object)circleId).executeUpdate();
                            if (count == 0) {
                                OlvidCircleVisibilityRules olvidCircleVisibilityRulesTo = new OlvidCircleVisibilityRules();
                                olvidCircleVisibilityRulesTo.setId(KeycloakModelUtils.generateId());
                                olvidCircleVisibilityRulesTo.setRealmId(realmModel.getId());
                                olvidCircleVisibilityRulesTo.setVisibility(visibility);
                                olvidCircleVisibilityRulesTo.setCircleVisibilityId1From(rule.getId());
                                olvidCircleVisibilityRulesTo.setCircleVisibilityId2To(circleId);
                                this.em.persist((Object)olvidCircleVisibilityRulesTo);
                                TypedQuery q = this.em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultRealmCircleRuleTo", OlvidCircleVisibilityRules.class);
                                q.setParameter("realmId", (Object)realmModel.getId());
                                OlvidCircleVisibilityRules olvidCircleVisibilityRulesFrom = new OlvidCircleVisibilityRules();
                                olvidCircleVisibilityRulesFrom.setId(KeycloakModelUtils.generateId());
                                olvidCircleVisibilityRulesFrom.setRealmId(realmModel.getId());
                                olvidCircleVisibilityRulesFrom.setVisibility(((OlvidCircleVisibilityRules)q.getSingleResult()).getVisibility());
                                olvidCircleVisibilityRulesFrom.setCircleVisibilityId2To(rule.getId());
                                olvidCircleVisibilityRulesFrom.setCircleVisibilityId1From(circleId);
                                this.em.persist((Object)olvidCircleVisibilityRulesFrom);
                            }
                        } else {
                            count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateCircleRulesDefaultCircleTo").setParameter("realmId", (Object)realmModel.getId()).setParameter("visibility", (Object)visibility).setParameter("fromId", (Object)rule.getId()).executeUpdate();
                        }
                    } else if (rule.getId().contentEquals("defaultCircleBetweenMembers")) {
                        count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateDefaultCircleRuleBetweenMembers").setParameter("realmId", (Object)realmModel.getId()).setParameter("visibility", (Object)visibility).executeUpdate();
                    } else {
                        count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateCircleRulesDefaultCircleFrom").setParameter("realmId", (Object)realmModel.getId()).setParameter("toId", (Object)rulesEdited.getCircleId()).setParameter("visibility", (Object)visibility).executeUpdate();
                        if (count == 0) {
                            OlvidCircleVisibilityRules olvidCircleVisibilityRulesTo = new OlvidCircleVisibilityRules();
                            olvidCircleVisibilityRulesTo.setId(KeycloakModelUtils.generateId());
                            olvidCircleVisibilityRulesTo.setRealmId(realmModel.getId());
                            olvidCircleVisibilityRulesTo.setVisibility(visibility);
                            olvidCircleVisibilityRulesTo.setCircleVisibilityId1From(rulesEdited.getCircleId());
                            this.em.persist((Object)olvidCircleVisibilityRulesTo);
                            TypedQuery q = this.em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultRealmCircleRuleFrom", OlvidCircleVisibilityRules.class);
                            q.setParameter("realmId", (Object)realmModel.getId());
                            OlvidCircleVisibilityRules olvidCircleVisibilityRulesFrom = new OlvidCircleVisibilityRules();
                            olvidCircleVisibilityRulesFrom.setId(KeycloakModelUtils.generateId());
                            olvidCircleVisibilityRulesFrom.setRealmId(realmModel.getId());
                            olvidCircleVisibilityRulesFrom.setVisibility(((OlvidCircleVisibilityRules)q.getSingleResult()).getVisibility());
                            olvidCircleVisibilityRulesFrom.setCircleVisibilityId2To(rulesEdited.getCircleId());
                            this.em.persist((Object)olvidCircleVisibilityRulesFrom);
                        }
                    }
                    try {
                        String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  edit rule to circle id : " + rulesEdited.getCircleId() + ",\n  edit rule from circle : " + rule.item + ",\n  edit rule before : " + rule.before + ",\n  edit rule after : " + rule.after + ",\n  count edited : " + count + ",\n]";
                        logger.debug((Object)logs);
                        HashMap<String, Object> ret = new HashMap<String, Object>();
                        OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "circleVisibilityEdit", "Circle visibility edited:" + logs, ret);
                    }
                    catch (Exception exception) {}
                }
                catch (NoResultException noResultException) {
                    // empty catch block
                }
            });
            return this.success();
        });
        EditCircleVisibilityResponseModel responseModel = new EditCircleVisibilityResponseModel();
        responseModel.setStatus(true);
        try {
            GenericReponseModel response = new GenericReponseModel();
            if (result.isExecuted()) {
                response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            } else {
                response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_ERROR, 3, "ERROR_CODE_OPERATION_ALREADY_PROCESSING", true);
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processEditUserCircleVisibilityRules(String realmName, String circleId, String userId) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        int count = this.editUserRules(circleId, userId, realmModel);
        EditCircleVisibilityResponseModel responseModel = new EditCircleVisibilityResponseModel();
        responseModel.setStatus(true);
        responseModel.setCount(count);
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private int editUserRules(String circleId, String userId, RealmModel realmModel) {
        int count;
        block11: {
            count = 0;
            try {
                TypedQuery q = this.em.createNamedQuery("OlvidCircleVisibilityUser.getUserCircleVisibilityId", OlvidCircleVisibilityUser.class);
                q.setParameter("realmId", (Object)realmModel.getId());
                q.setParameter("id", (Object)userId);
                q.getSingleResult();
                if (!circleId.contains("default")) {
                    try {
                        count = this.em.createNamedQuery("OlvidCircleVisibilityUser.updateUserCircle").setParameter("realmId", (Object)realmModel.getId()).setParameter("newCircleId", (Object)circleId).setParameter("id", (Object)userId).executeUpdate();
                        try {
                            String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  edit user : " + userId + ",\n  set circle : " + circleId + ",\n  count edited : " + count + ",\n]";
                            logger.debug((Object)logs);
                            HashMap<String, Object> ret = new HashMap<String, Object>();
                            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "circleVisibilityEdit", "Circle visibility edited:" + logs, ret);
                            break block11;
                        }
                        catch (Exception logs) {
                        }
                    }
                    catch (NoResultException logs) {}
                    break block11;
                }
                try {
                    count = this.em.createNamedQuery("OlvidCircleVisibilityUser.deleteUserCircle").setParameter("realmId", (Object)realmModel.getId()).setParameter("id", (Object)userId).executeUpdate();
                    try {
                        String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  edit user : " + userId + ",\n  set circle : " + circleId + ",\n  count edited : " + count + ",\n]";
                        logger.debug((Object)logs);
                        HashMap<String, Object> ret = new HashMap<String, Object>();
                        OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "circleVisibilityEdit", "Circle visibility edited:" + logs, ret);
                    }
                    catch (Exception logs) {
                    }
                }
                catch (NoResultException logs) {}
            }
            catch (NoResultException e) {
                OlvidCircleVisibilityUser olvidCircleVisibilityUser = new OlvidCircleVisibilityUser();
                olvidCircleVisibilityUser.setId(KeycloakModelUtils.generateId());
                olvidCircleVisibilityUser.setRealmId(realmModel.getId());
                olvidCircleVisibilityUser.setUserId(userId);
                olvidCircleVisibilityUser.setCircleVisibilityId(circleId);
                this.em.persist((Object)olvidCircleVisibilityUser);
            }
        }
        return count;
    }

    private Response processRemoveUsersCircleVisibility(String realmName, String circleId, List<String> usersList) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        try {
            int count = this.em.createNamedQuery("OlvidCircleVisibilityUser.deleteUsersCircle").setParameter("realmId", (Object)realmModel.getId()).setParameter("list", usersList).executeUpdate();
            try {
                String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  edit users : " + String.valueOf(usersList) + ",\n  remove circle : " + circleId + ",\n  count removed : " + count + ",\n]";
                logger.debug((Object)logs);
                HashMap<String, Object> ret = new HashMap<String, Object>();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "circleVisibilityEdit", "Circle visibility edited:" + logs, ret);
            }
            catch (Exception logs) {}
        }
        catch (NoResultException count) {
            // empty catch block
        }
        EditCircleVisibilityResponseModel responseModel = new EditCircleVisibilityResponseModel();
        responseModel.setStatus(true);
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processAddUsersCircleVisibility(String realmName, String circleId, List<String> usersList) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        AtomicInteger count = new AtomicInteger();
        usersList.forEach(userId -> count.addAndGet(this.editUserRules(circleId, (String)userId, realmModel)));
        EditCircleVisibilityResponseModel responseModel = new EditCircleVisibilityResponseModel();
        responseModel.setStatus(true);
        responseModel.setCount(count.get());
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private void createOlvidCircleVisibilityRulesFrom(RealmModel realmModel, CirclesVisibilityRulesModel rule, String circleId) {
        OlvidCircleVisibilityRules olvidCircleVisibilityRules = new OlvidCircleVisibilityRules();
        String ruleId = KeycloakModelUtils.generateId();
        olvidCircleVisibilityRules.setRealmId(realmModel.getId());
        olvidCircleVisibilityRules.setId(ruleId);
        olvidCircleVisibilityRules.setCircleVisibilityId1From(circleId);
        olvidCircleVisibilityRules.setCircleVisibilityId2To(rule.getTo().getId().contains("default-to") ? null : rule.getTo().getId());
        olvidCircleVisibilityRules.setVisibility(rule.getVisibilityRule());
        this.em.persist((Object)olvidCircleVisibilityRules);
    }

    private void createOlvidCircleVisibilityRulesTo(RealmModel realmModel, CirclesVisibilityRulesModel rule, String circleId) {
        OlvidCircleVisibilityRules olvidCircleVisibilityRules = new OlvidCircleVisibilityRules();
        String ruleId = KeycloakModelUtils.generateId();
        olvidCircleVisibilityRules.setRealmId(realmModel.getId());
        olvidCircleVisibilityRules.setId(ruleId);
        olvidCircleVisibilityRules.setCircleVisibilityId1From(rule.getFrom().getId().contains("default") ? null : rule.getFrom().getId());
        olvidCircleVisibilityRules.setCircleVisibilityId2To(circleId);
        olvidCircleVisibilityRules.setVisibility(rule.getVisibilityRule());
        this.em.persist((Object)olvidCircleVisibilityRules);
    }

    private Response processCreateOlvidGroup(String realmName, Object dataObj) throws Exception {
        GroupModel newGroupModel;
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        CreateOlvidGroupModel group = (CreateOlvidGroupModel)this.objectMapper.convertValue(dataObj, CreateOlvidGroupModel.class);
        String groupName = group.getName();
        String groupParentId = group.getParentId();
        Boolean groupOlvid = group.getOlvidGroup();
        String groupDescription = group.getDescription();
        String groupOlvidName = group.getOlvidName();
        if (groupName.contentEquals("")) {
            logger.info((Object)"processCreateOlvidGroup: group name empty");
            return this.invalidRequest();
        }
        if (this.session.groups().getGroupsStream(realmModel).anyMatch(groupFound -> Objects.equals(groupFound.getName(), groupName))) {
            logger.info((Object)"processCreateOlvidGroup: duplicate group name");
            return this.invalidRequest();
        }
        if (groupParentId != null) {
            GroupModel parentGroupModel = this.session.groups().getGroupById(realmModel, groupParentId);
            if (parentGroupModel == null) {
                logger.info((Object)"processCreateOlvidGroup: invalid parent Id");
                return this.invalidRequest();
            }
            newGroupModel = this.session.groups().createGroup(realmModel, groupName, parentGroupModel);
        } else {
            newGroupModel = this.session.groups().createGroup(realmModel, groupName);
        }
        Utils.setGroupAttribute(newGroupModel, "olvid-description", groupDescription);
        Utils.setGroupAttribute(newGroupModel, "olvid-name", groupOlvidName);
        Utils.setGroupAttribute(newGroupModel, "olvid-group", groupOlvid.toString());
        Utils.setGroupAttribute(newGroupModel, "olvid-managed", "true");
        this.updateOlvidGroupAndNotify(realmModel, newGroupModel);
        try {
            String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  groupName: " + newGroupModel.getName() + ",\n  groupCustomName: " + groupOlvidName + ",\n  create group: " + groupOlvid + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "groupCreate", "Group created:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        CreateOlvidGroupResponseModel responseModel = new CreateOlvidGroupResponseModel();
        responseModel.setId(newGroupModel.getId());
        responseModel.setStatus(true);
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response processMoveOlvidGroup(String realmName, String groupId, String newParentGroupId) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        EntityTransaction tx = null;
        boolean isDone = false;
        GroupModel group = this.session.groups().getGroupById(realmModel, groupId);
        String oldGroupParentName = "";
        if (group.getParentId() != null) {
            oldGroupParentName = this.session.groups().getGroupById(realmModel, group.getParentId()).getName();
        }
        GroupModel newGroupParent = this.session.groups().getGroupById(realmModel, newParentGroupId);
        try {
            tx = this.em.getTransaction();
            tx.begin();
            group.setParent(newGroupParent);
            isDone = true;
        }
        finally {
            if (isDone) {
                tx.commit();
            } else if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
        try {
            String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  move group: " + group.getName() + ",\n  from oldParent: " + oldGroupParentName + ",\n  to newParent: " + newGroupParent.getName() + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "groupMove", "Group moved:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(new HashMap(), new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response processDuplicateOlvidGroup(String realmName, String groupId, Object data) throws Exception {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        EntityTransaction tx = null;
        boolean isDone = false;
        GroupModel group = this.session.groups().getGroupById(realmModel, groupId);
        GroupDuplicateSettingsModel parameters = (GroupDuplicateSettingsModel)this.objectMapper.convertValue(data, GroupDuplicateSettingsModel.class);
        GroupModel groupDuplicatedResponse = null;
        try {
            tx = this.em.getTransaction();
            tx.begin();
            GroupModel groupDuplicated = this.session.groups().createGroup(realmModel, parameters.getGroupName());
            groupDuplicated.setParent(group.getParent());
            Utils.setGroupAttribute(groupDuplicated, "olvid-managed", "true");
            group.getAttributes().forEach((arg_0, arg_1) -> ((GroupModel)groupDuplicated).setAttribute(arg_0, arg_1));
            Utils.setGroupAttribute(groupDuplicated, "olvid-name", parameters.getOlvidName());
            try {
                OlvidGroup olvidGroup;
                if (parameters.getWithGroupAvatar().booleanValue() && (olvidGroup = OlvidGroupDao.getOlvidGroupById(this.em, realmModel.getId(), group.getId())) != null) {
                    byte[] groupPhotoUid = olvidGroup.getGroupPhotoUid();
                    OlvidData groupData = OlvidDataDao.getOlvidDataByUid(this.em, realmModel.getId(), groupPhotoUid);
                    if (groupData != null) {
                        OlvidGroup olvidGroupDuplicated = OlvidGroup.createOlvidGroupFromModelAndSign(this.session, this.em, realmModel, groupDuplicated, this.objectMapper, new SecureRandom());
                        this.em.persist((Object)olvidGroupDuplicated);
                        OlvidData olvidDataDuplicated = new OlvidData();
                        byte[] dataDuplicatedUid = this.setOlvidDataAvatar(groupData.getData(), realmModel, olvidDataDuplicated);
                        olvidGroupDuplicated.setGroupPhotoUid(dataDuplicatedUid);
                        this.em.merge((Object)olvidGroupDuplicated);
                    }
                }
            }
            catch (Exception olvidGroup) {
                // empty catch block
            }
            this.updateOlvidGroupAndNotify(realmModel, groupDuplicated);
            groupDuplicatedResponse = groupDuplicated;
            isDone = true;
        }
        finally {
            if (isDone) {
                tx.commit();
                try {
                    if (parameters.getWithGroupMembers().booleanValue()) {
                        List<UserModel> groupMembers = this.session.users().getGroupMembersStream(realmModel, group).collect(Collectors.toList());
                        GroupModel finalGroupDuplicatedResponse = this.session.groups().getGroupById(realmModel, groupDuplicatedResponse.getId());
                        groupMembers.forEach(user -> {
                            UserModel userFound = this.session.users().getUserById(realmModel, user.getId());
                            userFound.joinGroup(finalGroupDuplicatedResponse);
                        });
                        this.updateOlvidGroupAndNotify(realmModel, finalGroupDuplicatedResponse);
                    }
                }
                catch (Exception groupMembers) {}
            } else if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
        try {
            String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  duplicate group: " + group.getName() + ",\n  with parameters : \n  with Group' Members: " + parameters.getWithGroupMembers().toString() + "\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "groupDuplicate", "Group duplicated:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        int userGroupsLimit = 10000;
        int userGroupsOffset = 0;
        GroupUserModel groupUsers = this.getGroupUsers(groupDuplicatedResponse.getId(), realmModel, "", new ArrayList<String>(), userGroupsLimit, userGroupsOffset, true, new ArrayList<String>());
        DuplicateGroupResponseModel responseModel = new DuplicateGroupResponseModel();
        responseModel.setGroup(groupUsers);
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processSetUpGroupAvatar(String realmName, byte[] dataBytes, String groupId, String groupName) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        EntityTransaction tx = null;
        boolean isDone = false;
        OlvidData olvidData = new OlvidData();
        Collection<UserOrTopicToNotify> notificationsToSend = null;
        GetGroupAvatarResponseModel responseModel = new GetGroupAvatarResponseModel();
        Object avatarUrl = "";
        responseModel.setAvatarUrl((String)avatarUrl);
        try {
            tx = this.em.getTransaction();
            tx.begin();
            byte[] dataUid = this.setOlvidDataAvatar(dataBytes, realmModel, olvidData);
            GroupModel groupModel = this.session.groups().getGroupById(realmModel, groupId);
            if (groupModel == null) {
                logger.error((Object)"In processSetUpGroupAvatar: group not found");
                GenericReponseModel response = new GenericReponseModel();
                response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "In processSetUpGroupAvatar: group not found", false);
                Response response2 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
                return response2;
            }
            OlvidGroup olvidGroup = OlvidGroupDao.getOlvidGroupById(this.em, realmModel.getId(), groupId);
            if (olvidGroup == null) {
                try {
                    olvidGroup = OlvidGroup.createOlvidGroupFromModelAndSign(this.session, this.em, realmModel, groupModel, this.objectMapper, new SecureRandom());
                    this.em.persist((Object)olvidGroup);
                }
                catch (Exception e) {
                    logger.error((Object)"In processSetUpGroupAvatar: unable to create OlvidGroup", (Throwable)e);
                    GenericReponseModel response = new GenericReponseModel();
                    response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
                    Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
                    if (isDone) {
                        tx.commit();
                        if (notificationsToSend != null) {
                            CronScheduler.scheduleSendNotifications(notificationsToSend);
                        }
                    } else if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                    return response3;
                }
            }
            olvidGroup.setGroupPhotoUid(dataUid);
            this.em.merge((Object)olvidGroup);
            if (Utils.isOlvidGroup(groupModel)) {
                try {
                    notificationsToSend = OlvidGroupDao.enableThenUpdateOlvidGroupIfNeededAndGetMembersToNotify(this.session, this.em, realmModel, groupModel, this.objectMapper, new SecureRandom());
                }
                catch (Exception e) {
                    logger.error((Object)"In processSetUpGroupAvatar: unable to updateOlvidGroupIfNeededAndGetMembersToNotify", (Throwable)e);
                    GenericReponseModel response = new GenericReponseModel();
                    response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
                    Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
                    if (isDone) {
                        tx.commit();
                        if (notificationsToSend != null) {
                            CronScheduler.scheduleSendNotifications(notificationsToSend);
                        }
                    } else if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                    return response4;
                }
            }
            avatarUrl = "data:image/jpeg;base64," + Base64.getEncoder().encodeToString(olvidData.getData());
            responseModel.setAvatarUrl((String)avatarUrl);
            isDone = true;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (isDone) {
                tx.commit();
                if (notificationsToSend != null) {
                    CronScheduler.scheduleSendNotifications(notificationsToSend);
                }
            } else if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
        try {
            String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  groupName: " + groupName + ",\n  setUp Group Avatar : " + olvidData.getDataUid() + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "groupEdit", "Group edited:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    protected byte[] setOlvidDataAvatar(byte[] dataBytes, RealmModel realmModel, OlvidData olvidData) {
        olvidData.setData(dataBytes);
        olvidData.setRealmId(realmModel.getId());
        byte[] dataUid = PRNGHolder.get().bytes(32);
        String dataUidString = Base64.getEncoder().encodeToString(dataUid);
        olvidData.setDataUid(dataUidString);
        olvidData.setEncodedDataKey(Encoded.of(AuthEncAES256ThenSHA256Key.generate(PRNGHolder.get())).getBytes());
        OlvidData.insert(this.em, olvidData);
        return dataUid;
    }

    private Response processRemoveGroupAvatar(String realmName, String groupId) throws JsonProcessingException {
        String olvidGroupName;
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        EntityTransaction tx = null;
        boolean isDone = false;
        Collection<UserOrTopicToNotify> notificationsToSend = null;
        try {
            tx = this.em.getTransaction();
            tx.begin();
            GroupModel groupModel = this.session.groups().getGroupById(realmModel, groupId);
            if (groupModel == null) {
                logger.error((Object)"In processRemoveGroupAvatar: group not found");
                GenericReponseModel response = new GenericReponseModel();
                response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "In processRemoveGroupAvatar: group not found", false);
                Response response2 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
                return response2;
            }
            olvidGroupName = groupModel.getName();
            OlvidGroup olvidGroup = OlvidGroupDao.getOlvidGroupById(this.em, realmModel.getId(), groupId);
            if (olvidGroup == null) {
                logger.error((Object)"In processRemoveGroupAvatar: OlvidGroup doesn't exist");
                GenericReponseModel response = new GenericReponseModel();
                response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "In processRemoveGroupAvatar: OlvidGroup doesn't exist", false);
                Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
                return response3;
            }
            olvidGroup.setGroupPhotoUid(null);
            this.em.merge((Object)olvidGroup);
            if (Utils.isOlvidGroup(groupModel)) {
                try {
                    notificationsToSend = OlvidGroupDao.enableThenUpdateOlvidGroupIfNeededAndGetMembersToNotify(this.session, this.em, realmModel, groupModel, this.objectMapper, new SecureRandom());
                }
                catch (Exception e) {
                    logger.error((Object)"In processSetUpGroupAvatar: unable to updateOlvidGroupIfNeededAndGetMembersToNotify", (Throwable)e);
                    GenericReponseModel response = new GenericReponseModel();
                    response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
                    Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
                    if (isDone) {
                        tx.commit();
                        if (notificationsToSend != null) {
                            CronScheduler.scheduleSendNotifications(notificationsToSend);
                        }
                    } else if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                    return response4;
                }
            }
            isDone = true;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (isDone) {
                tx.commit();
                if (notificationsToSend != null) {
                    CronScheduler.scheduleSendNotifications(notificationsToSend);
                }
            } else if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
        try {
            String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  groupName: " + olvidGroupName + ",\n  removed group avatar\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "groupEdit", "Group edited:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        RemoveGroupAvatarResponseModel responseModel = new RemoveGroupAvatarResponseModel();
        responseModel.setStatus(new ResponseConstants().STATUS_SUCCESS);
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response processDeleteGroup(String realmName, String groupId) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        EntityTransaction tx = null;
        boolean isDone = false;
        Collection<UserOrTopicToNotify> notificationsToSend = null;
        GroupModel groupModel = this.session.groups().getGroupById(realmModel, groupId);
        if (groupModel == null) {
            logger.error((Object)"In processDeleteAvatar: group not found");
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "In processDeleteAvatar: group not found", false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        String groupName = groupModel.getName();
        try {
            tx = this.em.getTransaction();
            tx.begin();
            OlvidGroup olvidGroup = OlvidGroupDao.getOlvidGroupById(this.em, realmModel.getId(), groupId);
            if (olvidGroup != null) {
                if (Utils.isOlvidGroup(groupModel)) {
                    try {
                        notificationsToSend = OlvidGroupDao.disableGroupAndGetMembersToNotify(this.session, this.objectMapper, this.em, realmModel, olvidGroup);
                    }
                    catch (Exception e) {
                        logger.error((Object)"In processSetUpGroupAvatar: unable to updateOlvidGroupIfNeededAndGetMembersToNotify", (Throwable)e);
                        GenericReponseModel response = new GenericReponseModel();
                        response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
                        Response response2 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
                        if (isDone) {
                            tx.commit();
                            if (notificationsToSend != null) {
                                CronScheduler.scheduleSendNotifications(notificationsToSend);
                            }
                            this.session.groups().removeGroup(realmModel, groupModel);
                        } else if (tx != null && tx.isActive()) {
                            tx.rollback();
                        }
                        return response2;
                    }
                }
                this.em.remove((Object)olvidGroup);
            }
            isDone = true;
        }
        finally {
            if (isDone) {
                tx.commit();
                if (notificationsToSend != null) {
                    CronScheduler.scheduleSendNotifications(notificationsToSend);
                }
                this.session.groups().removeGroup(realmModel, groupModel);
            } else if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
        try {
            String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  groupName: " + groupName + ",\n  delete group\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "groupDelete", "Group edited:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(new HashMap(), new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processAddOlvidGroupUsers(String realmName, String groupId, List<String> usersList) throws Exception {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        GroupModel groupModel = this.session.groups().getGroupById(realmModel, groupId);
        if (groupModel == null) {
            return this.invalidRequest();
        }
        ArrayList usernamesList = new ArrayList();
        usersList.forEach(userId -> {
            UserModel user = this.session.users().getUserById(realmModel, userId);
            if (user != null) {
                user.joinGroup(groupModel);
                usernamesList.add(user.getUsername());
            }
        });
        try {
            String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  groupName: " + groupModel.getName() + ",\n  add users : " + String.valueOf(usernamesList) + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "groupEdit", "Group edited:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        this.updateOlvidGroupAndNotify(realmModel, groupModel);
        AddGroupUserResponseModel responseModel = new AddGroupUserResponseModel();
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processRemoveOlvidGroupUsers(String realmName, String groupId, List<String> dataArray) throws Exception {
        return this.getResponseProcessRemoveOlvidGroupUsers(realmName, groupId, dataArray);
    }

    protected Response getResponseProcessRemoveOlvidGroupUsers(String realmName, String groupId, List<String> usersList) throws Exception {
        GenericReponseModel response;
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        GroupModel groupModel = this.session.groups().getGroupById(realmModel, groupId);
        if (groupModel == null) {
            return this.invalidRequest();
        }
        ArrayList usersListName = new ArrayList();
        usersList.forEach(userId -> {
            UserModel user = this.session.users().getUserById(realmModel, userId);
            if (user != null) {
                user.leaveGroup(groupModel);
                usersListName.add(user.getUsername());
            }
        });
        try {
            String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  groupName: " + groupModel.getName() + ",\n  remove users : " + String.valueOf(usersListName) + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "groupEdit", "Group edited:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        this.updateOlvidGroupAndNotify(realmModel, groupModel);
        try {
            RemoveOlvidGroupUsersResponseModel responseModel = new RemoveOlvidGroupUsersResponseModel();
            responseModel.setStatus(new ResponseConstants().STATUS_SUCCESS);
            response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processRemoveManagers(String role, ArrayList<String> managerIdList) {
        Optional<RealmModel> adminRealm = this.session.realms().getRealmsStream().filter(realmModel -> OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "admin", false)).findFirst();
        if (!adminRealm.isPresent()) {
            logger.warn((Object)"Manager user creation: Could not find any admin realm");
            return this.invalidRequest();
        }
        RealmModel adminRealmModel = adminRealm.get();
        for (String s : managerIdList) {
            if (this.authenticatedUser.getUsername().equals(s) && this.authenticatedUserRealm.getId().equals(adminRealmModel.getId())) continue;
            UserModel userModel = this.session.users().getUserByUsername(adminRealmModel, s);
            UserManager um = new UserManager(this.session);
            um.removeUser(adminRealmModel, userModel);
            try {
                String logs = " [\n  username: " + userModel.getUsername() + ",\n  realm Id: " + adminRealmModel.getId() + ",\n  realm Name: " + adminRealmModel.getName() + ",\n" + (String)(!Utils.emptyStringOrTrim(userModel.getFirstName()).isEmpty() ? "  firstname: " + userModel.getFirstName() + ",\n" : "") + (String)(!Utils.emptyStringOrTrim(userModel.getUsername()).isEmpty() ? "  lastname: " + userModel.getUsername() + ",\n" : "") + "  email: " + userModel.getEmail() + ",\n  role: " + Utils.getUserAttribute(userModel, "olvid-role") + "\n]";
                logger.debug((Object)logs);
                HashMap<String, Object> ret = new HashMap<String, Object>();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, adminRealmModel, this.authenticatedUser.getUsername(), adminRealmModel.getName(), "adminDeletion", "Admin deletion:" + logs, ret);
            }
            catch (Exception exception) {}
        }
        ArrayList<String> filters = new ArrayList<String>();
        String tabChose = "";
        return this.processGetManagersUsers(role, adminRealmModel.getName(), tabChose, filters, 10, 0);
    }

    protected Response processSendAutomaticPasswordEmail(String password, String username, String isocode, String realmName) {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        RealmModel masterRealm = this.session.realms().getRealmByName("master");
        UserModel userModel = this.session.users().getUserByUsername(realmModel, Utils.emptyStringOrTrim(username));
        return this.sendEmailAndGetResponse(masterRealm, userModel, Email.getCreateUserEmailSubject(this.session, isocode, userModel), Email.getCreateUserEmailBodyText(this.session, isocode, userModel, password), Email.getCreateUserEmailBodyHTML(this.session, isocode, userModel, password));
    }

    protected Response processSendAutomaticPasswordEmailReseted(String password, String username, String isocode, String realmName) {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        RealmModel masterRealm = this.session.realms().getRealmByName("master");
        UserModel userModel = this.session.users().getUserByUsername(realmModel, Utils.emptyStringOrTrim(username));
        return this.sendEmailAndGetResponse(masterRealm, userModel, Email.getPasswordResetEmailSubject(this.session, isocode, userModel), Email.getPasswordResetEmailBodyText(this.session, isocode, userModel, password), Email.getPasswordResetEmailBodyHTML(this.session, isocode, userModel, password));
    }

    private Response processSendUserOldDeviceAlert(String id, String username, String isocode, String realmName) {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        RealmModel masterRealm = this.session.realms().getRealmByName("master");
        UserModel userModel = this.session.users().getUserByUsername(realmModel, Utils.emptyStringOrTrim(username));
        TypedQuery q = this.em.createNamedQuery("OlvidUserDevice.getByIdAndDeviceUid", OlvidUserDevice.class);
        q.setParameter("realmId", (Object)realmModel.getId());
        q.setParameter("userId", (Object)userModel.getId());
        q.setParameter("deviceUid", (Object)id);
        OlvidUserDevice olvidUserDevice = (OlvidUserDevice)q.getSingleResult();
        String displayName = olvidUserDevice.getDisplayName();
        return this.sendEmailAndGetResponse(masterRealm, userModel, Email.getUserOldDeviceAlertSubject(isocode), Email.getUserOldDeviceAlertBodyText(isocode, userModel.getUsername(), displayName), Email.getUserOldDeviceAlertBodyHTML(isocode, userModel.getUsername(), displayName));
    }

    private Response processSendUserUnknownDeviceAlert(String id, String username, String isocode, String realmName) {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        RealmModel masterRealm = this.session.realms().getRealmByName("master");
        UserModel userModel = this.session.users().getUserByUsername(realmModel, Utils.emptyStringOrTrim(username));
        TypedQuery q = this.em.createNamedQuery("OlvidUserDevice.getByIdAndDeviceUid", OlvidUserDevice.class);
        q.setParameter("realmId", (Object)realmModel.getId());
        q.setParameter("userId", (Object)userModel.getId());
        q.setParameter("deviceUid", (Object)id);
        OlvidUserDevice olvidUserDevice = (OlvidUserDevice)q.getSingleResult();
        String displayName = olvidUserDevice.getDisplayName();
        return this.sendEmailAndGetResponse(masterRealm, userModel, Email.getUserUnknownDeviceAlertSubject(isocode), Email.getUserUnknownDeviceAlertBodyText(isocode, userModel.getUsername(), displayName), Email.getUserUnknownDeviceAlertBodyHTML(isocode, userModel.getUsername(), displayName));
    }

    private Response sendEmailAndGetResponse(RealmModel masterRealm, UserModel userModel, String emailSubject, String emailTextBody, String emailHtmlBody) {
        try {
            EmailSenderProvider emailSender = (EmailSenderProvider)this.session.getProvider(EmailSenderProvider.class);
            try {
                emailSender.send(masterRealm.getSmtpConfig(), userModel, emailSubject, emailTextBody, emailHtmlBody);
            }
            catch (Exception e) {
                logger.warn((Object)("Exception sendEmailAndGetResponse senderProvider e " + String.valueOf(e)));
                GenericReponseModel response = new GenericReponseModel();
                SendAutomaticPasswordResponseModel responseModel = new SendAutomaticPasswordResponseModel().setUpSendAutomaticPasswordResponseModel(false);
                CustomUserModel olvidUser = new CustomUserModel();
                CustomUserModel userModelCustom = olvidUser.initCustomUserModel(this.em, this.session, masterRealm, olvidUser, userModel, new OlvidCircleVisibility());
                response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_ERROR, 1, userModelCustom.toString(), true);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).type("application/json").build();
            }
            GenericReponseModel response = new GenericReponseModel();
            SendAutomaticPasswordResponseModel responseModel = new SendAutomaticPasswordResponseModel().setUpSendAutomaticPasswordResponseModel(true);
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception sendEmailAndGetResponse e ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            SendAutomaticPasswordResponseModel responseModel = new SendAutomaticPasswordResponseModel().setUpSendAutomaticPasswordResponseModel(false);
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_ERROR, 1, userModel.toString(), true);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).type("application/json").build();
        }
    }

    private Response processResetManagerPassword(ArrayList<String> managersListString) throws JsonProcessingException {
        ArrayList<String> managerUsersListError = new ArrayList<String>();
        Optional<RealmModel> adminRealm = this.session.realms().getRealmsStream().filter(realmModel -> OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "admin", false)).findFirst();
        if (!adminRealm.isPresent()) {
            logger.warn((Object)"Manager user reset password error: could not find any admin realm");
            return this.invalidRequest();
        }
        RealmModel realmModel2 = adminRealm.get();
        ArrayList<UserModel> managerUsersList = new ArrayList<UserModel>();
        for (String string : managersListString) {
            UserModel managerUser = this.session.users().getUserByUsername(realmModel2, string);
            if (managerUser == null || string.isEmpty()) {
                logger.warn((Object)"Manager user reset password error: one or mode username not exists or invalid request");
                managerUsersListError.add(string);
                continue;
            }
            managerUsersList.add(managerUser);
        }
        ArrayList<CustomBasicWithPasswordModel> dataRet = new ArrayList<CustomBasicWithPasswordModel>();
        for (UserModel managerUser : managerUsersList) {
            PasswordPolicy passwordPolicy = realmModel2.getPasswordPolicy();
            String password = this.generateRandomPassword(passwordPolicy);
            try {
                this.setUserPassword(managerUser, password, passwordPolicy);
            }
            catch (Exception e) {
                logger.warn((Object)"Manager user update error: unable to create password for account (no hash provider found)");
                managerUsersListError.add(managerUser.getUsername());
                continue;
            }
            CustomBasicWithPasswordModel dataRetObject = new CustomBasicWithPasswordModel();
            dataRetObject.setUsername(managerUser.getUsername());
            dataRetObject.setEmail(managerUser.getEmail());
            dataRetObject.setPassword(password);
            try {
                String logs = " [\n  username: " + managerUser.getUsername() + ",\n  realm Name: " + realmModel2.getName() + ",\n" + (String)(Utils.nullOrTrim(managerUser.getFirstName()) != null ? "  firstname: " + managerUser.getFirstName() + ",\n" : "") + (String)(Utils.nullOrTrim(managerUser.getLastName()) != null ? "  lastname: " + managerUser.getLastName() + ",\n" : "") + "  email: " + managerUser.getEmail() + ",\n  role: " + Utils.getUserAttribute(managerUser, "olvid-role") + "\n]";
                logger.debug((Object)logs);
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel2, this.authenticatedUser.getUsername(), realmModel2.getName(), "adminUpdate", "Admin updated:" + logs, new HashMap<String, Object>());
            }
            catch (Exception exception) {
                // empty catch block
            }
            dataRet.add(dataRetObject);
        }
        Map map = this.session.realms().getRealmByName("master").getSmtpConfig();
        UpdateUserResetPasswordResponseModel responseModel = new UpdateUserResetPasswordResponseModel();
        responseModel.updateManagerResetPasswordResponseModel(dataRet, managerUsersListError, map.isEmpty() || map.get("host") == null || ((String)map.get("host")).isEmpty() || map.get("from") == null || ((String)map.get("from")).isEmpty());
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processResetUserPassword(ArrayList<String> usersListString, String passwordCustom, String realmName) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(realmName);
        ArrayList<UserModel> usersList = new ArrayList<UserModel>();
        ArrayList<String> errorsList = new ArrayList<String>();
        for (String string : usersListString) {
            UserModel user = this.session.users().getUserByUsername(realmModel, string);
            if (user == null || string.isEmpty()) {
                logger.warn((Object)"User reset password error: one or more username does not exist (or invalid request)");
                errorsList.add(string);
                continue;
            }
            usersList.add(user);
        }
        ArrayList<CustomBasicWithPasswordModel> dataArray = new ArrayList<CustomBasicWithPasswordModel>();
        for (UserModel user : usersList) {
            PasswordPolicy passwordPolicy = realmModel.getPasswordPolicy();
            String password = "";
            if (passwordCustom == null) {
                user.credentialManager().getStoredCredentialsByTypeStream("password").forEach(credentialModel -> user.credentialManager().removeStoredCredentialById(credentialModel.getId()));
                Utils.setUserAttribute(user, "one-time-password", null);
            } else {
                password = passwordCustom.trim().isEmpty() ? this.generateRandomPassword(passwordPolicy) : passwordCustom.trim();
                try {
                    this.setUserPassword(user, password, passwordPolicy);
                }
                catch (Exception e) {
                    logger.warn((Object)"User update error: unable to create password for account (no hash provider found)");
                    errorsList.add(user.getUsername());
                    continue;
                }
            }
            CustomBasicWithPasswordModel dataRetObject = new CustomBasicWithPasswordModel();
            dataRetObject.setUsername(user.getUsername());
            dataRetObject.setPassword(password);
            dataRetObject.setEmail(user.getEmail());
            try {
                String logs = " [\n  username: " + user.getUsername() + ",\n  realm Name: " + realmModel.getName() + ",\n" + (String)(Utils.nullOrTrim(user.getFirstName()) != null ? "  firstname: " + user.getFirstName() + ",\n" : "") + (String)(Utils.nullOrTrim(user.getLastName()) != null ? "  lastname: " + user.getLastName() + ",\n" : "") + "  email: " + user.getEmail() + ",\n  role: " + Utils.getUserAttribute(user, "olvid-role") + "\n]";
                logger.debug((Object)logs);
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "userCreation", "User created:" + logs, new HashMap<String, Object>());
            }
            catch (Exception exception) {
                // empty catch block
            }
            dataArray.add(dataRetObject);
        }
        UpdateUserResetPasswordResponseModel updateUserResetPasswordResponseModel = new UpdateUserResetPasswordResponseModel();
        updateUserResetPasswordResponseModel.setData(dataArray);
        updateUserResetPasswordResponseModel.setErrors(errorsList);
        Map masterSmtpConfig = this.session.realms().getRealmByName("master").getSmtpConfig();
        updateUserResetPasswordResponseModel.setSmtpError(masterSmtpConfig.isEmpty() || masterSmtpConfig.get("host") == null || ((String)masterSmtpConfig.get("host")).isEmpty() || masterSmtpConfig.get("from") == null || ((String)masterSmtpConfig.get("from")).isEmpty());
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(updateUserResetPasswordResponseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            response.setData(updateUserResetPasswordResponseModel);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    protected PasswordHashProvider getHashProvider(PasswordPolicy policy) {
        if (policy != null && policy.getHashAlgorithm() != null) {
            return (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class, policy.getHashAlgorithm());
        }
        return (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class);
    }

    protected Response processGetEmailContent(String isocode, String emailType) throws JsonProcessingException {
        String dataRet = "";
        if (emailType.contains(EmailConstants.CREATE_USER)) {
            dataRet = Email.getCreateUserEmailBodyHTML(this.session, isocode, null, null);
        } else if (emailType.contains(EmailConstants.RESET_PASSWORD)) {
            dataRet = Email.getPasswordResetEmailBodyHTML(this.session, isocode, null, null);
        } else if (emailType.contains(EmailConstants.ALERT_USER_OLD_SYNC)) {
            dataRet = Email.getUserOldDeviceAlertBodyHTML(isocode, "[OlvidUser]", "[DisplayName]");
        } else if (emailType.contains(EmailConstants.ALERT_USER_UNKNOWN_DEVICE)) {
            dataRet = Email.getUserUnknownDeviceAlertBodyHTML(isocode, "[OlvidUser]", "[DisplayName]");
        }
        GetEmailContentResponseModel responseModel = new GetEmailContentResponseModel();
        responseModel.setData(dataRet);
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processCreateBot(byte[] postData) throws JsonProcessingException {
        boolean legacy;
        CreateBotPayloadModel request;
        if (postData == null || postData.length == 0) {
            logger.warn((Object)"Invalid request : CreateBot: no payload in request");
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 3, "Invalid request : CreateBot: no payload in request", false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        try {
            request = (CreateBotPayloadModel)this.objectMapper.readValue(postData, CreateBotPayloadModel.class);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception CreateBot: Unable to parse request", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 3, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        RealmModel realmModel = this.session.realms().getRealmByName(request.getRealmName());
        if (realmModel == null) {
            logger.warn((Object)"Internal Error : CreateBot: Unable to get requested realm");
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 3, "Realm do not exists: " + request.getRealmName(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "enableBotsManagement", false)) {
            logger.warn((Object)"Internal Error : Bots management disabled");
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 3, "Bots management disabled", false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        if (request.getUsername() == null || request.getRealmName() == null || request.getFirstname() == null && request.getLastname() == null) {
            logger.warn((Object)"Invalid Request CreateBot: Missing required fields");
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 3, "Invalid Request CreateBot: Missing required fields", false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        if (this.session.users().getUserByUsername(realmModel, request.getUsername()) != null) {
            logger.warn((Object)"CreateBot: username already used");
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 3, "Username already exists: " + request.getUsername(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        boolean bl = legacy = !OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "enableAuthenticationWithOlvidId", false);
        if (legacy) {
            ClientModel client = realmModel.getClientByClientId("olvid-bot-client");
            if (client == null) {
                client = realmModel.addClient("olvid-bot-client");
                client.setEnabled(true);
                client.setDirectAccessGrantsEnabled(true);
                client.setClientAuthenticatorType("client-secret");
                client.setSecret(UUID.randomUUID().toString());
                client.setProtocol("openid-connect");
                ClientScopeModel[] offlineAccess = new ClientScopeModel[1];
                realmModel.getClientScopesStream().forEach(clientScopeModel -> {
                    if (clientScopeModel.getName().equals("offline_access")) {
                        offlineAccess[0] = clientScopeModel;
                    }
                });
                if (offlineAccess[0] != null) {
                    client.addClientScope(offlineAccess[0], false);
                } else {
                    logger.warn((Object)"Unable to find offline scopes for bot client");
                }
                client.setAttribute("client.offline.session.idle.timeout", "86400000000");
                client.setAttribute("client.offline.session.max.lifespan", "86400000000");
                logger.info((Object)"CreateBot: Created bot client");
            }
            UserModel botUser = this.session.users().addUser(realmModel, request.getUsername());
            botUser.setFirstName(request.getFirstname());
            botUser.setLastName(request.getLastname());
            Utils.setUserAttribute(botUser, "olvid-company", request.getCompany());
            Utils.setUserAttribute(botUser, "olvid-position", request.getPosition());
            Utils.setUserAttribute(botUser, "olvid-is-bot", "true");
            Utils.setUserAttribute(botUser, "one-time-password", "true");
            Utils.setUserAttribute(botUser, "olvid-role", request.getRole());
            botUser.setEnabled(true);
            String password = UUID.randomUUID().toString();
            PasswordPolicy passwordPolicy = realmModel.getPasswordPolicy();
            PasswordPolicy policy = this.session.getContext().getRealm().getPasswordPolicy();
            PasswordHashProvider hashProvider = this.getHashProvider(policy);
            if (hashProvider == null) {
                logger.warn((Object)"Internal Error: legacy: Unable to create password for bot account: no hash provider found");
                GenericReponseModel response = new GenericReponseModel();
                response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 3, "Hash provider not found", false);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
            }
            PasswordCredentialModel credentialModel = hashProvider.encodedCredential(password, passwordPolicy.getHashIterations());
            credentialModel.setCreatedDate(Long.valueOf(Time.currentTimeMillis()));
            botUser.credentialManager().createStoredCredential((CredentialModel)credentialModel);
            String logs = " [\n  bot: " + botUser.getUsername() + ",\n  realmName: " + realmModel.getName() + ",\n" + (String)(!Utils.emptyStringOrTrim(botUser.getFirstName()).isEmpty() ? "  firstname: " + botUser.getFirstName() + ",\n" : "") + (String)(!Utils.emptyStringOrTrim(botUser.getLastName()).isEmpty() ? "  lastname: " + botUser.getLastName() + ",\n" : "") + "  email: " + botUser.getEmail() + ",\n  (legacy),\n]";
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "botCreation", "Bot created:" + logs, ret);
            try {
                String legacyConfigurationLink = ConfigurationLinkHelper.getLegacyBotConfigurationLink(this.em, this.session, realmModel, client, botUser.getUsername(), password);
                CreateUserMagicLinkResponseModel responseModel = new CreateUserMagicLinkResponseModel();
                responseModel.setConfigurationUrl(legacyConfigurationLink);
                GenericReponseModel response = new GenericReponseModel();
                response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
                return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
            }
            catch (JsonProcessingException e) {
                logger.warn((Object)"ResetBotLink: legacy: unable to serialize response");
                logger.warn((Object)"Exception : ", (Throwable)e);
                GenericReponseModel response = new GenericReponseModel();
                response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 3, e.getMessage(), false);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
            }
        }
        UserModel botUser = this.session.users().addUser(realmModel, request.getUsername());
        botUser.setFirstName(request.getFirstname());
        botUser.setLastName(request.getLastname());
        Utils.setUserAttribute(botUser, "olvid-company", request.getCompany());
        Utils.setUserAttribute(botUser, "olvid-position", request.getPosition());
        Utils.setUserAttribute(botUser, "olvid-is-bot", "true");
        Utils.setUserAttribute(botUser, "olvid-role", request.getRole());
        botUser.setEnabled(true);
        MagicTokenModel magicTokenModel = MagicTokenModel.generateNewToken(null);
        botUser.credentialManager().createStoredCredential((CredentialModel)magicTokenModel);
        String logs = " [\n  bot: " + botUser.getUsername() + ",\n  realmName: " + realmModel.getName() + ",\n" + (String)(!Utils.emptyStringOrTrim(botUser.getFirstName()).isEmpty() ? "  firstname: " + botUser.getFirstName() + ",\n" : "") + (String)(!Utils.emptyStringOrTrim(botUser.getLastName()).isEmpty() ? "  lastname: " + botUser.getLastName() + ",\n" : "") + "  email: " + botUser.getEmail() + ",\n]";
        HashMap<String, Object> ret = new HashMap<String, Object>();
        OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "botCreation", "Bot created:" + logs, ret);
        try {
            String botMagicLink = ConfigurationLinkHelper.getBotConfigurationLink(this.em, this.session, realmModel, botUser.getUsername(), magicTokenModel.getToken());
            CreateUserMagicLinkResponseModel responseModel = new CreateUserMagicLinkResponseModel();
            responseModel.setConfigurationUrl(botMagicLink);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (JsonProcessingException e) {
            logger.warn((Object)"ResetBotLink: unable to serialize response");
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 3, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processResetBotLink(String realmName, String id) throws JsonProcessingException {
        boolean legacy;
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "enableBotsManagement", false)) {
            logger.warn((Object)"Internal Error : Bots management disabled");
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 3, "Bots management disabled", false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        if (id == null) {
            logger.warn((Object)"Invalid request : ResetLinkBot: no botId in request");
            return this.invalidRequest();
        }
        UserModel bot = this.session.users().getUserById(realmModel, id);
        if (bot == null || !Utils.isBotUser(bot)) {
            logger.warn((Object)"Received a resetBotLink request for a user Id that is not a bot (or does not exist)");
            return this.invalidRequest();
        }
        this.signOutUser(realmName, id);
        bot.credentialManager().getStoredCredentialsStream().forEach(credentialModel -> bot.credentialManager().removeStoredCredentialById(credentialModel.getId()));
        bot.setEnabled(true);
        boolean bl = legacy = !OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "enableAuthenticationWithOlvidId", false);
        if (legacy) {
            ClientModel client = realmModel.getClientByClientId("olvid-bot-client");
            if (client == null) {
                logger.warn((Object)"Received a resetBotLink request and olvid bot client does not exist");
                GenericReponseModel response = new GenericReponseModel();
                response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "Received a resetBotLink request and olvid bot client does not exist", false);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
            }
            bot.setAttribute("one-time-password", Collections.singletonList("true"));
            String password = UUID.randomUUID().toString();
            PasswordPolicy passwordPolicy = realmModel.getPasswordPolicy();
            PasswordPolicy policy = this.session.getContext().getRealm().getPasswordPolicy();
            PasswordHashProvider hashProvider = this.getHashProvider(policy);
            if (hashProvider == null) {
                logger.warn((Object)"Internal Error: legacy : Unable to create password for bot account: no hash provider found");
                GenericReponseModel response = new GenericReponseModel();
                response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 3, "Hash provider not found", false);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
            }
            PasswordCredentialModel credentialModel2 = hashProvider.encodedCredential(password, passwordPolicy.getHashIterations());
            credentialModel2.setCreatedDate(Long.valueOf(Time.currentTimeMillis()));
            bot.credentialManager().createStoredCredential((CredentialModel)credentialModel2);
            try {
                String logs = " [\n  bot: " + bot.getUsername() + ",\n  realmName: " + realmModel.getName() + ",\n" + (String)(!Utils.emptyStringOrTrim(bot.getFirstName()).isEmpty() ? "  firstname: " + bot.getFirstName() + ",\n" : "") + (String)(!Utils.emptyStringOrTrim(bot.getLastName()).isEmpty() ? "  lastname: " + bot.getLastName() + ",\n" : "") + "  email: " + bot.getEmail() + ",\n]";
                HashMap<String, Object> ret = new HashMap<String, Object>();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "botResetLink", "Bot's link reseted:" + logs, ret);
            }
            catch (Exception logs) {
                // empty catch block
            }
            try {
                String legacyConfigurationLink = ConfigurationLinkHelper.getLegacyBotConfigurationLink(this.em, this.session, realmModel, client, bot.getUsername(), password);
                return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)legacyConfigurationLink), (String)"application/json").build();
            }
            catch (JsonProcessingException e) {
                logger.warn((Object)"ResetBotLink: unable to serialize response");
                logger.warn((Object)"Exception : ", (Throwable)e);
                GenericReponseModel response = new GenericReponseModel();
                response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 3, e.getMessage(), false);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
            }
        }
        MagicTokenModel magicTokenModel = MagicTokenModel.generateNewToken(null);
        bot.credentialManager().createStoredCredential((CredentialModel)magicTokenModel);
        try {
            String logs = " [\n  bot: " + bot.getUsername() + ",\n  realmName: " + realmModel.getName() + ",\n" + (String)(!Utils.emptyStringOrTrim(bot.getFirstName()).isEmpty() ? "  firstname: " + bot.getFirstName() + ",\n" : "") + (String)(!Utils.emptyStringOrTrim(bot.getLastName()).isEmpty() ? "  lastname: " + bot.getLastName() + ",\n" : "") + "  email: " + bot.getEmail() + ",\n]";
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "botResetLink", "Bot's link reseted:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        try {
            String botMagicLink = ConfigurationLinkHelper.getBotConfigurationLink(this.em, this.session, realmModel, bot.getUsername(), magicTokenModel.getToken());
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)botMagicLink), (String)"application/json").build();
        }
        catch (JsonProcessingException e) {
            logger.warn((Object)"ResetBotLink: unable to serialize response");
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 3, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processDownloadXslxCsv(String realmName, String format, String tabChose, List<String> filters, int offset) throws JsonProcessingException {
        Response ret = null;
        int userGroupsLimit = 1000;
        int userGroupsOffset = 0;
        if (format.contentEquals("users")) {
            ret = this.processDownloadUsersFormat(realmName, tabChose, filters, offset, userGroupsLimit, userGroupsOffset);
        } else if (format.contentEquals("devices")) {
            ret = this.processDownloadDevicesFormat(realmName, tabChose, filters, offset);
        } else if (format.contentEquals("externalLinks")) {
            ret = this.processDownloadExternalLinksFormat(realmName, tabChose, filters, offset);
        }
        return ret;
    }

    private Response processDownloadUsersFormat(String realmName, String tabChose, List<String> filters, int offset, int userGroupsLimit, int userGroupsOffset) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(realmName);
        int usersCount = this.session.users().getUsersCount(realmModel);
        TypedQuery<Object[]> query = this.buildUsersQueryLimited(realmModel.getId(), filters, 500, offset, Utils.emptyStringOrTrim(tabChose), new ArrayList<String>());
        List<CustomUserModel> olvidUsersList = query.getResultStream().map(result -> Configuration.createOlvidUserFromUserEntity(this.em, this.session, realmModel, (UserEntity)result[0], (OlvidCircleVisibility)result[1])).collect(Collectors.toList());
        DownloadXslxCsvUsersResponseModel responseModel = new DownloadXslxCsvUsersResponseModel();
        responseModel.setData(olvidUsersList);
        responseModel.setCount(usersCount);
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            String logs = " [\n  by manager's username: " + this.authenticatedUser.getUsername() + ",\n  realm Name: " + realmModel.getName() + ",\n  export users xslx or csv with: \n  tabChose: " + tabChose + ",\n  filters: " + String.valueOf(filters) + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "exportUsers", "Users exported:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception processDownloadUsersFormat e ", (Throwable)e);
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), true);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processDownloadDevicesFormat(String realmName, String tabChose, List<String> filters, int offset) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(realmName);
        Query countQuery = this.buildDevicesQueryCountWithFilter(realmModel.getId(), Utils.emptyStringOrTrim(tabChose), filters, new ArrayList<String>());
        Object devicesCount = countQuery.getSingleResult();
        TypedQuery<Object[]> query = this.buildDevicesQueryLimited(realmModel.getId(), filters, 500, offset, Utils.emptyStringOrTrim(tabChose));
        List olvidUserDeviceList = query.getResultStream().map(device -> new OlvidUserDeviceModel().newOlvidUserDevice(this.em, this.session, realmModel, (Object[])device, new OlvidCircleVisibility())).collect(Collectors.toList());
        try {
            String logs = " [\n  by manager's username: " + this.authenticatedUser.getUsername() + ",\n  realm Name: " + realmModel.getName() + ",\n  export devices xslx or csv with: \n  tabChose: " + tabChose + ",\n  filters: " + String.valueOf(filters) + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "exportDevices", "Devices exported:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        try {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("data", olvidUserDeviceList);
            response.put("count", devicesCount);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes(response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processDownloadExternalLinksFormat(String realmName, String tabChose, List<String> filters, int offset) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(realmName);
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        List<OlvidExternalLink> list = OlvidExternalLinkDao.getAllOlvidExternalLinkForRealmId(this.em, realmModel.getId(), filters);
        int count = list.size();
        list = list.subList(Math.min(count, offset), Math.min(count, offset + 500));
        List listFormated = list.stream().map(item -> new ExternalLinkModel().initExternalLinkModel(this.em, realmModel, this.objectMapper, (OlvidExternalLink)item)).collect(Collectors.toList());
        responseData.put("data", listFormated);
        responseData.put("count", count);
        try {
            String logs = " [\n  by manager's username: " + this.authenticatedUser.getUsername() + ",\n  realm Name: " + realmModel.getName() + ",\n  export external links xslx or csv with: \n  tabChose: " + tabChose + ",\n  filters: " + String.valueOf(filters) + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "externalLinks", "External links exported:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseData, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processGetDashboard(String role) throws JsonProcessingException {
        boolean writeAllowed = this.checkQueryIsAllowed(44, role);
        try {
            TypedQuery query = this.em.createQuery(" SELECT  r.id as realmId, u.username, oc.value, a.value as activated  FROM RealmEntity r LEFT JOIN OlvidConfiguration oc ON oc.realmId = r.id AND oc.name = 'serverKeycloakApiKey'  LEFT JOIN UserEntity u ON u.realmId = r.id LEFT JOIN u.attributes AS a ON a.name = 'olvid-identity'  WHERE r.id in ( SELECT oc2.realmId FROM OlvidConfiguration oc2 WHERE oc2.name = 'olvid' and oc2.value = 'true')", Object[].class);
            List resultFormated = query.getResultStream().map(DashboardJPAModel::initDashboardJPAModel).collect(Collectors.toList());
            List<String> realmIds = resultFormated.stream().map(DashboardJPAModel::getRealmId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            ArrayList<DashboardModel> dashboardModelsList = new ArrayList<DashboardModel>();
            ArrayList apiKeys = new ArrayList();
            realmIds.forEach(realmId -> {
                RealmModel realmModel = this.session.realms().getRealm(realmId);
                DashboardUsersModel dashboardUsersModel = new DashboardUsersModel();
                long usersActivated = resultFormated.stream().filter(DashboardJPAModel::isActivated).filter(result -> result.getRealmId().equals(realmId)).map(DashboardJPAModel::getUsername).distinct().count();
                dashboardUsersModel.setUsersActivated(usersActivated);
                if (realmModel != null) {
                    dashboardUsersModel.setCount((int)resultFormated.stream().filter(result -> result.getRealmId().equals(realmId)).map(DashboardJPAModel::getUsername).filter(Objects::nonNull).distinct().count());
                    DashboardLicensesModel dashboardLicensesModel = new DashboardLicensesModel();
                    String apiKey = resultFormated.stream().filter(result -> result.getRealmId().equals(realmId)).map(DashboardJPAModel::getValue).filter(Objects::nonNull).findAny().orElse(null);
                    if (apiKey != null && !apiKeys.contains(apiKey)) {
                        apiKeys.add(apiKey);
                    }
                    dashboardLicensesModel.setApiKey(apiKey);
                    dashboardLicensesModel.setOlvidApiKeyCount(usersActivated);
                    try {
                        if (apiKey != null) {
                            List<String> realmIdsWithSameApiKeys = resultFormated.stream().filter(result -> Objects.equals(result.getValue(), apiKey)).map(DashboardJPAModel::getRealmId).distinct().collect(Collectors.toList());
                            ArrayList<String> realmNamesWithSameApiKeys = new ArrayList<String>();
                            realmIdsWithSameApiKeys.forEach(realm -> {
                                try {
                                    realmNamesWithSameApiKeys.add(this.session.realms().getRealm(realm).getName());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            });
                            dashboardLicensesModel.setRealmNames(realmNamesWithSameApiKeys);
                        } else {
                            dashboardLicensesModel.setRealmNames(Collections.emptyList());
                        }
                        long licences = OlvidConfigurationDao.getLongConfiguration(this.em, realmId, "licensesCount", -1L);
                        if (licences < 0L) {
                            dashboardLicensesModel.setMissingInformation(true);
                            dashboardLicensesModel.setLicenseCount(0L);
                        } else {
                            dashboardLicensesModel.setMissingInformation(false);
                            dashboardLicensesModel.setLicenseCount(licences);
                        }
                        DashboardOldDataModel dashboardOldDataModel = new DashboardOldDataModel();
                        Query countQueryUsersOldLastSync = this.buildQueryCountWithFilter((String)realmId, "useroldlastsync", (List<String>)new ArrayList<String>(), (List<String>)new ArrayList<String>());
                        Object countResultUsersOldLastSync = countQueryUsersOldLastSync.getSingleResult();
                        HashMap<String, Object> users = new HashMap<String, Object>();
                        users.put("countResultUsersOldSync", countResultUsersOldLastSync);
                        dashboardOldDataModel.setUsers(users);
                        HashMap devices = new HashMap();
                        dashboardOldDataModel.setDevices(devices);
                        DashboardModel dashboardModel = new DashboardModel();
                        dashboardModel.setRealmId((String)realmId);
                        dashboardModel.setRealmName(realmModel.getName());
                        dashboardModel.setUsers(dashboardUsersModel);
                        dashboardModel.setLicenses(dashboardLicensesModel);
                        dashboardModel.setOldData(dashboardOldDataModel);
                        dashboardModelsList.add(dashboardModel);
                    }
                    catch (Exception e) {
                        logger.info((Object)"", (Throwable)e);
                    }
                }
            });
            apiKeys.forEach(apiKey -> {
                Long count = dashboardModelsList.stream().filter(realmModel -> Objects.equals(realmModel.getLicenses().apiKey, apiKey)).map(realm -> realm.getLicenses().olvidApiKeyCount).reduce(0L, Long::sum);
                dashboardModelsList.stream().filter(realmModel -> Objects.equals(realmModel.getLicenses().getApiKey(), apiKey)).forEach(dashboardModel -> {
                    DashboardLicensesModel licensesModel = dashboardModel.getLicenses();
                    licensesModel.setOlvidApiKeyCountOverRealms(count);
                });
            });
            GetDashboardResponseModel responseModel = new GetDashboardResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setData(dashboardModelsList);
            responseModel.setVersion("4.5.1");
            List olvidNotifications = new ArrayList();
            try {
                TypedQuery q = this.em.createNamedQuery("OlvidNotifications.getAllUnreadByRealm", OlvidNotifications.class);
                q.setParameter("realmId", (Object)"master");
                olvidNotifications = q.getResultList();
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
            responseModel.setNotificationUnreadCount(olvidNotifications.size());
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processGetNotifications(String role, String realmName, String tabChose, List<String> filters, int limit, int offset) throws JsonProcessingException {
        boolean writeAllowed = this.checkQueryIsAllowed(44, role);
        return this.getResponseProcessGetNotifications(realmName, writeAllowed, tabChose, filters, limit, offset);
    }

    protected Response getResponseProcessGetNotifications(String realmName, boolean writeAllowed, String tabChose, List<String> filters, int limit, int offset) throws JsonProcessingException {
        RealmModel realmModel = this.session.realms().getRealmByName(realmName);
        try {
            List<OlvidNotifications> olvidNotifications = new ArrayList<OlvidNotifications>();
            try {
                TypedQuery q = this.em.createNamedQuery("OlvidNotifications.getNotificationsByRealmAndType", OlvidNotifications.class);
                q.setParameter("realmId", (Object)"master");
                q.setParameter("isRead", (Object)false);
                q.setParameter("type", (Object)OlvidNotifications.NotificationType.pluginVersion.getStringValue());
                olvidNotifications = q.getResultList();
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
            GetNotificationsResponseModel responseModel = new GetNotificationsResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setNotificationVersions(olvidNotifications);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processSetNotificationRead(String role, List<String> dataArray) throws JsonProcessingException {
        if (this.authenticatedUser == null) {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "authenticatedUser == null", false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        boolean writeAllowed = this.checkQueryIsAllowed(44, role);
        if (writeAllowed) {
            try {
                dataArray.forEach(id -> {
                    if (id == null) {
                        this.em.getTransaction().begin();
                        List<OlvidNotifications> onList = OlvidNotificationsDao.getOlvidNotificationsVersion(this.em);
                        long timestamp = System.currentTimeMillis();
                        onList.forEach(on -> {
                            on.setIsRead(true);
                            on.setReadDate(timestamp);
                            on.setReaderUserId(this.authenticatedUser.getId());
                            this.em.merge(on);
                        });
                    }
                });
                return this.getResponseProcessGetNotifications("master", writeAllowed, "", new ArrayList<String>(), 0, 0);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                GenericReponseModel response = new GenericReponseModel();
                response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
            }
        }
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "not writeAllowed", false);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
    }

    private Response processSetGroupSharedSettings(UserModel authenticatedUser, String role, String realmName, String groupId, String data) throws JsonProcessingException {
        boolean writeAllowed = this.checkQueryIsAllowed(44, role);
        RealmModel realmModel = this.session.realms().getRealmByName(realmName);
        if (writeAllowed) {
            boolean isJsonSharedSettings = new JsonSharedSettings().isJsonSharedSettingsFormat(data);
            if (isJsonSharedSettings) {
                TypedQuery q = this.em.createNamedQuery("OlvidGroup.getById", OlvidGroup.class);
                q.setParameter("realmId", (Object)realmModel.getId());
                q.setParameter("keycloakGroupId", (Object)groupId);
                OlvidGroup result = (OlvidGroup)q.getSingleResult();
                result.setSerializedSharedSettings(data);
                this.em.merge((Object)result);
            }
            GroupModel groupModel = this.session.groups().getGroupById(realmModel, groupId);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(new HashMap(), new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            try {
                String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  groupName: " + groupModel.getName() + ",\n  new sharedSettings: " + data + "\n]";
                logger.debug((Object)logs);
                HashMap<String, Object> ret = new HashMap<String, Object>();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, authenticatedUser.getUsername(), realmModel.getName(), "groupEdit", "Group edited:" + logs, ret);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Response.ok(new HashMap(), (String)"application/json").build();
        }
        UpdateOlvidGroupByIdResponseModel responseModel = new UpdateOlvidGroupByIdResponseModel();
        responseModel.setStatus(true);
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processCreateUserMagicLink(byte[] postData) throws JsonProcessingException {
        CreateUserMagicLinkPayloadModel request;
        if (postData == null || postData.length == 0) {
            logger.warn((Object)"Invalid request : CreateUserMagicLink: no payload in request");
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 3, "Invalid request : CreateUserMagicLink: no payload in request", false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        try {
            request = (CreateUserMagicLinkPayloadModel)this.objectMapper.readValue(postData, CreateUserMagicLinkPayloadModel.class);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception CreateUserMagicLink: Unable to parse request", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 3, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        if (request.getUserId() == null || request.getRealmName() == null) {
            logger.error((Object)"Invalid Request CreateUserMagicLink: Missing required fields");
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 3, "Invalid Request CreateUserMagicLink: Missing required fields", false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        RealmModel realmModel = this.session.realms().getRealmByName(request.getRealmName());
        if (realmModel == null) {
            logger.warn((Object)"Internal Error : CreateUserMagicLink: Unable to get requested realm");
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "Realm do not exists: " + request.getRealmName(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        UserModel userModel = this.session.users().getUserById(realmModel, request.getUserId());
        if (userModel == null) {
            logger.error((Object)"CreateUserMagicLink: user not found");
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "User not found: " + request.getUserId(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        MagicTokenModel magicTokenModel = MagicTokenModel.generateNewToken(null);
        userModel.credentialManager().createStoredCredential((CredentialModel)magicTokenModel);
        try {
            String logs = " [\n  user: " + userModel.getUsername() + ",\n]";
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, realmModel, this.authenticatedUser.getUsername(), realmModel.getName(), "botCreation", "Magic link created:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        try {
            String magicLink = ConfigurationLinkHelper.generateMagicLink(this.em, this.session, realmModel, userModel.getUsername(), magicTokenModel.getToken());
            CreateUserMagicLinkResponseModel responseModel = new CreateUserMagicLinkResponseModel();
            responseModel.setConfigurationUrl(magicLink);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (JsonProcessingException e) {
            logger.error((Object)"CreateUserMagicLink: unable to serialize response", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processRevokeUserMagicLinks(byte[] postData) throws JsonProcessingException {
        RevokeUserMagicLinksPayloadModel request;
        if (postData == null || postData.length == 0) {
            logger.warn((Object)"Invalid request : RevokeUserMagicLink: no payload in request");
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 3, "Invalid request : RevokeUserMagicLink: no payload in request", false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        try {
            request = (RevokeUserMagicLinksPayloadModel)this.objectMapper.readValue(postData, RevokeUserMagicLinksPayloadModel.class);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception RevokeUserMagicLink: Unable to parse request", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 3, e.getMessage(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        if (request.getUserId() == null || request.getRealmName() == null) {
            logger.error((Object)"Invalid Request CreateUserMagicLink: Missing required fields");
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 3, "Invalid Request CreateUserMagicLink: Missing required fields", false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        RealmModel realmModel = this.session.realms().getRealmByName(request.getRealmName());
        if (realmModel == null) {
            logger.warn((Object)"Internal Error : RevokeUserMagicLink: Unable to get requested realm");
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "Realm do not exists: " + request.getRealmName(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        UserModel userModel = this.session.users().getUserById(realmModel, request.getUserId());
        if (userModel == null) {
            logger.error((Object)"RevokeUserMagicLink: user not found");
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "User not found: " + request.getUserId(), false);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        userModel.credentialManager().getStoredCredentialsByTypeStream("olvid-magic-token").forEach(credentialModel -> userModel.credentialManager().removeStoredCredentialById(credentialModel.getId()));
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
    }
}

