/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.authenticationDiscovery;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.jpa.OlvidConfigurationDao;
import io.olvid.keycloak.jpa.OlvidConsoleLogsDao;
import io.olvid.keycloak.rest.api.AbstractEntryPoint;
import io.olvid.keycloak.rest.api.configuration.ConfigurationQueryJson;
import jakarta.persistence.EntityManager;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Predicate;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.AuthenticationManager;

public class AuthenticationDiscovery
extends AbstractEntryPoint {
    protected static final Logger logger = Logger.getLogger(AuthenticationDiscovery.class);
    public static final HashSet<String> userSessions = new HashSet();

    public AuthenticationDiscovery(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(byte[] postData) {
        try {
            ConfigurationQueryJson.QueryJson query = (ConfigurationQueryJson.QueryJson)this.objectMapper.readValue(postData, ConfigurationQueryJson.QueryJson.class);
            switch (query.q) {
                case 1: {
                    return this.processIsAuth();
                }
                case 2: {
                    return this.processSignOut();
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
        }
        return Response.serverError().type("text/html").build();
    }

    protected Response processIsAuth() {
        Authentication authentication = new Authentication();
        AuthenticationManager.AuthResult authResult = AuthenticationManager.authenticateIdentityCookie((KeycloakSession)this.session, (RealmModel)this.session.getContext().getRealm(), (boolean)true);
        if (authResult != null) {
            authentication.realmName = this.session.getContext().getRealm().getName();
            authentication.username = authResult.user().getUsername();
            authentication.email = authResult.user().getEmail();
            try {
                String sessionId = authResult.session().getId();
                if (!userSessions.contains(sessionId)) {
                    userSessions.add(sessionId);
                    HashMap<String, Object> ret = new HashMap<String, Object>();
                    OlvidConsoleLogsDao.logUserEvent(this.em, this.session, this.session.getContext().getRealm(), authentication.username, authentication.realmName, "authentication", "Realm: " + authentication.realmName, ret);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
            }
        } else if ("master".equals(this.session.getContext().getRealm().getName())) {
            Predicate<RealmModel> predicate = realmModel -> OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "admin", false) && !"master".equals(realmModel.getName());
            RealmModel[] filteredArray = (RealmModel[])this.session.realms().getRealmsStream().filter(predicate).toArray(RealmModel[]::new);
            if (filteredArray.length != 0) {
                RealmModel adminRealm = filteredArray[0];
                if (adminRealm != null) {
                    authentication.realmName = adminRealm.getName();
                }
            } else {
                logger.warn((Object)"No admin realm");
                authentication.realmName = "No admin realm";
                authentication.session = this.session.toString();
            }
        } else {
            logger.warn((Object)"User not signed in: neither on master nor on an admin realm");
        }
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)authentication)).type("application/json").build();
        }
        catch (JsonProcessingException e) {
            return Response.serverError().type("text/html").build();
        }
    }

    private Response processSignOut() {
        boolean remove = false;
        AuthenticationManager.AuthResult authResult = AuthenticationManager.authenticateIdentityCookie((KeycloakSession)this.session, (RealmModel)this.session.getContext().getRealm(), (boolean)true);
        if (authResult != null) {
            remove = true;
            this.session.sessions().removeUserSessions(this.session.getContext().getRealm(), authResult.user());
        }
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)remove)).type("application/json").build();
        }
        catch (JsonProcessingException e) {
            return Response.serverError().type("text/html").build();
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Authentication {
        public String realmName;
        public String username;
        public String email;
        public String session;
    }

    public static class QueryJson {
        public static final int AUTH_VERIFICATION = 1;
        public static final int SIGN_OUT = 2;
    }
}

