/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.apiModelsDevices.putKey;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.jpa.OlvidConfigurationDao;
import io.olvid.keycloak.rest.OlvidServerApiHelper;
import io.olvid.keycloak.rest.Utils;
import io.olvid.keycloak.rest.api.AbstractUserApiEntryPoint;
import io.olvid.keycloak.rest.api.apiModelsDevices.putKey.payload.PutKeyPayloadModel;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.ExecutionResult;
import org.keycloak.models.KeycloakSession;

public class PutKey
extends AbstractUserApiEntryPoint {
    protected static final Logger logger = Logger.getLogger(PutKey.class);

    public PutKey(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(byte[] postData) {
        String identity;
        try {
            PutKeyPayloadModel request = (PutKeyPayloadModel)this.objectMapper.readValue(postData, PutKeyPayloadModel.class);
            identity = request.getIdentity();
            if (identity == null) {
                return this.invalidRequestDevice();
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.invalidRequestDevice();
        }
        ClusterProvider clusterProvider = (ClusterProvider)this.session.getProvider(ClusterProvider.class);
        ExecutionResult result = clusterProvider.executeIfNotExecuted("olvid.putKey." + this.authenticatedUserRealm.getId() + "." + this.authenticatedUser.getId(), 10000, () -> {
            TypedQuery q = this.em.createNamedQuery("OlvidRevocation.getRevocationByOlvidId", Long.class);
            q.setParameter("olvidId", (Object)identity);
            q.setParameter("realmId", (Object)this.authenticatedUserRealm.getId());
            if ((Long)q.getSingleResult() > 0L) {
                return this.identityWasRevoked();
            }
            String oldIdentity = Utils.getUserAttribute(this.authenticatedUser, "olvid-identity");
            if (oldIdentity == null) {
                String newApiKey;
                String apiKey = Utils.getUserAttribute(this.authenticatedUser, "olvid-api-key");
                if (apiKey != null) {
                    if (OlvidServerApiHelper.revokeApiKey(this.session, this.em, this.authenticatedUserRealm.getId(), this.objectMapper, apiKey)) {
                        Utils.setUserAttribute(this.authenticatedUser, "olvid-api-key", null);
                    } else {
                        return this.internalErrorDevice();
                    }
                }
                if ((newApiKey = Utils.isBotUser(this.authenticatedUser) ? OlvidServerApiHelper.requestNewBotApiKey(this.session, this.em, this.authenticatedUserRealm.getId(), this.objectMapper) : OlvidServerApiHelper.requestNewApiKey(this.session, this.em, this.authenticatedUserRealm.getId(), this.objectMapper)) == null) {
                    return this.internalErrorDevice();
                }
                Utils.setUserAttribute(this.authenticatedUser, "olvid-api-key", newApiKey);
                Utils.setUserAttribute(this.authenticatedUser, "olvid-identity", identity);
                Utils.setUserAttribute(this.authenticatedUser, "olvid-unbound", null);
                Utils.updateUserSignedDetailsAndAssociatedGroups(this.session, this.em, this.objectMapper, this.authenticatedUserRealm, this.authenticatedUser);
                return this.success();
            }
            if (oldIdentity.equals(identity)) {
                String apiKey = Utils.getUserAttribute(this.authenticatedUser, "olvid-api-key");
                if (apiKey == null) {
                    String newApiKey = Utils.isBotUser(this.authenticatedUser) ? OlvidServerApiHelper.requestNewBotApiKey(this.session, this.em, this.authenticatedUserRealm.getId(), this.objectMapper) : OlvidServerApiHelper.requestNewApiKey(this.session, this.em, this.authenticatedUserRealm.getId(), this.objectMapper);
                    if (newApiKey != null) {
                        Utils.setUserAttribute(this.authenticatedUser, "olvid-api-key", newApiKey);
                    } else {
                        return this.internalErrorDevice();
                    }
                }
                Utils.setUserAttribute(this.authenticatedUser, "olvid-unbound", null);
                Utils.updateUserSignedDetailsAndAssociatedGroups(this.session, this.em, this.objectMapper, this.authenticatedUserRealm, this.authenticatedUser);
                return this.success();
            }
            if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, this.authenticatedUserRealm.getId(), "revocationAllowed", false)) {
                return this.identityAlreadyUploaded();
            }
            String apiKey = Utils.getUserAttribute(this.authenticatedUser, "olvid-api-key");
            if (apiKey != null) {
                if (OlvidServerApiHelper.revokeApiKey(this.session, this.em, this.authenticatedUserRealm.getId(), this.objectMapper, apiKey)) {
                    Utils.setUserAttribute(this.authenticatedUser, "olvid-api-key", null);
                } else {
                    return this.internalErrorDevice();
                }
            }
            Utils.setUserAttribute(this.authenticatedUser, "olvid-identity", null);
            String newApiKey = Utils.isBotUser(this.authenticatedUser) ? OlvidServerApiHelper.requestNewBotApiKey(this.session, this.em, this.authenticatedUserRealm.getId(), this.objectMapper) : OlvidServerApiHelper.requestNewApiKey(this.session, this.em, this.authenticatedUserRealm.getId(), this.objectMapper);
            if (newApiKey == null) {
                return this.internalErrorDevice();
            }
            Utils.setUserAttribute(this.authenticatedUser, "olvid-api-key", newApiKey);
            Utils.setUserAttribute(this.authenticatedUser, "olvid-identity", identity);
            Utils.setUserAttribute(this.authenticatedUser, "olvid-unbound", null);
            Utils.updateUserSignedDetailsAndAssociatedGroups(this.session, this.em, this.objectMapper, this.authenticatedUserRealm, this.authenticatedUser);
            return this.success();
        });
        if (result.isExecuted()) {
            this.authenticatedUser.credentialManager().getStoredCredentialsByTypeStream("olvid-magic-token").forEach(magicToken -> this.authenticatedUser.credentialManager().removeStoredCredentialById(magicToken.getId()));
            return (Response)result.getResult();
        }
        return this.invalidRequestDevice();
    }
}

