/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.apiModelsDevices.listUsers;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.datatypes.OlvidUserDetails;
import io.olvid.keycloak.jpa.OlvidCircleVisibilityUser;
import io.olvid.keycloak.jpa.OlvidConfigurationDao;
import io.olvid.keycloak.jpa.OlvidUser;
import io.olvid.keycloak.rest.api.AbstractUserApiEntryPoint;
import io.olvid.keycloak.rest.api.apiModelsDevices.listUsers.payload.ListUsersPayloadModel;
import io.olvid.keycloak.rest.api.apiModelsDevices.listUsers.response.ListUsersResponseModel;
import io.olvid.keycloak.rest.api.search.Search;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.KeycloakSession;

public class ListUsers
extends AbstractUserApiEntryPoint {
    protected static final Logger logger = Logger.getLogger(ListUsers.class);
    public static final String SELECT_QUERY_WITH_CIRCLE = " SELECT  DISTINCT(ou)  FROM OlvidUser ou  LEFT JOIN OlvidCircleVisibilityUser ocvu on ocvu.userId = ou.userId  WHERE ou.realmId = :realmId  AND ou.userId != :userId ";
    public static final String SELECT_QUERY_ALL = "SELECT ou FROM OlvidUser ou WHERE ou.realmId = :realmId";
    public static final String AND_TIMESTAMP = " AND ou.creationTimestamp > :creationTimestamp ";

    public ListUsers(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(byte[] postData) {
        Long timestamp;
        try {
            ListUsersPayloadModel query = (ListUsersPayloadModel)this.objectMapper.readValue(postData, ListUsersPayloadModel.class);
            timestamp = query.timestamp;
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.invalidRequestDevice();
        }
        try {
            boolean circleVisibility;
            ListUsersResponseModel response = new ListUsersResponseModel();
            response.users = new ArrayList<OlvidUserDetails>();
            response.timestamp = System.currentTimeMillis();
            try {
                circleVisibility = OlvidConfigurationDao.getBooleanConfiguration(this.em, this.authenticatedUserRealm.getId(), "enableVisibilityCircles", false);
            }
            catch (Exception e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
                return this.invalidRequestDevice();
            }
            if (circleVisibility) {
                String circleId;
                TypedQuery queryCircleVisibilityUser = this.em.createNamedQuery("OlvidCircleVisibilityUser.getUserCircleVisibilityId", OlvidCircleVisibilityUser.class);
                queryCircleVisibilityUser.setParameter("realmId", (Object)this.authenticatedUserRealm.getId());
                queryCircleVisibilityUser.setParameter("id", (Object)this.authenticatedUser.getId());
                try {
                    circleId = ((OlvidCircleVisibilityUser)queryCircleVisibilityUser.getSingleResult()).getCircleVisibilityId();
                }
                catch (NoResultException ignored) {
                    circleId = "";
                }
                ArrayList<String> circlesIds = new ArrayList<String>();
                StringBuilder sb = Search.switchQuery(this.em, this.authenticatedUserRealm.getId(), circleId, circlesIds, SELECT_QUERY_WITH_CIRCLE, SELECT_QUERY_ALL);
                if (timestamp != null) {
                    sb.append(AND_TIMESTAMP);
                }
                TypedQuery queryOlvidUser = this.em.createQuery(sb.toString(), OlvidUser.class);
                queryOlvidUser.setParameter("realmId", (Object)this.authenticatedUserRealm.getId());
                queryOlvidUser.setParameter("circleIds", circlesIds);
                queryOlvidUser.setParameter("userId", (Object)this.authenticatedUser.getId());
                if (timestamp != null) {
                    queryOlvidUser.setParameter("creationTimestamp", (Object)timestamp);
                }
                List queryResultList = queryOlvidUser.getResultList();
                for (OlvidUser olvidUser : queryResultList) {
                    try {
                        JWSInput jwsInput = new JWSInput(olvidUser.getSignedDetails());
                        response.users.add((OlvidUserDetails)this.objectMapper.readValue(jwsInput.getContent(), OlvidUserDetails.class));
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Error parsing OlvidUser signed details", (Throwable)e);
                    }
                }
            } else {
                TypedQuery queryOlvidUser;
                if (timestamp == null) {
                    queryOlvidUser = this.em.createNamedQuery("OlvidUser.getAllByRealmId", OlvidUser.class);
                    queryOlvidUser.setParameter("realmId", (Object)this.authenticatedUserRealm.getId());
                } else {
                    queryOlvidUser = this.em.createNamedQuery("OlvidUser.getAllCreatedAfterByRealmId", OlvidUser.class);
                    queryOlvidUser.setParameter("realmId", (Object)this.authenticatedUserRealm.getId());
                    queryOlvidUser.setParameter("creationTimestamp", (Object)timestamp);
                }
                List queryResultList = queryOlvidUser.getResultList();
                for (OlvidUser olvidUser : queryResultList) {
                    try {
                        JWSInput jwsInput = new JWSInput(olvidUser.getSignedDetails());
                        response.users.add((OlvidUserDetails)this.objectMapper.readValue(jwsInput.getContent(), OlvidUserDetails.class));
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Error parsing OlvidUser signed details", (Throwable)e);
                    }
                }
            }
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalErrorDevice();
        }
    }
}

