/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.apiModelsDevices.groups;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.jpa.OlvidGroup;
import io.olvid.keycloak.jpa.OlvidGroupDao;
import io.olvid.keycloak.rest.Utils;
import io.olvid.keycloak.rest.api.AbstractUserApiEntryPoint;
import io.olvid.keycloak.rest.api.apiModelsDevices.groups.payload.JsonGroupsPayloadModel;
import io.olvid.keycloak.rest.api.apiModelsDevices.groups.response.JsonGroupsResponseModel;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;

public class Groups
extends AbstractUserApiEntryPoint {
    public Groups(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(byte[] postData) {
        JsonGroupsPayloadModel query = null;
        if (postData != null && postData.length > 0) {
            try {
                query = (JsonGroupsPayloadModel)this.objectMapper.readValue(postData, JsonGroupsPayloadModel.class);
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to parse Groups post data. ", (Throwable)e);
            }
        }
        Long queryTimestamp = query == null ? null : query.getTimestamp();
        long currentTimestamp = System.currentTimeMillis();
        UserModel user = this.session.users().getUserById(this.authenticatedUserRealm, this.authenticatedUser.getId());
        if (Utils.isUnboundUser(user)) {
            user.setAttribute("olvid-unbound", null);
            Utils.updateUserSignedDetailsAndAssociatedGroups(this.session, this.em, this.objectMapper, this.authenticatedUserRealm, this.authenticatedUser);
        }
        try {
            JsonGroupsResponseModel response = new JsonGroupsResponseModel();
            response.setCurrentTimestamp(currentTimestamp);
            ArrayList<String> signedGroupBlobs = new ArrayList<String>();
            this.authenticatedUser.getGroupsStream().forEach(groupModel -> {
                OlvidGroup olvidGroup = OlvidGroupDao.getOlvidGroupById(this.em, this.authenticatedUserRealm.getId(), groupModel.getId());
                if (olvidGroup != null && olvidGroup.isEnabled() && (queryTimestamp == null || queryTimestamp < olvidGroup.getLastModificationTimestamp())) {
                    signedGroupBlobs.add(olvidGroup.getSignedGroupBlob());
                }
            });
            long earliestRevocationTimestamp = queryTimestamp != null ? queryTimestamp : currentTimestamp - 5184000000L;
            TypedQuery q = this.em.createNamedQuery("OlvidGroupDeletion.getGroupDeletionList", String.class);
            q.setParameter("realmId", (Object)this.authenticatedUserRealm.getId());
            q.setParameter("timestamp", (Object)earliestRevocationTimestamp);
            List signedGroupDeletions = q.getResultList();
            TypedQuery q2 = this.em.createNamedQuery("OlvidGroupMemberKicked.getGroupKickList", String.class);
            q2.setParameter("realmId", (Object)this.authenticatedUserRealm.getId());
            q2.setParameter("userId", (Object)this.authenticatedUser.getId());
            q2.setParameter("timestamp", (Object)earliestRevocationTimestamp);
            List signedGroupKicks = q2.getResultList();
            if (!signedGroupBlobs.isEmpty()) {
                response.setSignedGroupBlobs(signedGroupBlobs);
            }
            if (!signedGroupDeletions.isEmpty()) {
                response.setSignedGroupDeletions(signedGroupDeletions);
            }
            if (!signedGroupKicks.isEmpty()) {
                response.setSignedGroupKicks(signedGroupKicks);
            }
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalErrorDevice();
        }
    }
}

