/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.apiModelsDevices.getKey;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.rest.Utils;
import io.olvid.keycloak.rest.api.AbstractUserApiEntryPoint;
import io.olvid.keycloak.rest.api.apiModelsDevices.getKey.payload.GetKeyPayloadModel;
import io.olvid.keycloak.rest.api.apiModelsDevices.getKey.response.GetKeyResponseModel;
import jakarta.persistence.EntityManager;
import jakarta.ws.rs.core.Response;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;

public class GetKey
extends AbstractUserApiEntryPoint {
    public GetKey(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(byte[] postData) {
        GetKeyPayloadModel request;
        UserModel otherUser = null;
        try {
            request = (GetKeyPayloadModel)this.objectMapper.readValue(postData, GetKeyPayloadModel.class);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.invalidRequestDevice();
        }
        String userId = request.getUserId();
        if (userId != null && !userId.isEmpty()) {
            otherUser = this.session.users().getUserById(this.authenticatedUserRealm, userId);
        }
        if (otherUser == null || !otherUser.isEnabled() || Utils.isUnboundUser(otherUser)) {
            return this.invalidRequestDevice();
        }
        try {
            String signedDetails = Utils.getSignedUserDetails(this.session, this.em, this.objectMapper, this.authenticatedUserRealm, otherUser);
            if (signedDetails == null) {
                return this.internalErrorDevice();
            }
            GetKeyResponseModel getKeyResponseModel = new GetKeyResponseModel();
            getKeyResponseModel.setSignature(signedDetails);
            String response = this.objectMapper.writeValueAsString((Object)getKeyResponseModel);
            return Response.ok((Object)response, (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalErrorDevice();
        }
    }
}

