/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.apiModels.configurations.response.generic;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.olvid.keycloak.classes.constants.ResponseConstants;
import java.util.Objects;
import org.apache.commons.lang3.EnumUtils;
import org.jboss.logging.Logger;

public class GenericReponseModel {
    @JsonProperty(value="data")
    Object data;
    @JsonProperty(value="status")
    String status;
    @JsonProperty(value="message")
    String message;
    @JsonProperty(value="error")
    int error;
    @JsonProperty(value="isQueryAllowed")
    boolean isQueryAllowed;
    static Logger logger = Logger.getLogger(GenericReponseModel.class);

    public boolean getIsQueryAllowed() {
        return this.isQueryAllowed;
    }

    public void setIsQueryAllowed(boolean isQueryAllowed) {
        this.isQueryAllowed = isQueryAllowed;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        try {
            if (EnumUtils.isValidEnum(ResponseConstants.Status.class, status)) {
                this.status = status;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getError() {
        return this.error;
    }

    public void setError(int error) {
        this.error = error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericReponseModel that = (GenericReponseModel)o;
        return this.error == that.error && this.isQueryAllowed == that.isQueryAllowed && Objects.equals(this.data, that.data) && Objects.equals(this.status, that.status) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.status, this.message, this.error, this.isQueryAllowed);
    }

    public void setUpGenericResponseModel(Object data, String status, int error, String message, boolean isQueryAllowed) {
        this.setData(data);
        if (status == null) {
            this.setStatus(new ResponseConstants().STATUS_SUCCESS);
        } else {
            this.setStatus(status);
        }
        this.setError(error);
        if (message == null) {
            this.setMessage("");
        } else {
            this.setMessage(message);
        }
        this.setIsQueryAllowed(isQueryAllowed);
    }

    public String toString() {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        return gson.toJson((Object)this);
    }
}

