/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.datatypes.encoder.Encoded;
import jakarta.persistence.EntityManager;
import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;

public abstract class AbstractEngineEntryPoint {
    public static final byte[] STATUS_OK = new byte[]{0};
    public static final byte[] STATUS_PERMISSION_DENIED = new byte[]{14};
    public static final byte[] STATUS_PARSING_ERROR = new byte[]{-2};
    public static final byte[] STATUS_GENERAL_ERROR = new byte[]{-1};
    protected final KeycloakSession session;
    protected final EntityManager em;
    protected final ObjectMapper objectMapper;
    protected final Logger logger = Logger.getLogger(this.getClass());

    public AbstractEngineEntryPoint(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        this.session = session;
        this.em = em;
        this.objectMapper = objectMapper;
    }

    public Response entryPoint(byte[] postData) {
        try {
            return this.handler(postData);
        }
        catch (Exception e) {
            this.logger.warn((Object)"Unexpected error occurred during entryPoint handling:", (Throwable)e);
            return this.generalError();
        }
    }

    protected abstract Response handler(byte[] var1);

    protected Response getResponse(Encoded response) {
        return Response.ok((Object)response.getBytes(), (String)"application/octet-stream").build();
    }

    protected Response success() {
        return this.getResponse(Encoded.of(new Encoded[]{Encoded.of(STATUS_OK)}));
    }

    protected Response permissionDenied() {
        return this.getResponse(Encoded.of(new Encoded[]{Encoded.of(STATUS_PERMISSION_DENIED)}));
    }

    protected Response generalError() {
        return this.getResponse(Encoded.of(new Encoded[]{Encoded.of(STATUS_GENERAL_ERROR)}));
    }

    protected Response parsingError() {
        return this.getResponse(Encoded.of(new Encoded[]{Encoded.of(STATUS_PARSING_ERROR)}));
    }
}

