/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.rest.api.AbstractEntryPoint;
import jakarta.persistence.EntityManager;
import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;

public abstract class AbstractAdminApiEntryPoint
extends AbstractEntryPoint {
    protected final RealmModel authenticatedUserRealm;
    protected final UserModel authenticatedUser;
    protected boolean useDirectAuthToken = false;
    protected static final Logger logger = Logger.getLogger(AbstractAdminApiEntryPoint.class);

    public AbstractAdminApiEntryPoint(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
        this.authenticatedUser = this.isUserLoggedIn(session);
        this.authenticatedUserRealm = session.getContext().getRealm();
    }

    @Override
    public Response entryPoint(byte[] postData) {
        try {
            if (this.authenticatedUser == null) {
                return this.permissionDenied();
            }
            return this.handler(postData);
        }
        catch (Exception e) {
            logger.warn((Object)"Unexpected error occurred during AbstractAdminApiEntryPoint handling:", (Throwable)e);
            return this.internalError();
        }
    }

    private UserModel isUserLoggedIn(KeycloakSession session) {
        AuthenticationManager.AuthResult authResult = AuthenticationManager.authenticateIdentityCookie((KeycloakSession)session, (RealmModel)session.getContext().getRealm(), (boolean)true);
        if (authResult != null) {
            return authResult.user();
        }
        authResult = new AppAuthManager.BearerTokenAuthenticator(session).authenticate();
        if (authResult != null) {
            return authResult.user();
        }
        return null;
    }
}

