/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.rest.api.apiModelsDevices.getKey.GetKey;
import io.olvid.keycloak.rest.api.apiModelsDevices.groups.Groups;
import io.olvid.keycloak.rest.api.apiModelsDevices.listUsers.ListUsers;
import io.olvid.keycloak.rest.api.apiModelsDevices.me.Me;
import io.olvid.keycloak.rest.api.apiModelsDevices.myDevices.MyDevices;
import io.olvid.keycloak.rest.api.apiModelsDevices.putKey.PutKey;
import io.olvid.keycloak.rest.api.apiModelsDevices.transferProof.TransferProof;
import io.olvid.keycloak.rest.api.authenticationDiscovery.AuthenticationDiscovery;
import io.olvid.keycloak.rest.api.configuration.Configuration;
import io.olvid.keycloak.rest.api.getData.GetData;
import io.olvid.keycloak.rest.api.getMagicSession.GetMagicSession;
import io.olvid.keycloak.rest.api.revocationTest.RevocationTest;
import io.olvid.keycloak.rest.api.search.Search;
import io.olvid.keycloak.rest.api.verify.Verify;
import io.olvid.keycloak.rest.engine.getSession.GetSession;
import io.olvid.keycloak.rest.engine.requestChallenge.RequestChallenge;
import jakarta.persistence.EntityManager;
import jakarta.transaction.Transactional;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.resource.RealmResourceProvider;

public class RestProvider
implements RealmResourceProvider {
    protected static final Logger logger = Logger.getLogger(RestProvider.class);
    private final KeycloakSession session;
    private final EntityManager em;
    private final ObjectMapper objectMapper;

    public RestProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public Object getResource() {
        return this;
    }

    public void close() {
    }

    @GET
    @Path(value="ping")
    @Produces(value={"text/plain"})
    @Transactional
    public Response ping() {
        logger.info((Object)"PING");
        return Response.ok((Object)"pong", (String)"text/plain").build();
    }

    @GET
    @Path(value="me")
    @Produces(value={"application/json"})
    @Transactional
    public Response meGet() {
        logger.info((Object)"Called \"me\" (GET)");
        return new Me(this.session, this.em, this.objectMapper).entryPoint(null);
    }

    @POST
    @Path(value="me")
    @Produces(value={"application/json"})
    @Transactional
    public Response me(byte[] postData) {
        logger.info((Object)"Called \"me\"");
        return new Me(this.session, this.em, this.objectMapper).entryPoint(postData);
    }

    @POST
    @Path(value="myDevices")
    @Produces(value={"application/json"})
    @Transactional
    public Response myDevices(byte[] postData) {
        logger.info((Object)"Called \"MyDevices\"");
        return new MyDevices(this.session, this.em, this.objectMapper).entryPoint(postData);
    }

    @POST
    @Path(value="putKey")
    @Produces(value={"application/json"})
    @Transactional
    public Response putKey(byte[] postData) {
        logger.info((Object)"Called \"putKey\"");
        return new PutKey(this.session, this.em, this.objectMapper).entryPoint(postData);
    }

    @POST
    @Path(value="getKey")
    @Produces(value={"application/json"})
    @Transactional
    public Response getKey(byte[] postData) {
        logger.info((Object)"Called \"getKey\"");
        return new GetKey(this.session, this.em, this.objectMapper).entryPoint(postData);
    }

    @POST
    @Path(value="search")
    @Produces(value={"application/json"})
    @Transactional
    public Response search(byte[] postData) {
        logger.info((Object)"Called \"search\"");
        return new Search(this.session, this.em, this.objectMapper).entryPoint(postData);
    }

    @POST
    @Path(value="verify")
    @Produces(value={"application/octet-stream"})
    @Transactional
    public Response verify(byte[] postData) {
        logger.info((Object)"Called \"verify\"");
        return new Verify(this.session, this.em, this.objectMapper).entryPoint(postData);
    }

    @POST
    @Path(value="transferProof")
    @Produces(value={"application/json"})
    @Transactional
    public Response transferProof(byte[] postData) {
        logger.info((Object)"Called \"transferProof\"");
        return new TransferProof(this.session, this.em, this.objectMapper).entryPoint(postData);
    }

    @POST
    @Path(value="revocationTest")
    @Produces(value={"application/octet-stream"})
    @Transactional
    public Response revocationTest(byte[] postData) {
        logger.info((Object)"Called \"revocationTest\"");
        return new RevocationTest(this.session, this.em, this.objectMapper).entryPoint(postData);
    }

    @POST
    @Path(value="groups")
    @Produces(value={"application/json"})
    @Transactional
    public Response groups(byte[] postData) {
        logger.info((Object)"Called \"groups\"");
        return new Groups(this.session, this.em, this.objectMapper).entryPoint(postData);
    }

    @POST
    @Path(value="getData")
    @Produces(value={"application/octet-stream"})
    @Transactional
    public Response getData(byte[] postData) {
        logger.info((Object)"Called \"getData\"");
        return new GetData(this.session, this.em, this.objectMapper).entryPoint(postData);
    }

    @POST
    @Path(value="listUsers")
    @Produces(value={"application/json"})
    @Transactional
    public Response listUsers(byte[] postData) {
        logger.info((Object)"Called \"listUsers\"");
        return new ListUsers(this.session, this.em, this.objectMapper).entryPoint(postData);
    }

    @POST
    @Path(value="configuration")
    @Produces(value={"text/html"})
    @Transactional
    public Response configuration(byte[] postData) {
        return new Configuration(this.session, this.em, this.objectMapper).entryPoint(postData);
    }

    @POST
    @Path(value="authenticationDiscovery")
    @Produces(value={"text/html"})
    @Transactional
    public Response authenticateDiscovery(byte[] postData) {
        return new AuthenticationDiscovery(this.session, this.em, this.objectMapper).entryPoint(postData);
    }

    @POST
    @Path(value="getMagicSession")
    @Produces(value={"application/json"})
    @Transactional
    public Response getMagicSession(byte[] postData) {
        logger.info((Object)"Called \"getMagicSession\"");
        return new GetMagicSession(this.session, this.em, this.objectMapper).entryPoint(postData);
    }

    @GET
    @Path(value="olvidMetrics")
    @Produces(value={"text/plain"})
    @Transactional
    public Response olvidMetrics() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Not found").build();
    }

    @POST
    @Path(value="requestChallenge")
    @Produces(value={"application/octet-stream"})
    @Transactional
    public Response requestChallenge(byte[] postData) {
        logger.info((Object)"Called \"requestChallenge\"");
        return new RequestChallenge(this.session, this.em, this.objectMapper).entryPoint(postData);
    }

    @POST
    @Path(value="getSession")
    @Produces(value={"application/octet-stream"})
    @Transactional
    public Response getSession(byte[] postData) {
        logger.info((Object)"Called \"getSession\"");
        return new GetSession(this.session, this.em, this.objectMapper).entryPoint(postData);
    }
}

