/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.datatypes.UserOrTopicToNotify;
import io.olvid.keycloak.jpa.OlvidConfigurationDao;
import jakarta.persistence.EntityManager;
import java.io.IOException;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;

public class OlvidServerApiHelper {
    protected static final Logger logger = Logger.getLogger(OlvidServerApiHelper.class);
    private static final int ERROR_INVALID_REQUEST = 1;
    private static final int ERROR_INTERNAL = 2;
    private static final int ERROR_INVALID_API_KEY = 3;
    private static final int ERROR_API_KEY_NOT_FOUND = 4;
    private static final int ERROR_MISSING_BOT_PERMISSION = 5;
    public static final int SOCKET_TIMEOUT_MILLIS = 60000;

    public static String requestNewApiKey(KeycloakSession session, EntityManager em, String realmId, ObjectMapper objectMapper) {
        logger.info((Object)"OlvidServerApiHelper: requesting new API key");
        try {
            KeycloakQueryJson keycloakQueryJson = new KeycloakQueryJson();
            keycloakQueryJson.q = 1;
            keycloakQueryJson.keycloakApiKey = OlvidConfigurationDao.getStringConfiguration(em, realmId, "serverKeycloakApiKey");
            String server = OlvidConfigurationDao.getStringConfiguration(em, realmId, "serverUrl");
            if (server == null || keycloakQueryJson.keycloakApiKey == null) {
                logger.warn((Object)"Trying to requestNewApiKey with no server or keycloakApiKey in OlvidConfiguration");
                return null;
            }
            byte[] output = OlvidServerApiHelper.serverApiRequest(session, server, objectMapper, keycloakQueryJson, em);
            try {
                Map errorMap = (Map)objectMapper.readValue(output, (TypeReference)new TypeReference<Map<String, Integer>>(){});
                Integer errorCode = (Integer)errorMap.get("error");
                if (errorCode != null) {
                    logger.warn((Object)("Olvid server returned error code " + errorCode + " during requestNewApiKey"));
                    return null;
                }
            }
            catch (Exception errorMap) {
                // empty catch block
            }
            RequestNewApiKeyResponseJson requestNewApiKeyResponseJson = (RequestNewApiKeyResponseJson)objectMapper.readValue(output, RequestNewApiKeyResponseJson.class);
            return requestNewApiKeyResponseJson.apiKey;
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return null;
        }
    }

    public static boolean revokeApiKey(KeycloakSession session, EntityManager em, String realmId, ObjectMapper objectMapper, String apiKeyToRevoke) {
        logger.info((Object)"OlvidServerApiHelper: revoking API key");
        try {
            KeycloakQueryJson keycloakQueryJson = new KeycloakQueryJson();
            keycloakQueryJson.q = 2;
            keycloakQueryJson.apiKeyToRevoke = apiKeyToRevoke;
            keycloakQueryJson.keycloakApiKey = OlvidConfigurationDao.getStringConfiguration(em, realmId, "serverKeycloakApiKey");
            String server = OlvidConfigurationDao.getStringConfiguration(em, realmId, "serverUrl");
            if (server == null || keycloakQueryJson.keycloakApiKey == null) {
                logger.warn((Object)"Trying to revokeApiKey with no server or keycloakApiKey in OlvidConfiguration");
                return false;
            }
            byte[] output = OlvidServerApiHelper.serverApiRequest(session, server, objectMapper, keycloakQueryJson, em);
            try {
                Map errorMap = (Map)objectMapper.readValue(output, (TypeReference)new TypeReference<Map<String, Integer>>(){});
                Integer errorCode = (Integer)errorMap.get("error");
                if (errorCode != null) {
                    switch (errorCode) {
                        case 4: {
                            logger.warn((Object)"revokeApiKey: Olvid server says api key is not found / already revoked");
                            return true;
                        }
                    }
                    logger.warn((Object)("Olvid server returned error code " + errorCode + " during revokeApiKey"));
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return false;
        }
    }

    public static String requestNewPushTopic(KeycloakSession session, EntityManager em, String realmId, ObjectMapper objectMapper) {
        logger.info((Object)"OlvidServerApiHelper: requesting new push topic");
        try {
            KeycloakQueryJson keycloakQueryJson = new KeycloakQueryJson();
            keycloakQueryJson.q = 4;
            keycloakQueryJson.keycloakApiKey = OlvidConfigurationDao.getStringConfiguration(em, realmId, "serverKeycloakApiKey");
            String server = OlvidConfigurationDao.getStringConfiguration(em, realmId, "serverUrl");
            if (server == null || keycloakQueryJson.keycloakApiKey == null) {
                logger.warn((Object)"Trying to requestNewApiKey with no server or keycloakApiKey in OlvidConfiguration");
                return null;
            }
            byte[] output = OlvidServerApiHelper.serverApiRequest(session, server, objectMapper, keycloakQueryJson, em);
            try {
                Map errorMap = (Map)objectMapper.readValue(output, (TypeReference)new TypeReference<Map<String, Integer>>(){});
                Integer errorCode = (Integer)errorMap.get("error");
                if (errorCode != null) {
                    switch (errorCode) {
                        default: 
                    }
                    logger.warn((Object)("Olvid server returned error code " + errorCode + " during requestNewPushTopic"));
                    return null;
                }
            }
            catch (Exception errorMap) {
                // empty catch block
            }
            RequestNewPushTopicResponseJson requestNewPushTopicResponseJson = (RequestNewPushTopicResponseJson)objectMapper.readValue(output, RequestNewPushTopicResponseJson.class);
            return requestNewPushTopicResponseJson.pushTopic;
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return null;
        }
    }

    private static void notifyAllUsers(KeycloakSession session, EntityManager em, String realmId, ObjectMapper objectMapper, String pushTopic) {
        logger.info((Object)("OlvidServerApiHelper: notifying user in push topic " + pushTopic));
        try {
            KeycloakQueryJson keycloakQueryJson = new KeycloakQueryJson();
            keycloakQueryJson.q = 3;
            keycloakQueryJson.keycloakApiKey = OlvidConfigurationDao.getStringConfiguration(em, realmId, "serverKeycloakApiKey");
            keycloakQueryJson.pushTopic = pushTopic;
            String server = OlvidConfigurationDao.getStringConfiguration(em, realmId, "serverUrl");
            if (server == null || keycloakQueryJson.keycloakApiKey == null) {
                logger.warn((Object)"Trying to notifyAllUsers with no server or keycloakApiKey in OlvidConfiguration");
                return;
            }
            byte[] output = OlvidServerApiHelper.serverApiRequest(session, server, objectMapper, keycloakQueryJson, em);
            try {
                Map errorMap = (Map)objectMapper.readValue(output, (TypeReference)new TypeReference<Map<String, Integer>>(){});
                Integer errorCode = (Integer)errorMap.get("error");
                if (errorCode != null) {
                    logger.warn((Object)("Olvid server returned error code " + errorCode + " during notifyAllUsers"));
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            logger.warn((Object)"Unexpected exception in notifyAllUsers:", (Throwable)e);
        }
    }

    public static UnknownApiKeysAndPushTopics apiKeySynchronization(KeycloakSession session, String server, String keycloakApiKey, ObjectMapper objectMapper, Set<String> knownApiKeys, Set<String> knownPushTopics, EntityManager em) {
        logger.info((Object)"OlvidServerApiHelper: syncing API keys and push topics");
        try {
            KeycloakQueryJson keycloakQueryJson = new KeycloakQueryJson();
            keycloakQueryJson.q = 6;
            keycloakQueryJson.keycloakApiKey = keycloakApiKey;
            keycloakQueryJson.knownApiKeys = knownApiKeys;
            keycloakQueryJson.knownPushTopics = knownPushTopics;
            byte[] output = OlvidServerApiHelper.serverApiRequest(session, server, objectMapper, keycloakQueryJson, em);
            try {
                Map errorMap = (Map)objectMapper.readValue(output, (TypeReference)new TypeReference<Map<String, Integer>>(){});
                Integer errorCode = (Integer)errorMap.get("error");
                if (errorCode != null) {
                    logger.warn((Object)("Olvid server returned error code " + errorCode + " during apiKeySynchronization"));
                    return null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return (UnknownApiKeysAndPushTopics)objectMapper.readValue(output, UnknownApiKeysAndPushTopics.class);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return null;
        }
    }

    private static void notifySingleUser(KeycloakSession session, EntityManager em, String realmId, ObjectMapper objectMapper, String userIdentity) {
        logger.info((Object)"OlvidServerApiHelper: notifying single user");
        try {
            KeycloakQueryJson keycloakQueryJson = new KeycloakQueryJson();
            keycloakQueryJson.q = 7;
            keycloakQueryJson.keycloakApiKey = OlvidConfigurationDao.getStringConfiguration(em, realmId, "serverKeycloakApiKey");
            keycloakQueryJson.userIdentity = Base64.getDecoder().decode(userIdentity);
            String server = OlvidConfigurationDao.getStringConfiguration(em, realmId, "serverUrl");
            if (server == null || keycloakQueryJson.keycloakApiKey == null) {
                logger.warn((Object)"Trying to notifySingleUser with no server or keycloakApiKey in OlvidConfiguration");
                return;
            }
            byte[] output = OlvidServerApiHelper.serverApiRequest(session, server, objectMapper, keycloakQueryJson, em);
            try {
                Map errorMap = (Map)objectMapper.readValue(output, (TypeReference)new TypeReference<Map<String, Integer>>(){});
                Integer errorCode = (Integer)errorMap.get("error");
                if (errorCode != null) {
                    logger.warn((Object)("Olvid server returned error code " + errorCode + " during notifySingleUser"));
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            logger.warn((Object)"Unexpected exception in notifySingleUser:", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private static byte[] serverApiRequest(KeycloakSession session, String olvidServer, ObjectMapper objectMapper, KeycloakQueryJson keycloakQueryJson, EntityManager em) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void sendNotifications(KeycloakSession session, EntityManager em, ObjectMapper jsonObjectMapper, Collection<UserOrTopicToNotify> usersAndTopicsToNotify) {
        for (UserOrTopicToNotify userOrTopicToNotify : usersAndTopicsToNotify) {
            try {
                switch (userOrTopicToNotify.notificationType) {
                    case TOPIC: {
                        OlvidServerApiHelper.notifyAllUsers(session, em, userOrTopicToNotify.realmId, jsonObjectMapper, userOrTopicToNotify.topicOrIdentityString);
                        break;
                    }
                    case SINGLE_USER: {
                        OlvidServerApiHelper.notifySingleUser(session, em, userOrTopicToNotify.realmId, jsonObjectMapper, userOrTopicToNotify.topicOrIdentityString);
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String requestNewBotApiKey(KeycloakSession session, EntityManager em, String realmId, ObjectMapper objectMapper) {
        logger.info((Object)"OlvidServerApiHelper: requesting new bot API key");
        try {
            KeycloakQueryJson keycloakQueryJson = new KeycloakQueryJson();
            keycloakQueryJson.q = 8;
            keycloakQueryJson.keycloakApiKey = OlvidConfigurationDao.getStringConfiguration(em, realmId, "serverKeycloakApiKey");
            String server = OlvidConfigurationDao.getStringConfiguration(em, realmId, "serverUrl");
            if (server == null || keycloakQueryJson.keycloakApiKey == null) {
                logger.warn((Object)"Trying to requestNewApiKey with no server or keycloakApiKey in OlvidConfiguration");
                return null;
            }
            byte[] output = OlvidServerApiHelper.serverApiRequest(session, server, objectMapper, keycloakQueryJson, em);
            try {
                Map errorMap = (Map)objectMapper.readValue(output, (TypeReference)new TypeReference<Map<String, Integer>>(){});
                Integer errorCode = (Integer)errorMap.get("error");
                if (errorCode != null) {
                    logger.warn((Object)("Olvid server returned error code " + errorCode + " during requestNewBotApiKey"));
                    return null;
                }
            }
            catch (Exception errorMap) {
                // empty catch block
            }
            RequestNewApiKeyResponseJson requestNewApiKeyResponseJson = (RequestNewApiKeyResponseJson)objectMapper.readValue(output, RequestNewApiKeyResponseJson.class);
            return requestNewApiKeyResponseJson.apiKey;
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class KeycloakQueryJson {
        public static final int QUERY_REQUEST_NEW_API_KEY = 1;
        public static final int QUERY_REVOKE_API_KEY = 2;
        public static final int QUERY_NOTIFY_PUSH_TOPIC_USERS = 3;
        public static final int QUERY_REQUEST_NEW_PUSH_TOPIC = 4;
        public static final int QUERY_DELETE_PUSH_TOPIC = 5;
        public static final int QUERY_API_KEY_SYNCHRONIZATION = 6;
        public static final int QUERY_NOTIFY_SINGLE_USER = 7;
        public static final int QUERY_REQUEST_NEW_BOT_API_KEY = 8;
        public static final int QUERY_CURRENT_KEYCLOAK_VERSION = 9;
        public int q;
        public String keycloakApiKey;
        public String keycloakVersion;
        public String pluginVersion;
        public String apiKeyToRevoke;
        public String pushTopic;
        public Set<String> knownApiKeys;
        public Set<String> knownPushTopics;
        public byte[] userIdentity;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class RequestNewApiKeyResponseJson {
        public String apiKey;

        private RequestNewApiKeyResponseJson() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class RequestNewPushTopicResponseJson {
        public String pushTopic;

        private RequestNewPushTopicResponseJson() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UnknownApiKeysAndPushTopics {
        public Set<String> unknownApiKeys;
        public Set<String> unknownPushTopics;
        public Integer licenseCount;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RequestGetKeycloakPluginVersionResponseJson {
        public String keycloak;
        public String version;
    }
}

