/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.jpa.OlvidConfigurationDao;
import jakarta.persistence.EntityManager;
import java.util.Base64;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.urls.UrlType;

public class ConfigurationLinkHelper {
    private static final ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public static String getKeycloakRealmConfigurationLink(EntityManager em, KeycloakSession session, RealmModel realmModel, ClientModel clientModel) throws Exception {
        String olvidServerUrl;
        KeycloakConfigurationLink keycloakConfigurationLink = new KeycloakConfigurationLink();
        keycloakConfigurationLink.keycloak = new KeycloakConfigurationLink.Keycloak();
        keycloakConfigurationLink.keycloak.realmUrl = ConfigurationLinkHelper.getKeycloakRealmUrl(em, realmModel, session);
        keycloakConfigurationLink.keycloak.clientId = clientModel.getClientId();
        if (clientModel.getSecret() != null) {
            keycloakConfigurationLink.keycloak.clientSecret = clientModel.getSecret();
        }
        if ((olvidServerUrl = ConfigurationLinkHelper.getOlvidServerUrl(em, realmModel)) != null) {
            keycloakConfigurationLink.olvidServerUrl = olvidServerUrl;
        }
        return ConfigurationLinkHelper.serializeConfigurationLink(keycloakConfigurationLink);
    }

    public static String getLegacyBotConfigurationLink(EntityManager em, KeycloakSession session, RealmModel realmModel, ClientModel clientModel, String username, String password) throws JsonProcessingException {
        String olvidServerUrl;
        LegacyBotConfigurationLink legacyBotConfigurationLink = new LegacyBotConfigurationLink();
        legacyBotConfigurationLink.keycloak = new LegacyBotConfigurationLink.Keycloak();
        legacyBotConfigurationLink.keycloak.realmUrl = ConfigurationLinkHelper.getKeycloakRealmUrl(em, realmModel, session);
        legacyBotConfigurationLink.keycloak.clientId = clientModel.getClientId();
        if (clientModel.getSecret() != null) {
            legacyBotConfigurationLink.keycloak.clientSecret = clientModel.getSecret();
        }
        if ((olvidServerUrl = ConfigurationLinkHelper.getOlvidServerUrl(em, realmModel)) != null) {
            legacyBotConfigurationLink.olvidServerUrl = olvidServerUrl;
        }
        legacyBotConfigurationLink.bot = new LegacyBotConfigurationLink.Bot();
        legacyBotConfigurationLink.bot.username = username;
        legacyBotConfigurationLink.bot.password = password;
        return ConfigurationLinkHelper.serializeConfigurationLink(legacyBotConfigurationLink);
    }

    public static String getBotConfigurationLink(EntityManager em, KeycloakSession session, RealmModel realmModel, String username, String magicToken) throws JsonProcessingException {
        BotConfigurationLink botConfigurationLink = new BotConfigurationLink();
        botConfigurationLink.keycloak = new BotConfigurationLink.Keycloak();
        botConfigurationLink.keycloak.realmUrl = ConfigurationLinkHelper.getKeycloakRealmUrl(em, realmModel, session);
        String olvidServerUrl = ConfigurationLinkHelper.getOlvidServerUrl(em, realmModel);
        if (olvidServerUrl != null) {
            botConfigurationLink.olvidServerUrl = olvidServerUrl;
        }
        botConfigurationLink.magic = new BotConfigurationLink.Magic();
        botConfigurationLink.magic.username = username;
        botConfigurationLink.magic.token = magicToken;
        return ConfigurationLinkHelper.serializeConfigurationLink(botConfigurationLink);
    }

    public static String generateMagicLink(EntityManager em, KeycloakSession session, RealmModel realm, String username, String magicToken) throws JsonProcessingException {
        MagicKeycloakConfigurationLink magicKeycloakConfigurationLink = new MagicKeycloakConfigurationLink();
        magicKeycloakConfigurationLink.keycloak = new MagicKeycloakConfigurationLink.Keycloak();
        magicKeycloakConfigurationLink.keycloak.realmUrl = ConfigurationLinkHelper.getKeycloakRealmUrl(em, realm, session);
        magicKeycloakConfigurationLink.olvidServerUrl = ConfigurationLinkHelper.getOlvidServerUrl(em, realm);
        magicKeycloakConfigurationLink.magic = new MagicKeycloakConfigurationLink.Magic();
        magicKeycloakConfigurationLink.magic.username = username;
        magicKeycloakConfigurationLink.magic.token = magicToken;
        return ConfigurationLinkHelper.serializeConfigurationLink(magicKeycloakConfigurationLink);
    }

    public static String generateConfigurationLink(EntityManager em, RealmModel realm, String key) throws JsonProcessingException {
        ApiKeyConfigurationLink apiKeyConfigurationLink = new ApiKeyConfigurationLink();
        apiKeyConfigurationLink.olvidServerUrl = ConfigurationLinkHelper.getOlvidServerUrl(em, realm);
        apiKeyConfigurationLink.apiKey = key;
        return ConfigurationLinkHelper.serializeConfigurationLink(apiKeyConfigurationLink);
    }

    private static String getKeycloakRealmUrl(EntityManager em, RealmModel realmModel, KeycloakSession session) {
        Object baseRealmUrl;
        String keycloakServerUrl = OlvidConfigurationDao.getStringConfiguration(em, realmModel.getId(), "keycloakUrl");
        if (keycloakServerUrl != null) {
            keycloakServerUrl = keycloakServerUrl.replaceAll("/*$", "");
            baseRealmUrl = keycloakServerUrl + session.getContext().getUri(UrlType.FRONTEND).getBaseUri().getPath();
        } else {
            baseRealmUrl = session.getContext().getUri(UrlType.FRONTEND).getBaseUri().toString();
        }
        if (!((String)baseRealmUrl).endsWith("/")) {
            baseRealmUrl = (String)baseRealmUrl + "/";
        }
        return (String)baseRealmUrl + "realms/" + realmModel.getName() + "/";
    }

    private static String getOlvidServerUrl(EntityManager em, RealmModel realmModel) {
        String olvidServerUrl = OlvidConfigurationDao.getStringConfiguration(em, realmModel.getId(), "serverUrl");
        return olvidServerUrl == null || olvidServerUrl.isEmpty() ? null : olvidServerUrl;
    }

    private static String serializeConfigurationLink(Object jsonConfigurationLink) throws JsonProcessingException {
        return "https://configuration.olvid.io/#" + Base64.getUrlEncoder().encodeToString(objectMapper.writeValueAsBytes(jsonConfigurationLink));
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class KeycloakConfigurationLink {
        @JsonProperty(value="server")
        public String olvidServerUrl;
        @JsonProperty(value="keycloak")
        public Keycloak keycloak;

        public static class Keycloak {
            @JsonProperty(value="server")
            public String realmUrl;
            @JsonProperty(value="cid")
            public String clientId;
            @JsonProperty(value="secret")
            public String clientSecret;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LegacyBotConfigurationLink {
        @JsonProperty(value="server")
        public String olvidServerUrl;
        @JsonProperty(value="keycloak")
        public Keycloak keycloak;
        @JsonProperty(value="bot")
        public Bot bot;

        public static class Bot {
            public String username;
            public String password;
        }

        public static class Keycloak {
            @JsonProperty(value="server")
            public String realmUrl;
            @JsonProperty(value="cid")
            public String clientId;
            @JsonProperty(value="secret")
            public String clientSecret;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class BotConfigurationLink {
        @JsonProperty(value="server")
        public String olvidServerUrl;
        @JsonProperty(value="keycloak")
        public Keycloak keycloak;
        @JsonProperty(value="magic")
        public Magic magic;

        public static class Magic {
            public String username;
            public String token;
        }

        public static class Keycloak {
            @JsonProperty(value="server")
            public String realmUrl;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class MagicKeycloakConfigurationLink {
        @JsonProperty(value="server")
        public String olvidServerUrl;
        @JsonProperty(value="keycloak")
        public Keycloak keycloak;
        @JsonProperty(value="magic")
        public Magic magic;

        public static class Magic {
            public String username;
            public String token;
        }

        public static class Keycloak {
            @JsonProperty(value="server")
            public String realmUrl;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ApiKeyConfigurationLink {
        @JsonProperty(value="server")
        public String olvidServerUrl;
        @JsonProperty(value="apikey")
        public String apiKey;
    }
}

