/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.jpa;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.datatypes.GroupBlob;
import io.olvid.keycloak.datatypes.OlvidUserDetailsSignatureSignerContext;
import io.olvid.keycloak.rest.OlvidServerApiHelper;
import io.olvid.keycloak.rest.Utils;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

@NamedQueries(value={@NamedQuery(name="OlvidGroup.getById", query="SELECT og FROM OlvidGroup og WHERE og.realmId = :realmId and og.keycloakGroupId = :keycloakGroupId"), @NamedQuery(name="OlvidGroup.getAllWithAPushTopicByRealm", query="SELECT og FROM OlvidGroup og WHERE og.realmId = :realmId and og.pushTopic IS NOT NULL"), @NamedQuery(name="OlvidGroup.getAllEnabledByRealm", query="SELECT og FROM OlvidGroup og WHERE og.realmId = :realmId AND enabled = TRUE"), @NamedQuery(name="OlvidGroup.getAllWithPhoto", query="SELECT og FROM OlvidGroup og WHERE og.groupPhotoUid IS NOT NULL")})
@Entity
@IdClass(value=OlvidGroupId.class)
@Table(name="OLVID_GROUP")
public class OlvidGroup {
    protected static final Logger logger = Logger.getLogger(OlvidGroup.class);
    @Id
    @Column(name="REALM_ID")
    private String realmId;
    @Id
    @Column(name="KEYCLOAK_GROUP_ID")
    private String keycloakGroupId;
    @Column(name="GROUP_UID")
    private byte[] groupUid;
    @Column(name="LAST_MODIFICATION_TIMESTAMP", nullable=false)
    private long lastModificationTimestamp;
    @Column(name="PUSH_TOPIC")
    private String pushTopic;
    @Column(name="GROUP_PHOTO_UID")
    private byte[] groupPhotoUid;
    @Column(name="SHARED_SETTINGS")
    private String serializedSharedSettings;
    @Column(name="SIGNED_GROUP_BLOB", nullable=false)
    private String signedGroupBlob;
    @Column(name="ENABLED", nullable=false)
    private boolean enabled;

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public String getKeycloakGroupId() {
        return this.keycloakGroupId;
    }

    public void setKeycloakGroupId(String keycloakGroupId) {
        this.keycloakGroupId = keycloakGroupId;
    }

    public byte[] getGroupUid() {
        return this.groupUid;
    }

    public void setGroupUid(byte[] groupUid) {
        this.groupUid = groupUid;
    }

    public long getLastModificationTimestamp() {
        return this.lastModificationTimestamp;
    }

    public void setLastModificationTimestamp(long lastModificationTimestamp) {
        this.lastModificationTimestamp = lastModificationTimestamp;
    }

    public String getPushTopic() {
        return this.pushTopic;
    }

    public void setPushTopic(String pushTopic) {
        this.pushTopic = pushTopic;
    }

    public byte[] getGroupPhotoUid() {
        return this.groupPhotoUid;
    }

    public void setGroupPhotoUid(byte[] groupPhotoUid) {
        this.groupPhotoUid = groupPhotoUid;
    }

    public String getSignedGroupBlob() {
        return this.signedGroupBlob;
    }

    public String getSerializedSharedSettings() {
        return this.serializedSharedSettings;
    }

    public void setSerializedSharedSettings(String serializedSharedSettings) {
        this.serializedSharedSettings = serializedSharedSettings;
    }

    public void setSignedGroupBlob(String signedGroupBlob) {
        this.signedGroupBlob = signedGroupBlob;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public GroupBlob getGroupBlob(ObjectMapper jsonObjectMapper) {
        try {
            JWSInput jwsInput = new JWSInput(this.signedGroupBlob);
            return (GroupBlob)jsonObjectMapper.readValue(jwsInput.readContentAsString(), GroupBlob.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static OlvidGroup createOlvidGroupFromModelAndSign(KeycloakSession session, EntityManager em, RealmModel realmModel, GroupModel groupModel, ObjectMapper jsonObjectMapper, SecureRandom random) throws Exception {
        OlvidGroup olvidGroup = new OlvidGroup();
        olvidGroup.realmId = realmModel.getId();
        olvidGroup.keycloakGroupId = groupModel.getId();
        olvidGroup.groupUid = new byte[32];
        random.nextBytes(olvidGroup.groupUid);
        olvidGroup.lastModificationTimestamp = System.currentTimeMillis();
        olvidGroup.pushTopic = OlvidServerApiHelper.requestNewPushTopic(session, em, realmModel.getId(), jsonObjectMapper);
        if (olvidGroup.pushTopic == null) {
            logger.warn((Object)"Failed to get a push topic");
        }
        olvidGroup.groupPhotoUid = null;
        olvidGroup.serializedSharedSettings = null;
        GroupBlob groupBlob = GroupBlob.createPartialBlobFromGroupModel(session, em, jsonObjectMapper, realmModel, groupModel, random);
        groupBlob.bytesGroupUid = olvidGroup.groupUid;
        groupBlob.pushTopic = olvidGroup.pushTopic;
        groupBlob.photoUid = null;
        groupBlob.encodedPhotoKey = null;
        groupBlob.serializedSharedSettings = null;
        OlvidUserDetailsSignatureSignerContext signatureSignerContext = OlvidUserDetailsSignatureSignerContext.createForRealm(session, em, realmModel);
        if (signatureSignerContext == null) {
            logger.warn((Object)("Unable to create signature context for createFromGroupModelAndSign for group: " + groupModel.getName() + "; groupId: " + groupModel.getId()));
            throw new Exception();
        }
        logger.info((Object)("Signing groupBlob of group " + olvidGroup.keycloakGroupId));
        JWSBuilder jwsBuilder = new JWSBuilder();
        olvidGroup.signedGroupBlob = jwsBuilder.content(jsonObjectMapper.writeValueAsBytes((Object)groupBlob)).sign((SignatureSignerContext)signatureSignerContext);
        olvidGroup.enabled = Utils.isOlvidGroup(groupModel);
        return olvidGroup;
    }

    public static void insert(EntityManager em, OlvidGroup data) {
        em.persist((Object)data);
        em.flush();
    }

    public String toString() {
        return "OlvidGroup{realmId='" + this.realmId + "', keycloakGroupId='" + this.keycloakGroupId + "', groupUid=" + Arrays.toString(this.groupUid) + ", lastModificationTimestamp=" + this.lastModificationTimestamp + ", pushTopic='" + this.pushTopic + "', groupPhotoUid=" + Arrays.toString(this.groupPhotoUid) + ", serializedSharedSettings='" + this.serializedSharedSettings + "', signedGroupBlob='" + this.signedGroupBlob + "', enabled=" + this.enabled + "}";
    }

    public static class OlvidGroupId
    implements Serializable {
        private String realmId;
        private String keycloakGroupId;

        public int hashCode() {
            int hashCode = this.realmId == null ? 0 : this.realmId.hashCode();
            hashCode = 31 * hashCode + (this.keycloakGroupId == null ? 0 : this.keycloakGroupId.hashCode());
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OlvidGroupId) {
                OlvidGroupId casted = (OlvidGroupId)obj;
                return Objects.equals(casted.realmId, this.realmId) && Objects.equals(casted.keycloakGroupId, this.keycloakGroupId);
            }
            return false;
        }
    }
}

