/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.jpa;

import io.olvid.keycloak.jpa.OlvidExternalLink;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class OlvidExternalLinkDao {
    public static List<OlvidExternalLink> getAllOlvidExternalLinkForRealmId(EntityManager em, String realmId, List<String> filters) {
        try {
            TypedQuery q;
            if (filters != null && !filters.isEmpty()) {
                q = em.createNamedQuery("OlvidExternalLinks.getByTags", OlvidExternalLink.class);
                q.setParameter("tags", (Object)filters.stream().map(filter -> "%" + filter + "%").collect(Collectors.joining("|")));
            } else {
                q = em.createNamedQuery("OlvidExternalLinks.getAllByRealmId", OlvidExternalLink.class);
            }
            q.setParameter("realmId", (Object)realmId);
            return q.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public static List<OlvidExternalLink> getAllNotRevokedOlvidExternalLinkForRealmId(EntityManager em, String realmId) {
        try {
            TypedQuery q = em.createNamedQuery("OlvidExternalLinks.getAllNotRevokedByRealmId", OlvidExternalLink.class);
            q.setParameter("realmId", (Object)realmId);
            return q.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public static void revokeByRealmAndApiKey(EntityManager em, String realmId, String apiKey) {
        em.createNamedQuery("OlvidExternalLinks.revokeByApiKey").setParameter("realmId", (Object)realmId).setParameter("revokedDate", (Object)System.currentTimeMillis()).setParameter("apiKey", (Object)apiKey).executeUpdate();
    }
}

