/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.jpa;

import io.olvid.keycloak.jpa.OlvidConsoleLogs;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

public class OlvidConsoleLogsDao {
    protected static final Logger logger = Logger.getLogger(OlvidConsoleLogsDao.class);
    public static final String LOG_TYPE_REVOKE_ID = "idRevocation";
    public static final String LOG_TYPE_REMOVE_USER = "removeUser";
    public static final String LOG_TYPE_UNBOUND_USER = "unboundUser";
    public static final String LOG_TYPE_DISABLED_USER = "disabledUser";
    public static final String LOG_TYPE_ENABLED_USER = "enabledUser";
    public static final String LOG_TYPE_REVOCATION_UNKNOWN = "revocationUnknown";
    public static final String LOG_TYPE_SET_ROLE = "setRole";
    public static final String LOG_TYPE_SET_CONFIG = "setConfig";
    public static final String LOG_TYPE_SET_GLOBAL_SETTINGS = "setGlobalSettings";
    public static final String LOG_TYPE_AUTHENTICATION = "authentication";
    public static final String LOG_TYPE_ADMIN_CREATION = "adminCreation";
    public static final String LOG_TYPE_EXPORT_USERS = "exportUsers";
    public static final String LOG_TYPE_EXPORT_EXTERNAL_LINKS = "externalLinks";
    public static final String LOG_TYPE_EXPORT_DEVICES = "exportDevices";
    public static final String LOG_TYPE_DELETE_USER_REVOKED_DATA = "userRevokedData";
    public static final String LOG_TYPE_USER_CREATION = "userCreation";
    public static final String LOG_TYPE_USER_UPDATE = "userUpdate";
    public static final String LOG_TYPE_ADMIN_UPDATE = "adminUpdate";
    public static final String LOG_TYPE_ADMIN_DELETION = "adminDeletion";
    public static final String LOG_TYPE_BOT_CREATION = "botCreation";
    public static final String LOG_TYPE_BOT_RESET_LINK = "botResetLink";
    public static final String LOG_TYPE_BOT_UPDATE = "botUpdate";
    public static final String LOG_TYPE_GROUP_CREATE = "groupCreate";
    public static final String LOG_TYPE_GROUP_EDIT = "groupEdit";
    public static final String LOG_TYPE_GROUP_DELETE = "groupDelete";
    public static final String LOG_TYPE_GROUP_MOVE = "groupMove";
    public static final String LOG_TYPE_DUPLICATE_MOVE = "groupDuplicate";
    public static final String LOG_TYPE_EXTERNAL_LINKS = "externalLinks";
    public static final String PARAMETER_EXTERNAL_LINKS_CREATED = "External Links created:";
    public static final String PARAMETER_EXTERNAL_LINKS_EDITED = "External Links edited:";
    public static final String PARAMETER_EXTERNAL_LINKS_REVOKED = "External Links revoked:";
    public static final String LOG_TYPE_CIRCLE_VISIBILITY_CREATE = "circleVisibilityCreate";
    public static final String LOG_TYPE_CIRCLE_VISIBILITY_EDIT = "circleVisibilityEdit";
    public static final String LOG_TYPE_CIRCLE_VISIBILITY_DELETE = "circleVisibilityDelete";
    public static final String LOG_TYPE_CRON_ONE_TIME_JOB = "cronOneTimeJob";
    public static final String PARAMETER_CRON_ONE_TIME_JOB = "Cron One Time Job:";
    public static final String PARAMETER_ID_REVOKED = "User's id revoked: ";
    public static final String PARAMETER_USER_REMOVED = "User removed: ";
    public static final String PARAMETER_USER_UNBOUND = "User unbound: ";
    public static final String PARAMETER_USER_BOUND = "User bound: ";
    public static final String PARAMETER_USER_DISABLED = "User disabled: ";
    public static final String PARAMETER_USER_ENABLED = "User enabled: ";
    public static final String PARAMETER_REVOCATION_UNKNOWN = "User revoked: ";
    public static final String PARAMETER_SET_ROLE = "Changes roles of users:\n";
    public static final String PARAMETER_SET_CONFIG = "Realms modified:\n";
    public static final String PARAMETER_AUTHENTICATION = "Realm: ";
    public static final String PARAMETER_ADMIN_CREATION = "Admin created:";
    public static final String PARAMETER_USERS_EXPORTED = "Users exported:";
    public static final String PARAMETER_EXTERNAL_LINKS_EXPORTED = "External links exported:";
    public static final String PARAMETER_DEVICES_EXPORTED = "Devices exported:";
    public static final String PARAMETER_USER_REVOKED = "User revoked:";
    public static final String PARAMETER_USER_CREATION = "User created:";
    public static final String PARAMETER_USER_UPDATED = "User updated:";
    public static final String PARAMETER_BOT_UPDATED = "Bot updated:";
    public static final String PARAMETER_ADMIN_UPDATE = "Admin updated:";
    public static final String PARAMETER_ADMIN_DELETION = "Admin deletion:";
    public static final String PARAMETER_BOT_CREATION = "Bot created:";
    public static final String PARAMETER_BOT_RESET_LINK = "Bot's link reseted:";
    public static final String PARAMETER_GROUP_CREATE = "Group created:";
    public static final String PARAMETER_GROUP_EDITION = "Group edited:";
    public static final String PARAMETER_GROUP_MOVE = "Group moved:";
    public static final String PARAMETER_GROUP_DUPLICATE = "Group duplicated:";
    public static final String PARAMETER_MAGIC_LINK_CREATED = "Magic link created:";
    public static final String PARAMETER_CIRCLE_VISIBILITY_CREATION = "Circle visibility created:";
    public static final String PARAMETER_CIRCLE_VISIBILITY_EDITION = "Circle visibility edited:";
    public static final String PARAMETER_CIRCLE_VISIBILITY_DELETION = "Circle visibility deletion:";
    public static final String SELECT_QUERY = "SELECT ocl FROM OlvidConsoleLogs ocl ";
    public static final String SELECT_COUNT_QUERY = "SELECT COUNT(DISTINCT ocl) FROM OlvidConsoleLogs ocl ";
    public static final String SELECT_QUERY_WHERE = " WHERE ";
    public static final String SELECT_QUERY_FILTER = " (ocl.fullSearchString LIKE :?) ";
    public static final String SELECT_QUERY_FILTER_AND = " AND (ocl.fullSearchString LIKE :?) ";

    public static List<OlvidConsoleLogs> getLogs(EntityManager em, String realmId, String tabChose, List<String> filters, int limit, int offset) {
        try {
            StringBuilder sb = new StringBuilder(SELECT_QUERY);
            int count = 0;
            boolean addAnd = false;
            if (!(filters.isEmpty() && realmId.isEmpty() && tabChose.isEmpty())) {
                sb.append(SELECT_QUERY_WHERE);
            }
            if (!realmId.isEmpty()) {
                addAnd = true;
                sb.append(" ocl.realmId = :realmId ");
            }
            if (!tabChose.isEmpty()) {
                if (addAnd) {
                    sb.append(" AND ");
                }
                addAnd = true;
                sb.append(" ocl.logType = :tabChose ");
            }
            for (String filter : filters) {
                if (filter == null || filter.trim().isEmpty()) continue;
                if (addAnd) {
                    sb.append(" AND ");
                }
                addAnd = true;
                sb.append(SELECT_QUERY_FILTER.replace("?", "s" + count));
                ++count;
            }
            sb.append(" order by ocl.timestamp DESC");
            TypedQuery q = em.createQuery(sb.toString(), OlvidConsoleLogs.class);
            count = 0;
            for (String filter : filters) {
                if (filter == null || filter.trim().isEmpty()) continue;
                q.setParameter("s" + count, (Object)("%" + filter + "%"));
                ++count;
            }
            if (!realmId.isEmpty()) {
                q.setParameter("realmId", (Object)realmId);
            }
            if (!tabChose.isEmpty()) {
                q.setParameter("tabChose", (Object)tabChose);
            }
            q.setFirstResult(offset);
            q.setMaxResults(limit);
            return q.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public static Long getLogsCount(EntityManager em, String realmId, String tabChose, List<String> filters) {
        try {
            StringBuilder sb = new StringBuilder(SELECT_COUNT_QUERY);
            int count = 0;
            if (filters.size() > 0 || !realmId.equals("") || !tabChose.equals("")) {
                sb.append(SELECT_QUERY_WHERE);
                if (!realmId.equals("")) {
                    sb.append("ocl.realmId = :realmId");
                }
                if (!realmId.equals("") && !tabChose.equals("")) {
                    sb.append(" AND ");
                }
                if (!tabChose.equals("")) {
                    sb.append("ocl.logType = :tabChose");
                }
            }
            for (String filter : filters) {
                if (!realmId.equals("") || !tabChose.equals("")) {
                    sb.append(" AND ");
                }
                if (filter == null || filter.trim().length() == 0) continue;
                if (count == 0) {
                    sb.append(SELECT_QUERY_FILTER.replace("?", "s" + count));
                } else {
                    sb.append(SELECT_QUERY_FILTER_AND.replace("?", "s" + count));
                }
                ++count;
            }
            TypedQuery q = em.createQuery(sb.toString(), Long.class);
            count = 0;
            for (String filter : filters) {
                if (filter == null || filter.trim().length() == 0) continue;
                q.setParameter("s" + count, (Object)("%" + filter + "%"));
                ++count;
            }
            if (!realmId.equals("")) {
                q.setParameter("realmId", (Object)realmId);
            }
            if (!tabChose.equals("")) {
                q.setParameter("tabChose", (Object)tabChose);
            }
            return (Long)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public static List<String> getLogsType(EntityManager em) {
        try {
            TypedQuery q = em.createQuery("SELECT DISTINCT ocl.logType FROM OlvidConsoleLogs ocl", String.class);
            return q.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertLog(EntityManager em, String username, long timestamp, String logType, String parameter, String ipSource, String realmId) {
        EntityTransaction tx = null;
        boolean isDone = false;
        try {
            tx = em.getTransaction();
            tx.begin();
            OlvidConsoleLogs ocl = new OlvidConsoleLogs();
            ocl.setAdminUsername(username);
            ocl.setTimestamp(timestamp);
            ocl.setLogType(logType);
            ocl.setParameter(parameter);
            ocl.setIpSource(ipSource);
            ocl.setFullSearchString();
            ocl.setRealmId(realmId);
            OlvidConsoleLogs.insert(em, ocl);
            isDone = true;
        }
        catch (EntityExistsException entityExistsException) {
        }
        finally {
            if (isDone) {
                tx.commit();
            } else if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
    }

    public static void logUserEvent(EntityManager em, KeycloakSession session, RealmModel realmModel, String username, String realmName, String logType, String parameter, Map<String, Object> ret) {
        try {
            String sourceIp = "";
            try {
                sourceIp = session.getContext().getRequestHeaders().getHeaderString("X-Forwarded-For");
                if (sourceIp == null) {
                    sourceIp = session.getContext().getConnection().getRemoteAddr();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            long timestamp = System.currentTimeMillis();
            try {
                realmModel = session.realms().getRealmByName(realmName);
                OlvidConsoleLogsDao.insertLog(em, username, timestamp, logType, parameter, sourceIp, realmModel.getId());
            }
            catch (Exception e) {
                OlvidConsoleLogsDao.insertLog(em, username, timestamp, logType, parameter, sourceIp, "master");
            }
            ret.put("status", "SUCCESS");
            ret.put("message", logType);
            ret.put("data", parameter);
            em.flush();
        }
        catch (Exception e) {
            if (e.getMessage().contains("Duplicate")) {
                ret.put("status", "ERROR");
                ret.put("message", "Duplicate entry");
                ret.put("data", parameter);
            } else {
                ret.put("status", "ERROR");
                ret.put("message", "error");
                ret.put("data", parameter);
            }
            logger.warn((Object)"Exception : ", (Throwable)e);
        }
    }
}

