/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.jpa;

import io.olvid.keycloak.rest.Utils;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import org.jboss.logging.Logger;

@NamedQueries(value={@NamedQuery(name="OlvidConsoleLogs.applyVersion30003", query="UPDATE OlvidConsoleLogs ocl SET ocl.fullSearchString=CONCAT(IFNULL(ocl.adminUsername, ''), ' ', IFNULL(ocl.parameter, ''), ' ', IFNULL(ocl.ipSource, '')) WHERE ocl.fullSearchString=null")})
@Entity
@Table(name="OLVID_LOGS")
public class OlvidConsoleLogs {
    protected static final Logger logger = Logger.getLogger(OlvidConsoleLogs.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="LOG_ID")
    private Long id;
    @Column(name="ADMIN_USERNAME")
    private String adminUsername;
    @Column(name="LOG_TIMESTAMP")
    private long timestamp;
    @Column(name="LOG_TYPE")
    private String logType;
    @Column(name="LOG_PARAMETER")
    private String parameter;
    @Column(name="IP_SOURCE")
    private String ipSource;
    @Column(name="FULL_SEARCH_STRING")
    private String fullSearchString;
    @Column(name="REALM_ID")
    private String realmId;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public void setAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getLogType() {
        return this.logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public String getIpSource() {
        return this.ipSource;
    }

    public void setIpSource(String ipSource) {
        this.ipSource = ipSource;
    }

    public void setFullSearchString() {
        this.fullSearchString = Utils.unAccent(this.getAdminUsername() + " " + this.getParameter() + " " + this.getIpSource());
        if (this.fullSearchString.length() > 65000) {
            this.fullSearchString = this.fullSearchString.substring(0, 65000);
        }
    }

    public String getFullSearchString() {
        return this.fullSearchString;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public static void insert(EntityManager em, OlvidConsoleLogs ocl) {
        em.persist((Object)ocl);
        em.flush();
    }
}

