/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.jpa;

import io.olvid.keycloak.jpa.OlvidConfiguration;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.models.utils.KeycloakModelUtils;

public class OlvidConfigurationDao {
    protected static final Logger logger = Logger.getLogger(OlvidConfigurationDao.class);
    public static final String CONFIG_SERVER_URL = "serverUrl";
    public static final String CONFIG_SERVER_KEYCLOAK_API_KEY = "serverKeycloakApiKey";
    public static final String CONFIG_REVOCATION_ALLOWED = "revocationAllowed";
    public static final String CONFIG_TRANSFER_RESTRICTED = "transferRestricted";
    public static final String CONFIG_ADMIN_REALM = "admin";
    public static final String CONFIG_OLVID_USER_REALM = "olvid";
    public static final String CONFIG_CLIENT = "authClient";
    public static final String CONFIG_KEYCLOAK_URL = "keycloakUrl";
    public static final String CONFIG_KEY_ID = "keyChoosen";
    public static final String CONFIG_KEYCLOAK_PUSH_TOPIC = "keycloakPushTopic";
    public static final String CONFIG_ENABLE_BOTS_MANAGEMENT = "enableBotsManagement";
    public static final String CONFIG_SEARCH_RESULT_COUNT = "searchResultCount";
    public static final String CONFIG_OLD_DEVICE_TIME_LIMIT = "oldDeviceTimeLimit";
    public static final String CONFIG_SEARCH_INCLUDE_NOT_ACTIVATED_USERS = "isSearchIncludeNotActivatedUsers";
    public static final String CONFIG_LAST_RUN_PLUGIN_VERSION = "pluginVersion";
    public static final String CONFIG_ENABLE_VISIBILITY_CIRCLE = "enableVisibilityCircles";
    public static final String CONFIG_LICENSES_COUNT = "licensesCount";
    public static final String CONFIG_ENABLE_IDENTITY_AUTHENTICATION = "enableAuthenticationWithOlvidId";

    public static String getStringConfiguration(EntityManager em, String realmId, String name) {
        OlvidConfiguration oc = OlvidConfigurationDao.getOlvidConfiguration(em, realmId, name);
        if (oc != null) {
            return oc.getValue();
        }
        return null;
    }

    public static int getIntConfiguration(EntityManager em, String realmId, String name, int defaultValue) {
        OlvidConfiguration oc = OlvidConfigurationDao.getOlvidConfiguration(em, realmId, name);
        if (oc != null) {
            try {
                return Integer.parseInt(oc.getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static long getLongConfiguration(EntityManager em, String realmId, String name, long defaultValue) {
        OlvidConfiguration oc = OlvidConfigurationDao.getOlvidConfiguration(em, realmId, name);
        if (oc != null) {
            try {
                return Long.parseLong(oc.getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getBooleanConfiguration(EntityManager em, String realmId, String name, boolean defaultValue) {
        OlvidConfiguration oc = OlvidConfigurationDao.getOlvidConfiguration(em, realmId, name);
        if (oc != null) {
            return Boolean.parseBoolean(oc.getValue());
        }
        return defaultValue;
    }

    public static void setConfiguration(EntityManager em, String realmId, String name, String value) {
        em.getTransaction().begin();
        OlvidConfiguration oc = OlvidConfigurationDao.getOlvidConfiguration(em, realmId, name);
        if (oc != null) {
            if (value == null) {
                em.remove((Object)oc);
            } else {
                oc.setValue(value);
                em.merge((Object)oc);
            }
        } else if (value != null) {
            oc = new OlvidConfiguration();
            oc.setId(KeycloakModelUtils.generateId());
            oc.setRealmId(realmId);
            oc.setName(name);
            oc.setValue(value);
            em.persist((Object)oc);
        }
        em.flush();
        em.getTransaction().commit();
    }

    public static void setBooleanConfiguration(EntityManager em, String realmId, String key, Boolean value) {
        OlvidConfigurationDao.setConfiguration(em, realmId, key, value == null ? null : Boolean.toString(value));
    }

    public static void setIntConfiguration(EntityManager em, String realmId, String key, Integer value) {
        OlvidConfigurationDao.setConfiguration(em, realmId, key, value == null ? null : Integer.toString(value));
    }

    private static OlvidConfiguration getOlvidConfiguration(EntityManager em, String realmId, String name) {
        TypedQuery q = em.createNamedQuery("OlvidConfiguration.getConfiguration", OlvidConfiguration.class);
        q.setParameter("realmId", (Object)realmId);
        q.setParameter("name", (Object)name);
        try {
            return (OlvidConfiguration)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public static List<String> getRealmIdsForApiKey(EntityManager em, String apiKey) {
        Query q = em.createNamedQuery("OlvidConfiguration.getRealmIdsForApiKey");
        q.setParameter("apiKey", (Object)apiKey);
        try {
            return q.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }
}

