/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.jpa;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.Objects;

@NamedQueries(value={@NamedQuery(name="OlvidConfiguration.getConfiguration", query="SELECT oc FROM OlvidConfiguration oc WHERE oc.realmId = :realmId AND oc.name = :name"), @NamedQuery(name="OlvidConfiguration.cleanUselessConfiguration", query="DELETE FROM OlvidConfiguration oc WHERE oc.realmId not in :realmIds"), @NamedQuery(name="OlvidConfiguration.getRealmIdsForApiKey", query="SELECT oc.realmId FROM OlvidConfiguration oc WHERE oc.value = :apiKey")})
@Entity
@Table(name="OLVID_CONFIGURATION", uniqueConstraints={@UniqueConstraint(columnNames={"REALM_ID", "NAME"})})
public class OlvidConfiguration {
    public static final String ID_COLUMN = "ID";
    public static final String REALM_ID_COLUMN = "REALM_ID";
    public static final String NAME_COLUMN = "NAME";
    public static final String VALUE_COLUMN = "VALUE";
    @Id
    @Column(name="ID", length=36)
    private String id;
    @Column(name="REALM_ID", nullable=false)
    private String realmId;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="VALUE", nullable=false)
    private String value;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlvidConfiguration that = (OlvidConfiguration)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.realmId, that.realmId) && Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.realmId, this.name, this.value);
    }

    public String toString() {
        return "OlvidConfiguration{id='" + this.id + "', realmId='" + this.realmId + "', name='" + this.name + "', value='" + this.value + "'}";
    }
}

