/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto.keys;

import io.olvid.keycloak.datatypes.crypto.keys.AuthEncKey;
import io.olvid.keycloak.datatypes.crypto.keys.CryptographicKey;
import io.olvid.keycloak.datatypes.crypto.keys.MACKey;
import io.olvid.keycloak.datatypes.crypto.keys.SymEncKey;
import io.olvid.keycloak.datatypes.encoder.DictionaryKey;
import io.olvid.keycloak.datatypes.encoder.Encoded;
import java.util.HashMap;

public abstract class SymmetricKey
extends CryptographicKey {
    public SymmetricKey(byte algorithmClass, byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        super(algorithmClass, algorithmImplementation, key);
    }

    public static SymmetricKey of(byte algorithmClass, byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        switch (algorithmClass) {
            case 2: {
                return AuthEncKey.of(algorithmImplementation, key);
            }
            case 1: {
                return MACKey.of(algorithmImplementation, key);
            }
            case 0: {
                return SymEncKey.of(algorithmImplementation, key);
            }
        }
        return null;
    }
}

