/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto.keys;

import io.olvid.keycloak.datatypes.crypto.keys.SymEncCTRAES256Key;
import io.olvid.keycloak.datatypes.crypto.keys.SymmetricKey;
import io.olvid.keycloak.datatypes.encoder.DecodingException;
import io.olvid.keycloak.datatypes.encoder.DictionaryKey;
import io.olvid.keycloak.datatypes.encoder.Encoded;
import java.security.InvalidParameterException;
import java.util.HashMap;

public abstract class SymEncKey
extends SymmetricKey {
    public static final byte ALGO_IMPL_CTR_AES256 = 0;
    public static final String SYMENC_KEY_NAME = "enckey";
    private final byte[] keyBytes;

    public SymEncKey(byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) throws InvalidParameterException {
        super((byte)0, algorithmImplementation, key);
        try {
            this.keyBytes = key.get(new DictionaryKey(SYMENC_KEY_NAME)).decodeBytes();
        }
        catch (DecodingException e) {
            throw new InvalidParameterException();
        }
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public int getKeyLength() {
        return this.keyBytes.length;
    }

    public static SymEncKey of(byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        switch (algorithmImplementation) {
            case 0: {
                return new SymEncCTRAES256Key(key);
            }
        }
        return null;
    }
}

