/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto.keys;

import io.olvid.keycloak.datatypes.crypto.keys.PublicKey;
import io.olvid.keycloak.datatypes.crypto.keys.SignatureECSdsaCurve25519PublicKey;
import io.olvid.keycloak.datatypes.crypto.keys.SignatureECSdsaMDCPublicKey;
import io.olvid.keycloak.datatypes.encoder.DictionaryKey;
import io.olvid.keycloak.datatypes.encoder.Encoded;
import java.util.HashMap;

public abstract class SignaturePublicKey
extends PublicKey {
    public static final byte ALGO_IMPL_EC_SDSA_MDC = 0;
    public static final byte ALGO_IMPL_EC_SDSA_CURVE25519 = 1;

    public SignaturePublicKey(byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        super((byte)17, algorithmImplementation, key);
    }

    public static SignaturePublicKey of(byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        switch (algorithmImplementation) {
            case 0: {
                return new SignatureECSdsaMDCPublicKey(key);
            }
            case 1: {
                return new SignatureECSdsaCurve25519PublicKey(key);
            }
        }
        return null;
    }
}

