/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto.keys;

import io.olvid.keycloak.datatypes.crypto.keys.CryptographicKey;
import io.olvid.keycloak.datatypes.crypto.keys.EncryptionPublicKey;
import io.olvid.keycloak.datatypes.crypto.keys.ServerAuthenticationPublicKey;
import io.olvid.keycloak.datatypes.crypto.keys.SignaturePublicKey;
import io.olvid.keycloak.datatypes.encoder.DictionaryKey;
import io.olvid.keycloak.datatypes.encoder.Encoded;
import java.util.HashMap;

public abstract class PublicKey
extends CryptographicKey {
    public PublicKey(byte algorithmClass, byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        super(algorithmClass, algorithmImplementation, key);
    }

    public static PublicKey of(byte algorithmClass, byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        switch (algorithmClass) {
            case 18: {
                return EncryptionPublicKey.of(algorithmImplementation, key);
            }
            case 17: {
                return SignaturePublicKey.of(algorithmImplementation, key);
            }
            case 20: {
                return ServerAuthenticationPublicKey.of(algorithmImplementation, key);
            }
        }
        return null;
    }
}

