/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto.keys;

import io.olvid.keycloak.datatypes.crypto.keys.MACHmacSha256Key;
import io.olvid.keycloak.datatypes.crypto.keys.SymmetricKey;
import io.olvid.keycloak.datatypes.encoder.DecodingException;
import io.olvid.keycloak.datatypes.encoder.DictionaryKey;
import io.olvid.keycloak.datatypes.encoder.Encoded;
import java.security.InvalidParameterException;
import java.util.HashMap;

public abstract class MACKey
extends SymmetricKey {
    public static final byte ALGO_IMPL_HMAC_SHA256 = 0;
    public static final String MACKEY_KEY_NAME = "mackey";
    private final byte[] keyBytes;

    public MACKey(byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) throws InvalidParameterException {
        super((byte)1, algorithmImplementation, key);
        try {
            this.keyBytes = key.get(new DictionaryKey(MACKEY_KEY_NAME)).decodeBytes();
        }
        catch (DecodingException e) {
            throw new InvalidParameterException();
        }
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public int getKeyLength() {
        return this.keyBytes.length;
    }

    public static MACKey of(byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        switch (algorithmImplementation) {
            case 0: {
                return new MACHmacSha256Key(key);
            }
        }
        return null;
    }
}

