/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto.keys;

import io.olvid.keycloak.datatypes.crypto.Suite;
import io.olvid.keycloak.datatypes.crypto.keys.EncryptionEciesPublicKey;
import io.olvid.keycloak.datatypes.encoder.DecodingException;
import io.olvid.keycloak.datatypes.encoder.DictionaryKey;
import io.olvid.keycloak.datatypes.encoder.Encoded;
import io.olvid.keycloak.datatypes.encoder.EncodingException;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.HashMap;

public class EncryptionEciesMDCPublicKey
extends EncryptionEciesPublicKey {
    public static final int COMPACT_KEY_LENGTH = 1 + Suite.getCurve((String)"MDC").byteLength;

    public EncryptionEciesMDCPublicKey(HashMap<DictionaryKey, Encoded> key) throws InvalidParameterException {
        super((byte)0, key);
    }

    public static EncryptionEciesMDCPublicKey of(byte[] compactKeyBytes) throws DecodingException {
        if (compactKeyBytes[0] != 0 || compactKeyBytes.length != COMPACT_KEY_LENGTH) {
            throw new DecodingException();
        }
        HashMap<DictionaryKey, Encoded> key = new HashMap<DictionaryKey, Encoded>();
        try {
            key.put(new DictionaryKey("y"), Encoded.of(Encoded.bigUIntFromBytes(Arrays.copyOfRange(compactKeyBytes, 1, compactKeyBytes.length)), COMPACT_KEY_LENGTH - 1));
        }
        catch (EncodingException e) {
            throw new DecodingException();
        }
        return new EncryptionEciesMDCPublicKey(key);
    }
}

