/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto;

import io.olvid.keycloak.datatypes.crypto.AuthEnc;
import io.olvid.keycloak.datatypes.crypto.AuthEncAES256ThenSHA256;
import io.olvid.keycloak.datatypes.crypto.Curve25519;
import io.olvid.keycloak.datatypes.crypto.EdwardCurve;
import io.olvid.keycloak.datatypes.crypto.Hash;
import io.olvid.keycloak.datatypes.crypto.HashSHA256;
import io.olvid.keycloak.datatypes.crypto.KDF;
import io.olvid.keycloak.datatypes.crypto.KDFSha256;
import io.olvid.keycloak.datatypes.crypto.MDC;
import io.olvid.keycloak.datatypes.crypto.PRNG;
import io.olvid.keycloak.datatypes.crypto.PRNGHmacSHA256;
import io.olvid.keycloak.datatypes.crypto.PublicKeyEncryption;
import io.olvid.keycloak.datatypes.crypto.PublicKeyEncryptionEciesCurve25519;
import io.olvid.keycloak.datatypes.crypto.PublicKeyEncryptionEciesMDC;
import io.olvid.keycloak.datatypes.crypto.Signature;
import io.olvid.keycloak.datatypes.crypto.SignatureECSdsaCurve25519;
import io.olvid.keycloak.datatypes.crypto.SignatureECSdsaMDC;
import io.olvid.keycloak.datatypes.crypto.keys.CryptographicKey;
import io.olvid.keycloak.datatypes.crypto.keys.PublicKey;
import java.security.InvalidParameterException;
import java.security.PrivateKey;

public class Suite {
    public static final int LATEST_VERSION = 0;
    public static final int MINIMUM_ACCEPTABLE_VERSION = 0;

    public static Hash getHash(String hashName) {
        switch (hashName) {
            default: 
        }
        return new HashSHA256();
    }

    public static PRNG getPRNG(String prngName, byte[] seed) throws InvalidParameterException {
        switch (prngName) {
            default: 
        }
        return new PRNGHmacSHA256(seed);
    }

    public static PRNG getDefaultPRNG(int obliviousEngineVersion, byte[] seed) {
        return Suite.getPRNG("prng_hmac_sha-256", seed);
    }

    public static EdwardCurve getCurve(String curveName) {
        switch (curveName) {
            case "Curve_25519": {
                return Curve25519.getInstance();
            }
        }
        return MDC.getInstance();
    }

    public static KDF getKDF(String kdfName) {
        switch (kdfName) {
            default: 
        }
        return new KDFSha256();
    }

    public static PublicKeyEncryption getPublicKeyEncryption(CryptographicKey key) {
        if (!(key instanceof PublicKey) && !(key instanceof PrivateKey)) {
            return null;
        }
        if (key.getAlgorithmClass() != 18) {
            return null;
        }
        switch (key.getAlgorithmImplementation()) {
            case 0: {
                return new PublicKeyEncryptionEciesMDC();
            }
            case 1: {
                return new PublicKeyEncryptionEciesCurve25519();
            }
        }
        return null;
    }

    public static Signature getSignature(CryptographicKey key) {
        if (!(key instanceof PublicKey)) {
            return null;
        }
        if (key.getAlgorithmClass() != 17) {
            return null;
        }
        switch (key.getAlgorithmImplementation()) {
            case 0: {
                return new SignatureECSdsaMDC();
            }
            case 1: {
                return new SignatureECSdsaCurve25519();
            }
        }
        return null;
    }

    public static AuthEnc getAuthEnc() {
        return new AuthEncAES256ThenSHA256();
    }
}

