/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto;

import io.olvid.keycloak.datatypes.crypto.EdwardCurve;
import io.olvid.keycloak.datatypes.crypto.HashSHA256;
import io.olvid.keycloak.datatypes.crypto.HashSHA512;
import io.olvid.keycloak.datatypes.crypto.Signature;
import io.olvid.keycloak.datatypes.crypto.keys.EdwardCurvePoint;
import io.olvid.keycloak.datatypes.crypto.keys.SignatureECSdsaPublicKey;
import io.olvid.keycloak.datatypes.encoder.Encoded;
import io.olvid.keycloak.datatypes.encoder.EncodingException;
import java.math.BigInteger;
import java.util.Arrays;

abstract class SignatureECSdsa
implements Signature {
    private final EdwardCurve curve;

    SignatureECSdsa(EdwardCurve curve) {
        this.curve = curve;
    }

    public boolean internalVerify(SignatureECSdsaPublicKey publicKey, byte[] message, byte[] signature) {
        try {
            boolean isSha512;
            int l = this.curve.byteLength;
            if (signature.length == 32 + l) {
                isSha512 = false;
            } else if (signature.length == 64 + l) {
                isSha512 = true;
            } else {
                return false;
            }
            EdwardCurvePoint A = EdwardCurvePoint.noCheckFactory(publicKey.getAx(), publicKey.getAy(), this.curve);
            byte[] hash = Arrays.copyOfRange(signature, 0, signature.length - l);
            BigInteger e = Encoded.bigUIntFromBytes(hash);
            BigInteger y = Encoded.bigUIntFromBytes(Arrays.copyOfRange(signature, signature.length - l, signature.length));
            if (y.compareTo(this.curve.q) >= 0) {
                return false;
            }
            EdwardCurvePoint[] points = this.curve.mulAdd(y, this.curve.G, e, A);
            byte[] hashInput = new byte[message.length + 2 * l];
            System.arraycopy(Encoded.bytesFromBigUInt(publicKey.getAy(), l), 0, hashInput, l, l);
            System.arraycopy(message, 0, hashInput, 2 * l, message.length);
            for (EdwardCurvePoint point : points) {
                byte[] recomputedHash;
                System.arraycopy(Encoded.bytesFromBigUInt(point.getY(), l), 0, hashInput, 0, l);
                byte[] byArray = recomputedHash = isSha512 ? new HashSHA512().digest(hashInput) : new HashSHA256().digest(hashInput);
                if (!Arrays.equals(hash, recomputedHash)) continue;
                return true;
            }
        }
        catch (EncodingException encodingException) {
            // empty catch block
        }
        return false;
    }
}

