/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto;

import io.olvid.keycloak.datatypes.crypto.AuthEncAES256ThenSHA256;
import io.olvid.keycloak.datatypes.crypto.KemEcies256Kem512;
import io.olvid.keycloak.datatypes.crypto.PRNG;
import io.olvid.keycloak.datatypes.crypto.PublicKeyEncryption;
import io.olvid.keycloak.datatypes.crypto.keys.CiphertextAndKey;
import io.olvid.keycloak.datatypes.crypto.keys.EncryptionPublicKey;
import java.security.InvalidKeyException;

abstract class PublicKeyEncryptionEcies
implements PublicKeyEncryption {
    private final KemEcies256Kem512 kem;
    private final AuthEncAES256ThenSHA256 dem;

    protected PublicKeyEncryptionEcies(KemEcies256Kem512 kem) {
        this.kem = kem;
        this.dem = new AuthEncAES256ThenSHA256();
    }

    @Override
    public byte[] encrypt(EncryptionPublicKey publicKey, byte[] plaintext, PRNG prng) throws InvalidKeyException {
        byte[] ciphertextBytes = new byte[this.kem.ciphertextLength() + this.dem.ciphertextLengthFromPlaintextLength(plaintext.length)];
        CiphertextAndKey ciphertextAndKey = this.kem.encrypt(publicKey, prng);
        System.arraycopy(ciphertextAndKey.getCiphertext(), 0, ciphertextBytes, 0, this.kem.ciphertextLength());
        byte[] demCiphertext = this.dem.encrypt(ciphertextAndKey.getKey(), plaintext, prng);
        System.arraycopy(demCiphertext, 0, ciphertextBytes, this.kem.ciphertextLength(), this.dem.ciphertextLengthFromPlaintextLength(plaintext.length));
        return ciphertextBytes;
    }
}

