/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto;

import io.olvid.keycloak.datatypes.crypto.MAC;
import io.olvid.keycloak.datatypes.crypto.keys.MACKey;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class MACHmacSha256
implements MAC {
    static final int OUTPUT_LENGTH = 32;

    MACHmacSha256() {
    }

    @Override
    public byte[] digest(MACKey key, byte[] bytes) throws InvalidKeyException {
        try {
            Mac h = Mac.getInstance("HmacSHA256");
            h.init(new SecretKeySpec(key.getKeyBytes(), "HmacSHA256"));
            return h.doFinal(bytes);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    @Override
    public byte[] digest(MACKey key, byte[] bytes, int inputLen) throws InvalidKeyException {
        try {
            Mac h = Mac.getInstance("HmacSHA256");
            h.init(new SecretKeySpec(key.getKeyBytes(), "HmacSHA256"));
            h.update(bytes, 0, inputLen);
            return h.doFinal();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }
}

