/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto;

import io.olvid.keycloak.datatypes.crypto.EdwardCurve;
import io.olvid.keycloak.datatypes.crypto.KDFDelegateForAuthEncAES256ThenSHA256;
import io.olvid.keycloak.datatypes.crypto.KDFSha256;
import io.olvid.keycloak.datatypes.crypto.KEM;
import io.olvid.keycloak.datatypes.crypto.PRNG;
import io.olvid.keycloak.datatypes.crypto.keys.AuthEncKey;
import io.olvid.keycloak.datatypes.crypto.keys.CiphertextAndKey;
import io.olvid.keycloak.datatypes.crypto.keys.EncryptionEciesPublicKey;
import io.olvid.keycloak.datatypes.crypto.keys.EncryptionPublicKey;
import io.olvid.keycloak.datatypes.encoder.Encoded;
import io.olvid.keycloak.datatypes.encoder.EncodingException;
import java.math.BigInteger;

abstract class KemEcies256Kem512
implements KEM {
    private final EdwardCurve curve;
    public static final int CIPHERTEXT_LENGTH = 32;

    protected KemEcies256Kem512(EdwardCurve curve) {
        this.curve = curve;
    }

    CiphertextAndKey internalEncrypt(EncryptionPublicKey publicKey, PRNG prng) {
        BigInteger r;
        BigInteger Ay = ((EncryptionEciesPublicKey)publicKey).getAy();
        int l = this.curve.byteLength;
        while ((r = prng.bigInt(this.curve.q)).equals(BigInteger.ZERO)) {
        }
        BigInteger Gy = this.curve.G.getY();
        BigInteger By = this.curve.scalarMultiplication(r, Gy);
        BigInteger Dy = this.curve.scalarMultiplication(r, Ay);
        try {
            byte[] ciphertext = Encoded.bytesFromBigUInt(By, l);
            byte[] seedBytes = new byte[2 * l];
            System.arraycopy(ciphertext, 0, seedBytes, 0, l);
            System.arraycopy(Encoded.bytesFromBigUInt(Dy, l), 0, seedBytes, l, l);
            AuthEncKey key = (AuthEncKey)new KDFSha256().gen(seedBytes, new KDFDelegateForAuthEncAES256ThenSHA256())[0];
            return new CiphertextAndKey(key, ciphertext);
        }
        catch (EncodingException e) {
            return null;
        }
    }

    @Override
    public int ciphertextLength() {
        return 32;
    }
}

