/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto;

import io.olvid.keycloak.datatypes.crypto.keys.EncryptionPublicKey;
import io.olvid.keycloak.datatypes.crypto.keys.ServerAuthenticationPublicKey;
import io.olvid.keycloak.datatypes.encoder.DecodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class Identity {
    private final String server;
    private final ServerAuthenticationPublicKey serverAuthenticationPublicKey;
    private final EncryptionPublicKey encryptionPublicKey;

    public Identity(String server, ServerAuthenticationPublicKey serverAuthenticationPublicKey, EncryptionPublicKey encryptionPublicKey) {
        this.server = server;
        this.serverAuthenticationPublicKey = serverAuthenticationPublicKey;
        this.encryptionPublicKey = encryptionPublicKey;
    }

    public static Identity of(byte[] identityBytes) throws DecodingException {
        int serverPkLength;
        int pos = -1;
        for (int i = 0; i < identityBytes.length; ++i) {
            if (identityBytes[i] != 0) continue;
            pos = i;
            break;
        }
        if (pos == -1) {
            throw new DecodingException();
        }
        String server = new String(Arrays.copyOfRange(identityBytes, 0, pos), StandardCharsets.UTF_8);
        if ((serverPkLength = ServerAuthenticationPublicKey.getCompactKeyLength(identityBytes[++pos])) < 0) {
            throw new DecodingException();
        }
        ServerAuthenticationPublicKey serverAuthenticationPublicKey = ServerAuthenticationPublicKey.of(Arrays.copyOfRange(identityBytes, pos, pos + serverPkLength));
        int anonAuthPkLength = EncryptionPublicKey.getCompactKeyLength(identityBytes[pos += serverPkLength]);
        if (anonAuthPkLength < 0) {
            throw new DecodingException();
        }
        EncryptionPublicKey encryptionPublicKey = EncryptionPublicKey.of(Arrays.copyOfRange(identityBytes, pos, pos + anonAuthPkLength));
        return new Identity(server, serverAuthenticationPublicKey, encryptionPublicKey);
    }

    public byte[] getBytes() {
        byte[] serverBytes = this.server.getBytes(StandardCharsets.UTF_8);
        byte[] serverAuthenticationPublicKeyBytes = this.serverAuthenticationPublicKey.getCompactKey();
        byte[] anonAuthPublicKeyBytes = this.encryptionPublicKey.getCompactKey();
        byte[] identityBytes = new byte[serverBytes.length + 1 + serverAuthenticationPublicKeyBytes.length + anonAuthPublicKeyBytes.length];
        System.arraycopy(serverBytes, 0, identityBytes, 0, serverBytes.length);
        identityBytes[serverBytes.length] = 0;
        System.arraycopy(serverAuthenticationPublicKeyBytes, 0, identityBytes, serverBytes.length + 1, serverAuthenticationPublicKeyBytes.length);
        System.arraycopy(anonAuthPublicKeyBytes, 0, identityBytes, serverBytes.length + 1 + serverAuthenticationPublicKeyBytes.length, anonAuthPublicKeyBytes.length);
        return identityBytes;
    }

    public String getServer() {
        return this.server;
    }

    public ServerAuthenticationPublicKey getServerAuthenticationPublicKey() {
        return this.serverAuthenticationPublicKey;
    }

    public EncryptionPublicKey getEncryptionPublicKey() {
        return this.encryptionPublicKey;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getBytes());
    }

    public boolean equals(Object other) {
        if (!(other instanceof Identity)) {
            return false;
        }
        return Arrays.equals(this.getBytes(), ((Identity)other).getBytes());
    }
}

