/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto;

import io.olvid.keycloak.datatypes.crypto.keys.EdwardCurvePoint;
import java.math.BigInteger;
import java.util.ArrayList;

public abstract class EdwardCurve {
    public static final String MDC = "MDC";
    public static final String CURVE_25519 = "Curve_25519";
    public BigInteger p = null;
    public BigInteger q = null;
    public BigInteger d = null;
    public BigInteger nu = null;
    public EdwardCurvePoint G = null;
    public BigInteger tonelliNonQR = null;
    public BigInteger tonelliT = null;
    public int tonelliS = 0;
    public int byteLength = 0;

    public BigInteger xCoordinateFromY(BigInteger Y) {
        BigInteger Y2 = Y.multiply(Y).mod(this.p);
        BigInteger X2 = BigInteger.ONE.subtract(this.d.multiply(Y2)).modInverse(this.p).multiply(BigInteger.ONE.subtract(Y2)).mod(this.p);
        return this.modSqrt(X2);
    }

    private BigInteger modSqrt(BigInteger x) {
        BigInteger pMinusOneDiv2 = this.p.shiftRight(1);
        if (!x.modPow(pMinusOneDiv2, this.p).equals(BigInteger.ONE)) {
            return null;
        }
        if (this.p.testBit(1)) {
            return x.modPow(this.p.add(BigInteger.ONE).shiftRight(2), this.p);
        }
        BigInteger TWO = BigInteger.valueOf(2L);
        BigInteger e = BigInteger.ZERO;
        for (int i = 1; i < this.tonelliS; ++i) {
            if (this.tonelliNonQR.modPow(e, this.p).multiply(x).modPow(pMinusOneDiv2.shiftRight(i), this.p).equals(BigInteger.ONE)) continue;
            e = e.add(TWO.pow(i));
        }
        return this.tonelliNonQR.modPow(this.tonelliT.multiply(e).shiftRight(1), this.p).multiply(x.modPow(this.tonelliT.add(BigInteger.ONE).shiftRight(1), this.p)).mod(this.p);
    }

    public BigInteger scalarMultiplication(BigInteger n, BigInteger Y) {
        if (n.equals(BigInteger.ZERO) || Y.equals(BigInteger.ONE)) {
            return BigInteger.ONE;
        }
        if (Y.equals(this.p.subtract(BigInteger.ONE))) {
            if (n.testBit(0)) {
                return this.p.subtract(BigInteger.ONE);
            }
            return BigInteger.ONE;
        }
        BigInteger TWO = BigInteger.valueOf(2L);
        BigInteger c = BigInteger.ONE.subtract(this.d).modInverse(this.p);
        BigInteger uP = Y.add(BigInteger.ONE).mod(this.p);
        BigInteger wP = BigInteger.ONE.subtract(Y).mod(this.p);
        BigInteger uQ = BigInteger.ONE;
        BigInteger wQ = BigInteger.ZERO;
        BigInteger uR = uP;
        BigInteger wR = wP;
        for (int i = n.bitLength() - 1; i >= 0; --i) {
            BigInteger t5;
            BigInteger t4;
            BigInteger t3;
            BigInteger t1 = uQ.subtract(wQ).multiply(uR.add(wR)).mod(this.p);
            BigInteger t2 = uQ.add(wQ).multiply(uR.subtract(wR)).mod(this.p);
            BigInteger uQplusR = wP.multiply(t1.add(t2).modPow(TWO, this.p)).mod(this.p);
            BigInteger wQplusR = uP.multiply(t1.subtract(t2).modPow(TWO, this.p)).mod(this.p);
            if (n.testBit(i)) {
                t3 = uR.add(wR).modPow(TWO, this.p);
                t4 = uR.subtract(wR).modPow(TWO, this.p);
                t5 = t3.subtract(t4).mod(this.p);
                BigInteger u2R = t3.multiply(t4).mod(this.p);
                BigInteger w2R = t5.multiply(t4.add(c.multiply(t5))).mod(this.p);
                uQ = uQplusR;
                wQ = wQplusR;
                uR = u2R;
                wR = w2R;
                continue;
            }
            t3 = uQ.add(wQ).modPow(TWO, this.p);
            t4 = uQ.subtract(wQ).modPow(TWO, this.p);
            t5 = t3.subtract(t4).mod(this.p);
            BigInteger u2Q = t3.multiply(t4).mod(this.p);
            BigInteger w2Q = t5.multiply(t4.add(c.multiply(t5))).mod(this.p);
            uQ = u2Q;
            wQ = w2Q;
            uR = uQplusR;
            wR = wQplusR;
        }
        return uQ.subtract(wQ).multiply(uQ.add(wQ).modInverse(this.p)).mod(this.p);
    }

    public EdwardCurvePoint pointAddition(EdwardCurvePoint P, EdwardCurvePoint Q) {
        BigInteger t = this.d.multiply(P.getX()).mod(this.p).multiply(Q.getX()).mod(this.p).multiply(P.getY()).mod(this.p).multiply(Q.getY()).mod(this.p);
        BigInteger z = t.add(BigInteger.ONE).modInverse(this.p);
        BigInteger X = z.multiply(P.getX().multiply(Q.getY()).add(P.getY().multiply(Q.getX()))).mod(this.p);
        z = BigInteger.ONE.subtract(t).modInverse(this.p);
        BigInteger Y = z.multiply(P.getY().multiply(Q.getY()).subtract(P.getX().multiply(Q.getX()))).mod(this.p);
        return EdwardCurvePoint.noCheckFactory(X, Y, this);
    }

    public EdwardCurvePoint scalarMutliplicationWithX(BigInteger n, EdwardCurvePoint P) {
        if (n.equals(BigInteger.ZERO) || P.getY().equals(BigInteger.ONE)) {
            return EdwardCurvePoint.noCheckFactory(BigInteger.ZERO, BigInteger.ONE, this);
        }
        if (P.getY().equals(this.p.subtract(BigInteger.ONE))) {
            if (n.testBit(0)) {
                return EdwardCurvePoint.noCheckFactory(BigInteger.ZERO, this.p.subtract(BigInteger.ONE), this);
            }
            return EdwardCurvePoint.noCheckFactory(BigInteger.ZERO, BigInteger.ONE, this);
        }
        EdwardCurvePoint Q = EdwardCurvePoint.noCheckFactory(P.getX(), P.getY(), this);
        EdwardCurvePoint R = EdwardCurvePoint.noCheckFactory(BigInteger.ZERO, BigInteger.ONE, this);
        for (int i = n.bitLength() - 1; i >= 0; --i) {
            if (n.testBit(i)) {
                R = this.pointAddition(R, Q);
                Q = this.pointAddition(Q, Q);
                continue;
            }
            Q = this.pointAddition(R, Q);
            R = this.pointAddition(R, R);
        }
        return R;
    }

    public EdwardCurvePoint[] mulAdd(BigInteger a, EdwardCurvePoint P1, BigInteger b, EdwardCurvePoint P2) {
        EdwardCurvePoint P3 = this.scalarMutliplicationWithX(a, P1);
        ArrayList<EdwardCurvePoint> list = new ArrayList<EdwardCurvePoint>();
        if (P2.getX() != null) {
            EdwardCurvePoint P4 = this.scalarMutliplicationWithX(b, P2);
            list.add(this.pointAddition(P3, P4));
        } else {
            BigInteger Y4 = this.scalarMultiplication(b, P2.getY());
            BigInteger X4 = this.xCoordinateFromY(Y4);
            EdwardCurvePoint P4 = EdwardCurvePoint.noCheckFactory(X4, Y4, this);
            list.add(this.pointAddition(P3, P4));
            P4 = EdwardCurvePoint.noCheckFactory(this.p.subtract(X4), Y4, this);
            list.add(this.pointAddition(P3, P4));
        }
        return list.toArray(new EdwardCurvePoint[0]);
    }
}

