/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto;

import io.olvid.keycloak.datatypes.crypto.AuthEnc;
import io.olvid.keycloak.datatypes.crypto.MACHmacSha256;
import io.olvid.keycloak.datatypes.crypto.PRNG;
import io.olvid.keycloak.datatypes.crypto.SymEncCtrAES256;
import io.olvid.keycloak.datatypes.crypto.keys.AuthEncAES256ThenSHA256Key;
import io.olvid.keycloak.datatypes.crypto.keys.AuthEncKey;
import io.olvid.keycloak.datatypes.crypto.keys.MACHmacSha256Key;
import io.olvid.keycloak.datatypes.crypto.keys.SymEncCTRAES256Key;
import java.security.InvalidKeyException;

class AuthEncAES256ThenSHA256
implements AuthEnc {
    AuthEncAES256ThenSHA256() {
    }

    @Override
    public int ciphertextLengthFromPlaintextLength(int plaintextLength) {
        return plaintextLength + 8 + 32;
    }

    @Override
    public byte[] encrypt(AuthEncKey key, byte[] plaintext, PRNG prng) throws InvalidKeyException {
        if (!(key instanceof AuthEncAES256ThenSHA256Key)) {
            throw new InvalidKeyException();
        }
        MACHmacSha256Key macKey = ((AuthEncAES256ThenSHA256Key)key).getMacKey();
        SymEncCTRAES256Key encKey = ((AuthEncAES256ThenSHA256Key)key).getEncKey();
        MACHmacSha256 mac = new MACHmacSha256();
        SymEncCtrAES256 enc = new SymEncCtrAES256(encKey);
        byte[] ciphertext = new byte[this.ciphertextLengthFromPlaintextLength(plaintext.length)];
        byte[] iv = prng.bytes(8);
        enc.encrypt(iv, plaintext, ciphertext);
        byte[] hash = mac.digest(macKey, ciphertext, enc.ciphertextLengthFromPlaintextLength(plaintext.length));
        System.arraycopy(hash, 0, ciphertext, enc.ciphertextLengthFromPlaintextLength(plaintext.length), hash.length);
        return ciphertext;
    }
}

