/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.datatypes.GroupMemberAndPermissions;
import io.olvid.keycloak.datatypes.GroupPermission;
import io.olvid.keycloak.datatypes.JsonGroupDetails;
import io.olvid.keycloak.rest.Utils;
import jakarta.persistence.EntityManager;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashSet;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GroupBlob {
    public byte[] bytesGroupUid;
    public JsonGroupDetails groupDetails;
    public byte[] photoUid;
    public byte[] encodedPhotoKey;
    public String pushTopic;
    public HashSet<GroupMemberAndPermissions> groupMembersAndPermissions;
    public String serializedSharedSettings;
    public long timestamp;

    @JsonProperty(value="guid")
    public byte[] getBytesGroupUid() {
        return this.bytesGroupUid;
    }

    @JsonProperty(value="guid")
    public void setBytesGroupUid(byte[] bytesGroupUid) {
        this.bytesGroupUid = bytesGroupUid;
    }

    @JsonProperty(value="details")
    public JsonGroupDetails getGroupDetails() {
        return this.groupDetails;
    }

    @JsonProperty(value="details")
    public void setGroupDetails(JsonGroupDetails groupDetails) {
        this.groupDetails = groupDetails;
    }

    @JsonProperty(value="photo_label")
    public byte[] getPhotoUid() {
        return this.photoUid;
    }

    @JsonProperty(value="photo_label")
    public void setPhotoUid(byte[] photoUid) {
        this.photoUid = photoUid;
    }

    @JsonProperty(value="photo_key")
    public byte[] getEncodedPhotoKey() {
        return this.encodedPhotoKey;
    }

    @JsonProperty(value="photo_key")
    public void setEncodedPhotoKey(byte[] encodedPhotoKey) {
        this.encodedPhotoKey = encodedPhotoKey;
    }

    @JsonProperty(value="pt")
    public String getPushTopic() {
        return this.pushTopic;
    }

    @JsonProperty(value="pt")
    public void setPushTopic(String pushTopic) {
        this.pushTopic = pushTopic;
    }

    @JsonProperty(value="gm_perms")
    public HashSet<GroupMemberAndPermissions> getGroupMembersAndPermissions() {
        return this.groupMembersAndPermissions;
    }

    @JsonProperty(value="gm_perms")
    public void setGroupMembersAndPermissions(HashSet<GroupMemberAndPermissions> groupMembersAndPermissions) {
        this.groupMembersAndPermissions = groupMembersAndPermissions;
    }

    @JsonProperty(value="sss")
    public String getSerializedSharedSettings() {
        return this.serializedSharedSettings;
    }

    @JsonProperty(value="sss")
    public void setSerializedSharedSettings(String serializedSharedSettings) {
        this.serializedSharedSettings = serializedSharedSettings;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public static GroupBlob createPartialBlobFromGroupModel(KeycloakSession session, EntityManager em, ObjectMapper jsonObjectMapper, RealmModel realmModel, GroupModel groupModel, SecureRandom random) {
        GroupBlob groupBlob = new GroupBlob();
        String olvidName = Utils.nullOrTrim(Utils.getGroupAttribute(groupModel, "olvid-name"));
        groupBlob.groupDetails = new JsonGroupDetails(olvidName != null ? olvidName : groupModel.getName(), Utils.getGroupAttribute(groupModel, "olvid-description"));
        groupBlob.groupMembersAndPermissions = new HashSet();
        session.users().getGroupMembersStream(realmModel, groupModel).forEach(userModel -> {
            String identityString;
            if (userModel.isEnabled() && Utils.getUserAttribute(userModel, "olvid-unbound") == null && (identityString = Utils.getUserAttribute(userModel, "olvid-identity")) != null) {
                GroupMemberAndPermissions groupMemberPermissions = new GroupMemberAndPermissions();
                groupMemberPermissions.keycloakUserId = userModel.getId();
                groupMemberPermissions.identityString = identityString;
                try {
                    groupMemberPermissions.signedUserDetails = Utils.getSignedUserDetails(session, em, jsonObjectMapper, realmModel, userModel);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                groupMemberPermissions.permissions = Arrays.asList(GroupPermission.DEFAULT_MEMBER_PERMISSIONS);
                groupMemberPermissions.groupInvitationNonce = new byte[16];
                random.nextBytes(groupMemberPermissions.groupInvitationNonce);
                groupBlob.groupMembersAndPermissions.add(groupMemberPermissions);
            }
        });
        groupBlob.timestamp = System.currentTimeMillis();
        return groupBlob;
    }
}

