/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.credentials;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.IOException;
import java.util.UUID;
import org.keycloak.credential.CredentialModel;
import org.keycloak.util.JsonSerialization;

public class MagicTokenModel
extends CredentialModel {
    public static final String TYPE = "olvid-magic-token";
    private final MagicTokenModelData magicTokenModelData;
    private final MagicTokenModelSecretData magicTokenModelSecretData;

    MagicTokenModel(String id, Long createdDate, String data, String secretData) {
        this.setType(TYPE);
        this.setId(id);
        this.setCreatedDate(createdDate);
        this.setCredentialData(data);
        try {
            this.magicTokenModelData = (MagicTokenModelData)JsonSerialization.readValue((String)data, MagicTokenModelData.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.setSecretData(secretData);
        try {
            this.magicTokenModelSecretData = (MagicTokenModelSecretData)JsonSerialization.readValue((String)secretData, MagicTokenModelSecretData.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static MagicTokenModel generateNewToken(Long expirationTimestamp) {
        String secretData;
        String data;
        try {
            data = JsonSerialization.writeValueAsString((Object)new MagicTokenModelData(expirationTimestamp));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            secretData = JsonSerialization.writeValueAsString((Object)new MagicTokenModelSecretData(UUID.randomUUID().toString()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new MagicTokenModel(UUID.randomUUID().toString(), System.currentTimeMillis(), data, secretData);
    }

    public static MagicTokenModel createFromCredentialModel(CredentialModel credentialModel) {
        return new MagicTokenModel(credentialModel.getId(), credentialModel.getCreatedDate(), credentialModel.getCredentialData(), credentialModel.getSecretData());
    }

    public boolean isTokenStillValid() {
        return this.magicTokenModelData.expirationTimestamp == null || this.magicTokenModelData.expirationTimestamp > System.currentTimeMillis();
    }

    public String getToken() {
        return this.magicTokenModelSecretData.magicToken;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class MagicTokenModelData {
        public Long expirationTimestamp;

        public MagicTokenModelData() {
        }

        public MagicTokenModelData(Long expirationTimestamp) {
            this.expirationTimestamp = expirationTimestamp;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class MagicTokenModelSecretData {
        public String magicToken;

        public MagicTokenModelSecretData() {
        }

        public MagicTokenModelSecretData(String magicToken) {
            this.magicToken = magicToken;
        }
    }
}

