/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.credentials;

import io.olvid.keycloak.credentials.MagicTokenModel;
import java.util.Objects;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialTypeMetadata;
import org.keycloak.credential.CredentialTypeMetadataContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class MagicTokenCredentialProvider
implements CredentialProvider<MagicTokenModel> {
    private final KeycloakSession session;

    MagicTokenCredentialProvider(KeycloakSession session) {
        this.session = session;
    }

    public String getType() {
        return "olvid-magic-token";
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, MagicTokenModel magicTokenModel) {
        return user.credentialManager().createStoredCredential((CredentialModel)magicTokenModel);
    }

    public boolean deleteCredential(RealmModel realmModel, UserModel userModel, String credentialId) {
        return userModel.credentialManager().removeStoredCredentialById(credentialId);
    }

    public MagicTokenModel getCredentialFromModel(CredentialModel credentialModel) {
        return MagicTokenModel.createFromCredentialModel(credentialModel);
    }

    public CredentialTypeMetadata getCredentialTypeMetadata(CredentialTypeMetadataContext credentialTypeMetadataContext) {
        return CredentialTypeMetadata.builder().type(this.getType()).category(CredentialTypeMetadata.Category.PASSWORDLESS).displayName("Olvid Magic Token").removeable(true).build(this.session);
    }

    public static boolean isUserMagicTokenValid(UserModel userModel, String token) {
        MagicTokenModel magicTokenModel = userModel.credentialManager().getStoredCredentialsByTypeStream("olvid-magic-token").map(MagicTokenModel::createFromCredentialModel).filter(mgt -> Objects.equals(mgt.getToken(), token)).findFirst().orElse(null);
        if (magicTokenModel == null) {
            return false;
        }
        if (!magicTokenModel.isTokenStillValid()) {
            userModel.credentialManager().removeStoredCredentialById(magicTokenModel.getId());
            return false;
        }
        return true;
    }
}

