/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.credentials;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.IOException;
import java.util.UUID;
import org.keycloak.credential.CredentialModel;
import org.keycloak.util.JsonSerialization;

public class DirectAuthTokenModel
extends CredentialModel {
    public static final String TYPE = "direct-auth-token";
    private DirectAuthTokenModelSecretData directAuthTokenModelSecretData;

    DirectAuthTokenModel(String id, Long createdDate, String secretData) {
        this.setType(TYPE);
        this.setId(id);
        this.setCreatedDate(createdDate);
        this.setSecretData(secretData);
        try {
            this.directAuthTokenModelSecretData = (DirectAuthTokenModelSecretData)JsonSerialization.readValue((String)secretData, DirectAuthTokenModelSecretData.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static DirectAuthTokenModel generateNewKey() {
        String secretData;
        try {
            secretData = JsonSerialization.writeValueAsString((Object)new DirectAuthTokenModelSecretData(UUID.randomUUID().toString(), UUID.randomUUID().toString()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new DirectAuthTokenModel(UUID.randomUUID().toString(), System.currentTimeMillis(), secretData);
    }

    public static DirectAuthTokenModel createFromCredentialModel(CredentialModel credentialModel) {
        return new DirectAuthTokenModel(credentialModel.getId(), credentialModel.getCreatedDate(), credentialModel.getSecretData());
    }

    public String getToken() {
        return this.directAuthTokenModelSecretData.token;
    }

    public String getMagicNonce() {
        if (this.directAuthTokenModelSecretData.magicNonce == null || this.directAuthTokenModelSecretData.magicNonce.isEmpty()) {
            return null;
        }
        return this.directAuthTokenModelSecretData.magicNonce;
    }

    public void removeMagicNonce() {
        this.directAuthTokenModelSecretData = new DirectAuthTokenModelSecretData(this.directAuthTokenModelSecretData.token, null);
        try {
            this.setSecretData(JsonSerialization.writeValueAsString((Object)this.directAuthTokenModelSecretData));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DirectAuthTokenModelSecretData {
        public String token;
        public String magicNonce;

        public DirectAuthTokenModelSecretData() {
        }

        public DirectAuthTokenModelSecretData(String token, String magicNonce) {
            this.token = token;
            this.magicNonce = magicNonce;
        }
    }
}

