/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.credentials;

import io.olvid.keycloak.credentials.DirectAuthTokenModel;
import java.util.stream.Collectors;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialTypeMetadata;
import org.keycloak.credential.CredentialTypeMetadataContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class DirectAuthTokenCredentialProvider
implements CredentialProvider<DirectAuthTokenModel> {
    private final KeycloakSession session;

    DirectAuthTokenCredentialProvider(KeycloakSession session) {
        this.session = session;
    }

    public String getType() {
        return "direct-auth-token";
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, DirectAuthTokenModel directAuthTokenModel) {
        return user.credentialManager().createStoredCredential((CredentialModel)directAuthTokenModel);
    }

    public boolean deleteCredential(RealmModel realmModel, UserModel userModel, String credentialId) {
        return userModel.credentialManager().removeStoredCredentialById(credentialId);
    }

    public DirectAuthTokenModel getCredentialFromModel(CredentialModel credentialModel) {
        return DirectAuthTokenModel.createFromCredentialModel(credentialModel);
    }

    public CredentialTypeMetadata getCredentialTypeMetadata(CredentialTypeMetadataContext credentialTypeMetadataContext) {
        return CredentialTypeMetadata.builder().type(this.getType()).category(CredentialTypeMetadata.Category.PASSWORDLESS).displayName("Olvid Direct Auth Token").removeable(true).build(this.session);
    }

    public static UserModel checkForDirectAuthToken(KeycloakSession session) {
        String username = session.getContext().getRequestHeaders().getHeaderString("direct-auth-username");
        String token = session.getContext().getRequestHeaders().getHeaderString("direct-auth-token");
        if (username == null || token == null) {
            return null;
        }
        UserModel userModel = session.users().getUserByUsername(session.getContext().getRealm(), username);
        if (userModel == null || !userModel.isEnabled()) {
            return null;
        }
        DirectAuthTokenModel directAuthTokenModel = userModel.credentialManager().getStoredCredentialsByTypeStream("direct-auth-token").filter(credential -> DirectAuthTokenModel.createFromCredentialModel(credential).getToken().equals(token)).map(DirectAuthTokenModel::createFromCredentialModel).collect(Collectors.collectingAndThen(Collectors.toList(), list -> list.isEmpty() ? null : (DirectAuthTokenModel)((Object)((Object)list.get(0)))));
        if (directAuthTokenModel == null) {
            return null;
        }
        directAuthTokenModel.removeMagicNonce();
        userModel.credentialManager().updateStoredCredential((CredentialModel)directAuthTokenModel);
        return userModel;
    }

    public static String getUserTokenFromNonce(KeycloakSession session, String username, String nonce) {
        UserModel userModel = session.users().getUserByUsername(session.getContext().getRealm(), username);
        if (userModel == null) {
            return null;
        }
        return userModel.credentialManager().getStoredCredentialsByTypeStream("direct-auth-token").filter(credential -> DirectAuthTokenModel.createFromCredentialModel(credential).getMagicNonce().equals(nonce)).map(credential -> DirectAuthTokenModel.createFromCredentialModel(credential).getToken()).collect(Collectors.collectingAndThen(Collectors.toList(), list -> list.isEmpty() ? null : (String)list.get(0)));
    }
}

