/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.classes.models.users;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.olvid.keycloak.rest.Utils;
import java.util.Base64;
import java.util.Objects;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class UserModelAttributes {
    @JsonProperty(value="id")
    String id;
    @JsonProperty(value="username")
    String username;
    @JsonProperty(value="credential")
    Boolean credential;
    @JsonProperty(value="federatedIdentities")
    Boolean federatedIdentities;
    @JsonProperty(value="federatedUsers")
    Boolean federatedUsers;
    @JsonProperty(value="olvidIsBot")
    Boolean olvidIsBot;
    @JsonProperty(value="isActivated")
    Boolean isActivated;
    @JsonProperty(value="isUnbound")
    Boolean isUnbound;
    @JsonProperty(value="isEnabled")
    Boolean isEnabled;
    @JsonProperty(value="apiKey")
    String apiKey;
    @JsonProperty(value="olvidIdentity")
    String olvidIdentity;
    @JsonProperty(value="LDAP_ENTRY_DN")
    String ldapEntryDn;

    public Boolean getActivated() {
        return this.isActivated;
    }

    public void setActivated(Boolean activated) {
        this.isActivated = activated;
    }

    public Boolean getIsUnbound() {
        return this.isUnbound;
    }

    public void setIsUnbound(Boolean isUnbound) {
        this.isUnbound = isUnbound;
    }

    public String getLdapEntryDn() {
        return this.ldapEntryDn;
    }

    public void setLdapEntryDn(String ldapEntryDn) {
        this.ldapEntryDn = ldapEntryDn;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getOlvidIdentity() {
        return this.olvidIdentity;
    }

    public void setOlvidIdentity(String olvidIdentity) {
        this.olvidIdentity = olvidIdentity;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Boolean getCredential() {
        return this.credential;
    }

    public void setCredential(Boolean credential) {
        this.credential = credential;
    }

    public Boolean getFederatedIdentities() {
        return this.federatedIdentities;
    }

    public void setFederatedIdentities(Boolean federatedIdentities) {
        this.federatedIdentities = federatedIdentities;
    }

    public Boolean getFederatedUsers() {
        return this.federatedUsers;
    }

    public void setFederatedUsers(Boolean federatedUsers) {
        this.federatedUsers = federatedUsers;
    }

    public Boolean getOlvidIsBot() {
        return this.olvidIsBot;
    }

    public void setOlvidIsBot(Boolean olvidIsBot) {
        this.olvidIsBot = olvidIsBot;
    }

    public Boolean getIsActivated() {
        return this.isActivated;
    }

    public void setIsActivated(Boolean activated) {
        this.isActivated = activated;
    }

    public void setIsEnabled(Boolean isEnabled) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserModelAttributes that = (UserModelAttributes)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getUsername(), that.getUsername()) && Objects.equals(this.getCredential(), that.getCredential()) && Objects.equals(this.getFederatedIdentities(), that.getFederatedIdentities()) && Objects.equals(this.getFederatedUsers(), that.getFederatedUsers()) && Objects.equals(this.getOlvidIsBot(), that.getOlvidIsBot()) && Objects.equals(this.getIsActivated(), that.getIsActivated()) && Objects.equals(this.getIsUnbound(), that.getIsUnbound()) && Objects.equals(this.isEnabled, that.isEnabled) && Objects.equals(this.getApiKey(), that.getApiKey()) && Objects.equals(this.getOlvidIdentity(), that.getOlvidIdentity()) && Objects.equals(this.getLdapEntryDn(), that.getLdapEntryDn());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getUsername(), this.getCredential(), this.getFederatedIdentities(), this.getFederatedUsers(), this.getOlvidIsBot(), this.getIsActivated(), this.getIsUnbound(), this.isEnabled, this.getApiKey(), this.getOlvidIdentity(), this.getLdapEntryDn());
    }

    public String toString() {
        return "UserModelAttributes{id='" + this.id + "', username='" + this.username + "', credential=" + this.credential + ", federatedIdentities=" + this.federatedIdentities + ", federatedUsers=" + this.federatedUsers + ", olvidIsBot=" + this.olvidIsBot + ", isActivated=" + this.isActivated + ", isUnbound=" + this.isUnbound + ", isEnabled=" + this.isEnabled + ", apiKey='" + this.apiKey + "', olvidIdentity='" + this.olvidIdentity + "', ldapEntryDn='" + this.ldapEntryDn + "'}";
    }

    public UserModelAttributes initUserModelAttributes(KeycloakSession session, RealmModel realmModel, UserModelAttributes olvidUser, UserModel user, String stringSearched) {
        if (user != null) {
            olvidUser.setUsername(user.getUsername());
            olvidUser.setId(user.getId());
            String identityString = Utils.getUserAttribute(user, "olvid-identity");
            if (identityString != null) {
                try {
                    Base64.getDecoder().decode(identityString);
                    olvidUser.setOlvidIdentity(identityString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            olvidUser.setIsActivated(false);
            if (olvidUser.getOlvidIdentity() != null) {
                olvidUser.setIsActivated(true);
            }
            try {
                olvidUser.setFederatedUsers(Utils.getUserAttribute(user, "LDAP_ID") != null || Utils.getUserAttribute(user, "KERBEROS_PRINCIPAL") != null);
            }
            catch (Exception e) {
                olvidUser.setFederatedUsers(false);
            }
            try {
                olvidUser.setFederatedIdentities(session.users().getFederatedIdentitiesStream(realmModel, user).findAny().isPresent());
            }
            catch (Exception e) {
                olvidUser.setFederatedIdentities(false);
            }
            olvidUser.setCredential(user.credentialManager().getStoredCredentialsByTypeStream("password").findAny().isPresent());
            olvidUser.setOlvidIsBot(Utils.isBotUser(user));
            olvidUser.setIsUnbound(Utils.isUnboundUser(user));
            olvidUser.setIsEnabled(user.isEnabled());
            olvidUser.setApiKey(Utils.getUserAttribute(user, "olvid-api-key"));
            olvidUser.setLdapEntryDn(stringSearched);
            return olvidUser;
        }
        return null;
    }
}

