/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.classes.models.users;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.olvid.keycloak.rest.Utils;
import java.util.Objects;
import org.keycloak.models.jpa.entities.UserEntity;

public class CustomUserBasicModel {
    @JsonProperty(value="firstname")
    String firstname;
    @JsonProperty(value="lastname")
    String lastname;
    @JsonProperty(value="username")
    String username;
    @JsonProperty(value="fullname")
    String fullname;
    @JsonProperty(value="email")
    String email;
    @JsonProperty(value="position")
    String position;
    @JsonProperty(value="company")
    String company;
    @JsonProperty(value="olvidIsBot")
    boolean isBot;
    @JsonProperty(value="isEnabled")
    boolean isEnabled;
    @JsonProperty(value="isUnbound")
    boolean isUnbound;

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String firstname, String lastname) {
        this.fullname = firstname + " " + lastname;
    }

    public boolean getIsBot() {
        return this.isBot;
    }

    public void setIsBot(boolean isBot) {
        this.isBot = isBot;
    }

    public boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean getIsUnbound() {
        return this.isUnbound;
    }

    public void setIsUnbound(boolean isUnbound) {
        this.isUnbound = isUnbound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomUserBasicModel that = (CustomUserBasicModel)o;
        return this.isBot == that.isBot && this.isEnabled == that.isEnabled && this.isUnbound == that.isUnbound && Objects.equals(this.getFirstname(), that.getFirstname()) && Objects.equals(this.getLastname(), that.getLastname()) && Objects.equals(this.getUsername(), that.getUsername()) && Objects.equals(this.getFullname(), that.getFullname()) && Objects.equals(this.getEmail(), that.getEmail()) && Objects.equals(this.getPosition(), that.getPosition()) && Objects.equals(this.getCompany(), that.getCompany());
    }

    public int hashCode() {
        return Objects.hash(this.getFirstname(), this.getLastname(), this.getUsername(), this.getFullname(), this.getEmail(), this.getPosition(), this.getCompany(), this.isBot, this.isEnabled, this.isUnbound);
    }

    public String toString() {
        return "CustomUserBasicModel{firstname='" + this.firstname + "', lastname='" + this.lastname + "', username='" + this.username + "', fullname='" + this.fullname + "', email='" + this.email + "', position='" + this.position + "', company='" + this.company + "', olvidIsBot=" + this.isBot + ", isEnabled=" + this.isEnabled + ", isUnbound=" + this.isUnbound + "}";
    }

    public CustomUserBasicModel initCustomUserBasicModel(UserEntity user) {
        CustomUserBasicModel olvidUser = new CustomUserBasicModel();
        if (user != null) {
            try {
                olvidUser.setFirstname(Utils.emptyStringOrTrim(user.getFirstName()));
            }
            catch (Exception e) {
                olvidUser.setFirstname("");
            }
            try {
                olvidUser.setLastname(Utils.emptyStringOrTrim(user.getLastName()));
            }
            catch (Exception e) {
                olvidUser.setLastname("");
            }
            olvidUser.setFullname(user.getFirstName(), user.getLastName());
            olvidUser.setUsername(user.getUsername());
            olvidUser.setEmail(user.getEmail());
            if (olvidUser.getEmail() == null) {
                olvidUser.setEmail("");
            }
            user.getAttributes().forEach(attribute -> {
                if (attribute.getName().contentEquals("olvid-is-bot")) {
                    olvidUser.setIsBot(true);
                } else if (attribute.getName().contentEquals("olvid-company")) {
                    olvidUser.setCompany(attribute.getValue());
                } else if (attribute.getName().contentEquals("olvid-position")) {
                    olvidUser.setPosition(attribute.getValue());
                } else if (attribute.getName().contentEquals("olvid-unbound")) {
                    olvidUser.setIsUnbound(true);
                }
            });
            olvidUser.setIsEnabled(user.isEnabled());
            return olvidUser;
        }
        return null;
    }
}

