/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.classes.models.realms;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.olvid.keycloak.jpa.OlvidCircleVisibilityRules;
import io.olvid.keycloak.jpa.OlvidConfigurationDao;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public final class RealmSettingsModel {
    @JsonProperty(value="writeAllowed")
    public boolean writeAllowed;
    @JsonProperty(value="enableBotsManagement")
    public boolean enableBotsManagement;
    @JsonProperty(value="enableAuthenticationWithOlvidId")
    public boolean enableAuthenticationWithOlvidId;
    @JsonProperty(value="searchResultCount")
    public int searchResultCount;
    @JsonProperty(value="isSearchIncludeNotActivatedUsers")
    public boolean isSearchIncludeNotActivatedUsers;
    @JsonProperty(value="oldDeviceTimeLimit")
    public int oldDeviceTimeLimit;
    @JsonProperty(value="configLink")
    public String configLink;
    @JsonProperty(value="isVerifyProfile")
    public Boolean isVerifyProfile;
    @JsonProperty(value="isBotUserExist")
    public Boolean isBotUserExist;
    @JsonProperty(value="passwordKeycloakPolicy")
    Object passwordKeycloakPolicy;
    @JsonProperty(value="enableVisibilityCircle")
    boolean enableVisibilityCircle;
    @JsonProperty(value="visibilityCircleRealmDefaultRuleFrom")
    String visibilityCircleRealmDefaultRuleFrom;
    @JsonProperty(value="visibilityCircleRealmDefaultRuleTo")
    String visibilityCircleRealmDefaultRuleTo;
    @JsonProperty(value="visibilityCircleDefaultRuleBetweenMembers")
    String visibilityCircleDefaultRuleBetweenMembers;

    public Boolean getIsVerifyProfile() {
        return this.isVerifyProfile;
    }

    public void setIsVerifyProfile(Boolean isVerifyProfile) {
        this.isVerifyProfile = isVerifyProfile;
    }

    public String getVisibilityCircleDefaultRuleBetweenMembers() {
        return this.visibilityCircleDefaultRuleBetweenMembers;
    }

    public void setVisibilityCircleCreatedDefaultRule(String visibilityCircleDefaultRuleBetweenMembers) {
        this.visibilityCircleDefaultRuleBetweenMembers = visibilityCircleDefaultRuleBetweenMembers;
    }

    public boolean isEnableVisibilityCircle() {
        return this.enableVisibilityCircle;
    }

    public String getVisibilityCircleRealmDefaultRuleTo() {
        return this.visibilityCircleRealmDefaultRuleTo;
    }

    public void setVisibilityCircleRealmDefaultRuleTo(String visibilityCircleRealmDefaultRuleTo) {
        this.visibilityCircleRealmDefaultRuleTo = visibilityCircleRealmDefaultRuleTo;
    }

    public boolean getEnableVisibilityCircle() {
        return this.enableVisibilityCircle;
    }

    public void setEnableVisibilityCircle(boolean enableVisibilityCircle) {
        this.enableVisibilityCircle = enableVisibilityCircle;
    }

    public String getVisibilityCircleRealmDefaultRuleFrom() {
        return this.visibilityCircleRealmDefaultRuleFrom;
    }

    public void setVisibilityCircleRealmDefaultRuleFrom(String visibilityCircleRealmDefaultRuleFrom) {
        this.visibilityCircleRealmDefaultRuleFrom = visibilityCircleRealmDefaultRuleFrom;
    }

    public Boolean getIsBotUserExist() {
        return this.isBotUserExist;
    }

    public void setIsBotUserExist(Boolean isBotUserExist) {
        this.isBotUserExist = isBotUserExist;
    }

    public boolean getWriteAllowed() {
        return this.writeAllowed;
    }

    public void setWriteAllowed(boolean writeAllowed) {
        this.writeAllowed = writeAllowed;
    }

    public boolean getEnableBotsManagement() {
        return this.enableBotsManagement;
    }

    public void setEnableBotsManagement(boolean enableBotsManagement) {
        this.enableBotsManagement = enableBotsManagement;
    }

    public int getSearchResultCount() {
        return this.searchResultCount;
    }

    public void setSearchResultCount(int searchResultCount) {
        this.searchResultCount = searchResultCount;
    }

    public boolean getIsSearchIncludeNotActivatedUsers() {
        return this.isSearchIncludeNotActivatedUsers;
    }

    public void setIsSearchIncludeNotActivatedUsers(boolean isSearchIncludeNotActivatedUsers) {
        this.isSearchIncludeNotActivatedUsers = isSearchIncludeNotActivatedUsers;
    }

    public int getOldDeviceTimeLimit() {
        return this.oldDeviceTimeLimit;
    }

    public void setOldDeviceTimeLimit(int oldDeviceTimeLimit) {
        this.oldDeviceTimeLimit = oldDeviceTimeLimit;
    }

    public String getConfigLink() {
        return this.configLink;
    }

    public void setConfigLink(String configLink) {
        this.configLink = configLink;
    }

    public boolean isWriteAllowed() {
        return this.writeAllowed;
    }

    public boolean isEnableBotsManagement() {
        return this.enableBotsManagement;
    }

    public boolean isSearchIncludeNotActivatedUsers() {
        return this.isSearchIncludeNotActivatedUsers;
    }

    public void setSearchIncludeNotActivatedUsers(boolean searchIncludeNotActivatedUsers) {
        this.isSearchIncludeNotActivatedUsers = searchIncludeNotActivatedUsers;
    }

    public Boolean getBotUserExist() {
        return this.isBotUserExist;
    }

    public void setBotUserExist(Boolean botUserExist) {
        this.isBotUserExist = botUserExist;
    }

    public Object getPasswordKeycloakPolicy() {
        return this.passwordKeycloakPolicy;
    }

    public void setPasswordKeycloakPolicy(Object passwordKeycloakPolicy) {
        this.passwordKeycloakPolicy = passwordKeycloakPolicy;
    }

    public void setVisibilityCircleDefaultRuleBetweenMembers(String visibilityCircleDefaultRuleBetweenMembers) {
        this.visibilityCircleDefaultRuleBetweenMembers = visibilityCircleDefaultRuleBetweenMembers;
    }

    public boolean getEnableAuthenticationWithOlvidId() {
        return this.enableAuthenticationWithOlvidId;
    }

    public void setEnableAuthenticationWithOlvidId(boolean enableAuthenticationWithOlvidId) {
        this.enableAuthenticationWithOlvidId = enableAuthenticationWithOlvidId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RealmSettingsModel that = (RealmSettingsModel)o;
        return this.writeAllowed == that.writeAllowed && this.enableBotsManagement == that.enableBotsManagement && this.enableAuthenticationWithOlvidId == that.enableAuthenticationWithOlvidId && this.searchResultCount == that.searchResultCount && this.isSearchIncludeNotActivatedUsers == that.isSearchIncludeNotActivatedUsers && this.oldDeviceTimeLimit == that.oldDeviceTimeLimit && this.enableVisibilityCircle == that.enableVisibilityCircle && Objects.equals(this.configLink, that.configLink) && Objects.equals(this.isVerifyProfile, that.isVerifyProfile) && Objects.equals(this.isBotUserExist, that.isBotUserExist) && Objects.equals(this.passwordKeycloakPolicy, that.passwordKeycloakPolicy) && Objects.equals(this.visibilityCircleRealmDefaultRuleFrom, that.visibilityCircleRealmDefaultRuleFrom) && Objects.equals(this.visibilityCircleRealmDefaultRuleTo, that.visibilityCircleRealmDefaultRuleTo) && Objects.equals(this.visibilityCircleDefaultRuleBetweenMembers, that.visibilityCircleDefaultRuleBetweenMembers);
    }

    public int hashCode() {
        return Objects.hash(this.writeAllowed, this.enableBotsManagement, this.enableAuthenticationWithOlvidId, this.searchResultCount, this.isSearchIncludeNotActivatedUsers, this.oldDeviceTimeLimit, this.configLink, this.isVerifyProfile, this.isBotUserExist, this.passwordKeycloakPolicy, this.enableVisibilityCircle, this.visibilityCircleRealmDefaultRuleFrom, this.visibilityCircleRealmDefaultRuleTo, this.visibilityCircleDefaultRuleBetweenMembers);
    }

    public String toString() {
        return "RealmSettingsModel{writeAllowed=" + this.writeAllowed + ", enableBotsManagement=" + this.enableBotsManagement + ", enableAuthenticationWithOlvidId=" + this.enableAuthenticationWithOlvidId + ", searchResultCount=" + this.searchResultCount + ", isSearchIncludeNotActivatedUsers=" + this.isSearchIncludeNotActivatedUsers + ", oldDeviceTimeLimit=" + this.oldDeviceTimeLimit + ", configLink='" + this.configLink + "', isVerifyProfile=" + this.isVerifyProfile + ", isBotUserExist=" + this.isBotUserExist + ", passwordKeycloakPolicy=" + String.valueOf(this.passwordKeycloakPolicy) + ", enableVisibilityCircle=" + this.enableVisibilityCircle + ", visibilityCircleRealmDefaultRuleFrom='" + this.visibilityCircleRealmDefaultRuleFrom + "', visibilityCircleRealmDefaultRuleTo='" + this.visibilityCircleRealmDefaultRuleTo + "', visibilityCircleDefaultRuleBetweenMembers='" + this.visibilityCircleDefaultRuleBetweenMembers + "'}";
    }

    public static RealmSettingsModel initRealmSettings(EntityManager em, KeycloakSession session, RealmModel realmModel, Boolean writeAllowed) {
        RealmSettingsModel realmSettings = new RealmSettingsModel();
        boolean isBotUserExist = session.users().searchForUserByUserAttributeStream(realmModel, "olvid-is-bot", "true").findAny().isPresent();
        realmSettings.setIsBotUserExist(isBotUserExist);
        realmSettings.setEnableBotsManagement(OlvidConfigurationDao.getBooleanConfiguration(em, realmModel.getId(), "enableBotsManagement", false) || isBotUserExist);
        realmSettings.setEnableAuthenticationWithOlvidId(OlvidConfigurationDao.getBooleanConfiguration(em, realmModel.getId(), "enableAuthenticationWithOlvidId", false));
        Logger logger = Logger.getLogger(RealmSettingsModel.class);
        realmSettings.setSearchResultCount(OlvidConfigurationDao.getIntConfiguration(em, realmModel.getId(), "searchResultCount", 50));
        realmSettings.setIsSearchIncludeNotActivatedUsers(OlvidConfigurationDao.getBooleanConfiguration(em, realmModel.getId(), "isSearchIncludeNotActivatedUsers", false));
        realmSettings.setOldDeviceTimeLimit(OlvidConfigurationDao.getIntConfiguration(em, realmModel.getId(), "oldDeviceTimeLimit", 30));
        realmSettings.setEnableVisibilityCircle(OlvidConfigurationDao.getBooleanConfiguration(em, realmModel.getId(), "enableVisibilityCircles", false));
        realmSettings.setWriteAllowed(writeAllowed);
        List getRequiredActionProvidersStream = realmModel.getRequiredActionProvidersStream().collect(Collectors.toList());
        if (getRequiredActionProvidersStream.stream().anyMatch(provider -> provider.getProviderId().contentEquals(UserModel.RequiredAction.VERIFY_PROFILE.name()))) {
            boolean found = getRequiredActionProvidersStream.stream().anyMatch(provider -> provider.getProviderId().contentEquals(UserModel.RequiredAction.VERIFY_PROFILE.name()));
            if (found) {
                realmSettings.setIsVerifyProfile(getRequiredActionProvidersStream.stream().filter(provider -> provider.getProviderId().contentEquals(UserModel.RequiredAction.VERIFY_PROFILE.name())).findFirst().get().isEnabled());
            } else {
                realmSettings.setIsVerifyProfile(false);
            }
        } else {
            realmSettings.setIsVerifyProfile(false);
        }
        HashMap<String, Object> passwordPolicies = new HashMap<String, Object>();
        Set policies = realmModel.getPasswordPolicy().getPolicies();
        passwordPolicies.put("passwordPolicies", policies);
        HashMap passwordPolicy = new HashMap();
        policies.forEach(policy -> passwordPolicy.put(policy, realmModel.getPasswordPolicy().getPolicyConfig(policy)));
        passwordPolicies.put("passwordPoliciesDetails", passwordPolicy);
        passwordPolicies.put("getExpiredPasswords", realmModel.getPasswordPolicy().getExpiredPasswords());
        passwordPolicies.put("getDaysToExpirePassword", realmModel.getPasswordPolicy().getDaysToExpirePassword());
        passwordPolicies.put("getHashAlgorithm", realmModel.getPasswordPolicy().getHashAlgorithm());
        passwordPolicies.put("getHashIterations", realmModel.getPasswordPolicy().getHashIterations());
        passwordPolicies.put("getMaxAuthAge", realmModel.getPasswordPolicy().getMaxAuthAge());
        passwordPolicies.put("getRecoveryCodesWarningThreshold", realmModel.getPasswordPolicy().getRecoveryCodesWarningThreshold());
        realmSettings.setPasswordKeycloakPolicy(passwordPolicies);
        String circleDefaultRuleFrom = "";
        String circleDefaultRuleTo = "";
        String circleDefaultRule = "";
        try {
            TypedQuery qDefaultRule = em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultCircleRuleBetweenMembers", OlvidCircleVisibilityRules.class);
            qDefaultRule.setParameter("realmId", (Object)realmModel.getId());
            circleDefaultRule = ((OlvidCircleVisibilityRules)qDefaultRule.getSingleResult()).getVisibility();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        realmSettings.setVisibilityCircleRealmDefaultRuleFrom(circleDefaultRuleFrom);
        realmSettings.setVisibilityCircleRealmDefaultRuleTo(circleDefaultRuleTo);
        realmSettings.setVisibilityCircleCreatedDefaultRule(circleDefaultRule);
        return realmSettings;
    }
}

